/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IRefactoringStatusEntryComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class MoveInnerToTopRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_FIELD = "field";
    private static final String ATTRIBUTE_MANDATORY = "mandatory";
    private static final String ATTRIBUTE_POSSIBLE = "possible";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_FIELD_NAME = "fieldName";
    private static final String ATTRIBUTE_PARAMETER_NAME = "parameterName";
    private TextChangeManager fChangeManager;
    private CodeGenerationSettings fCodeGenerationSettings;
    private boolean fCreateInstanceField;
    private String fEnclosingInstanceFieldName;
    private boolean fIsInstanceFieldCreationMandatory;
    private boolean fIsInstanceFieldCreationPossible;
    private boolean fMarkInstanceFieldAsFinal;
    private String fNameForEnclosingInstanceConstructorParameter;
    private String fNewSourceOfInputType;
    private CompilationUnitRewrite fSourceRewrite;
    private Collection fStaticImports;
    private IType fType;
    private String fQualifiedTypeName;
    private Collection fTypeImports;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private static void addTypeParameters(CompilationUnit compilationUnit, IType iType, Map map) throws JavaModelException {
        Assert.isNotNull((Object)compilationUnit);
        Assert.isNotNull((Object)iType);
        Assert.isNotNull((Object)map);
        AbstractTypeDeclaration abstractTypeDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, compilationUnit);
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            ITypeBinding iTypeBinding = null;
            TypeParameter typeParameter = null;
            IType iType2 = ((TypeDeclaration)abstractTypeDeclaration).typeParameters().iterator();
            while (iType2.hasNext()) {
                typeParameter = (TypeParameter)iType2.next();
                iTypeBinding = typeParameter.resolveBinding();
                if (iTypeBinding == null || map.containsKey(iTypeBinding.getKey())) continue;
                map.put(iTypeBinding.getKey(), iTypeBinding);
            }
            iType2 = iType.getDeclaringType();
            if (iType2 != null && !Flags.isStatic((int)iType.getFlags())) {
                MoveInnerToTopRefactoring.addTypeParameters(compilationUnit, iType2, map);
            }
        }
    }

    private static boolean containsNonStatic(FieldAccess[] fieldAccessArray) {
        int n = 0;
        while (n < fieldAccessArray.length) {
            if (!MoveInnerToTopRefactoring.isStatic(fieldAccessArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean containsNonStatic(MethodInvocation[] methodInvocationArray) {
        int n = 0;
        while (n < methodInvocationArray.length) {
            if (!MoveInnerToTopRefactoring.isStatic(methodInvocationArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean containsNonStatic(SimpleName[] simpleNameArray) {
        int n = 0;
        while (n < simpleNameArray.length) {
            if (!MoveInnerToTopRefactoring.isStaticFieldName(simpleNameArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean containsStatusEntry(RefactoringStatus refactoringStatus, RefactoringStatusEntry refactoringStatusEntry) {
        return refactoringStatus.getEntries(new IRefactoringStatusEntryComparator(){

            public final int compare(RefactoringStatusEntry refactoringStatusEntry, RefactoringStatusEntry refactoringStatusEntry2) {
                return refactoringStatusEntry.getMessage().compareTo(refactoringStatusEntry2.getMessage());
            }
        }, refactoringStatusEntry).length > 0;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(IType iType, AbstractTypeDeclaration[] abstractTypeDeclarationArray) {
        String string = iType.getElementName();
        int n = 0;
        while (n < abstractTypeDeclarationArray.length) {
            AbstractTypeDeclaration abstractTypeDeclaration = abstractTypeDeclarationArray[n];
            if (abstractTypeDeclaration.getName().getIdentifier().equals(string)) {
                return abstractTypeDeclaration;
            }
            ++n;
        }
        return null;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(IType iType, CompilationUnit compilationUnit) {
        List list = MoveInnerToTopRefactoring.getDeclaringTypes(iType);
        list.add(iType);
        AbstractTypeDeclaration[] abstractTypeDeclarationArray = compilationUnit.types().toArray(new AbstractTypeDeclaration[compilationUnit.types().size()]);
        AbstractTypeDeclaration abstractTypeDeclaration = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IType iType2 = (IType)iterator.next();
            abstractTypeDeclaration = MoveInnerToTopRefactoring.findTypeDeclaration(iType2, abstractTypeDeclarationArray);
            Assert.isNotNull((Object)abstractTypeDeclaration);
            abstractTypeDeclarationArray = MoveInnerToTopRefactoring.getAbstractTypeDeclarations(abstractTypeDeclaration);
        }
        Assert.isNotNull(abstractTypeDeclaration);
        return abstractTypeDeclaration;
    }

    public static AbstractTypeDeclaration[] getAbstractTypeDeclarations(AbstractTypeDeclaration abstractTypeDeclaration) {
        int n = 0;
        AbstractTypeDeclaration[] abstractTypeDeclarationArray = abstractTypeDeclaration.bodyDeclarations().listIterator();
        while (abstractTypeDeclarationArray.hasNext()) {
            if (!(abstractTypeDeclarationArray.next() instanceof AbstractTypeDeclaration)) continue;
            ++n;
        }
        abstractTypeDeclarationArray = new AbstractTypeDeclaration[n];
        int n2 = 0;
        ListIterator listIterator = abstractTypeDeclaration.bodyDeclarations().listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof AbstractTypeDeclaration)) continue;
            abstractTypeDeclarationArray[n2++] = (AbstractTypeDeclaration)e;
        }
        return abstractTypeDeclarationArray;
    }

    private static ITypeBinding getDeclaringTypeBinding(FieldAccess fieldAccess) {
        IVariableBinding iVariableBinding = fieldAccess.resolveFieldBinding();
        if (iVariableBinding == null) {
            return null;
        }
        return iVariableBinding.getDeclaringClass();
    }

    private static ITypeBinding getDeclaringTypeBinding(MethodInvocation methodInvocation) {
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        if (iMethodBinding == null) {
            return null;
        }
        return iMethodBinding.getDeclaringClass();
    }

    private static List getDeclaringTypes(IType iType) {
        IType iType2 = iType.getDeclaringType();
        if (iType2 == null) {
            return new ArrayList(0);
        }
        List list = MoveInnerToTopRefactoring.getDeclaringTypes(iType2);
        list.add(iType2);
        return list;
    }

    private static String[] getFieldNames(IType iType) {
        try {
            IField[] iFieldArray = iType.getFields();
            ArrayList<String> arrayList = new ArrayList<String>(iFieldArray.length);
            int n = 0;
            while (n < iFieldArray.length) {
                arrayList.add(iFieldArray[n].getElementName());
                ++n;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static Set getMergedSet(Set set, Set set2) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    private static String[] getParameterNamesOfAllConstructors(IType iType) throws JavaModelException {
        IMethod[] iMethodArray = JavaElementUtil.getAllConstructors(iType);
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < iMethodArray.length) {
            hashSet.addAll(Arrays.asList(iMethodArray[n].getParameterNames()));
            ++n;
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private static ASTNode[] getReferenceNodesIn(CompilationUnit compilationUnit, Map map, ICompilationUnit iCompilationUnit) {
        SearchMatch[] searchMatchArray = (SearchMatch[])map.get(iCompilationUnit);
        if (searchMatchArray == null) {
            return new ASTNode[0];
        }
        return ASTNodeSearchUtil.getAstNodes(searchMatchArray, compilationUnit);
    }

    private static boolean isCorrespondingTypeBinding(ITypeBinding iTypeBinding, IType iType) {
        if (iTypeBinding == null) {
            return false;
        }
        return Bindings.getFullyQualifiedName(iTypeBinding).equals(JavaElementUtil.createSignature((IMember)iType));
    }

    private static boolean isStatic(FieldAccess fieldAccess) {
        IVariableBinding iVariableBinding = fieldAccess.resolveFieldBinding();
        if (iVariableBinding == null) {
            return false;
        }
        return JdtFlags.isStatic(iVariableBinding);
    }

    private static boolean isStatic(MethodInvocation methodInvocation) {
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        if (iMethodBinding == null) {
            return false;
        }
        return JdtFlags.isStatic(iMethodBinding);
    }

    private static boolean isStaticFieldName(SimpleName simpleName) {
        IBinding iBinding = simpleName.resolveBinding();
        if (!(iBinding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
        if (!iVariableBinding.isField()) {
            return false;
        }
        return JdtFlags.isStatic(iVariableBinding);
    }

    public MoveInnerToTopRefactoring(IType iType, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        this.fType = iType;
        this.fCodeGenerationSettings = codeGenerationSettings;
        this.fMarkInstanceFieldAsFinal = true;
        if (this.fType != null) {
            this.initialize();
        }
    }

    private void initialize() throws JavaModelException {
        this.fQualifiedTypeName = JavaModelUtil.concatenateName(this.fType.getPackageFragment().getElementName(), this.fType.getElementName());
        this.fEnclosingInstanceFieldName = this.getInitialNameForEnclosingInstanceField();
        this.fSourceRewrite = new CompilationUnitRewrite(this.fType.getCompilationUnit());
        this.fIsInstanceFieldCreationPossible = !JdtFlags.isStatic((IMember)this.fType) && !this.fType.isAnnotation() && !this.fType.isEnum();
        this.fCreateInstanceField = this.fIsInstanceFieldCreationMandatory = this.fIsInstanceFieldCreationPossible && this.isInstanceFieldCreationMandatory();
    }

    private void addEnclosingInstanceDeclaration(AbstractTypeDeclaration abstractTypeDeclaration, ASTRewrite aSTRewrite) throws CoreException {
        Assert.isNotNull((Object)abstractTypeDeclaration);
        Assert.isNotNull((Object)aSTRewrite);
        AST aST = abstractTypeDeclaration.getAST();
        VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(aST.newSimpleName(this.fEnclosingInstanceFieldName));
        FieldDeclaration fieldDeclaration = aST.newFieldDeclaration(variableDeclarationFragment);
        fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, this.getEnclosingInstanceAccessModifiers()));
        fieldDeclaration.setType(this.createEnclosingType(aST));
        String string = CodeGeneration.getFieldComment(this.fType.getCompilationUnit(), abstractTypeDeclaration.getName().getIdentifier(), this.fEnclosingInstanceFieldName, StubUtility.getLineDelimiterUsed(this.fType.getJavaProject()));
        if (string != null && string.length() > 0) {
            Javadoc javadoc = (Javadoc)aSTRewrite.createStringPlaceholder(string, 29);
            fieldDeclaration.setJavadoc(javadoc);
        }
        aSTRewrite.getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertFirst((ASTNode)fieldDeclaration, null);
    }

    private void addEnclosingInstanceTypeParameters(ITypeBinding[] iTypeBindingArray, AbstractTypeDeclaration abstractTypeDeclaration, ASTRewrite aSTRewrite) {
        Assert.isNotNull((Object)iTypeBindingArray);
        Assert.isNotNull((Object)abstractTypeDeclaration);
        Assert.isNotNull((Object)aSTRewrite);
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)abstractTypeDeclaration;
            List list = typeDeclaration.typeParameters();
            HashSet<String> hashSet = new HashSet<String>();
            TypeParameter typeParameter = null;
            ListRewrite listRewrite = list.iterator();
            while (listRewrite.hasNext()) {
                typeParameter = (TypeParameter)listRewrite.next();
                hashSet.add(typeParameter.getName().getIdentifier());
            }
            listRewrite = aSTRewrite.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            String string = null;
            int n = 0;
            while (n < iTypeBindingArray.length) {
                string = iTypeBindingArray[n].getName();
                if (!hashSet.contains(string)) {
                    typeParameter = typeDeclaration.getAST().newTypeParameter();
                    typeParameter.setName(typeDeclaration.getAST().newSimpleName(string));
                    listRewrite.insertLast((ASTNode)typeParameter, null);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addImportsToTargetUnit(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) throws CoreException, JavaModelException {
        iProgressMonitor.beginTask("", 2);
        try {
            Iterator iterator;
            ITypeBinding iTypeBinding;
            ImportRewrite importRewrite = StubUtility.createImportRewrite(iCompilationUnit, true);
            if (this.fTypeImports != null) {
                iTypeBinding = null;
                iterator = this.fTypeImports.iterator();
                while (iterator.hasNext()) {
                    iTypeBinding = (ITypeBinding)iterator.next();
                    importRewrite.addImport(iTypeBinding);
                }
            }
            if (this.fStaticImports != null) {
                iTypeBinding = null;
                iterator = this.fStaticImports.iterator();
                while (iterator.hasNext()) {
                    iTypeBinding = (IBinding)iterator.next();
                    importRewrite.addStaticImport((IBinding)iTypeBinding);
                }
            }
            this.fTypeImports = null;
            this.fStaticImports = null;
            iTypeBinding = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            JavaModelUtil.applyEdit(iCompilationUnit, (TextEdit)iTypeBinding, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        iProgressMonitor.done();
    }

    private void addInheritedTypeQualifications(AbstractTypeDeclaration abstractTypeDeclaration, CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup) {
        Assert.isNotNull((Object)abstractTypeDeclaration);
        Assert.isNotNull((Object)compilationUnitRewrite);
        CompilationUnit compilationUnit = (CompilationUnit)abstractTypeDeclaration.getRoot();
        ITypeBinding iTypeBinding = abstractTypeDeclaration.resolveBinding();
        if (iTypeBinding != null) {
            Type type = null;
            if (abstractTypeDeclaration instanceof TypeDeclaration && (type = ((TypeDeclaration)abstractTypeDeclaration).getSuperclassType()) != null && compilationUnit.findDeclaringNode((IBinding)iTypeBinding) != null) {
                this.addTypeQualification(type, compilationUnitRewrite, textEditGroup);
            }
            List list = null;
            if (abstractTypeDeclaration instanceof TypeDeclaration) {
                list = ((TypeDeclaration)abstractTypeDeclaration).superInterfaceTypes();
            } else if (abstractTypeDeclaration instanceof EnumDeclaration) {
                list = ((EnumDeclaration)abstractTypeDeclaration).superInterfaceTypes();
            }
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    type = (Type)iterator.next();
                    if (compilationUnit.findDeclaringNode((IBinding)type.resolveBinding()) == null) continue;
                    this.addTypeQualification(type, compilationUnitRewrite, textEditGroup);
                }
            }
        }
    }

    private void addParameterToConstructor(ASTRewrite aSTRewrite, MethodDeclaration methodDeclaration) throws JavaModelException {
        Assert.isNotNull((Object)aSTRewrite);
        Assert.isNotNull((Object)methodDeclaration);
        AST aST = methodDeclaration.getAST();
        String string = this.getNameForEnclosingInstanceConstructorParameter();
        SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
        singleVariableDeclaration.setType(this.createEnclosingType(aST));
        singleVariableDeclaration.setName(aST.newSimpleName(string));
        aSTRewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY).insertFirst((ASTNode)singleVariableDeclaration, null);
        JavadocUtil.addParamJavadoc(string, methodDeclaration, aSTRewrite, this.fType.getJavaProject(), null);
    }

    private void addSimpleTypeQualification(CompilationUnitRewrite compilationUnitRewrite, ITypeBinding iTypeBinding, SimpleType simpleType, TextEditGroup textEditGroup) {
        Assert.isNotNull((Object)compilationUnitRewrite);
        Assert.isNotNull((Object)iTypeBinding);
        Assert.isNotNull((Object)simpleType);
        AST aST = compilationUnitRewrite.getRoot().getAST();
        if (!(simpleType.getName() instanceof QualifiedName)) {
            compilationUnitRewrite.getASTRewrite().replace((ASTNode)simpleType, (ASTNode)aST.newQualifiedType(compilationUnitRewrite.getImportRewrite().addImport(iTypeBinding, aST), aST.newSimpleName(simpleType.getName().getFullyQualifiedName())), textEditGroup);
            compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)simpleType);
        }
    }

    private void addTypeQualification(Type type, CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup) {
        ITypeBinding iTypeBinding;
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)compilationUnitRewrite);
        ITypeBinding iTypeBinding2 = type.resolveBinding();
        if (iTypeBinding2 != null && (iTypeBinding = iTypeBinding2.getDeclaringClass()) != null) {
            ParameterizedType parameterizedType;
            Type type2;
            if (type instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)type;
                this.addSimpleTypeQualification(compilationUnitRewrite, iTypeBinding, simpleType, textEditGroup);
            } else if (type instanceof ParameterizedType && (type2 = (parameterizedType = (ParameterizedType)type).getType()) instanceof SimpleType) {
                this.addSimpleTypeQualification(compilationUnitRewrite, iTypeBinding, (SimpleType)type2, textEditGroup);
            }
        }
    }

    private RefactoringStatus checkConstructorParameterNames() {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)this.fType.getCompilationUnit(), false);
        MethodDeclaration[] methodDeclarationArray = this.getConstructorDeclarationNodes(MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, compilationUnit));
        int n = 0;
        while (n < methodDeclarationArray.length) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n];
            Iterator iterator = methodDeclaration.parameters().iterator();
            while (iterator.hasNext()) {
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)iterator.next();
                if (!this.fEnclosingInstanceFieldName.equals(singleVariableDeclaration.getName().getIdentifier())) continue;
                String string = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_name_used, new String[]{singleVariableDeclaration.getName().getIdentifier(), this.fType.getElementName()});
                refactoringStatus.addError(string, JavaStatusContext.create((ITypeRoot)this.fType.getCompilationUnit(), (ASTNode)singleVariableDeclaration));
            }
            ++n;
        }
        return refactoringStatus;
    }

    public RefactoringStatus checkEnclosingInstanceName(String string) {
        if (!this.fCreateInstanceField) {
            return new RefactoringStatus();
        }
        RefactoringStatus refactoringStatus = Checks.checkFieldName(string);
        if (!Checks.startsWithLowerCase(string)) {
            refactoringStatus.addWarning(RefactoringCoreMessages.MoveInnerToTopRefactoring_names_start_lowercase);
        }
        if (this.fType.getField(string).exists()) {
            Object[] objectArray = new String[]{string, this.fType.getElementName()};
            String string2 = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_already_declared, objectArray);
            refactoringStatus.addError(string2, JavaStatusContext.create((IMember)this.fType.getField(string)));
        }
        return refactoringStatus;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        iProgressMonitor.beginTask("", 2);
        try {
            RefactoringStatus refactoringStatus2 = new RefactoringStatus();
            if (JdtFlags.isStatic((IMember)this.fType)) {
                refactoringStatus2.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            }
            if (this.fType.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())).exists()) {
                String string = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_compilation_Unit_exists, new String[]{JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName()), this.fType.getPackageFragment().getElementName()});
                refactoringStatus2.addFatalError(string);
            }
            refactoringStatus2.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            refactoringStatus2.merge(Checks.checkCompilationUnitName(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())));
            refactoringStatus2.merge(this.checkConstructorParameterNames());
            refactoringStatus2.merge(this.checkTypeNameInPackage());
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus2);
            refactoringStatus2.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getValidationContext()));
            refactoringStatus = refactoringStatus2;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    private RefactoringStatus checkTypeNameInPackage() throws JavaModelException {
        IType iType = Checks.findTypeInPackage(this.fType.getPackageFragment(), this.fType.getElementName());
        if (iType == null || !iType.exists()) {
            return null;
        }
        String string = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_type_exists, new String[]{this.fType.getElementName(), this.fType.getPackageFragment().getElementName()});
        return RefactoringStatus.createErrorStatus((String)string);
    }

    private Expression createAccessExpressionToEnclosingInstanceFieldText(ASTNode aSTNode, IBinding iBinding, AbstractTypeDeclaration abstractTypeDeclaration) {
        if (Modifier.isStatic((int)iBinding.getModifiers())) {
            return aSTNode.getAST().newName(JavaModelUtil.getTypeQualifiedName(this.fType.getDeclaringType()));
        }
        if (this.isInAnonymousTypeInsideInputType(aSTNode, abstractTypeDeclaration) || this.isInLocalTypeInsideInputType(aSTNode, abstractTypeDeclaration) || this.isInNonStaticMemberTypeInsideInputType(aSTNode, abstractTypeDeclaration)) {
            return this.createQualifiedReadAccessExpressionForEnclosingInstance(aSTNode.getAST());
        }
        return this.createReadAccessExpressionForEnclosingInstance(aSTNode.getAST());
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl;
        iProgressMonitor.beginTask(RefactoringCoreMessages.MoveInnerToTopRefactoring_creating_change, 1);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        IJavaProject iJavaProject = this.fType.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        String string2 = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_descriptor_description_short, this.fType.getElementName());
        String string3 = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fType, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel(this.fType.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_original_pattern, JavaElementLabels.getElementLabel((IJavaElement)this.fType, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        boolean bl2 = bl = this.fEnclosingInstanceFieldName != null && !"".equals(this.fEnclosingInstanceFieldName);
        if (bl) {
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_field_pattern, this.fEnclosingInstanceFieldName));
        }
        if (this.fNameForEnclosingInstanceConstructorParameter != null && !"".equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_parameter_pattern, this.fNameForEnclosingInstanceConstructorParameter));
        }
        if (bl && this.fMarkInstanceFieldAsFinal) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.MoveInnerToTopRefactoring_declare_final);
        }
        JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.move.inner", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, 786438);
        hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fType));
        if (bl) {
            hashMap.put(ATTRIBUTE_FIELD_NAME, this.fEnclosingInstanceFieldName);
        }
        if (this.fNameForEnclosingInstanceConstructorParameter != null && !"".equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            hashMap.put(ATTRIBUTE_PARAMETER_NAME, this.fNameForEnclosingInstanceConstructorParameter);
        }
        hashMap.put(ATTRIBUTE_FIELD, Boolean.valueOf(this.fCreateInstanceField).toString());
        hashMap.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fMarkInstanceFieldAsFinal).toString());
        hashMap.put(ATTRIBUTE_POSSIBLE, Boolean.valueOf(this.fIsInstanceFieldCreationPossible).toString());
        hashMap.put(ATTRIBUTE_MANDATORY, Boolean.valueOf(this.fIsInstanceFieldCreationMandatory).toString());
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, RefactoringCoreMessages.MoveInnerToTopRefactoring_move_to_Top);
        dynamicValidationRefactoringChange.addAll((Change[])this.fChangeManager.getAllChanges());
        dynamicValidationRefactoringChange.add(this.createCompilationUnitForMovedType((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        return dynamicValidationRefactoringChange;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextChangeManager createChangeManager(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        Assert.isNotNull((Object)iProgressMonitor);
        Assert.isNotNull((Object)refactoringStatus);
        TextChangeManager textChangeManager = new TextChangeManager();
        try {
            ICompilationUnit iCompilationUnit;
            Object object;
            iProgressMonitor.beginTask(RefactoringCoreMessages.MoveInnerToTopRefactoring_creating_preview, 4);
            HashMap<ICompilationUnit, CompilationUnitRewrite> hashMap = new HashMap<ICompilationUnit, CompilationUnitRewrite>(2);
            this.fSourceRewrite.clearASTAndImportRewrites();
            hashMap.put(this.fSourceRewrite.getCu(), this.fSourceRewrite);
            MemberVisibilityAdjustor memberVisibilityAdjustor = new MemberVisibilityAdjustor((IJavaElement)this.fType.getPackageFragment(), (IMember)this.fType);
            memberVisibilityAdjustor.setRewrites(hashMap);
            memberVisibilityAdjustor.setVisibilitySeverity(2);
            memberVisibilityAdjustor.setFailureSeverity(2);
            memberVisibilityAdjustor.setStatus(refactoringStatus);
            memberVisibilityAdjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            MoveInnerToTopRefactoring.addTypeParameters(this.fSourceRewrite.getRoot(), this.fType, linkedHashMap);
            ITypeBinding[] iTypeBindingArray = new ITypeBinding[linkedHashMap.values().size()];
            linkedHashMap.values().toArray(iTypeBindingArray);
            Map map = this.createTypeReferencesMapping((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
            Map map2 = null;
            map2 = JdtFlags.isStatic((IMember)this.fType) ? new HashMap(0) : this.createConstructorReferencesMapping((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
            if (this.fCreateInstanceField) {
                object = this.fType;
                iCompilationUnit = null;
                while ((object = object.getDeclaringType()) != null) {
                    if (memberVisibilityAdjustor.getAdjustments().containsKey(object) || !Modifier.isPrivate((int)object.getFlags())) continue;
                    memberVisibilityAdjustor.getAdjustments().put(object, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)object, (Modifier.ModifierKeyword)iCompilationUnit, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning, new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)object), MemberVisibilityAdjustor.getLabel((Modifier.ModifierKeyword)iCompilationUnit)}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)object.getCompilationUnit(), object.getSourceRange()))));
                }
            }
            iProgressMonitor.worked(1);
            object = MoveInnerToTopRefactoring.getMergedSet(map.keySet(), map2.keySet()).iterator();
            while (object.hasNext()) {
                iCompilationUnit = (ICompilationUnit)object.next();
                CompilationUnitRewrite compilationUnitRewrite = this.getCompilationUnitRewrite(iCompilationUnit);
                this.createCompilationUnitRewrite(iTypeBindingArray, compilationUnitRewrite, map, map2, memberVisibilityAdjustor.getAdjustments().containsKey(this.fType), this.fType.getCompilationUnit(), iCompilationUnit, false, refactoringStatus, iProgressMonitor);
                if (iCompilationUnit.equals(this.fType.getCompilationUnit())) {
                    Object var13_13;
                    try {
                        memberVisibilityAdjustor.setStatus(new RefactoringStatus());
                        memberVisibilityAdjustor.rewriteVisibility(compilationUnitRewrite.getCu(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    catch (Throwable throwable) {
                        var13_13 = null;
                        memberVisibilityAdjustor.setStatus(refactoringStatus);
                        throw throwable;
                    }
                    {
                        var13_13 = null;
                        memberVisibilityAdjustor.setStatus(refactoringStatus);
                    }
                    this.fNewSourceOfInputType = this.createNewSource(compilationUnitRewrite, iCompilationUnit);
                    compilationUnitRewrite.clearASTAndImportRewrites();
                    this.createCompilationUnitRewrite(iTypeBindingArray, compilationUnitRewrite, map, map2, memberVisibilityAdjustor.getAdjustments().containsKey(this.fType), this.fType.getCompilationUnit(), iCompilationUnit, true, refactoringStatus, iProgressMonitor);
                }
                memberVisibilityAdjustor.rewriteVisibility(compilationUnitRewrite.getCu(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                textChangeManager.manage(iCompilationUnit, (TextChange)compilationUnitRewrite.createChange());
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var15_17 = null;
        }
        iProgressMonitor.done();
        return textChangeManager;
    }

    private Change createCompilationUnitForMovedType(IProgressMonitor iProgressMonitor) throws CoreException {
        CreateCompilationUnitChange createCompilationUnitChange;
        block2: {
            ICompilationUnit iCompilationUnit = null;
            try {
                iCompilationUnit = this.fType.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())).getWorkingCopy(null);
                String string = this.createSourceForNewCu(iCompilationUnit, iProgressMonitor);
                createCompilationUnitChange = new CreateCompilationUnitChange(this.fType.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())), string, null);
                Object var4_5 = null;
                if (iCompilationUnit == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_6 = null;
                    if (iCompilationUnit == null) break block3;
                    iCompilationUnit.discardWorkingCopy();
                }
                throw throwable;
            }
            iCompilationUnit.discardWorkingCopy();
        }
        return createCompilationUnitChange;
    }

    private void createCompilationUnitRewrite(ITypeBinding[] iTypeBindingArray, CompilationUnitRewrite compilationUnitRewrite, Map map, Map map2, boolean bl, ICompilationUnit iCompilationUnit, ICompilationUnit iCompilationUnit2, boolean bl2, RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) throws CoreException {
        ASTNode[] aSTNodeArray;
        Assert.isNotNull((Object)iTypeBindingArray);
        Assert.isNotNull((Object)compilationUnitRewrite);
        Assert.isNotNull((Object)map);
        Assert.isNotNull((Object)map2);
        Assert.isNotNull((Object)iCompilationUnit);
        Assert.isNotNull((Object)iCompilationUnit2);
        CompilationUnit compilationUnit = compilationUnitRewrite.getRoot();
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        if (iCompilationUnit2.equals(iCompilationUnit)) {
            TextEditGroup textEditGroup;
            aSTNodeArray = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, compilationUnit);
            TextEditGroup textEditGroup2 = this.fSourceRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_qualifier);
            ITypeBinding iTypeBinding = aSTNodeArray.resolveBinding();
            if (!bl2) {
                if (!JdtFlags.isStatic((IMember)this.fType) && this.fCreateInstanceField) {
                    if (JavaElementUtil.getAllConstructors(this.fType).length == 0) {
                        this.createConstructor((AbstractTypeDeclaration)aSTNodeArray, aSTRewrite);
                    } else {
                        this.modifyConstructors((AbstractTypeDeclaration)aSTNodeArray, aSTRewrite);
                    }
                    this.addInheritedTypeQualifications((AbstractTypeDeclaration)aSTNodeArray, compilationUnitRewrite, textEditGroup2);
                    this.addEnclosingInstanceDeclaration((AbstractTypeDeclaration)aSTNodeArray, aSTRewrite);
                }
                this.fTypeImports = new HashSet();
                this.fStaticImports = new HashSet();
                ImportRewriteUtil.collectImports(this.fType.getJavaProject(), (ASTNode)aSTNodeArray, this.fTypeImports, this.fStaticImports, false);
                if (iTypeBinding != null) {
                    this.fTypeImports.remove(iTypeBinding);
                }
            }
            this.addEnclosingInstanceTypeParameters(iTypeBindingArray, (AbstractTypeDeclaration)aSTNodeArray, aSTRewrite);
            this.modifyAccessToEnclosingInstance(compilationUnitRewrite, (AbstractTypeDeclaration)aSTNodeArray, refactoringStatus, iProgressMonitor);
            if (iTypeBinding != null) {
                this.modifyInterfaceMemberModifiers(iTypeBinding);
                textEditGroup = iTypeBinding.getDeclaringClass();
                if (textEditGroup != null) {
                    aSTNodeArray.accept((ASTVisitor)new TypeReferenceQualifier(iTypeBinding, null));
                }
            }
            textEditGroup = compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_label);
            if (bl2) {
                aSTRewrite.remove((ASTNode)aSTNodeArray, textEditGroup);
                compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)aSTNodeArray);
            } else {
                int n = JdtFlags.clearFlag(8, aSTNodeArray.getModifiers());
                if (!bl && (Modifier.isPrivate((int)aSTNodeArray.getModifiers()) || Modifier.isProtected((int)aSTNodeArray.getModifiers()))) {
                    n = JdtFlags.clearFlag(6, n);
                    RefactoringStatusEntry refactoringStatusEntry = new RefactoringStatusEntry(2, Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_visibility_type_warning, new String[]{BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)}), JavaStatusContext.create((ITypeRoot)this.fSourceRewrite.getCu()));
                    if (!MoveInnerToTopRefactoring.containsStatusEntry(refactoringStatus, refactoringStatusEntry)) {
                        refactoringStatus.addEntry(refactoringStatusEntry);
                    }
                }
                ModifierRewrite.create(aSTRewrite, (ASTNode)aSTNodeArray).setModifiers(n, textEditGroup);
            }
        }
        aSTNodeArray = MoveInnerToTopRefactoring.getReferenceNodesIn(compilationUnit, map, iCompilationUnit2);
        int n = 0;
        while (n < aSTNodeArray.length) {
            this.updateTypeReference(iTypeBindingArray, aSTNodeArray[n], compilationUnitRewrite, iCompilationUnit2);
            ++n;
        }
        aSTNodeArray = MoveInnerToTopRefactoring.getReferenceNodesIn(compilationUnit, map2, iCompilationUnit2);
        n = 0;
        while (n < aSTNodeArray.length) {
            this.updateConstructorReference(iTypeBindingArray, aSTNodeArray[n], compilationUnitRewrite, iCompilationUnit2);
            ++n;
        }
    }

    private void createConstructor(AbstractTypeDeclaration abstractTypeDeclaration, ASTRewrite aSTRewrite) throws CoreException {
        SingleVariableDeclaration singleVariableDeclaration;
        Assert.isNotNull((Object)abstractTypeDeclaration);
        Assert.isNotNull((Object)aSTRewrite);
        AST aST = abstractTypeDeclaration.getAST();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setConstructor(true);
        methodDeclaration.setName(aST.newSimpleName(abstractTypeDeclaration.getName().getIdentifier()));
        String string = CodeGeneration.getMethodComment(this.fType.getCompilationUnit(), this.fType.getElementName(), this.fType.getElementName(), this.getNewConstructorParameterNames(), new String[0], null, null, StubUtility.getLineDelimiterUsed(this.fType.getJavaProject()));
        if (string != null && string.length() > 0) {
            singleVariableDeclaration = (Javadoc)aSTRewrite.createStringPlaceholder(string, 29);
            methodDeclaration.setJavadoc((Javadoc)singleVariableDeclaration);
        }
        if (this.fCreateInstanceField) {
            FieldAccess fieldAccess;
            singleVariableDeclaration = aST.newSingleVariableDeclaration();
            String string2 = this.getNameForEnclosingInstanceConstructorParameter();
            singleVariableDeclaration.setName(aST.newSimpleName(string2));
            singleVariableDeclaration.setType(this.createEnclosingType(aST));
            methodDeclaration.parameters().add(singleVariableDeclaration);
            Block block = aST.newBlock();
            Assignment assignment = aST.newAssignment();
            if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
                fieldAccess = aST.newFieldAccess();
                fieldAccess.setExpression((Expression)aST.newThisExpression());
                fieldAccess.setName(aST.newSimpleName(this.fEnclosingInstanceFieldName));
                assignment.setLeftHandSide((Expression)fieldAccess);
            } else {
                assignment.setLeftHandSide((Expression)aST.newSimpleName(this.fEnclosingInstanceFieldName));
            }
            assignment.setRightHandSide((Expression)aST.newSimpleName(string2));
            fieldAccess = aST.newExpressionStatement((Expression)assignment);
            block.statements().add(fieldAccess);
            methodDeclaration.setBody(block);
        } else {
            methodDeclaration.setBody(aST.newBlock());
        }
        aSTRewrite.getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertFirst((ASTNode)methodDeclaration, null);
    }

    private Map createConstructorReferencesMapping(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        SearchResultGroup[] searchResultGroupArray = ConstructorReferenceFinder.getConstructorReferences(this.fType, iProgressMonitor, refactoringStatus);
        HashMap<ICompilationUnit, SearchMatch[]> hashMap = new HashMap<ICompilationUnit, SearchMatch[]>();
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit != null) {
                hashMap.put(iCompilationUnit, searchResultGroup.getSearchResults());
            }
            ++n;
        }
        return hashMap;
    }

    private Expression createEnclosingInstanceCreationString(ASTNode aSTNode, ICompilationUnit iCompilationUnit) throws JavaModelException {
        Assert.isTrue((aSTNode instanceof ClassInstanceCreation || aSTNode instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        Assert.isNotNull((Object)iCompilationUnit);
        Expression expression = null;
        expression = aSTNode instanceof ClassInstanceCreation ? ((ClassInstanceCreation)aSTNode).getExpression() : ((SuperConstructorInvocation)aSTNode).getExpression();
        AST aST = aSTNode.getAST();
        if (expression != null) {
            return expression;
        }
        if (JdtFlags.isStatic((IMember)this.fType)) {
            return null;
        }
        if (this.isInsideSubclassOfDeclaringType(aSTNode)) {
            return aST.newThisExpression();
        }
        if (aSTNode.getStartPosition() >= this.fType.getSourceRange().getOffset() && ASTNodes.getExclusiveEnd(aSTNode) <= this.fType.getSourceRange().getOffset() + this.fType.getSourceRange().getLength()) {
            if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
                FieldAccess fieldAccess = aST.newFieldAccess();
                fieldAccess.setExpression((Expression)aST.newThisExpression());
                fieldAccess.setName(aST.newSimpleName(this.fEnclosingInstanceFieldName));
                return fieldAccess;
            }
            return aST.newSimpleName(this.fEnclosingInstanceFieldName);
        }
        if (this.isInsideTypeNestedInDeclaringType(aSTNode)) {
            ThisExpression thisExpression = aST.newThisExpression();
            thisExpression.setQualifier((Name)aST.newSimpleName(this.fType.getDeclaringType().getElementName()));
            return thisExpression;
        }
        return null;
    }

    private Type createEnclosingType(AST aST) throws JavaModelException {
        Assert.isNotNull((Object)aST);
        ITypeParameter[] iTypeParameterArray = this.fType.getDeclaringType().getTypeParameters();
        Type type = ASTNodeFactory.newType(aST, JavaModelUtil.getTypeQualifiedName(this.fType.getDeclaringType()));
        if (iTypeParameterArray.length > 0) {
            ParameterizedType parameterizedType = aST.newParameterizedType(type);
            int n = 0;
            while (n < iTypeParameterArray.length) {
                parameterizedType.typeArguments().add(aST.newSimpleType((Name)aST.newSimpleName(iTypeParameterArray[n].getElementName())));
                ++n;
            }
            return parameterizedType;
        }
        return type;
    }

    private String createNewSource(CompilationUnitRewrite compilationUnitRewrite, ICompilationUnit iCompilationUnit) throws CoreException, JavaModelException {
        Assert.isNotNull((Object)compilationUnitRewrite);
        Assert.isNotNull((Object)iCompilationUnit);
        CompilationUnitChange compilationUnitChange = compilationUnitRewrite.createChange();
        if (compilationUnitChange == null) {
            compilationUnitChange = new CompilationUnitChange("", iCompilationUnit);
        }
        String string = compilationUnitChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setProject(this.fType.getJavaProject());
        aSTParser.setResolveBindings(false);
        aSTParser.setSource(string.toCharArray());
        AbstractTypeDeclaration abstractTypeDeclaration = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, (CompilationUnit)aSTParser.createAST(null));
        return string.substring(abstractTypeDeclaration.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)abstractTypeDeclaration));
    }

    private Expression createQualifiedReadAccessExpressionForEnclosingInstance(AST aST) {
        ThisExpression thisExpression = aST.newThisExpression();
        thisExpression.setQualifier(aST.newName(new String[]{this.fType.getElementName()}));
        FieldAccess fieldAccess = aST.newFieldAccess();
        fieldAccess.setExpression((Expression)thisExpression);
        fieldAccess.setName(aST.newSimpleName(this.fEnclosingInstanceFieldName));
        return fieldAccess;
    }

    private Expression createReadAccessExpressionForEnclosingInstance(AST aST) {
        if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            FieldAccess fieldAccess = aST.newFieldAccess();
            fieldAccess.setExpression((Expression)aST.newThisExpression());
            fieldAccess.setName(aST.newSimpleName(this.fEnclosingInstanceFieldName));
            return fieldAccess;
        }
        return aST.newSimpleName(this.fEnclosingInstanceFieldName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createSourceForNewCu(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)iCompilationUnit);
        Assert.isNotNull((Object)iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 2);
            String string = StubUtility.getLineDelimiterUsed(this.fType.getJavaProject());
            String string2 = this.getAlignedSourceBlock(iCompilationUnit, this.fNewSourceOfInputType);
            String string3 = CodeGeneration.getCompilationUnitContent(iCompilationUnit, null, string2, string);
            if (string3 == null || string2.startsWith("/*") || string2.startsWith("//")) {
                StringBuffer stringBuffer = new StringBuffer();
                if (!this.fType.getPackageFragment().isDefaultPackage()) {
                    stringBuffer.append("package ").append(this.fType.getPackageFragment().getElementName()).append(';');
                }
                stringBuffer.append(string).append(string);
                stringBuffer.append(string2);
                string3 = stringBuffer.toString();
            }
            iCompilationUnit.getBuffer().setContents(string3);
            this.addImportsToTargetUnit(iCompilationUnit, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        iProgressMonitor.done();
        return iCompilationUnit.getSource();
    }

    private Map createTypeReferencesMapping(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)this.fType, (int)3, (int)24));
        refactoringSearchEngine2.setFiltering(true, true);
        refactoringSearchEngine2.setScope(RefactoringScopeFactory.create((IJavaElement)this.fType));
        refactoringSearchEngine2.setStatus(refactoringStatus);
        refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        SearchResultGroup[] searchResultGroupArray = (SearchResultGroup[])refactoringSearchEngine2.getResults();
        HashMap<ICompilationUnit, SearchMatch[]> hashMap = new HashMap<ICompilationUnit, SearchMatch[]>();
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit != null) {
                hashMap.put(iCompilationUnit, searchResultGroup.getSearchResults());
            }
            ++n;
        }
        return hashMap;
    }

    private String getAlignedSourceBlock(ICompilationUnit iCompilationUnit, String string) {
        Assert.isNotNull((Object)string);
        String[] stringArray = Strings.convertIntoLines(string);
        Strings.trimIndentation(stringArray, iCompilationUnit.getJavaProject(), false);
        return Strings.concatenate(stringArray, StubUtility.getLineDelimiterUsed(this.fType.getJavaProject()));
    }

    private CompilationUnitRewrite getCompilationUnitRewrite(ICompilationUnit iCompilationUnit) {
        Assert.isNotNull((Object)iCompilationUnit);
        if (iCompilationUnit.equals(this.fType.getCompilationUnit())) {
            return this.fSourceRewrite;
        }
        return new CompilationUnitRewrite(iCompilationUnit);
    }

    private MethodDeclaration[] getConstructorDeclarationNodes(AbstractTypeDeclaration abstractTypeDeclaration) {
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            MethodDeclaration[] methodDeclarationArray = ((TypeDeclaration)abstractTypeDeclaration).getMethods();
            ArrayList<MethodDeclaration> arrayList = new ArrayList<MethodDeclaration>(2);
            int n = 0;
            while (n < methodDeclarationArray.length) {
                if (methodDeclarationArray[n].isConstructor()) {
                    arrayList.add(methodDeclarationArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new MethodDeclaration[arrayList.size()]);
        }
        return new MethodDeclaration[0];
    }

    public boolean getCreateInstanceField() {
        return this.fCreateInstanceField;
    }

    private int getEnclosingInstanceAccessModifiers() {
        if (this.fMarkInstanceFieldAsFinal) {
            return 18;
        }
        return 2;
    }

    public String getEnclosingInstanceName() {
        return this.fEnclosingInstanceFieldName;
    }

    private String getInitialNameForEnclosingInstanceField() {
        IType iType = this.fType.getDeclaringType();
        if (iType == null) {
            return "";
        }
        String[] stringArray = StubUtility.getFieldNameSuggestions(this.fType.getDeclaringType(), this.getEnclosingInstanceAccessModifiers(), MoveInnerToTopRefactoring.getFieldNames(this.fType));
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        String string = iType.getElementName();
        if (string.equals("")) {
            return "";
        }
        return String.valueOf(Character.toLowerCase(string.charAt(0))) + string.substring(1);
    }

    public IType getInputType() {
        return this.fType;
    }

    public String getName() {
        return RefactoringCoreMessages.MoveInnerToTopRefactoring_name;
    }

    private String getNameForEnclosingInstanceConstructorParameter() throws JavaModelException {
        if (this.fNameForEnclosingInstanceConstructorParameter != null) {
            return this.fNameForEnclosingInstanceConstructorParameter;
        }
        String[] stringArray = StubUtility.getArgumentNameSuggestions(this.fType.getDeclaringType(), MoveInnerToTopRefactoring.getParameterNamesOfAllConstructors(this.fType));
        this.fNameForEnclosingInstanceConstructorParameter = stringArray.length > 0 ? stringArray[0] : this.fEnclosingInstanceFieldName;
        return this.fNameForEnclosingInstanceConstructorParameter;
    }

    private String[] getNewConstructorParameterNames() throws JavaModelException {
        if (!this.fCreateInstanceField) {
            return new String[0];
        }
        return new String[]{this.getNameForEnclosingInstanceConstructorParameter()};
    }

    private ASTNode getNewQualifiedNameNode(ITypeBinding[] iTypeBindingArray, Name name) {
        AST aST = name.getAST();
        boolean bl = false;
        ITypeBinding iTypeBinding = name.resolveTypeBinding();
        if (iTypeBinding != null && iTypeBinding.isRawType()) {
            bl = true;
        }
        if (iTypeBindingArray != null && iTypeBindingArray.length > 0 && !bl) {
            ParameterizedType parameterizedType = aST.newParameterizedType((Type)aST.newSimpleType(aST.newName(this.fQualifiedTypeName)));
            int n = 0;
            while (n < iTypeBindingArray.length) {
                parameterizedType.typeArguments().add(aST.newSimpleType((Name)aST.newSimpleName(iTypeBindingArray[n].getName())));
                ++n;
            }
            return parameterizedType;
        }
        return aST.newName(this.fQualifiedTypeName);
    }

    private ASTNode getNewUnqualifiedTypeNode(ITypeBinding[] iTypeBindingArray, Name name) {
        AST aST = name.getAST();
        boolean bl = false;
        ITypeBinding iTypeBinding = name.resolveTypeBinding();
        if (iTypeBinding != null && iTypeBinding.isRawType()) {
            bl = true;
        }
        if (iTypeBindingArray != null && iTypeBindingArray.length > 0 && !bl) {
            ParameterizedType parameterizedType = aST.newParameterizedType((Type)aST.newSimpleType((Name)aST.newSimpleName(this.fType.getElementName())));
            int n = 0;
            while (n < iTypeBindingArray.length) {
                parameterizedType.typeArguments().add(aST.newSimpleType((Name)aST.newSimpleName(iTypeBindingArray[n].getName())));
                ++n;
            }
            return parameterizedType;
        }
        return aST.newSimpleType((Name)aST.newSimpleName(this.fType.getElementName()));
    }

    private boolean insertExpressionAsParameter(ClassInstanceCreation classInstanceCreation, ASTRewrite aSTRewrite, ICompilationUnit iCompilationUnit, TextEditGroup textEditGroup) throws JavaModelException {
        Expression expression = this.createEnclosingInstanceCreationString((ASTNode)classInstanceCreation, iCompilationUnit);
        if (expression == null) {
            return false;
        }
        aSTRewrite.getListRewrite((ASTNode)classInstanceCreation, ClassInstanceCreation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)expression, textEditGroup);
        return true;
    }

    private boolean insertExpressionAsParameter(SuperConstructorInvocation superConstructorInvocation, ASTRewrite aSTRewrite, ICompilationUnit iCompilationUnit, TextEditGroup textEditGroup) throws JavaModelException {
        Expression expression = this.createEnclosingInstanceCreationString((ASTNode)superConstructorInvocation, iCompilationUnit);
        if (expression == null) {
            return false;
        }
        aSTRewrite.getListRewrite((ASTNode)superConstructorInvocation, SuperConstructorInvocation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)expression, textEditGroup);
        return true;
    }

    public boolean isCreatingInstanceFieldMandatory() {
        return this.fIsInstanceFieldCreationMandatory;
    }

    public boolean isCreatingInstanceFieldPossible() {
        return this.fIsInstanceFieldCreationPossible;
    }

    private boolean isInAnonymousTypeInsideInputType(ASTNode aSTNode, AbstractTypeDeclaration abstractTypeDeclaration) {
        AnonymousClassDeclaration anonymousClassDeclaration;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (anonymousClassDeclaration = (AnonymousClassDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null && ASTNodes.isParent((ASTNode)anonymousClassDeclaration, (ASTNode)abstractTypeDeclaration);
    }

    private boolean isInLocalTypeInsideInputType(ASTNode aSTNode, AbstractTypeDeclaration abstractTypeDeclaration) {
        TypeDeclarationStatement typeDeclarationStatement;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (typeDeclarationStatement = (TypeDeclarationStatement)ASTNodes.getParent(aSTNode, clazz)) != null && ASTNodes.isParent((ASTNode)typeDeclarationStatement, (ASTNode)abstractTypeDeclaration);
    }

    private boolean isInNonStaticMemberTypeInsideInputType(ASTNode aSTNode, AbstractTypeDeclaration abstractTypeDeclaration) {
        AbstractTypeDeclaration abstractTypeDeclaration2;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (abstractTypeDeclaration2 = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null && !abstractTypeDeclaration.equals((Object)abstractTypeDeclaration2) && !Modifier.isStatic((int)abstractTypeDeclaration2.getFlags()) && ASTNodes.isParent((ASTNode)abstractTypeDeclaration2, (ASTNode)abstractTypeDeclaration);
    }

    private boolean isInsideSubclassOfDeclaringType(ASTNode aSTNode) {
        AnonymousClassDeclaration anonymousClassDeclaration;
        boolean bl;
        Assert.isTrue((aSTNode instanceof ClassInstanceCreation || aSTNode instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
        Assert.isNotNull((Object)abstractTypeDeclaration);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean bl2 = bl = (anonymousClassDeclaration = (AnonymousClassDeclaration)ASTNodes.getParent(aSTNode, clazz2)) != null && ASTNodes.isParent((ASTNode)anonymousClassDeclaration, (ASTNode)abstractTypeDeclaration);
        if (bl) {
            return anonymousClassDeclaration != null && this.isSubclassBindingOfEnclosingType(anonymousClassDeclaration.resolveBinding());
        }
        return this.isSubclassBindingOfEnclosingType(abstractTypeDeclaration.resolveBinding());
    }

    private boolean isInsideTypeNestedInDeclaringType(ASTNode aSTNode) {
        Assert.isTrue((aSTNode instanceof ClassInstanceCreation || aSTNode instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
        Assert.isNotNull((Object)abstractTypeDeclaration);
        ITypeBinding iTypeBinding = abstractTypeDeclaration.resolveBinding();
        while (iTypeBinding != null) {
            if (MoveInnerToTopRefactoring.isCorrespondingTypeBinding(iTypeBinding, this.fType.getDeclaringType())) {
                return true;
            }
            iTypeBinding = iTypeBinding.getDeclaringClass();
        }
        return false;
    }

    private boolean isInstanceFieldCreationMandatory() throws JavaModelException {
        MemberAccessNodeCollector memberAccessNodeCollector = new MemberAccessNodeCollector(this.fType.getDeclaringType().newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()));
        MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, this.fSourceRewrite.getRoot()).accept((ASTVisitor)memberAccessNodeCollector);
        return MoveInnerToTopRefactoring.containsNonStatic(memberAccessNodeCollector.getFieldAccesses()) || MoveInnerToTopRefactoring.containsNonStatic(memberAccessNodeCollector.getMethodInvocations()) || MoveInnerToTopRefactoring.containsNonStatic(memberAccessNodeCollector.getSimpleFieldNames());
    }

    public boolean isInstanceFieldMarkedFinal() {
        return this.fMarkInstanceFieldAsFinal;
    }

    private boolean isSubclassBindingOfEnclosingType(ITypeBinding iTypeBinding) {
        while (iTypeBinding != null) {
            if (MoveInnerToTopRefactoring.isCorrespondingTypeBinding(iTypeBinding, this.fType.getDeclaringType())) {
                return true;
            }
            iTypeBinding = iTypeBinding.getSuperclass();
        }
        return false;
    }

    private void modifyAccessToEnclosingInstance(CompilationUnitRewrite compilationUnitRewrite, AbstractTypeDeclaration abstractTypeDeclaration, RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Assert.isNotNull((Object)compilationUnitRewrite);
        Assert.isNotNull((Object)abstractTypeDeclaration);
        Assert.isNotNull((Object)iProgressMonitor);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        MemberAccessNodeCollector memberAccessNodeCollector = new MemberAccessNodeCollector(this.fType.getDeclaringType().newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        abstractTypeDeclaration.accept((ASTVisitor)memberAccessNodeCollector);
        this.modifyAccessToMethodsFromEnclosingInstance(compilationUnitRewrite, hashSet, memberAccessNodeCollector.getMethodInvocations(), abstractTypeDeclaration, refactoringStatus);
        this.modifyAccessToFieldsFromEnclosingInstance(compilationUnitRewrite, hashSet2, memberAccessNodeCollector.getFieldAccesses(), abstractTypeDeclaration, refactoringStatus);
        this.modifyAccessToFieldsFromEnclosingInstance(compilationUnitRewrite, hashSet2, memberAccessNodeCollector.getSimpleFieldNames(), abstractTypeDeclaration, refactoringStatus);
    }

    private void modifyAccessToFieldsFromEnclosingInstance(CompilationUnitRewrite compilationUnitRewrite, Set set, FieldAccess[] fieldAccessArray, AbstractTypeDeclaration abstractTypeDeclaration, RefactoringStatus refactoringStatus) {
        FieldAccess fieldAccess = null;
        int n = 0;
        while (n < fieldAccessArray.length) {
            IVariableBinding iVariableBinding;
            fieldAccess = fieldAccessArray[n];
            Assert.isNotNull((Object)fieldAccess.getExpression());
            if (fieldAccess.getExpression() instanceof ThisExpression && ((ThisExpression)fieldAccess.getExpression()).getQualifier() != null && (iVariableBinding = fieldAccess.resolveFieldBinding()) != null) {
                compilationUnitRewrite.getASTRewrite().replace((ASTNode)fieldAccess.getExpression(), (ASTNode)this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)fieldAccess, (IBinding)iVariableBinding, abstractTypeDeclaration), null);
                compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)fieldAccess.getExpression());
            }
            ++n;
        }
    }

    private void modifyAccessToFieldsFromEnclosingInstance(CompilationUnitRewrite compilationUnitRewrite, Set set, SimpleName[] simpleNameArray, AbstractTypeDeclaration abstractTypeDeclaration, RefactoringStatus refactoringStatus) {
        IBinding iBinding = null;
        SimpleName simpleName = null;
        IVariableBinding iVariableBinding = null;
        int n = 0;
        while (n < simpleNameArray.length) {
            simpleName = simpleNameArray[n];
            iBinding = simpleName.resolveBinding();
            if (iBinding != null && iBinding instanceof IVariableBinding && !(simpleName.getParent() instanceof FieldAccess)) {
                iVariableBinding = (IVariableBinding)iBinding;
                FieldAccess fieldAccess = simpleName.getAST().newFieldAccess();
                fieldAccess.setExpression(this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)simpleName, (IBinding)iVariableBinding, abstractTypeDeclaration));
                fieldAccess.setName(simpleName.getAST().newSimpleName(simpleName.getIdentifier()));
                compilationUnitRewrite.getASTRewrite().replace((ASTNode)simpleName, (ASTNode)fieldAccess, null);
                compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)simpleName);
            }
            ++n;
        }
    }

    private void modifyAccessToMethodsFromEnclosingInstance(CompilationUnitRewrite compilationUnitRewrite, Set set, MethodInvocation[] methodInvocationArray, AbstractTypeDeclaration abstractTypeDeclaration, RefactoringStatus refactoringStatus) {
        IMethodBinding iMethodBinding = null;
        MethodInvocation methodInvocation = null;
        int n = 0;
        while (n < methodInvocationArray.length) {
            methodInvocation = methodInvocationArray[n];
            iMethodBinding = methodInvocation.resolveMethodBinding();
            if (iMethodBinding != null) {
                Expression expression = methodInvocation.getExpression();
                if (expression == null) {
                    Expression expression2 = this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)methodInvocation, (IBinding)iMethodBinding, abstractTypeDeclaration);
                    compilationUnitRewrite.getASTRewrite().set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)expression2, null);
                } else if (methodInvocation.getExpression() instanceof ThisExpression && ((ThisExpression)methodInvocation.getExpression()).getQualifier() != null) {
                    compilationUnitRewrite.getASTRewrite().replace((ASTNode)expression, (ASTNode)this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)methodInvocation, (IBinding)iMethodBinding, abstractTypeDeclaration), null);
                    compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
                }
            }
            ++n;
        }
    }

    private void modifyConstructors(AbstractTypeDeclaration abstractTypeDeclaration, ASTRewrite aSTRewrite) throws CoreException {
        MethodDeclaration[] methodDeclarationArray = this.getConstructorDeclarationNodes(abstractTypeDeclaration);
        int n = 0;
        while (n < methodDeclarationArray.length) {
            Assert.isTrue((boolean)methodDeclarationArray[n].isConstructor());
            this.addParameterToConstructor(aSTRewrite, methodDeclarationArray[n]);
            this.setEnclosingInstanceFieldInConstructor(aSTRewrite, methodDeclarationArray[n]);
            ++n;
        }
    }

    private void modifyInterfaceMemberModifiers(ITypeBinding iTypeBinding) {
        ASTNode aSTNode;
        Assert.isNotNull((Object)iTypeBinding);
        ITypeBinding iTypeBinding2 = iTypeBinding.getDeclaringClass();
        while (iTypeBinding2 != null && !iTypeBinding2.isInterface()) {
            iTypeBinding2 = iTypeBinding2.getDeclaringClass();
        }
        if (iTypeBinding2 != null && (aSTNode = ASTNodes.findDeclaration((IBinding)iTypeBinding, (ASTNode)this.fSourceRewrite.getRoot())) instanceof AbstractTypeDeclaration) {
            ModifierRewrite.create(this.fSourceRewrite.getASTRewrite(), aSTNode).setVisibility(1, null);
        }
    }

    public void setCreateInstanceField(boolean bl) {
        Assert.isTrue((boolean)this.fIsInstanceFieldCreationPossible);
        Assert.isTrue((!this.fIsInstanceFieldCreationMandatory ? 1 : 0) != 0);
        this.fCreateInstanceField = bl;
    }

    private void setEnclosingInstanceFieldInConstructor(ASTRewrite aSTRewrite, MethodDeclaration methodDeclaration) throws JavaModelException {
        AST aST = methodDeclaration.getAST();
        Block block = methodDeclaration.getBody();
        List list = block.statements();
        if (list.isEmpty()) {
            Assignment assignment = aST.newAssignment();
            assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(aST));
            assignment.setRightHandSide((Expression)aST.newSimpleName(this.getNameForEnclosingInstanceConstructorParameter()));
            aSTRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertFirst((ASTNode)aST.newExpressionStatement((Expression)assignment), null);
        } else {
            Statement statement = (Statement)list.get(0);
            if (statement instanceof ConstructorInvocation) {
                aSTRewrite.getListRewrite((ASTNode)statement, ConstructorInvocation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)aST.newSimpleName(this.fEnclosingInstanceFieldName), null);
            } else {
                int n = 0;
                if (statement instanceof SuperConstructorInvocation) {
                    ++n;
                }
                Assignment assignment = aST.newAssignment();
                assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(aST));
                assignment.setRightHandSide((Expression)aST.newSimpleName(this.getNameForEnclosingInstanceConstructorParameter()));
                aSTRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)aST.newExpressionStatement((Expression)assignment), n, null);
            }
        }
    }

    public void setEnclosingInstanceName(String string) {
        Assert.isNotNull((Object)string);
        this.fEnclosingInstanceFieldName = string;
    }

    public void setMarkInstanceFieldAsFinal(boolean bl) {
        this.fMarkInstanceFieldAsFinal = bl;
    }

    private void updateConstructorReference(ClassInstanceCreation classInstanceCreation, CompilationUnitRewrite compilationUnitRewrite, ICompilationUnit iCompilationUnit, TextEditGroup textEditGroup) throws JavaModelException {
        Expression expression;
        Assert.isNotNull((Object)classInstanceCreation);
        Assert.isNotNull((Object)compilationUnitRewrite);
        Assert.isNotNull((Object)iCompilationUnit);
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(classInstanceCreation, aSTRewrite, iCompilationUnit, textEditGroup);
        }
        if ((expression = classInstanceCreation.getExpression()) != null) {
            aSTRewrite.remove((ASTNode)expression, null);
            compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        }
    }

    private void updateConstructorReference(ITypeBinding[] iTypeBindingArray, ASTNode aSTNode, CompilationUnitRewrite compilationUnitRewrite, ICompilationUnit iCompilationUnit) throws CoreException {
        TextEditGroup textEditGroup = compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_update_constructor_reference);
        if (aSTNode instanceof SuperConstructorInvocation) {
            this.updateConstructorReference((SuperConstructorInvocation)aSTNode, compilationUnitRewrite, iCompilationUnit, textEditGroup);
        } else if (aSTNode instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)aSTNode, compilationUnitRewrite, iCompilationUnit, textEditGroup);
        } else if (aSTNode.getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)aSTNode.getParent(), compilationUnitRewrite, iCompilationUnit, textEditGroup);
        } else if (aSTNode.getParent() instanceof ParameterizedType && aSTNode.getParent().getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference(iTypeBindingArray, (ParameterizedType)aSTNode.getParent(), compilationUnitRewrite, iCompilationUnit, textEditGroup);
        }
    }

    private void updateConstructorReference(ITypeBinding[] iTypeBindingArray, ParameterizedType parameterizedType, CompilationUnitRewrite compilationUnitRewrite, ICompilationUnit iCompilationUnit, TextEditGroup textEditGroup) throws CoreException {
        ListRewrite listRewrite = compilationUnitRewrite.getASTRewrite().getListRewrite((ASTNode)parameterizedType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
        TypeParameter typeParameter = null;
        int n = parameterizedType.typeArguments().size();
        while (n < iTypeBindingArray.length) {
            typeParameter = compilationUnitRewrite.getRoot().getAST().newTypeParameter();
            typeParameter.setName(compilationUnitRewrite.getRoot().getAST().newSimpleName(iTypeBindingArray[n].getName()));
            listRewrite.insertLast((ASTNode)typeParameter, textEditGroup);
            ++n;
        }
        if (parameterizedType.getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)parameterizedType.getParent(), compilationUnitRewrite, iCompilationUnit, textEditGroup);
        }
    }

    private void updateConstructorReference(SuperConstructorInvocation superConstructorInvocation, CompilationUnitRewrite compilationUnitRewrite, ICompilationUnit iCompilationUnit, TextEditGroup textEditGroup) throws CoreException {
        Expression expression;
        Assert.isNotNull((Object)superConstructorInvocation);
        Assert.isNotNull((Object)compilationUnitRewrite);
        Assert.isNotNull((Object)iCompilationUnit);
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(superConstructorInvocation, aSTRewrite, iCompilationUnit, textEditGroup);
        }
        if ((expression = superConstructorInvocation.getExpression()) != null) {
            aSTRewrite.remove((ASTNode)expression, null);
            compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        }
    }

    private boolean updateNameReference(ITypeBinding[] iTypeBindingArray, Name name, CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup) {
        if (ASTNodes.asString((ASTNode)name).equals(this.fType.getFullyQualifiedName('.'))) {
            compilationUnitRewrite.getASTRewrite().replace((ASTNode)name, this.getNewQualifiedNameNode(iTypeBindingArray, name), textEditGroup);
            compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
            return true;
        }
        compilationUnitRewrite.getASTRewrite().replace((ASTNode)name, this.getNewUnqualifiedTypeNode(iTypeBindingArray, name), textEditGroup);
        compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
        return true;
    }

    private boolean updateParameterizedTypeReference(ITypeBinding[] iTypeBindingArray, ParameterizedType parameterizedType, CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup) {
        if (!(parameterizedType.getParent() instanceof ClassInstanceCreation)) {
            ListRewrite listRewrite = compilationUnitRewrite.getASTRewrite().getListRewrite((ASTNode)parameterizedType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
            AST aST = compilationUnitRewrite.getRoot().getAST();
            SimpleType simpleType = null;
            int n = parameterizedType.typeArguments().size();
            while (n < iTypeBindingArray.length) {
                simpleType = aST.newSimpleType((Name)aST.newSimpleName(iTypeBindingArray[n].getName()));
                listRewrite.insertLast((ASTNode)simpleType, textEditGroup);
                ++n;
            }
        }
        return true;
    }

    private boolean updateReference(ITypeBinding[] iTypeBindingArray, ASTNode aSTNode, CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup) {
        if (aSTNode.getLocationInParent() == ParameterizedType.TYPE_PROPERTY) {
            this.updateParameterizedTypeReference(iTypeBindingArray, (ParameterizedType)aSTNode.getParent(), compilationUnitRewrite, textEditGroup);
            return this.updateNameReference(new ITypeBinding[0], ((SimpleType)aSTNode).getName(), compilationUnitRewrite, textEditGroup);
        }
        if (aSTNode instanceof QualifiedName) {
            return this.updateNameReference(iTypeBindingArray, (Name)((QualifiedName)aSTNode), compilationUnitRewrite, textEditGroup);
        }
        if (aSTNode instanceof SimpleType) {
            return this.updateNameReference(iTypeBindingArray, ((SimpleType)aSTNode).getName(), compilationUnitRewrite, textEditGroup);
        }
        return false;
    }

    private void updateReferenceInImport(ImportDeclaration importDeclaration, ASTNode aSTNode, CompilationUnitRewrite compilationUnitRewrite) throws CoreException {
        IBinding iBinding = importDeclaration.resolveBinding();
        if (iBinding instanceof ITypeBinding) {
            ITypeBinding iTypeBinding = (ITypeBinding)iBinding;
            ImportRewrite importRewrite = compilationUnitRewrite.getImportRewrite();
            if (importDeclaration.isStatic()) {
                String string;
                String string2 = ASTNodes.asString(aSTNode);
                StringBuffer stringBuffer = new StringBuffer(string2);
                int n = stringBuffer.indexOf(string = this.fType.getDeclaringType().getElementName());
                if (n >= 0) {
                    stringBuffer.delete(n, n + string.length() + 1);
                    String string3 = stringBuffer.toString();
                    if (importDeclaration.isOnDemand()) {
                        importRewrite.removeStaticImport(String.valueOf(string2) + ".*");
                        importRewrite.addStaticImport(string3, "*", false);
                    } else {
                        importRewrite.removeStaticImport(string2);
                        int n2 = string3.lastIndexOf(46);
                        if (n2 >= 0 && n2 < string3.length() - 1) {
                            importRewrite.addStaticImport(string3.substring(0, n2), string3.substring(n2 + 1), false);
                        }
                    }
                }
            } else {
                importRewrite.removeImport(iTypeBinding.getQualifiedName());
            }
        }
    }

    private void updateTypeReference(ITypeBinding[] iTypeBindingArray, ASTNode aSTNode, CompilationUnitRewrite compilationUnitRewrite, ICompilationUnit iCompilationUnit) throws CoreException {
        ImportDeclaration importDeclaration;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.wst.jsdt.core.dom.ImportDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((importDeclaration = (ImportDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null) {
            this.updateReferenceInImport(importDeclaration, aSTNode, compilationUnitRewrite);
        } else {
            TextEditGroup textEditGroup = compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_update_type_reference);
            this.updateReference(iTypeBindingArray, aSTNode, compilationUnitRewrite, textEditGroup);
            if (!this.fType.getPackageFragment().equals(iCompilationUnit.getParent())) {
                String string = String.valueOf(this.fType.getPackageFragment().getElementName()) + '.' + this.fType.getElementName();
                compilationUnitRewrite.getImportRemover().registerAddedImport(string);
                compilationUnitRewrite.getImportRewrite().addImport(string);
            }
        }
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            String string2;
            String string3;
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string4 = javaRefactoringArguments.getAttribute("input");
            if (string4 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string4, false);
                if (object == null || !object.exists() || object.getElementType() != 7) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.move.inner");
                }
                this.fType = (IType)object;
                this.fCodeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fType.getJavaProject());
                try {
                    this.initialize();
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_FIELD_NAME);
            if (object != null && !"".equals(object)) {
                this.fEnclosingInstanceFieldName = object;
            }
            if ((string3 = javaRefactoringArguments.getAttribute(ATTRIBUTE_PARAMETER_NAME)) != null && !"".equals(string3)) {
                this.fNameForEnclosingInstanceConstructorParameter = string3;
            }
            if ((string2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_FIELD)) == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FIELD));
            }
            this.fCreateInstanceField = Boolean.valueOf(string2);
            String string5 = javaRefactoringArguments.getAttribute(ATTRIBUTE_FINAL);
            if (string5 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
            this.fMarkInstanceFieldAsFinal = Boolean.valueOf(string5);
            String string6 = javaRefactoringArguments.getAttribute(ATTRIBUTE_POSSIBLE);
            if (string6 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POSSIBLE));
            }
            this.fIsInstanceFieldCreationPossible = Boolean.valueOf(string6);
            string = javaRefactoringArguments.getAttribute(ATTRIBUTE_MANDATORY);
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MANDATORY));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fIsInstanceFieldCreationMandatory = Boolean.valueOf(string);
        return new RefactoringStatus();
    }

    private static class MemberAccessNodeCollector
    extends ASTVisitor {
        private final List fFieldAccesses = new ArrayList(0);
        private final ITypeHierarchy fHierarchy;
        private final List fMethodAccesses = new ArrayList(0);
        private final List fSimpleNames = new ArrayList(0);

        MemberAccessNodeCollector(ITypeHierarchy iTypeHierarchy) {
            Assert.isNotNull((Object)iTypeHierarchy);
            this.fHierarchy = iTypeHierarchy;
        }

        FieldAccess[] getFieldAccesses() {
            return this.fFieldAccesses.toArray(new FieldAccess[this.fFieldAccesses.size()]);
        }

        MethodInvocation[] getMethodInvocations() {
            return this.fMethodAccesses.toArray(new MethodInvocation[this.fMethodAccesses.size()]);
        }

        SimpleName[] getSimpleFieldNames() {
            return this.fSimpleNames.toArray(new SimpleName[this.fSimpleNames.size()]);
        }

        public boolean visit(FieldAccess fieldAccess) {
            IType iType;
            ITypeBinding iTypeBinding = MoveInnerToTopRefactoring.getDeclaringTypeBinding(fieldAccess);
            if (iTypeBinding != null && (iType = (IType)iTypeBinding.getJavaElement()) != null && this.fHierarchy.contains(iType)) {
                this.fFieldAccesses.add(fieldAccess);
            }
            return super.visit(fieldAccess);
        }

        public boolean visit(MethodInvocation methodInvocation) {
            IType iType;
            ITypeBinding iTypeBinding = MoveInnerToTopRefactoring.getDeclaringTypeBinding(methodInvocation);
            if (iTypeBinding != null && (iType = (IType)iTypeBinding.getJavaElement()) != null && this.fHierarchy.contains(iType)) {
                this.fMethodAccesses.add(methodInvocation);
            }
            return super.visit(methodInvocation);
        }

        public boolean visit(SimpleName simpleName) {
            if (simpleName.getParent() instanceof QualifiedName) {
                return super.visit(simpleName);
            }
            IBinding iBinding = simpleName.resolveBinding();
            if (iBinding instanceof IVariableBinding) {
                IType iType;
                IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
                ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass();
                if (iVariableBinding.isField() && iTypeBinding != null && (iType = (IType)iTypeBinding.getJavaElement()) != null && this.fHierarchy.contains(iType)) {
                    this.fSimpleNames.add(simpleName);
                    return false;
                }
            }
            return super.visit(simpleName);
        }

        public boolean visit(ThisExpression thisExpression) {
            IType iType;
            ITypeBinding iTypeBinding;
            Name name = thisExpression.getQualifier();
            if (name != null && (iTypeBinding = name.resolveTypeBinding()) != null && (iType = (IType)iTypeBinding.getJavaElement()) != null && this.fHierarchy.contains(iType)) {
                this.fSimpleNames.add(name);
                return false;
            }
            return super.visit(thisExpression);
        }
    }

    private class TypeReferenceQualifier
    extends ASTVisitor {
        private final TextEditGroup fGroup;
        private final ITypeBinding fTypeBinding;

        public TypeReferenceQualifier(ITypeBinding iTypeBinding, TextEditGroup textEditGroup) {
            Assert.isNotNull((Object)iTypeBinding);
            Assert.isNotNull((Object)iTypeBinding.getDeclaringClass());
            this.fTypeBinding = iTypeBinding;
            this.fGroup = textEditGroup;
        }

        public boolean visit(ClassInstanceCreation classInstanceCreation) {
            Assert.isNotNull((Object)classInstanceCreation);
            if (MoveInnerToTopRefactoring.this.fCreateInstanceField) {
                AST aST = classInstanceCreation.getAST();
                Type type = classInstanceCreation.getType();
                ITypeBinding iTypeBinding = type.resolveBinding();
                if (iTypeBinding != null && iTypeBinding.getDeclaringClass() != null && !Bindings.equals((IBinding)iTypeBinding, (IBinding)this.fTypeBinding) && MoveInnerToTopRefactoring.this.fSourceRewrite.getRoot().findDeclaringNode((IBinding)iTypeBinding) != null) {
                    if (!Modifier.isStatic((int)iTypeBinding.getModifiers())) {
                        SimpleName simpleName = null;
                        if (((MoveInnerToTopRefactoring)MoveInnerToTopRefactoring.this).fCodeGenerationSettings.useKeywordThis || MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName.equals(MoveInnerToTopRefactoring.this.fNameForEnclosingInstanceConstructorParameter)) {
                            FieldAccess fieldAccess = aST.newFieldAccess();
                            fieldAccess.setExpression((Expression)aST.newThisExpression());
                            fieldAccess.setName(aST.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName));
                            simpleName = fieldAccess;
                        } else {
                            simpleName = aST.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName);
                        }
                        if (classInstanceCreation.getExpression() != null) {
                            MoveInnerToTopRefactoring.this.fSourceRewrite.getImportRemover().registerRemovedNode((ASTNode)classInstanceCreation.getExpression());
                        }
                        MoveInnerToTopRefactoring.this.fSourceRewrite.getASTRewrite().set((ASTNode)classInstanceCreation, (StructuralPropertyDescriptor)ClassInstanceCreation.EXPRESSION_PROPERTY, (Object)simpleName, this.fGroup);
                    } else {
                        MoveInnerToTopRefactoring.this.addTypeQualification(type, MoveInnerToTopRefactoring.this.fSourceRewrite, this.fGroup);
                    }
                }
            }
            return true;
        }

        public boolean visit(QualifiedType qualifiedType) {
            Assert.isNotNull((Object)qualifiedType);
            return false;
        }

        public boolean visit(SimpleType simpleType) {
            ITypeBinding iTypeBinding;
            ITypeBinding iTypeBinding2;
            Assert.isNotNull((Object)simpleType);
            if (!(simpleType.getParent() instanceof ClassInstanceCreation) && (iTypeBinding2 = simpleType.resolveBinding()) != null && (iTypeBinding = iTypeBinding2.getDeclaringClass()) != null && !Bindings.equals((IBinding)iTypeBinding, (IBinding)this.fTypeBinding.getDeclaringClass()) && !Bindings.equals((IBinding)iTypeBinding2, (IBinding)this.fTypeBinding) && MoveInnerToTopRefactoring.this.fSourceRewrite.getRoot().findDeclaringNode((IBinding)iTypeBinding2) != null && Modifier.isStatic((int)iTypeBinding2.getModifiers())) {
                MoveInnerToTopRefactoring.this.addTypeQualification((Type)simpleType, MoveInnerToTopRefactoring.this.fSourceRewrite, this.fGroup);
            }
            return super.visit(simpleType);
        }

        public boolean visit(ThisExpression thisExpression) {
            Assert.isNotNull((Object)thisExpression);
            Name name = thisExpression.getQualifier();
            if (name != null && name.isSimpleName()) {
                AST aST = thisExpression.getAST();
                SimpleName simpleName = null;
                if (((MoveInnerToTopRefactoring)MoveInnerToTopRefactoring.this).fCodeGenerationSettings.useKeywordThis || MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName.equals(MoveInnerToTopRefactoring.this.fNameForEnclosingInstanceConstructorParameter)) {
                    FieldAccess fieldAccess = aST.newFieldAccess();
                    fieldAccess.setExpression((Expression)aST.newThisExpression());
                    fieldAccess.setName(aST.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName));
                    simpleName = fieldAccess;
                } else {
                    simpleName = aST.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName);
                }
                MoveInnerToTopRefactoring.this.fSourceRewrite.getASTRewrite().replace((ASTNode)thisExpression, (ASTNode)simpleName, null);
            }
            return super.visit(thisExpression);
        }
    }
}

