/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.HierarchyProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.IMemberActionInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.TypeVariableUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class PushDownRefactoringProcessor
extends HierarchyProcessor {
    private static final String ATTRIBUTE_ABSTRACT = "abstract";
    private static final String ATTRIBUTE_PUSH = "push";
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.pushDownProcessor";
    private static final GroupCategorySet SET_PUSH_DOWN = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.pushDown", RefactoringCoreMessages.PushDownRefactoring_category_name, RefactoringCoreMessages.PushDownRefactoring_category_description));
    private ITypeHierarchy fCachedClassHierarchy;
    private MemberActionInfo[] fMemberInfos;

    private static MemberActionInfo[] createInfosForAllPushableFieldsAndMethods(IType iType) throws JavaModelException {
        ArrayList<MemberActionInfo> arrayList = new ArrayList<MemberActionInfo>();
        IMember[] iMemberArray = RefactoringAvailabilityTester.getPushDownMembers(iType);
        int n = 0;
        while (n < iMemberArray.length) {
            arrayList.add(MemberActionInfo.create(iMemberArray[n], 2));
            ++n;
        }
        return arrayList.toArray(new MemberActionInfo[arrayList.size()]);
    }

    private static IMember[] getAbstractMembers(IMember[] iMemberArray) throws JavaModelException {
        ArrayList<IMember> arrayList = new ArrayList<IMember>(iMemberArray.length);
        int n = 0;
        while (n < iMemberArray.length) {
            IMember iMember = iMemberArray[n];
            if (JdtFlags.isAbstract(iMember)) {
                arrayList.add(iMember);
            }
            ++n;
        }
        return arrayList.toArray(new IMember[arrayList.size()]);
    }

    private static CompilationUnitRewrite getCompilationUnitRewrite(Map map, ICompilationUnit iCompilationUnit) {
        Assert.isNotNull((Object)map);
        Assert.isNotNull((Object)iCompilationUnit);
        CompilationUnitRewrite compilationUnitRewrite = (CompilationUnitRewrite)map.get(iCompilationUnit);
        if (compilationUnitRewrite == null) {
            compilationUnitRewrite = new CompilationUnitRewrite(iCompilationUnit);
            map.put(iCompilationUnit, compilationUnitRewrite);
        }
        return compilationUnitRewrite;
    }

    private static IJavaElement[] getReferencingElementsFromSameClass(IMember iMember, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        Assert.isNotNull((Object)iMember);
        RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)iMember, (int)2, (int)24));
        refactoringSearchEngine2.setFiltering(true, true);
        refactoringSearchEngine2.setScope(SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iMember.getDeclaringType()}));
        refactoringSearchEngine2.setStatus(refactoringStatus);
        refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        SearchResultGroup[] searchResultGroupArray = (SearchResultGroup[])refactoringSearchEngine2.getResults();
        HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>(3);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
            int n2 = 0;
            while (n2 < searchMatchArray.length) {
                SearchMatch searchMatch = searchMatchArray[n];
                hashSet.add(SearchUtils.getEnclosingJavaElement(searchMatch));
                ++n2;
            }
            ++n;
        }
        return hashSet.toArray(new IJavaElement[hashSet.size()]);
    }

    public PushDownRefactoringProcessor(IMember[] iMemberArray) {
        super(iMemberArray, null, false);
        if (iMemberArray != null) {
            IType iType = RefactoringAvailabilityTester.getTopLevelType(iMemberArray);
            try {
                if (iType != null && RefactoringAvailabilityTester.getPushDownMembers(iType).length != 0) {
                    this.fMembersToMove = new IMember[0];
                    this.fCachedDeclaringType = iType;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
    }

    private void addAllRequiredPushableMembers(List list, IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, 2);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
        subProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, 2);
        IMethod[] iMethodArray = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaElement[]{iMember}, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
        subProgressMonitor = new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1);
        subProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, iMethodArray.length);
        int n = 0;
        while (n < iMethodArray.length) {
            IMethod iMethod = iMethodArray[n];
            if (!MethodChecks.isVirtual(iMethod) && iMethod.getDeclaringType().equals(this.getDeclaringType()) && !list.contains(iMethod) && RefactoringAvailabilityTester.isPushDownAvailable((IMember)iMethod)) {
                list.add(iMethod);
            }
            ++n;
        }
        subProgressMonitor.done();
        IField[] iFieldArray = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaElement[]{iMember}, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        int n2 = 0;
        while (n2 < iFieldArray.length) {
            IField iField = iFieldArray[n2];
            if (iField.getDeclaringType().equals(this.getDeclaringType()) && !list.contains(iField) && RefactoringAvailabilityTester.isPushDownAvailable((IMember)iField)) {
                list.add(iField);
            }
            ++n2;
        }
        iProgressMonitor.done();
    }

    private RefactoringStatus checkAbstractMembersInDestinationClasses(IMember[] iMemberArray, IType[] iTypeArray) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IMember[] iMemberArray2 = PushDownRefactoringProcessor.getAbstractMembers(iMemberArray);
        int n = 0;
        while (n < iTypeArray.length) {
            refactoringStatus.merge(MemberCheckUtil.checkMembersInDestinationType(iMemberArray2, iTypeArray[n]));
            ++n;
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkAccessedFields(IType[] iTypeArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IMember[] iMemberArray = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        List<IMember> list = Arrays.asList(iMemberArray);
        IField[] iFieldArray = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])iMemberArray, iProgressMonitor);
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType = iTypeArray[n];
            ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
            int n2 = 0;
            while (n2 < iFieldArray.length) {
                boolean bl;
                IField iField = iFieldArray[n2];
                boolean bl2 = bl = list.contains(iField) || this.canBeAccessedFrom((IMember)iField, iType, iTypeHierarchy) || Flags.isEnum((int)iField.getFlags());
                if (!bl) {
                    String string = Messages.format(RefactoringCoreMessages.PushDownRefactoring_field_not_accessible, new String[]{JavaElementLabels.getTextLabel(iField, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(iType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
                    refactoringStatus.addError(string, JavaStatusContext.create((IMember)iField));
                }
                ++n2;
            }
            ++n;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkAccessedMethods(IType[] iTypeArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IMember[] iMemberArray = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        List<IMember> list = Arrays.asList(iMemberArray);
        IMethod[] iMethodArray = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])iMemberArray, iProgressMonitor);
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType = iTypeArray[n];
            ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
            int n2 = 0;
            while (n2 < iMethodArray.length) {
                boolean bl;
                IMethod iMethod = iMethodArray[n2];
                boolean bl2 = bl = list.contains(iMethod) || this.canBeAccessedFrom((IMember)iMethod, iType, iTypeHierarchy);
                if (!bl) {
                    String string = Messages.format(RefactoringCoreMessages.PushDownRefactoring_method_not_accessible, new String[]{JavaElementLabels.getTextLabel(iMethod, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(iType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
                    refactoringStatus.addError(string, JavaStatusContext.create((IMember)iMethod));
                }
                ++n2;
            }
            ++n;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkAccessedTypes(IType[] iTypeArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IType[] iTypeArray2 = this.getTypesReferencedInMovedMembers(iProgressMonitor);
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType = iTypeArray[n];
            ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
            int n2 = 0;
            while (n2 < iTypeArray2.length) {
                IType iType2 = iTypeArray2[n2];
                if (!this.canBeAccessedFrom((IMember)iType2, iType, iTypeHierarchy)) {
                    String string = Messages.format(RefactoringCoreMessages.PushDownRefactoring_type_not_accessible, new String[]{JavaElementLabels.getTextLabel(iType2, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(iType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
                    refactoringStatus.addError(string, JavaStatusContext.create((IMember)iType2));
                }
                ++n2;
            }
            ++n;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkElementsAccessedByModifiedMembers(IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        iProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_check_references, 3);
        IType[] iTypeArray = this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        refactoringStatus.merge(this.checkAccessedTypes(iTypeArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        refactoringStatus.merge(this.checkAccessedFields(iTypeArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        refactoringStatus.merge(this.checkAccessedMethods(iTypeArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        block10: {
            RefactoringStatus refactoringStatus2;
            block9: {
                iProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 5);
                this.clearCaches();
                ICompilationUnit iCompilationUnit = this.getDeclaringType().getCompilationUnit();
                if (this.fLayer) {
                    iCompilationUnit = iCompilationUnit.findWorkingCopy(this.fOwner);
                }
                this.resetWorkingCopies(iCompilationUnit);
                refactoringStatus = new RefactoringStatus();
                refactoringStatus.merge(this.checkMembersInDestinationClasses((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                refactoringStatus.merge(this.checkElementsAccessedByModifiedMembers((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                refactoringStatus.merge(this.checkReferencesToPushedDownMembers((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                if (!JdtFlags.isAbstract((IMember)this.getDeclaringType()) && this.getAbstractDeclarationInfos().length != 0) {
                    refactoringStatus.merge(this.checkConstructorCalls(this.getDeclaringType(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                } else {
                    iProgressMonitor.worked(1);
                }
                if (!refactoringStatus.hasFatalError()) break block9;
                RefactoringStatus refactoringStatus3 = refactoringStatus;
                Object var7_8 = null;
                iProgressMonitor.done();
                return refactoringStatus3;
            }
            try {
                ArrayList<IMember> arrayList = new ArrayList<IMember>(this.fMemberInfos.length);
                int n = 0;
                while (n < this.fMemberInfos.length) {
                    if (this.fMemberInfos[n].getAction() != 2) {
                        arrayList.add(this.fMemberInfos[n].getMember());
                    }
                    ++n;
                }
                this.fMembersToMove = arrayList.toArray(new IMember[arrayList.size()]);
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
                if (!refactoringStatus.hasFatalError()) break block10;
                refactoringStatus2 = refactoringStatus;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        refactoringStatus.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getRefactoring().getValidationContext()));
        RefactoringStatus refactoringStatus4 = refactoringStatus;
        Object var7_10 = null;
        iProgressMonitor.done();
        return refactoringStatus4;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus refactoringStatus2;
        block9: {
            block8: {
                block7: {
                    iProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 1);
                    refactoringStatus2 = new RefactoringStatus();
                    refactoringStatus2.merge(this.checkPossibleSubclasses((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                    if (!refactoringStatus2.hasFatalError()) break block7;
                    RefactoringStatus refactoringStatus3 = refactoringStatus2;
                    Object var6_7 = null;
                    iProgressMonitor.done();
                    return refactoringStatus3;
                }
                refactoringStatus2.merge(this.checkDeclaringType((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                if (!refactoringStatus2.hasFatalError()) break block8;
                RefactoringStatus refactoringStatus4 = refactoringStatus2;
                Object var6_8 = null;
                iProgressMonitor.done();
                return refactoringStatus4;
            }
            refactoringStatus2.merge(this.checkIfMembersExist());
            if (!refactoringStatus2.hasFatalError()) break block9;
            RefactoringStatus refactoringStatus5 = refactoringStatus2;
            Object var6_9 = null;
            iProgressMonitor.done();
            return refactoringStatus5;
        }
        try {
            this.fMemberInfos = PushDownRefactoringProcessor.createInfosForAllPushableFieldsAndMethods(this.getDeclaringType());
            List<IMember> list = Arrays.asList(this.fMembersToMove);
            int n = 0;
            while (n < this.fMemberInfos.length) {
                MemberActionInfo memberActionInfo = this.fMemberInfos[n];
                if (list.contains(memberActionInfo.getMember())) {
                    memberActionInfo.setAction(0);
                }
                ++n;
            }
            refactoringStatus = refactoringStatus2;
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkMembersInDestinationClasses(IProgressMonitor iProgressMonitor) throws JavaModelException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 2);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IMember[] iMemberArray = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        IType[] iTypeArray = this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        refactoringStatus.merge(this.checkNonAbstractMembersInDestinationClasses(iMemberArray, iTypeArray));
        List<IMember> list = Arrays.asList(PushDownRefactoringProcessor.getAbstractMembers((IMember[])this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1))));
        IType[] iTypeArray2 = list.toArray(new IType[list.size()]);
        refactoringStatus.merge(this.checkAbstractMembersInDestinationClasses(iMemberArray, iTypeArray2));
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkNonAbstractMembersInDestinationClasses(IMember[] iMemberArray, IType[] iTypeArray) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        ArrayList<IMember> arrayList = new ArrayList<IMember>();
        arrayList.addAll(Arrays.asList(iMemberArray));
        arrayList.removeAll(Arrays.asList(PushDownRefactoringProcessor.getAbstractMembers(iMemberArray)));
        IMember[] iMemberArray2 = arrayList.toArray(new IMember[arrayList.size()]);
        int n = 0;
        while (n < iTypeArray.length) {
            refactoringStatus.merge(MemberCheckUtil.checkMembersInDestinationType(iMemberArray2, iTypeArray[n]));
            ++n;
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkPossibleSubclasses(IProgressMonitor iProgressMonitor) throws JavaModelException {
        IType[] iTypeArray = this.getAbstractDestinations(iProgressMonitor);
        if (iTypeArray.length == 0) {
            String string = Messages.format(RefactoringCoreMessages.PushDownRefactoring_no_subclasses, new String[]{JavaElementLabels.getTextLabel(this.getDeclaringType(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkReferencesToPushedDownMembers(IProgressMonitor iProgressMonitor) throws JavaModelException {
        MemberActionInfo memberActionInfo;
        ArrayList<IMember> arrayList = new ArrayList<IMember>(this.fMemberInfos.length);
        int n = 0;
        while (n < this.fMemberInfos.length) {
            memberActionInfo = this.fMemberInfos[n];
            if (memberActionInfo.isToBePushedDown()) {
                arrayList.add(memberActionInfo.getMember());
            }
            ++n;
        }
        IMember[] iMemberArray = arrayList.toArray(new IMember[arrayList.size()]);
        memberActionInfo = new RefactoringStatus();
        List<IMember> list = Arrays.asList(MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass()));
        iProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_check_references, iMemberArray.length);
        int n2 = 0;
        while (n2 < iMemberArray.length) {
            IMember iMember = iMemberArray[n2];
            String string = PushDownRefactoringProcessor.createLabel(iMember);
            IJavaElement[] iJavaElementArray = PushDownRefactoringProcessor.getReferencingElementsFromSameClass(iMember, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), (RefactoringStatus)memberActionInfo);
            int n3 = 0;
            while (n3 < iJavaElementArray.length) {
                IJavaElement iJavaElement = iJavaElementArray[n3];
                if (!list.contains(iJavaElement) && iJavaElement instanceof IMember) {
                    IMember iMember2 = (IMember)iJavaElement;
                    Object[] objectArray = new Object[]{string, PushDownRefactoringProcessor.createLabel(iMember2)};
                    String string2 = Messages.format(RefactoringCoreMessages.PushDownRefactoring_referenced, objectArray);
                    memberActionInfo.addError(string2, JavaStatusContext.create(iMember2));
                }
                ++n3;
            }
            ++n2;
        }
        iProgressMonitor.done();
        return memberActionInfo;
    }

    public void computeAdditionalRequiredMembersToPushDown(IProgressMonitor iProgressMonitor) throws JavaModelException {
        List<IMember> list = Arrays.asList(this.getAdditionalRequiredMembers(iProgressMonitor));
        int n = 0;
        while (n < this.fMemberInfos.length) {
            MemberActionInfo memberActionInfo = this.fMemberInfos[n];
            if (list.contains(memberActionInfo.getMember())) {
                memberActionInfo.setAction(0);
            }
            ++n;
        }
    }

    private void copyBodyOfPushedDownMethod(ASTRewrite aSTRewrite, IMethod iMethod, MethodDeclaration methodDeclaration, MethodDeclaration methodDeclaration2, TypeVariableMaplet[] typeVariableMapletArray) throws JavaModelException {
        Block block = methodDeclaration.getBody();
        if (block == null) {
            methodDeclaration2.setBody(null);
            return;
        }
        try {
            Document document = new Document(iMethod.getCompilationUnit().getBuffer().getContents());
            ASTRewrite aSTRewrite2 = ASTRewrite.create((AST)block.getAST());
            ITrackedNodePosition iTrackedNodePosition = aSTRewrite2.track((ASTNode)block);
            block.accept((ASTVisitor)new HierarchyProcessor.TypeVariableMapper(aSTRewrite2, typeVariableMapletArray));
            aSTRewrite2.rewriteAST((IDocument)document, this.getDeclaringType().getCompilationUnit().getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            String string = document.get(iTrackedNodePosition.getStartPosition(), iTrackedNodePosition.getLength());
            String[] stringArray = Strings.convertIntoLines(string);
            Strings.trimIndentation(stringArray, iMethod.getJavaProject(), false);
            string = Strings.concatenate(stringArray, StubUtility.getLineDelimiterUsed((IJavaElement)iMethod));
            methodDeclaration2.setBody((Block)aSTRewrite.createStringPlaceholder(string, 8));
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyMembers(Collection collection, Map map, Map map2, RefactoringStatus refactoringStatus, MemberActionInfo[] memberActionInfoArray, IType[] iTypeArray, CompilationUnitRewrite compilationUnitRewrite, CompilationUnitRewrite compilationUnitRewrite2, IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 1);
            IType iType = null;
            TypeVariableMaplet[] typeVariableMapletArray = null;
            int n = 0;
            while (n < iTypeArray.length) {
                iType = iTypeArray[n];
                typeVariableMapletArray = TypeVariableUtil.superTypeToInheritedType(this.getDeclaringType(), iType);
                if (compilationUnitRewrite2.getCu().equals(iType.getCompilationUnit())) {
                    IMember iMember = null;
                    MemberVisibilityAdjustor memberVisibilityAdjustor = null;
                    AbstractTypeDeclaration abstractTypeDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, compilationUnitRewrite2.getRoot());
                    int n2 = memberActionInfoArray.length - 1;
                    while (n2 >= 0) {
                        MethodDeclaration methodDeclaration;
                        VariableDeclarationFragment variableDeclarationFragment;
                        iMember = memberActionInfoArray[n2].getMember();
                        memberVisibilityAdjustor = new MemberVisibilityAdjustor((IJavaElement)iType, iMember);
                        if (memberActionInfoArray[n2].isNewMethodToBeDeclaredAbstract()) {
                            memberVisibilityAdjustor.setIncoming(false);
                        }
                        memberVisibilityAdjustor.setRewrite(compilationUnitRewrite.getASTRewrite(), compilationUnitRewrite.getRoot());
                        memberVisibilityAdjustor.setRewrites(map2);
                        memberVisibilityAdjustor.setFailureSeverity(2);
                        memberVisibilityAdjustor.setStatus(refactoringStatus);
                        memberVisibilityAdjustor.setAdjustments(map);
                        memberVisibilityAdjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        map.remove(iMember);
                        collection.add(memberVisibilityAdjustor);
                        refactoringStatus.merge(PushDownRefactoringProcessor.checkProjectCompliance(PushDownRefactoringProcessor.getCompilationUnitRewrite(map2, this.getDeclaringType().getCompilationUnit()), iType, new IMember[]{memberActionInfoArray[n2].getMember()}));
                        if (memberActionInfoArray[n2].isFieldInfo()) {
                            variableDeclarationFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)memberActionInfoArray[n2].getMember(), compilationUnitRewrite.getRoot());
                            if (variableDeclarationFragment != null) {
                                methodDeclaration = this.createNewFieldDeclarationNode(memberActionInfoArray[n2], compilationUnitRewrite.getRoot(), typeVariableMapletArray, compilationUnitRewrite2.getASTRewrite(), variableDeclarationFragment);
                                compilationUnitRewrite2.getASTRewrite().getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertAt((ASTNode)methodDeclaration, ASTNodes.getInsertionIndex((BodyDeclaration)methodDeclaration, abstractTypeDeclaration.bodyDeclarations()), (TextEditGroup)compilationUnitRewrite2.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, SET_PUSH_DOWN));
                                ImportRewriteUtil.addImports(compilationUnitRewrite2, variableDeclarationFragment.getParent(), new HashMap(), new HashMap(), false);
                            }
                        } else {
                            variableDeclarationFragment = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)memberActionInfoArray[n2].getMember(), compilationUnitRewrite.getRoot());
                            if (variableDeclarationFragment != null) {
                                methodDeclaration = this.createNewMethodDeclarationNode(memberActionInfoArray[n2], compilationUnitRewrite.getRoot(), typeVariableMapletArray, compilationUnitRewrite2, (MethodDeclaration)variableDeclarationFragment);
                                compilationUnitRewrite2.getASTRewrite().getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertAt((ASTNode)methodDeclaration, ASTNodes.getInsertionIndex((BodyDeclaration)methodDeclaration, abstractTypeDeclaration.bodyDeclarations()), (TextEditGroup)compilationUnitRewrite2.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, SET_PUSH_DOWN));
                                ImportRewriteUtil.addImports(compilationUnitRewrite2, (ASTNode)variableDeclarationFragment, new HashMap(), new HashMap(), false);
                            }
                        }
                        --n2;
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var19_21 = null;
        }
        iProgressMonitor.done();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = null;
            IType iType = this.getDeclaringType();
            IJavaProject iJavaProject = iType.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            int n = 589830;
            try {
                if (iType.isLocal() || iType.isAnonymous()) {
                    n |= 0x40000;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            String string2 = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PushDownRefactoring_descriptor_description_short_multi, this.fMembersToMove[0].getElementName()) : RefactoringCoreMessages.PushDownRefactoring_descriptor_description_short;
            String string3 = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PushDownRefactoring_descriptor_description_full, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fMembersToMove[0], JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)iType, JavaElementLabels.ALL_FULLY_QUALIFIED)}) : Messages.format(RefactoringCoreMessages.PushDownRefactoring_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)iType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
            String[] stringArray = new String[this.fMembersToMove.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = JavaElementLabels.getElementLabel((IJavaElement)this.fMembersToMove[n2], JavaElementLabels.ALL_FULLY_QUALIFIED);
                ++n2;
            }
            jDTRefactoringDescriptorComment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.PushDownRefactoring_pushed_members_pattern, stringArray));
            this.addSuperTypeSettings(jDTRefactoringDescriptorComment, true);
            JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.push.down", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, n);
            if (this.fCachedDeclaringType != null) {
                hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fCachedDeclaringType));
            }
            int n3 = 0;
            while (n3 < this.fMembersToMove.length) {
                hashMap.put("element" + (n3 + 1), jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fMembersToMove[n3]));
                int n4 = 0;
                while (n4 < this.fMemberInfos.length) {
                    if (this.fMemberInfos[n4].getMember().equals(this.fMembersToMove[n3])) {
                        switch (this.fMemberInfos[n4].getAction()) {
                            case 1: {
                                hashMap.put(ATTRIBUTE_ABSTRACT + (n3 + 1), Boolean.valueOf(true).toString());
                                break;
                            }
                            case 0: {
                                hashMap.put(ATTRIBUTE_PUSH + (n3 + 1), Boolean.valueOf(true).toString());
                            }
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, RefactoringCoreMessages.PushDownRefactoring_change_name, (Change[])this.fChangeManager.getAllChanges());
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            iProgressMonitor.done();
            this.clearCaches();
            throw throwable;
        }
        iProgressMonitor.done();
        this.clearCaches();
        return dynamicValidationRefactoringChange;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextEditBasedChangeManager createChangeManager(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        TextEditBasedChangeManager textEditBasedChangeManager;
        Assert.isNotNull((Object)iProgressMonitor);
        Assert.isNotNull((Object)refactoringStatus);
        try {
            IMember[] iMemberArray;
            SubProgressMonitor subProgressMonitor;
            CompilationUnitRewrite compilationUnitRewrite;
            ICompilationUnit iCompilationUnit;
            ArrayList arrayList;
            HashMap hashMap;
            iProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 7);
            ICompilationUnit iCompilationUnit2 = this.getDeclaringType().getCompilationUnit();
            CompilationUnitRewrite compilationUnitRewrite2 = new CompilationUnitRewrite(iCompilationUnit2);
            HashMap<ICompilationUnit, CompilationUnitRewrite> hashMap2 = new HashMap<ICompilationUnit, CompilationUnitRewrite>(2);
            hashMap2.put(iCompilationUnit2, compilationUnitRewrite2);
            IType[] iTypeArray = this.getHierarchyOfDeclaringClass((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)).getSubclasses(this.getDeclaringType());
            HashSet<ICompilationUnit> hashSet = new HashSet<ICompilationUnit>(iTypeArray.length + 1);
            int n = 0;
            while (true) {
                if (n >= iTypeArray.length) {
                    hashSet.add(iCompilationUnit2);
                    hashMap = new HashMap();
                    arrayList = new ArrayList();
                    ICompilationUnit[] iCompilationUnitArray = hashSet.toArray(new ICompilationUnit[hashSet.size()]);
                    iCompilationUnit = null;
                    compilationUnitRewrite = null;
                    subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 4);
                    try {
                        subProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, iCompilationUnitArray.length * 4);
                        int n2 = 0;
                        while (n2 < iCompilationUnitArray.length) {
                            int n3;
                            Object[] objectArray;
                            iCompilationUnit = iCompilationUnitArray[n2];
                            compilationUnitRewrite = PushDownRefactoringProcessor.getCompilationUnitRewrite(hashMap2, iCompilationUnit);
                            if (iCompilationUnit.equals(compilationUnitRewrite2.getCu())) {
                                iMemberArray = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getDeclaringType(), compilationUnitRewrite.getRoot());
                                if (!JdtFlags.isAbstract((IMember)this.getDeclaringType()) && this.getAbstractDeclarationInfos().length != 0) {
                                    ModifierRewrite.create(compilationUnitRewrite.getASTRewrite(), (ASTNode)iMemberArray).setModifiers(0x400 | iMemberArray.getModifiers(), (TextEditGroup)compilationUnitRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.PushDownRefactoring_make_abstract, SET_PUSH_DOWN));
                                }
                                PushDownRefactoringProcessor.deleteDeclarationNodes(compilationUnitRewrite2, false, compilationUnitRewrite, Arrays.asList(this.getDeletableMembers()), SET_PUSH_DOWN);
                                objectArray = this.getAbstractDeclarationInfos();
                                n3 = 0;
                                while (n3 < objectArray.length) {
                                    this.declareMethodAbstract((MemberActionInfo)objectArray[n3], compilationUnitRewrite2, compilationUnitRewrite);
                                    ++n3;
                                }
                            }
                            iMemberArray = PushDownRefactoringProcessor.getAbstractMembers((IMember[])this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                            objectArray = new IType[iMemberArray.length];
                            n3 = 0;
                            while (true) {
                                if (n3 >= iMemberArray.length) {
                                    this.copyMembers(arrayList, hashMap, hashMap2, refactoringStatus, this.getAbstractMemberInfos(), (IType[])objectArray, compilationUnitRewrite2, compilationUnitRewrite, (IProgressMonitor)subProgressMonitor);
                                    this.copyMembers(arrayList, hashMap, hashMap2, refactoringStatus, this.getEffectedMemberInfos(), this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)), compilationUnitRewrite2, compilationUnitRewrite, (IProgressMonitor)subProgressMonitor);
                                    if (!iProgressMonitor.isCanceled()) break;
                                    throw new OperationCanceledException();
                                }
                                objectArray[n3] = (IType)iMemberArray[n3];
                                ++n3;
                            }
                            ++n2;
                        }
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var18_22 = null;
                        subProgressMonitor.done();
                        throw throwable;
                    }
                }
                hashSet.add(iTypeArray[n].getCompilationUnit());
                ++n;
            }
            {
                Object var18_23 = null;
            }
            subProgressMonitor.done();
            if (!arrayList.isEmpty() && !hashMap.isEmpty()) {
                MemberVisibilityAdjustor memberVisibilityAdjustor = (MemberVisibilityAdjustor)arrayList.get(0);
                memberVisibilityAdjustor.rewriteVisibility((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            TextEditBasedChangeManager textEditBasedChangeManager2 = new TextEditBasedChangeManager();
            iMemberArray = hashMap2.keySet().iterator();
            while (true) {
                if (!iMemberArray.hasNext()) {
                    textEditBasedChangeManager = textEditBasedChangeManager2;
                    Object var20_25 = null;
                    break;
                }
                iCompilationUnit = (ICompilationUnit)iMemberArray.next();
                compilationUnitRewrite = (CompilationUnitRewrite)hashMap2.get(iCompilationUnit);
                if (compilationUnitRewrite == null) continue;
                textEditBasedChangeManager2.manage(iCompilationUnit, (TextEditBasedChange)compilationUnitRewrite.createChange());
            }
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return textEditBasedChangeManager;
    }

    private FieldDeclaration createNewFieldDeclarationNode(MemberActionInfo memberActionInfo, CompilationUnit compilationUnit, TypeVariableMaplet[] typeVariableMapletArray, ASTRewrite aSTRewrite, VariableDeclarationFragment variableDeclarationFragment) throws JavaModelException {
        Expression expression;
        Assert.isTrue((boolean)memberActionInfo.isFieldInfo());
        IField iField = (IField)memberActionInfo.getMember();
        AST aST = aSTRewrite.getAST();
        VariableDeclarationFragment variableDeclarationFragment2 = aST.newVariableDeclarationFragment();
        variableDeclarationFragment2.setExtraDimensions(variableDeclarationFragment.getExtraDimensions());
        Expression expression2 = variableDeclarationFragment.getInitializer();
        if (expression2 != null) {
            expression = null;
            expression = typeVariableMapletArray.length > 0 ? PushDownRefactoringProcessor.createPlaceholderForExpression(expression2, iField.getCompilationUnit(), typeVariableMapletArray, aSTRewrite) : PushDownRefactoringProcessor.createPlaceholderForExpression(expression2, iField.getCompilationUnit(), aSTRewrite);
            variableDeclarationFragment2.setInitializer(expression);
        }
        variableDeclarationFragment2.setName(aST.newSimpleName(variableDeclarationFragment.getName().getIdentifier()));
        expression = aST.newFieldDeclaration(variableDeclarationFragment2);
        FieldDeclaration fieldDeclaration = ASTNodeSearchUtil.getFieldDeclarationNode(iField, compilationUnit);
        if (memberActionInfo.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoringProcessor.copyJavadocNode(aSTRewrite, (IMember)iField, (BodyDeclaration)fieldDeclaration, (BodyDeclaration)expression);
        }
        PushDownRefactoringProcessor.copyAnnotations(fieldDeclaration, (FieldDeclaration)expression);
        expression.modifiers().addAll(ASTNodeFactory.newModifiers(aST, memberActionInfo.getNewModifiersForCopyInSubclass(fieldDeclaration.getModifiers())));
        Type type = fieldDeclaration.getType();
        ICompilationUnit iCompilationUnit = iField.getCompilationUnit();
        Type type2 = null;
        type2 = typeVariableMapletArray.length > 0 ? PushDownRefactoringProcessor.createPlaceholderForType(type, iCompilationUnit, typeVariableMapletArray, aSTRewrite) : PushDownRefactoringProcessor.createPlaceholderForType(type, iCompilationUnit, aSTRewrite);
        expression.setType(type2);
        return expression;
    }

    private MethodDeclaration createNewMethodDeclarationNode(MemberActionInfo memberActionInfo, CompilationUnit compilationUnit, TypeVariableMaplet[] typeVariableMapletArray, CompilationUnitRewrite compilationUnitRewrite, MethodDeclaration methodDeclaration) throws JavaModelException {
        Assert.isTrue((!memberActionInfo.isFieldInfo() ? 1 : 0) != 0);
        IMethod iMethod = (IMethod)memberActionInfo.getMember();
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        AST aST = aSTRewrite.getAST();
        MethodDeclaration methodDeclaration2 = aST.newMethodDeclaration();
        this.copyBodyOfPushedDownMethod(aSTRewrite, iMethod, methodDeclaration, methodDeclaration2, typeVariableMapletArray);
        methodDeclaration2.setConstructor(methodDeclaration.isConstructor());
        methodDeclaration2.setExtraDimensions(methodDeclaration.getExtraDimensions());
        if (memberActionInfo.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoringProcessor.copyJavadocNode(aSTRewrite, (IMember)iMethod, (BodyDeclaration)methodDeclaration, (BodyDeclaration)methodDeclaration2);
        }
        IJavaProject iJavaProject = compilationUnitRewrite.getCu().getJavaProject();
        if (memberActionInfo.isNewMethodToBeDeclaredAbstract() && JavaModelUtil.is50OrHigher(iJavaProject) && JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)iJavaProject).overrideAnnotation) {
            MarkerAnnotation markerAnnotation = aST.newMarkerAnnotation();
            markerAnnotation.setTypeName((Name)aST.newSimpleName("Override"));
            methodDeclaration2.modifiers().add(markerAnnotation);
        }
        PushDownRefactoringProcessor.copyAnnotations(methodDeclaration, methodDeclaration2);
        methodDeclaration2.modifiers().addAll(ASTNodeFactory.newModifiers(aST, memberActionInfo.getNewModifiersForCopyInSubclass(methodDeclaration.getModifiers())));
        methodDeclaration2.setName(aST.newSimpleName(methodDeclaration.getName().getIdentifier()));
        this.copyReturnType(aSTRewrite, iMethod.getCompilationUnit(), methodDeclaration, methodDeclaration2, typeVariableMapletArray);
        this.copyParameters(aSTRewrite, iMethod.getCompilationUnit(), methodDeclaration, methodDeclaration2, typeVariableMapletArray);
        PushDownRefactoringProcessor.copyThrownExceptions(methodDeclaration, methodDeclaration2);
        PushDownRefactoringProcessor.copyTypeParameters(methodDeclaration, methodDeclaration2);
        return methodDeclaration2;
    }

    private void declareMethodAbstract(MemberActionInfo memberActionInfo, CompilationUnitRewrite compilationUnitRewrite, CompilationUnitRewrite compilationUnitRewrite2) throws JavaModelException {
        Assert.isTrue((!memberActionInfo.isFieldInfo() ? 1 : 0) != 0);
        IMethod iMethod = (IMethod)memberActionInfo.getMember();
        if (JdtFlags.isAbstract((IMember)iMethod)) {
            return;
        }
        MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, compilationUnitRewrite.getRoot());
        compilationUnitRewrite2.getASTRewrite().remove((ASTNode)methodDeclaration.getBody(), null);
        compilationUnitRewrite.getImportRemover().registerRemovedNode((ASTNode)methodDeclaration.getBody());
        ModifierRewrite.create(compilationUnitRewrite2.getASTRewrite(), (ASTNode)methodDeclaration).setModifiers(memberActionInfo.getNewModifiersForOriginal(methodDeclaration.getModifiers()), null);
    }

    private MemberActionInfo[] getAbstractDeclarationInfos() throws JavaModelException {
        ArrayList<MemberActionInfo> arrayList = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int n = 0;
        while (n < this.fMemberInfos.length) {
            MemberActionInfo memberActionInfo = this.fMemberInfos[n];
            if (memberActionInfo.isNewMethodToBeDeclaredAbstract()) {
                arrayList.add(memberActionInfo);
            }
            ++n;
        }
        return arrayList.toArray(new MemberActionInfo[arrayList.size()]);
    }

    private IType[] getAbstractDestinations(IProgressMonitor iProgressMonitor) throws JavaModelException {
        IType[] iTypeArray = this.getHierarchyOfDeclaringClass(iProgressMonitor).getSubclasses(this.getDeclaringType());
        ArrayList<IType> arrayList = new ArrayList<IType>(iTypeArray.length);
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType = iTypeArray[n];
            if (iType.exists() && !iType.isBinary() && !iType.isReadOnly() && iType.getCompilationUnit() != null && iType.isStructureKnown()) {
                arrayList.add(iType);
            }
            ++n;
        }
        return arrayList.toArray(new IType[arrayList.size()]);
    }

    private MemberActionInfo[] getAbstractMemberInfos() throws JavaModelException {
        ArrayList<MemberActionInfo> arrayList = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int n = 0;
        while (n < this.fMemberInfos.length) {
            MemberActionInfo memberActionInfo = this.fMemberInfos[n];
            if (memberActionInfo.isToBeCreatedInSubclassesOfDeclaringClass() && JdtFlags.isAbstract(memberActionInfo.getMember())) {
                arrayList.add(memberActionInfo);
            }
            ++n;
        }
        return arrayList.toArray(new MemberActionInfo[arrayList.size()]);
    }

    public IMember[] getAdditionalRequiredMembers(IProgressMonitor iProgressMonitor) throws JavaModelException {
        IMember iMember;
        IMember[] iMemberArray = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        iProgressMonitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, iMemberArray.length);
        ArrayList<IMember> arrayList = new ArrayList<IMember>(iMemberArray.length);
        arrayList.addAll(Arrays.asList(iMemberArray));
        if (arrayList.isEmpty()) {
            return new IMember[0];
        }
        int n = 0;
        do {
            iMember = (IMember)arrayList.get(n);
            this.addAllRequiredPushableMembers(arrayList, iMember, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (arrayList.size() != ++n) continue;
            iMember = null;
        } while (iMember != null);
        arrayList.removeAll(Arrays.asList(iMemberArray));
        return arrayList.toArray(new IMember[arrayList.size()]);
    }

    private IMember[] getDeletableMembers() {
        ArrayList<IMember> arrayList = new ArrayList<IMember>(this.fMemberInfos.length);
        int n = 0;
        while (n < this.fMemberInfos.length) {
            MemberActionInfo memberActionInfo = this.fMemberInfos[n];
            if (memberActionInfo.isToBeDeletedFromDeclaringClass()) {
                arrayList.add(memberActionInfo.getMember());
            }
            ++n;
        }
        return arrayList.toArray(new IMember[arrayList.size()]);
    }

    private MemberActionInfo[] getEffectedMemberInfos() throws JavaModelException {
        ArrayList<MemberActionInfo> arrayList = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int n = 0;
        while (n < this.fMemberInfos.length) {
            MemberActionInfo memberActionInfo = this.fMemberInfos[n];
            if (memberActionInfo.isToBeCreatedInSubclassesOfDeclaringClass() && !JdtFlags.isAbstract(memberActionInfo.getMember())) {
                arrayList.add(memberActionInfo);
            }
            ++n;
        }
        return arrayList.toArray(new MemberActionInfo[arrayList.size()]);
    }

    public Object[] getElements() {
        return this.fMembersToMove;
    }

    private ITypeHierarchy getHierarchyOfDeclaringClass(IProgressMonitor iProgressMonitor) throws JavaModelException {
        block3: {
            ITypeHierarchy iTypeHierarchy;
            try {
                if (this.fCachedClassHierarchy == null) break block3;
                iTypeHierarchy = this.fCachedClassHierarchy;
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return iTypeHierarchy;
        }
        ITypeHierarchy iTypeHierarchy = this.fCachedClassHierarchy = this.getDeclaringType().newTypeHierarchy(iProgressMonitor);
        Object var2_5 = null;
        iProgressMonitor.done();
        return iTypeHierarchy;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    private MemberActionInfo[] getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass() throws JavaModelException {
        MemberActionInfo[] memberActionInfoArray = this.getAbstractMemberInfos();
        MemberActionInfo[] memberActionInfoArray2 = this.getEffectedMemberInfos();
        ArrayList<MemberActionInfo> arrayList = new ArrayList<MemberActionInfo>(memberActionInfoArray.length + memberActionInfoArray2.length);
        arrayList.addAll(Arrays.asList(memberActionInfoArray));
        arrayList.addAll(Arrays.asList(memberActionInfoArray2));
        return arrayList.toArray(new MemberActionInfo[arrayList.size()]);
    }

    public MemberActionInfo[] getMemberActionInfos() {
        return this.fMemberInfos;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.PushDownRefactoring_name;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute("input");
            if (string != null) {
                IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
                if (iJavaElement == null || !iJavaElement.exists() || iJavaElement.getElementType() != 7) {
                    return ScriptableRefactoring.createInputFatalStatus(iJavaElement, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.push.down");
                }
                this.fCachedDeclaringType = (IType)iJavaElement;
            }
            int n = 1;
            ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
            ArrayList<MemberActionInfo> arrayList2 = new ArrayList<MemberActionInfo>();
            String string2 = "element" + n;
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            while ((string = javaRefactoringArguments.getAttribute(string2)) != null) {
                IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
                if (iJavaElement == null || !iJavaElement.exists()) {
                    refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iJavaElement, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.push.down"));
                } else {
                    arrayList.add(iJavaElement);
                }
                if (javaRefactoringArguments.getAttribute(ATTRIBUTE_ABSTRACT + n) != null) {
                    arrayList2.add(MemberActionInfo.create((IMember)iJavaElement, 1));
                } else if (javaRefactoringArguments.getAttribute(ATTRIBUTE_PUSH + n) != null) {
                    arrayList2.add(MemberActionInfo.create((IMember)iJavaElement, 0));
                } else {
                    arrayList2.add(MemberActionInfo.create((IMember)iJavaElement, 2));
                }
                string2 = "element" + ++n;
            }
            this.fMembersToMove = arrayList.toArray(new IMember[arrayList.size()]);
            this.fMemberInfos = arrayList2.toArray(new MemberActionInfo[arrayList2.size()]);
            if (!refactoringStatus.isOK()) {
                return refactoringStatus;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isPushDownAvailable(this.fMembersToMove);
    }

    protected void rewriteTypeOccurrences(TextEditBasedChangeManager textEditBasedChangeManager, ASTRequestor aSTRequestor, CompilationUnitRewrite compilationUnitRewrite, ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, Set set, IProgressMonitor iProgressMonitor) throws CoreException {
    }

    public static class MemberActionInfo
    implements IMemberActionInfo {
        public static final int NO_ACTION = 2;
        public static final int PUSH_ABSTRACT_ACTION = 1;
        public static final int PUSH_DOWN_ACTION = 0;
        private int fAction;
        private final IMember fMember;

        private static void assertValidAction(IMember iMember, int n) {
            if (iMember instanceof IMethod) {
                Assert.isTrue((n == 1 || n == 2 || n == 0 ? 1 : 0) != 0);
            } else if (iMember instanceof IField) {
                Assert.isTrue((n == 2 || n == 0 ? 1 : 0) != 0);
            }
        }

        public static MemberActionInfo create(IMember iMember, int n) {
            return new MemberActionInfo(iMember, n);
        }

        static IMember[] getMembers(MemberActionInfo[] memberActionInfoArray) {
            IMember[] iMemberArray = new IMember[memberActionInfoArray.length];
            int n = 0;
            while (n < iMemberArray.length) {
                iMemberArray[n] = memberActionInfoArray[n].getMember();
                ++n;
            }
            return iMemberArray;
        }

        private MemberActionInfo(IMember iMember, int n) {
            MemberActionInfo.assertValidAction(iMember, n);
            Assert.isTrue((iMember instanceof IField || iMember instanceof IMethod ? 1 : 0) != 0);
            this.fMember = iMember;
            this.fAction = n;
        }

        boolean copyJavadocToCopiesInSubclasses() {
            return this.isToBeDeletedFromDeclaringClass();
        }

        public int getAction() {
            return this.fAction;
        }

        public int[] getAvailableActions() {
            if (this.isFieldInfo()) {
                int[] nArray = new int[2];
                nArray[1] = 2;
                return nArray;
            }
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            return nArray;
        }

        public IMember getMember() {
            return this.fMember;
        }

        int getNewModifiersForCopyInSubclass(int n) throws JavaModelException {
            if (this.isFieldInfo()) {
                return n;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return n;
            }
            int n2 = n;
            if (this.isNewMethodToBeDeclaredAbstract() && !JdtFlags.isPublic(this.fMember)) {
                n2 = 4 | JdtFlags.clearAccessModifiers(n2);
            }
            return n2;
        }

        int getNewModifiersForOriginal(int n) throws JavaModelException {
            if (this.isFieldInfo()) {
                return n;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return n;
            }
            int n2 = n;
            if (this.isNewMethodToBeDeclaredAbstract()) {
                n2 = JdtFlags.clearFlag(272, n);
                n2 |= 0x400;
                if (!JdtFlags.isPublic(this.fMember)) {
                    n2 = 4 | JdtFlags.clearAccessModifiers(n2);
                }
            }
            return n2;
        }

        public boolean isActive() {
            return this.getAction() != 2;
        }

        public boolean isEditable() {
            if (this.isFieldInfo()) {
                return false;
            }
            return this.getAction() != 2;
        }

        boolean isFieldInfo() {
            return this.fMember instanceof IField;
        }

        boolean isNewMethodToBeDeclaredAbstract() throws JavaModelException {
            return !this.isFieldInfo() && !JdtFlags.isAbstract(this.fMember) && this.fAction == 1;
        }

        boolean isToBeCreatedInSubclassesOfDeclaringClass() {
            return this.fAction != 2;
        }

        boolean isToBeDeletedFromDeclaringClass() {
            return this.isToBePushedDown();
        }

        public boolean isToBePushedDown() {
            return this.fAction == 0;
        }

        public void setAction(int n) {
            MemberActionInfo.assertValidAction(this.fMember, n);
            if (this.isFieldInfo()) {
                Assert.isTrue((n != 1 ? 1 : 0) != 0);
            }
            this.fAction = n;
        }
    }
}

