/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.DeclaringTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.IConstraintVariableFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.IContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.RawBindingVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.TypeVariable;

public class ConstraintVariableFactory
implements IConstraintVariableFactory {
    private Map fBindingMap = new HashMap();
    private Map fExpressionMap = new Hashtable();
    private Map fLiteralMap = new HashMap();
    private Map fTypeVariableMap = new HashMap();
    private Map fDeclaringTypeVariableMap = new HashMap();
    private Map fParameterMap = new HashMap();
    private Map fRawBindingMap = new HashMap();
    private Map fReturnVariableMap = new HashMap();
    public static final boolean REPORT = false;
    protected int nrCreated = 0;
    protected int nrRetrieved = 0;

    public int getNumCreated() {
        return this.nrCreated;
    }

    public ConstraintVariable makeExpressionOrTypeVariable(Expression expression, IContext iContext) {
        IBinding iBinding = ExpressionVariable.resolveBinding(expression);
        if (iBinding instanceof ITypeBinding) {
            ICompilationUnit iCompilationUnit = ASTCreator.getCu((ASTNode)expression);
            Assert.isNotNull((Object)iCompilationUnit);
            CompilationUnitRange compilationUnitRange = new CompilationUnitRange(iCompilationUnit, (ASTNode)expression);
            return this.makeTypeVariable((ITypeBinding)this.getKey(iBinding), expression.toString(), compilationUnitRange);
        }
        if (ASTNodes.isLiteral(expression)) {
            Integer n = new Integer(expression.getNodeType());
            if (!this.fLiteralMap.containsKey(n)) {
                this.fLiteralMap.put(n, new ExpressionVariable(expression));
            }
            return (ExpressionVariable)this.fLiteralMap.get(n);
        }
        Object object = iBinding != null ? this.getKey(iBinding) : new CompilationUnitRange(ASTCreator.getCu((ASTNode)expression), (ASTNode)expression);
        ExpressionVariable expressionVariable = (ExpressionVariable)this.fExpressionMap.get(object);
        if (expressionVariable == null) {
            expressionVariable = new ExpressionVariable(expression);
            this.fExpressionMap.put(object, expressionVariable);
        }
        return expressionVariable;
    }

    private IBinding getKey(IBinding iBinding) {
        if (this.fBindingMap.containsKey(iBinding)) {
            return (IBinding)this.fBindingMap.get(iBinding);
        }
        Iterator iterator = this.fBindingMap.keySet().iterator();
        while (iterator.hasNext()) {
            IBinding iBinding2 = (IBinding)iterator.next();
            if (!Bindings.equals(iBinding, iBinding2)) continue;
            this.fBindingMap.put(iBinding, iBinding2);
            return iBinding2;
        }
        this.fBindingMap.put(iBinding, iBinding);
        return iBinding;
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(ITypeBinding iTypeBinding) {
        String string = iTypeBinding.getKey();
        if (!this.fDeclaringTypeVariableMap.containsKey(string)) {
            this.fDeclaringTypeVariableMap.put(string, new DeclaringTypeVariable(iTypeBinding));
        }
        return (DeclaringTypeVariable)this.fDeclaringTypeVariableMap.get(string);
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(IVariableBinding iVariableBinding) {
        String string = iVariableBinding.getKey();
        if (!this.fDeclaringTypeVariableMap.containsKey(string)) {
            this.fDeclaringTypeVariableMap.put(string, new DeclaringTypeVariable(iVariableBinding));
        }
        return (DeclaringTypeVariable)this.fDeclaringTypeVariableMap.get(string);
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(IMethodBinding iMethodBinding) {
        String string = iMethodBinding.getKey();
        if (!this.fDeclaringTypeVariableMap.containsKey(string)) {
            this.fDeclaringTypeVariableMap.put(string, new DeclaringTypeVariable(iMethodBinding));
        }
        return (DeclaringTypeVariable)this.fDeclaringTypeVariableMap.get(string);
    }

    public ParameterTypeVariable makeParameterTypeVariable(IMethodBinding iMethodBinding, int n) {
        String string = String.valueOf(iMethodBinding.getKey()) + n;
        if (!this.fParameterMap.containsKey(string)) {
            this.fParameterMap.put(string, new ParameterTypeVariable(iMethodBinding, n));
        }
        return (ParameterTypeVariable)this.fParameterMap.get(string);
    }

    public RawBindingVariable makeRawBindingVariable(ITypeBinding iTypeBinding) {
        String string = iTypeBinding.getKey();
        if (!this.fRawBindingMap.containsKey(string)) {
            this.fRawBindingMap.put(string, new RawBindingVariable(iTypeBinding));
        }
        return (RawBindingVariable)this.fRawBindingMap.get(string);
    }

    public ReturnTypeVariable makeReturnTypeVariable(ReturnStatement returnStatement) {
        return this.makeReturnTypeVariable(ReturnTypeVariable.getMethod(returnStatement).resolveBinding());
    }

    public ReturnTypeVariable makeReturnTypeVariable(IMethodBinding iMethodBinding) {
        String string = iMethodBinding.getKey();
        if (!this.fReturnVariableMap.containsKey(string)) {
            this.fReturnVariableMap.put(string, new ReturnTypeVariable(iMethodBinding));
        }
        return (ReturnTypeVariable)this.fReturnVariableMap.get(string);
    }

    public TypeVariable makeTypeVariable(Type type) {
        ICompilationUnit iCompilationUnit = ASTCreator.getCu((ASTNode)type);
        Assert.isNotNull((Object)iCompilationUnit);
        CompilationUnitRange compilationUnitRange = new CompilationUnitRange(iCompilationUnit, (ASTNode)type);
        if (!this.fTypeVariableMap.containsKey(compilationUnitRange)) {
            this.fTypeVariableMap.put(compilationUnitRange, new TypeVariable(type));
        }
        return (TypeVariable)this.fTypeVariableMap.get(compilationUnitRange);
    }

    public TypeVariable makeTypeVariable(ITypeBinding iTypeBinding, String string, CompilationUnitRange compilationUnitRange) {
        if (!this.fTypeVariableMap.containsKey(compilationUnitRange)) {
            this.fTypeVariableMap.put(compilationUnitRange, new TypeVariable(iTypeBinding, string, compilationUnitRange));
        }
        return (TypeVariable)this.fTypeVariableMap.get(compilationUnitRange);
    }

    protected void dumpConstraintStats() {
        System.out.println("created: " + this.nrCreated + ", retrieved: " + this.nrRetrieved);
    }
}

