/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ITypeConstraintFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;

public class TypeConstraintFactory
implements ITypeConstraintFactory {
    private Map fSimpleConstraints = new HashMap();
    private Map fOrConstraints = new HashMap();
    protected static final boolean PRINT_STATS = false;
    protected int fNrCreated = 0;
    protected int fNrFiltered = 0;
    protected int fNrRetrieved = 0;

    private SimpleTypeConstraint createSimpleTypeConstraint(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2, ConstraintOperator constraintOperator) {
        if (this.fSimpleConstraints.containsKey(constraintVariable)) {
            Map map = (Map)this.fSimpleConstraints.get(constraintVariable);
            if (map.containsKey(constraintVariable2)) {
                Map map2 = (Map)map.get(constraintVariable2);
                if (map2.containsKey(constraintOperator)) {
                    return (SimpleTypeConstraint)map2.get(constraintOperator);
                }
                return this.storeConstraint(constraintVariable, constraintVariable2, constraintOperator, map2);
            }
            HashMap hashMap = new HashMap();
            map.put(constraintVariable2, hashMap);
            return this.storeConstraint(constraintVariable, constraintVariable2, constraintOperator, hashMap);
        }
        HashMap hashMap = new HashMap();
        this.fSimpleConstraints.put(constraintVariable, hashMap);
        HashMap hashMap2 = new HashMap();
        hashMap.put(constraintVariable2, hashMap2);
        return this.storeConstraint(constraintVariable, constraintVariable2, constraintOperator, hashMap2);
    }

    private SimpleTypeConstraint storeConstraint(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2, ConstraintOperator constraintOperator, Map map) {
        SimpleTypeConstraint simpleTypeConstraint = new SimpleTypeConstraint(constraintVariable, constraintVariable2, constraintOperator);
        map.put(constraintOperator, simpleTypeConstraint);
        return simpleTypeConstraint;
    }

    public ITypeConstraint[] createConstraint(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2, ConstraintOperator constraintOperator) {
        if (this.filter(constraintVariable, constraintVariable2, constraintOperator)) {
            return new ITypeConstraint[0];
        }
        return new ITypeConstraint[]{this.createSimpleTypeConstraint(constraintVariable, constraintVariable2, constraintOperator)};
    }

    public ITypeConstraint[] createSubtypeConstraint(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2) {
        return this.createConstraint(constraintVariable, constraintVariable2, ConstraintOperator.createSubTypeOperator());
    }

    public ITypeConstraint[] createStrictSubtypeConstraint(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2) {
        return this.createConstraint(constraintVariable, constraintVariable2, ConstraintOperator.createStrictSubtypeOperator());
    }

    public ITypeConstraint[] createEqualsConstraint(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2) {
        return this.createConstraint(constraintVariable, constraintVariable2, ConstraintOperator.createEqualsOperator());
    }

    public ITypeConstraint[] createDefinesConstraint(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2) {
        return this.createConstraint(constraintVariable, constraintVariable2, ConstraintOperator.createDefinesOperator());
    }

    public boolean filter(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2, ConstraintOperator constraintOperator) {
        return constraintVariable.getBinding() != null && constraintVariable.getBinding().isPrimitive() && constraintVariable2.getBinding() != null && constraintVariable2.getBinding().isPrimitive() || constraintVariable == constraintVariable2;
    }

    public CompositeOrTypeConstraint createCompositeOrTypeConstraint(ITypeConstraint[] iTypeConstraintArray) {
        Object object;
        ConstraintVariable constraintVariable = ((SimpleTypeConstraint)iTypeConstraintArray[0]).getLeft();
        String string = "";
        int n = 0;
        while (n < iTypeConstraintArray.length) {
            object = ((SimpleTypeConstraint)iTypeConstraintArray[n]).getRight();
            ITypeBinding iTypeBinding = ((ConstraintVariable)object).getBinding();
            String string2 = iTypeBinding.getQualifiedName();
            string = String.valueOf(string) + string2 + ",";
            ++n;
        }
        if (this.fOrConstraints.containsKey(constraintVariable)) {
            Map map = (Map)this.fOrConstraints.get(constraintVariable);
            if (map.containsKey(string)) {
                return (CompositeOrTypeConstraint)map.get(string);
            }
            object = new CompositeOrTypeConstraint(iTypeConstraintArray);
            map.put(string, object);
            return object;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.fOrConstraints.put(constraintVariable, hashMap);
        object = new CompositeOrTypeConstraint(iTypeConstraintArray);
        hashMap.put(string, object);
        return object;
    }

    protected void dumpStats() {
        System.out.println("Constraints: " + this.fNrCreated + " created, " + this.fNrRetrieved + " retrieved, " + this.fNrFiltered + " filtered");
    }
}

