/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetIntersection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetUnion;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeSet;

public abstract class TypeSet
implements ITypeSet {
    private static int sID = 0;
    protected final int fID;
    private final TypeSetEnvironment fTypeSetEnvironment;

    public TType chooseSingleType() {
        return null;
    }

    public ITypeSet restrictedTo(ITypeSet iTypeSet) {
        throw new UnsupportedOperationException();
    }

    protected TType getJavaLangObject() {
        return this.fTypeSetEnvironment.getJavaLangObject();
    }

    protected TypeSetEnvironment getTypeSetEnvironment() {
        return this.fTypeSetEnvironment;
    }

    public static int getCount() {
        return sID;
    }

    public static void resetCount() {
        sID = 0;
    }

    protected TypeSet(TypeSetEnvironment typeSetEnvironment) {
        this.fTypeSetEnvironment = typeSetEnvironment;
        this.fID = sID++;
    }

    public abstract boolean isUniverse();

    public abstract TypeSet makeClone();

    protected TypeSet specialCasesIntersectedWith(TypeSet typeSet) {
        return null;
    }

    public TypeSet intersectedWith(TypeSet typeSet) {
        TypeSet typeSet2;
        if (typeSet.isUniverse()) {
            return this.makeClone();
        }
        if (this.isUniverse()) {
            return typeSet.makeClone();
        }
        if (this.isEmpty() || typeSet.isEmpty()) {
            return this.getTypeSetEnvironment().getEmptyTypeSet();
        }
        if (this.isSingleton()) {
            if (typeSet.contains(this.anyMember())) {
                return this.makeClone();
            }
            return this.getTypeSetEnvironment().getEmptyTypeSet();
        }
        if (typeSet.isSingleton()) {
            if (this.contains(typeSet.anyMember())) {
                return typeSet.makeClone();
            }
            return this.getTypeSetEnvironment().getEmptyTypeSet();
        }
        if (typeSet instanceof TypeSetIntersection && (((TypeSetIntersection)(typeSet2 = (TypeSetIntersection)typeSet)).getLHS().equals(this) || ((TypeSetIntersection)typeSet2).getRHS().equals(this))) {
            return typeSet2;
        }
        typeSet2 = this.specialCasesIntersectedWith(typeSet);
        if (typeSet2 != null) {
            return typeSet2;
        }
        return new TypeSetIntersection(this, typeSet);
    }

    public TypeSet addedTo(TypeSet typeSet) {
        if (this.isUniverse() || typeSet.isUniverse()) {
            return this.getTypeSetEnvironment().getUniverseTypeSet();
        }
        if ((this instanceof EnumeratedTypeSet || this instanceof SingletonTypeSet) && (typeSet instanceof EnumeratedTypeSet || typeSet instanceof SingletonTypeSet)) {
            EnumeratedTypeSet enumeratedTypeSet = this.enumerate();
            enumeratedTypeSet.addAll(typeSet);
            return enumeratedTypeSet;
        }
        return new TypeSetUnion(this, typeSet);
    }

    public TypeSet subTypes() {
        if (this.isUniverse() || this.contains(this.getJavaLangObject())) {
            return this.getTypeSetEnvironment().getUniverseTypeSet();
        }
        if (this.isSingleton()) {
            return this.possiblyArraySubTypeSetFor(this.anyMember());
        }
        return this.getTypeSetEnvironment().createSubTypesSet(this);
    }

    private TypeSet possiblyArraySubTypeSetFor(TType tType) {
        return this.getTypeSetEnvironment().createSubTypesOfSingleton(tType);
    }

    private TypeSet possiblyArraySuperTypeSetFor(TType tType) {
        return this.getTypeSetEnvironment().createSuperTypesOfSingleton(tType);
    }

    public TypeSet superTypes() {
        if (this.isUniverse()) {
            return this.getTypeSetEnvironment().getUniverseTypeSet();
        }
        if (this.isSingleton()) {
            return this.possiblyArraySuperTypeSetFor(this.anyMember());
        }
        return this.getTypeSetEnvironment().createSuperTypesSet(this);
    }

    public abstract boolean isEmpty();

    public abstract TypeSet upperBound();

    public abstract TypeSet lowerBound();

    public abstract boolean hasUniqueLowerBound();

    public abstract boolean hasUniqueUpperBound();

    public abstract TType uniqueLowerBound();

    public abstract TType uniqueUpperBound();

    public abstract boolean contains(TType var1);

    public abstract boolean containsAll(TypeSet var1);

    public abstract Iterator iterator();

    public abstract EnumeratedTypeSet enumerate();

    public abstract boolean isSingleton();

    public abstract TType anyMember();
}

