/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;

public final class RefactoringFileBuffers {
    public static ITextFileBuffer acquire(ICompilationUnit iCompilationUnit) throws CoreException {
        Assert.isNotNull((Object)iCompilationUnit);
        IResource iResource = iCompilationUnit.getResource();
        if (iResource != null && iResource.getType() == 1) {
            IPath iPath = iResource.getFullPath();
            FileBuffers.getTextFileBufferManager().connect(iPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            return FileBuffers.getTextFileBufferManager().getTextFileBuffer(iPath, LocationKind.IFILE);
        }
        return null;
    }

    public static ITextFileBuffer getTextFileBuffer(ICompilationUnit iCompilationUnit) {
        Assert.isNotNull((Object)iCompilationUnit);
        IResource iResource = iCompilationUnit.getResource();
        if (iResource == null || iResource.getType() != 1) {
            return null;
        }
        return FileBuffers.getTextFileBufferManager().getTextFileBuffer(iResource.getFullPath(), LocationKind.IFILE);
    }

    public static void release(ICompilationUnit iCompilationUnit) throws CoreException {
        Assert.isNotNull((Object)iCompilationUnit);
        IResource iResource = iCompilationUnit.getResource();
        if (iResource != null && iResource.getType() == 1) {
            FileBuffers.getTextFileBufferManager().disconnect(iResource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private RefactoringFileBuffers() {
    }
}

