/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;

public class TightSourceRangeComputer
extends TargetSourceRangeComputer {
    private HashSet fTightSourceRangeNodes = new HashSet();

    public void addTightSourceNode(ASTNode aSTNode) {
        this.fTightSourceRangeNodes.add(aSTNode);
        List list = aSTNode.structuralPropertiesForType();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            StructuralPropertyDescriptor structuralPropertyDescriptor = (StructuralPropertyDescriptor)iterator.next();
            if (structuralPropertyDescriptor.isChildProperty()) {
                object = (ASTNode)aSTNode.getStructuralProperty(structuralPropertyDescriptor);
                if (!this.isExtending((ASTNode)object, aSTNode)) continue;
                this.addTightSourceNode((ASTNode)object);
                continue;
            }
            if (!structuralPropertyDescriptor.isChildListProperty()) continue;
            object = (List)aSTNode.getStructuralProperty(structuralPropertyDescriptor);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                ASTNode aSTNode2 = (ASTNode)iterator2.next();
                if (!this.isExtending(aSTNode2, aSTNode)) continue;
                this.addTightSourceNode(aSTNode2);
            }
        }
    }

    public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode aSTNode) {
        if (this.fTightSourceRangeNodes.contains(aSTNode)) {
            return new TargetSourceRangeComputer.SourceRange(aSTNode.getStartPosition(), aSTNode.getLength());
        }
        return super.computeSourceRange(aSTNode);
    }

    private boolean isExtending(ASTNode aSTNode, ASTNode aSTNode2) {
        int n;
        int n2;
        TargetSourceRangeComputer.SourceRange sourceRange = super.computeSourceRange(aSTNode);
        int n3 = aSTNode2.getStartPosition();
        if (n3 > (n2 = sourceRange.getStartPosition())) {
            return true;
        }
        int n4 = n3 + aSTNode2.getLength();
        return n4 < (n = n2 + sourceRange.getLength());
    }
}

