/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaFormatter;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaVariable;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class JavaContext
extends CompilationUnitContext {
    private CompilationUnitCompletion fCompletion;
    private Set fUsedNames = new HashSet();
    private Map fVariables = new HashMap();

    public JavaContext(TemplateContextType templateContextType, IDocument iDocument, int n, int n2, ICompilationUnit iCompilationUnit) {
        super(templateContextType, iDocument, n, n2, iCompilationUnit);
    }

    public JavaContext(TemplateContextType templateContextType, IDocument iDocument, Position position, ICompilationUnit iCompilationUnit) {
        super(templateContextType, iDocument, position, iCompilationUnit);
    }

    private int getIndentation() {
        int n = this.getStart();
        IDocument iDocument = this.getDocument();
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            IJavaProject iJavaProject = this.getJavaProject();
            return Strings.computeIndentUnits(string, iJavaProject);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        this.clear();
        if (!this.canEvaluate(template)) {
            throw new TemplateException(JavaTemplateMessages.Context_error_cannot_evaluate);
        }
        TemplateTranslator templateTranslator = new TemplateTranslator(){

            protected TemplateVariable createVariable(TemplateVariableType templateVariableType, String string, int[] nArray) {
                JavaVariable javaVariable = new JavaVariable(templateVariableType, string, nArray);
                JavaContext.this.fVariables.put(string, javaVariable);
                return javaVariable;
            }
        };
        TemplateBuffer templateBuffer = templateTranslator.translate(template);
        this.getContextType().resolve(templateBuffer, (TemplateContext)this);
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("org.eclipse.wst.jsdt.ui.template.format");
        IJavaProject iJavaProject = this.getJavaProject();
        JavaFormatter javaFormatter = new JavaFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), this.getIndentation(), bl, iJavaProject);
        javaFormatter.format(templateBuffer, (TemplateContext)this);
        this.clear();
        return templateBuffer;
    }

    private void clear() {
        this.fUsedNames.clear();
    }

    public boolean canEvaluate(Template template) {
        if (this.fForceEvaluation) {
            return true;
        }
        String string = this.getKey();
        return template.matches(string, this.getContextType().getId()) && string.length() != 0 && template.getName().toLowerCase().startsWith(string.toLowerCase());
    }

    public int getStart() {
        if (this.fIsManaged && this.getCompletionLength() > 0) {
            return super.getStart();
        }
        try {
            IDocument iDocument = this.getDocument();
            int n = this.getCompletionOffset();
            int n2 = this.getCompletionOffset() + this.getCompletionLength();
            while (n != 0 && this.isTempalteNamePart(iDocument.getChar(n - 1))) {
                --n;
            }
            while (n != n2 && Character.isWhitespace(iDocument.getChar(n))) {
                ++n;
            }
            if (n == n2) {
                n = this.getCompletionOffset();
            }
            return n;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }

    private boolean isTempalteNamePart(char c) {
        return !Character.isWhitespace(c) && c != '(' && c != ')' && c != '{' && c != '}' && c != ';';
    }

    public int getEnd() {
        if (this.fIsManaged || this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument iDocument = this.getDocument();
            int n = this.getCompletionOffset();
            int n2 = this.getCompletionOffset() + this.getCompletionLength();
            while (n != n2 && Character.isWhitespace(iDocument.getChar(n2 - 1))) {
                --n2;
            }
            return n2;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument iDocument = this.getDocument();
            int n = this.getStart();
            int n2 = this.getCompletionOffset();
            return n <= n2 ? iDocument.get(n, n2 - n) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public char getCharacterBeforeStart() {
        int n = this.getStart();
        try {
            return n == 0 ? (char)' ' : this.getDocument().getChar(n - 1);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }

    private static void handleException(Shell shell, Exception exception) {
        String string = JavaTemplateMessages.JavaContext_error_title;
        if (exception instanceof CoreException) {
            ExceptionHandler.handle((CoreException)((Object)exception), shell, string, null);
        } else if (exception instanceof InvocationTargetException) {
            ExceptionHandler.handle((InvocationTargetException)exception, shell, string, null);
        } else {
            JavaPlugin.log(exception);
            MessageDialog.openError((Shell)shell, (String)string, (String)exception.getMessage());
        }
    }

    private CompilationUnitCompletion getCompletion() {
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        if (this.fCompletion == null) {
            this.fCompletion = new CompilationUnitCompletion(iCompilationUnit);
            if (iCompilationUnit != null) {
                try {
                    iCompilationUnit.codeComplete(this.getStart(), (CompletionRequestor)this.fCompletion);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return this.fCompletion;
    }

    public CompilationUnitCompletion.Variable[] getArrays() {
        CompilationUnitCompletion.Variable[] variableArray = this.getCompletion().findLocalArrays();
        this.arrange(variableArray);
        return variableArray;
    }

    private void arrange(CompilationUnitCompletion.Variable[] variableArray) {
        Arrays.sort(variableArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return this.rank((CompilationUnitCompletion.Variable)object) - this.rank((CompilationUnitCompletion.Variable)object2);
            }

            private int rank(CompilationUnitCompletion.Variable variable) {
                return JavaContext.this.fUsedNames.contains(variable.getName()) ? 1 : 0;
            }
        });
    }

    public CompilationUnitCompletion.Variable[] getLocalVariables(String string) {
        CompilationUnitCompletion.Variable[] variableArray = this.getCompletion().findLocalVariables(string);
        this.arrange(variableArray);
        return variableArray;
    }

    public CompilationUnitCompletion.Variable[] getFields(String string) {
        CompilationUnitCompletion.Variable[] variableArray = this.getCompletion().findFieldVariables(string);
        this.arrange(variableArray);
        return variableArray;
    }

    public CompilationUnitCompletion.Variable[] getIterables() {
        CompilationUnitCompletion.Variable[] variableArray = this.getCompletion().findLocalIterables();
        this.arrange(variableArray);
        return variableArray;
    }

    public void markAsUsed(String string) {
        this.fUsedNames.add(string);
    }

    public String[] suggestVariableNames(String string) throws IllegalArgumentException {
        String[] stringArray = this.computeExcludes();
        String[] stringArray2 = this.suggestVariableName(string, stringArray);
        return stringArray2;
    }

    private String[] computeExcludes() {
        String[] stringArray = this.getCompletion().getLocalVariableNames();
        if (!this.fUsedNames.isEmpty()) {
            String[] stringArray2 = new String[this.fUsedNames.size() + stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            System.arraycopy(this.fUsedNames.toArray(), 0, stringArray2, 0, this.fUsedNames.size());
            stringArray = stringArray2;
        }
        return stringArray;
    }

    private String[] suggestVariableName(String string, String[] stringArray) throws IllegalArgumentException {
        int n = 0;
        while (string.endsWith("[]")) {
            ++n;
            string = string.substring(0, string.length() - 2);
        }
        IJavaProject iJavaProject = this.getJavaProject();
        if (iJavaProject != null) {
            return StubUtility.getVariableNameSuggestions(5, iJavaProject, string, n, Arrays.asList(stringArray), true);
        }
        return new String[]{Signature.getSimpleName((String)string).toLowerCase()};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addImport(String string) {
        if (this.isReadOnly()) {
            return;
        }
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        if (iCompilationUnit == null) {
            return;
        }
        try {
            Object object;
            IDocument iDocument;
            Position position;
            boolean bl;
            boolean bl2 = bl = string.indexOf(46) != -1;
            if (!bl) {
                position = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iCompilationUnit.getJavaProject()});
                object = this.findAllTypes(string, (IJavaSearchScope)position, (SimpleName)(iDocument = null), null, iCompilationUnit);
                if (((TypeNameMatch[])object).length != 1) {
                    return;
                }
                string = object[0].getFullyQualifiedName();
            }
            position = new Position(this.getCompletionOffset(), this.getCompletionLength());
            iDocument = this.getDocument();
            object = "__template_position_importer" + System.currentTimeMillis();
            DefaultPositionUpdater defaultPositionUpdater = new DefaultPositionUpdater((String)object);
            iDocument.addPositionCategory((String)object);
            iDocument.addPositionUpdater((IPositionUpdater)defaultPositionUpdater);
            iDocument.addPosition(position);
            try {
                try {
                    ImportRewrite importRewrite = StubUtility.createImportRewrite(iCompilationUnit, true);
                    CompilationUnit compilationUnit = this.getASTRoot(iCompilationUnit);
                    ContextSensitiveImportRewriteContext contextSensitiveImportRewriteContext = compilationUnit == null ? null : new ContextSensitiveImportRewriteContext(compilationUnit, this.getCompletionOffset(), importRewrite);
                    importRewrite.addImport(string, contextSensitiveImportRewriteContext);
                    JavaModelUtil.applyEdit(iCompilationUnit, importRewrite.rewriteImports(null), false, null);
                    this.setCompletionOffset(position.getOffset());
                    this.setCompletionLength(position.getLength());
                }
                catch (CoreException coreException) {
                    JavaContext.handleException(null, (Exception)((Object)coreException));
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                iDocument.removePosition(position);
                iDocument.removePositionUpdater((IPositionUpdater)defaultPositionUpdater);
                iDocument.removePositionCategory((String)object);
                throw throwable;
            }
            {
                Object var11_17 = null;
                iDocument.removePosition(position);
                iDocument.removePositionUpdater((IPositionUpdater)defaultPositionUpdater);
                iDocument.removePositionCategory((String)object);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            JavaContext.handleException(null, (Exception)((Object)badLocationException));
            return;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            JavaContext.handleException(null, (Exception)((Object)badPositionCategoryException));
            return;
        }
        catch (JavaModelException javaModelException) {
            JavaContext.handleException(null, (Exception)((Object)javaModelException));
        }
    }

    private CompilationUnit getASTRoot(ICompilationUnit iCompilationUnit) {
        return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }

    private TypeNameMatch[] findAllTypes(String string, IJavaSearchScope iJavaSearchScope, SimpleName simpleName, IProgressMonitor iProgressMonitor, ICompilationUnit iCompilationUnit) throws JavaModelException {
        boolean bl = JavaModelUtil.is50OrHigher(iCompilationUnit.getJavaProject());
        int n = 126;
        if (simpleName != null) {
            n = ASTResolving.getPossibleTypeKinds((ASTNode)simpleName, bl);
        }
        ArrayList arrayList = new ArrayList();
        TypeNameMatchCollector typeNameMatchCollector = new TypeNameMatchCollector(arrayList);
        new SearchEngine().searchAllTypeNames(null, 0, string.toCharArray(), 8, this.getSearchForConstant(n), iJavaSearchScope, (TypeNameMatchRequestor)typeNameMatchCollector, 1, iProgressMonitor);
        ArrayList<TypeNameMatch> arrayList2 = new ArrayList<TypeNameMatch>(arrayList.size());
        int n2 = 0;
        int n3 = arrayList.size();
        while (n2 < n3) {
            TypeNameMatch typeNameMatch = (TypeNameMatch)arrayList.get(n2);
            if (typeNameMatch.getPackageName().length() > 0 && this.isOfKind(typeNameMatch, n, bl) && this.isVisible(typeNameMatch, iCompilationUnit)) {
                arrayList2.add(typeNameMatch);
            }
            ++n2;
        }
        return arrayList2.toArray(new TypeNameMatch[arrayList2.size()]);
    }

    private int getSearchForConstant(int n) {
        switch (n & 0x1E) {
            case 2: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 16: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 18: {
                return 9;
            }
        }
        return 0;
    }

    private boolean isOfKind(TypeNameMatch typeNameMatch, int n, boolean bl) {
        int n2 = typeNameMatch.getModifiers();
        if (Flags.isAnnotation((int)n2)) {
            return bl && (n & 8) != 0;
        }
        if (Flags.isEnum((int)n2)) {
            return bl && (n & 0x10) != 0;
        }
        if (Flags.isInterface((int)n2)) {
            return (n & 4) != 0;
        }
        return (n & 2) != 0;
    }

    private boolean isVisible(TypeNameMatch typeNameMatch, ICompilationUnit iCompilationUnit) {
        int n = typeNameMatch.getModifiers();
        if (Flags.isPrivate((int)n)) {
            return false;
        }
        if (Flags.isPublic((int)n) || Flags.isProtected((int)n)) {
            return true;
        }
        return typeNameMatch.getPackageName().equals(iCompilationUnit.getParent().getElementName());
    }

    public static String evaluateTemplate(Template template, ICompilationUnit iCompilationUnit, int n) throws CoreException, BadLocationException, TemplateException {
        TemplateContextType templateContextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("javaScript");
        if (templateContextType == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, JavaTemplateMessages.JavaContext_error_message, null));
        }
        Document document = new Document();
        if (iCompilationUnit != null && iCompilationUnit.exists()) {
            document.set(iCompilationUnit.getSource());
        }
        JavaContext javaContext = new JavaContext(templateContextType, (IDocument)document, n, 0, iCompilationUnit);
        javaContext.setForceEvaluation(true);
        TemplateBuffer templateBuffer = javaContext.evaluate(template);
        if (templateBuffer == null) {
            return null;
        }
        return templateBuffer.getString();
    }

    TemplateVariable getTemplateVariable(String string) {
        TemplateVariable templateVariable = (TemplateVariable)this.fVariables.get(string);
        if (templateVariable != null && !templateVariable.isResolved()) {
            this.getContextType().resolve(templateVariable, (TemplateContext)this);
        }
        return templateVariable;
    }

    public void addDependency(MultiVariable multiVariable, MultiVariable multiVariable2) {
        MultiVariableGuess multiVariableGuess = this.getMultiVariableGuess();
        if (multiVariableGuess == null) {
            multiVariableGuess = new MultiVariableGuess();
            this.setMultiVariableGuess(multiVariableGuess);
        }
        multiVariableGuess.addDependency(multiVariable, multiVariable2);
    }
}

