/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.ExclusivePositionUpdater;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.wst.jsdt.internal.ui.text.FastJavaPartitionScanner;

public class JavaFormatter {
    private static final String COMMENT_START = "/*-";
    private static final String COMMENT_END = "*/";
    private final String fLineDelimiter;
    private final int fInitialIndentLevel;
    private boolean fUseCodeFormatter;
    private final IJavaProject fProject;

    public JavaFormatter(String string, int n, boolean bl, IJavaProject iJavaProject) {
        this.fLineDelimiter = string;
        this.fUseCodeFormatter = bl;
        this.fInitialIndentLevel = n;
        this.fProject = iJavaProject;
    }

    public void format(TemplateBuffer templateBuffer, TemplateContext templateContext) throws BadLocationException {
        try {
            VariableTracker variableTracker = new VariableTracker(templateBuffer);
            IDocument iDocument = variableTracker.getDocument();
            this.internalFormat(iDocument, templateContext);
            this.convertLineDelimiters(iDocument);
            if (!this.isReplacedAreaEmpty(templateContext)) {
                this.trimStart(iDocument);
            }
            variableTracker.updateBuffer();
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new BadLocationException();
        }
    }

    private void internalFormat(IDocument iDocument, TemplateContext templateContext) throws BadLocationException {
        if (this.fUseCodeFormatter) {
            try {
                this.format(iDocument, (CompilationUnitContext)templateContext);
                return;
            }
            catch (BadLocationException badLocationException) {
            }
            catch (MalformedTreeException malformedTreeException) {}
        }
        this.indent(iDocument);
    }

    private void convertLineDelimiters(IDocument iDocument) throws BadLocationException {
        int n = iDocument.getNumberOfLines();
        int n2 = 0;
        while (n2 < n) {
            IRegion iRegion = iDocument.getLineInformation(n2);
            String string = iDocument.getLineDelimiter(n2);
            if (string != null) {
                iDocument.replace(iRegion.getOffset() + iRegion.getLength(), string.length(), this.fLineDelimiter);
            }
            ++n2;
        }
    }

    private void trimStart(IDocument iDocument) throws BadLocationException {
        int n = 0;
        while (n != iDocument.getLength() && Character.isWhitespace(iDocument.getChar(n))) {
            ++n;
        }
        iDocument.replace(0, n, "");
    }

    private boolean isReplacedAreaEmpty(TemplateContext templateContext) {
        DocumentTemplateContext documentTemplateContext;
        if (templateContext instanceof DocumentTemplateContext && (documentTemplateContext = (DocumentTemplateContext)templateContext).getStart() == documentTemplateContext.getCompletionOffset()) {
            try {
                if (documentTemplateContext.getDocument().get(documentTemplateContext.getStart(), documentTemplateContext.getEnd() - documentTemplateContext.getStart()).trim().length() == 0) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }
        return false;
    }

    private void format(IDocument iDocument, CompilationUnitContext compilationUnitContext) throws BadLocationException {
        IJavaProject iJavaProject = compilationUnitContext.getJavaProject();
        Map map = iJavaProject != null ? iJavaProject.getOptions(true) : JavaCore.getOptions();
        String string = iDocument.get();
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        int[] nArray2 = nArray;
        TextEdit textEdit = null;
        int n = 0;
        while (n < nArray2.length && textEdit == null) {
            textEdit = CodeFormatterUtil.format2(nArray2[n], string, this.fInitialIndentLevel, this.fLineDelimiter, map);
            ++n;
        }
        if (textEdit == null) {
            throw new BadLocationException();
        }
        textEdit.apply(iDocument, 2);
    }

    private void indent(IDocument iDocument) throws BadLocationException, MalformedTreeException {
        int n = iDocument.getLineOffset(0);
        iDocument.replace(n, 0, CodeFormatterUtil.createIndentString(this.fInitialIndentLevel, this.fProject));
        int n2 = iDocument.getNumberOfLines();
        IndentUtil.indentLines(iDocument, (ILineRange)new LineRange(1, n2 - 1), this.fProject, null);
    }

    private static final class VariableTracker {
        private static final String CATEGORY = "__template_variables";
        private Document fDocument;
        private final TemplateBuffer fBuffer;
        private List fPositions;

        public VariableTracker(TemplateBuffer templateBuffer) throws MalformedTreeException, BadLocationException {
            Assert.isLegal((templateBuffer != null ? 1 : 0) != 0);
            this.fBuffer = templateBuffer;
            this.fDocument = new Document(this.fBuffer.getString());
            VariableTracker.installJavaStuff(this.fDocument);
            this.fDocument.addPositionCategory(CATEGORY);
            this.fDocument.addPositionUpdater((IPositionUpdater)new ExclusivePositionUpdater(CATEGORY));
            this.fPositions = this.createRangeMarkers(this.fBuffer.getVariables(), (IDocument)this.fDocument);
        }

        private static void installJavaStuff(Document document) {
            String[] stringArray = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character", "__dftl_partition_content_type"};
            FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)new FastJavaPartitionScanner(), stringArray);
            fastPartitioner.connect((IDocument)document);
            document.setDocumentPartitioner("___java_partitioning", (IDocumentPartitioner)fastPartitioner);
        }

        public IDocument getDocument() {
            this.checkState();
            return this.fDocument;
        }

        private void checkState() {
            if (this.fDocument == null) {
                throw new IllegalStateException();
            }
        }

        public TemplateBuffer updateBuffer() throws MalformedTreeException, BadLocationException {
            this.checkState();
            TemplateVariable[] templateVariableArray = this.fBuffer.getVariables();
            try {
                this.removeRangeMarkers(this.fPositions, (IDocument)this.fDocument, templateVariableArray);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
            this.fBuffer.setContent(this.fDocument.get(), templateVariableArray);
            this.fDocument = null;
            return this.fBuffer;
        }

        private List createRangeMarkers(TemplateVariable[] templateVariableArray, IDocument iDocument) throws MalformedTreeException, BadLocationException {
            String string;
            Object object;
            Object object2;
            HashMap<ReplaceEdit, String> hashMap = new HashMap<ReplaceEdit, String>();
            MultiTextEdit multiTextEdit = new MultiTextEdit(0, iDocument.getLength());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = false;
            int n = 0;
            while (n != templateVariableArray.length) {
                object2 = templateVariableArray[n];
                object = object2.getOffsets();
                string = object2.getDefaultValue();
                if (this.isWhitespaceVariable(string)) {
                    String string2 = JavaFormatter.COMMENT_START + string + JavaFormatter.COMMENT_END;
                    int n2 = 0;
                    while (n2 != ((int[])object).length) {
                        ReplaceEdit replaceEdit = new ReplaceEdit(object[n2], string.length(), string2);
                        multiTextEdit.addChild((TextEdit)replaceEdit);
                        bl = true;
                        hashMap.put(replaceEdit, string);
                        arrayList.add(replaceEdit);
                        ++n2;
                    }
                } else {
                    int n3 = 0;
                    while (n3 != ((int[])object).length) {
                        RangeMarker rangeMarker = new RangeMarker(object[n3], string.length());
                        multiTextEdit.addChild((TextEdit)rangeMarker);
                        arrayList.add(rangeMarker);
                        ++n3;
                    }
                }
                ++n;
            }
            if (bl) {
                multiTextEdit.apply(iDocument, 2);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (TextEdit)object2.next();
                try {
                    string = new TypedPosition(object.getOffset(), object.getLength(), (String)hashMap.get(object));
                    iDocument.addPosition(CATEGORY, (Position)string);
                    arrayList2.add(string);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    Assert.isTrue((boolean)false);
                }
            }
            return arrayList2;
        }

        private boolean isWhitespaceVariable(String string) {
            int n = string.length();
            return n == 0 || Character.isWhitespace(string.charAt(0)) || Character.isWhitespace(string.charAt(n - 1));
        }

        private void removeRangeMarkers(List list, IDocument iDocument, TemplateVariable[] templateVariableArray) throws MalformedTreeException, BadLocationException, BadPositionCategoryException {
            String string;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TypedPosition typedPosition = (TypedPosition)iterator.next();
                iDocument.removePosition(CATEGORY, (Position)typedPosition);
                string = typedPosition.getType();
                if (string != null) {
                    iDocument.replace(typedPosition.getOffset(), typedPosition.getLength(), string);
                    typedPosition.setLength(string.length());
                }
                iDocument.addPosition((Position)typedPosition);
            }
            iterator = list.iterator();
            int n = 0;
            while (n != templateVariableArray.length) {
                string = templateVariableArray[n];
                int[] nArray = new int[string.getOffsets().length];
                int n2 = 0;
                while (n2 != nArray.length) {
                    nArray[n2] = ((Position)iterator.next()).getOffset();
                    ++n2;
                }
                string.setOffsets(nArray);
                ++n;
            }
        }
    }
}

