/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.internal.corext.CorextMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;

public class Resources {
    private Resources() {
    }

    public static IStatus checkInSync(IResource iResource) {
        return Resources.checkInSync(new IResource[]{iResource});
    }

    public static IStatus checkInSync(IResource[] iResourceArray) {
        IStatus iStatus = null;
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (!iResource.isSynchronized(2)) {
                iStatus = Resources.addOutOfSync(iStatus, iResource);
            }
            ++n;
        }
        if (iStatus != null) {
            return iStatus;
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    public static IStatus makeCommittable(IResource iResource, Object object) {
        return Resources.makeCommittable(new IResource[]{iResource}, object);
    }

    public static IStatus makeCommittable(IResource[] iResourceArray, Object object) {
        IResource iResource;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        int n = 0;
        while (n < iResourceArray.length) {
            iResource = iResourceArray[n];
            if (iResource.getType() == 1 && Resources.isReadOnly(iResource)) {
                arrayList.add(iResource);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }
        Map map = Resources.createModificationStampMap(arrayList);
        iResource = ResourcesPlugin.getWorkspace().validateEdit(arrayList.toArray(new IFile[arrayList.size()]), object);
        if (!iResource.isOK()) {
            return iResource;
        }
        IStatus iStatus = null;
        Map map2 = Resources.createModificationStampMap(arrayList);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            IFile iFile = (IFile)iterator.next();
            if (map.get(iFile).equals(map2.get(iFile))) continue;
            iStatus = Resources.addModified(iStatus, iFile);
        }
        if (iStatus != null) {
            return iStatus;
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    private static Map createModificationStampMap(List list) {
        HashMap<IFile, Long> hashMap = new HashMap<IFile, Long>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IFile iFile = (IFile)iterator.next();
            hashMap.put(iFile, new Long(iFile.getModificationStamp()));
        }
        return hashMap;
    }

    private static IStatus addModified(IStatus iStatus, IFile iFile) {
        IStatus iStatus2 = JavaUIStatus.createError(10003, Messages.format(CorextMessages.Resources_fileModified, iFile.getFullPath().toString()), null);
        if (iStatus == null) {
            return iStatus2;
        }
        if (iStatus.isMultiStatus()) {
            ((MultiStatus)iStatus).add(iStatus2);
            return iStatus;
        }
        MultiStatus multiStatus = new MultiStatus(JavaPlugin.getPluginId(), 10003, CorextMessages.Resources_modifiedResources, null);
        multiStatus.add(iStatus);
        multiStatus.add(iStatus2);
        return multiStatus;
    }

    private static IStatus addOutOfSync(IStatus iStatus, IResource iResource) {
        Status status = new Status(4, "org.eclipse.core.resources", 274, Messages.format(CorextMessages.Resources_outOfSync, iResource.getFullPath().toString()), null);
        if (iStatus == null) {
            return status;
        }
        if (iStatus.isMultiStatus()) {
            ((MultiStatus)iStatus).add((IStatus)status);
            return iStatus;
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 274, CorextMessages.Resources_outOfSyncResources, null);
        multiStatus.add(iStatus);
        multiStatus.add((IStatus)status);
        return multiStatus;
    }

    public static String[] getLocationOSStrings(IResource[] iResourceArray) {
        ArrayList<String> arrayList = new ArrayList<String>(iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            IPath iPath = iResourceArray[n].getLocation();
            if (iPath != null) {
                arrayList.add(iPath.toOSString());
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getLocationString(IResource iResource) {
        URI uRI = iResource.getLocationURI();
        if (uRI == null) {
            return null;
        }
        return "file".equalsIgnoreCase(uRI.getScheme()) ? new File(uRI).getAbsolutePath() : uRI.toString();
    }

    public static boolean isReadOnly(IResource iResource) {
        ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
        if (resourceAttributes == null) {
            return false;
        }
        return resourceAttributes.isReadOnly();
    }

    static void setReadOnly(IResource iResource, boolean bl) {
        ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
        if (resourceAttributes == null) {
            return;
        }
        resourceAttributes.setReadOnly(bl);
        try {
            iResource.setResourceAttributes(resourceAttributes);
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
    }
}

