/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;

public class InterfaceIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ListenerList fListeners;
    private IElementChangedListener fChangeListener;

    public Image decorateImage(Image image, Object object) {
        return null;
    }

    public String decorateText(String string, Object object) {
        return string;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fChangeListener == null) {
            this.fChangeListener = new IntefaceIndicatorChangeListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.fChangeListener);
        }
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)iLabelProviderListener);
    }

    public void dispose() {
        if (this.fChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fChangeListener);
            this.fChangeListener = null;
        }
        if (this.fListeners != null) {
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                this.fListeners.remove(objectArray[n]);
                ++n;
            }
            this.fListeners = null;
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)iLabelProviderListener);
        if (this.fListeners.isEmpty() && this.fChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fChangeListener);
            this.fChangeListener = null;
        }
    }

    public void decorate(Object object, IDecoration iDecoration) {
        try {
            ImageDescriptor imageDescriptor = this.getOverlay(object);
            if (imageDescriptor == null) {
                return;
            }
            iDecoration.addOverlay(imageDescriptor, 1);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    private ImageDescriptor getOverlay(Object object) throws JavaModelException {
        if (object instanceof ICompilationUnit) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)object;
            if (iCompilationUnit.isOpen()) {
                IType iType = iCompilationUnit.findPrimaryType();
                if (iType != null) {
                    return this.getOverlayFromFlags(iType.getFlags());
                }
                return null;
            }
            String string = JavaCore.removeJavaLikeExtension((String)iCompilationUnit.getElementName());
            return this.getOverlayWithSearchEngine((ITypeRoot)iCompilationUnit, string);
        }
        if (object instanceof IClassFile) {
            IClassFile iClassFile = (IClassFile)object;
            if (iClassFile.isOpen()) {
                return this.getOverlayFromFlags(iClassFile.getType().getFlags());
            }
            String string = iClassFile.getType().getElementName();
            return this.getOverlayWithSearchEngine((ITypeRoot)iClassFile, string);
        }
        return null;
    }

    private ImageDescriptor getOverlayWithSearchEngine(ITypeRoot iTypeRoot, String string) {
        class Result
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            int modifiers;

            public Result(int n) {
                this.modifiers = n;
            }
        }
        SearchEngine searchEngine = new SearchEngine();
        IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iTypeRoot});
        TypeNameRequestor typeNameRequestor = new TypeNameRequestor(){

            public void acceptType(int n, char[] cArray, char[] cArray2, char[][] cArray3, String string) {
                if (cArray3.length == 0 && Flags.isPublic((int)n)) {
                    throw new Result(n);
                }
            }
        };
        try {
            String string2 = iTypeRoot.getParent().getElementName();
            int n = 8;
            searchEngine.searchAllTypeNames(string2.toCharArray(), n, string.toCharArray(), n, 0, iJavaSearchScope, typeNameRequestor, 3, null);
        }
        catch (Result result) {
            return this.getOverlayFromFlags(result.modifiers);
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return null;
    }

    private ImageDescriptor getOverlayFromFlags(int n) {
        if (Flags.isAnnotation((int)n)) {
            return JavaPluginImages.DESC_OVR_ANNOTATION;
        }
        if (Flags.isEnum((int)n)) {
            return JavaPluginImages.DESC_OVR_ENUM;
        }
        if (Flags.isInterface((int)n)) {
            return JavaPluginImages.DESC_OVR_INTERFACE;
        }
        if (Flags.isAbstract((int)n)) {
            return JavaPluginImages.DESC_OVR_ABSTRACT_CLASS;
        }
        return null;
    }

    private void fireChange(IJavaElement[] iJavaElementArray) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            LabelProviderChangedEvent labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])iJavaElementArray);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ILabelProviderListener)objectArray[n]).labelProviderChanged(labelProviderChangedEvent);
                ++n;
            }
        }
    }

    private void processDelta(IJavaElementDelta iJavaElementDelta, List list) {
        IJavaElement iJavaElement = iJavaElementDelta.getElement();
        boolean bl = iJavaElementDelta.getKind() == 4;
        boolean bl2 = iJavaElementDelta.getKind() == 2;
        int n = iJavaElementDelta.getFlags();
        switch (iJavaElement.getElementType()) {
            case 2: {
                if (bl2 || bl && (n & 0x400) != 0) {
                    return;
                }
                this.processChildrenDelta(iJavaElementDelta, list);
                return;
            }
            case 3: {
                if (bl2 || bl && ((n & 0x8000) != 0 || (n & 0x80) != 0)) {
                    return;
                }
                this.processChildrenDelta(iJavaElementDelta, list);
                return;
            }
            case 4: {
                if (bl2) {
                    return;
                }
                this.processChildrenDelta(iJavaElementDelta, list);
                return;
            }
            case 6: 
            case 7: {
                return;
            }
            case 1: {
                this.processChildrenDelta(iJavaElementDelta, list);
                return;
            }
            case 5: {
                if (!JavaModelUtil.isPrimary((ICompilationUnit)iJavaElement)) {
                    return;
                }
                if (bl && ((n & 1) != 0 || (n & 0x4000) != 0)) {
                    if (iJavaElementDelta.getAffectedChildren().length == 0) {
                        return;
                    }
                    list.add(iJavaElement);
                }
                return;
            }
        }
    }

    private boolean processChildrenDelta(IJavaElementDelta iJavaElementDelta, List list) {
        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
        int n = 0;
        while (n < iJavaElementDeltaArray.length) {
            this.processDelta(iJavaElementDeltaArray[n], list);
            ++n;
        }
        return false;
    }

    private class IntefaceIndicatorChangeListener
    implements IElementChangedListener {
        private IntefaceIndicatorChangeListener() {
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            ArrayList arrayList = new ArrayList();
            InterfaceIndicatorLabelDecorator.this.processDelta(elementChangedEvent.getDelta(), arrayList);
            if (arrayList.size() == 0) {
                return;
            }
            InterfaceIndicatorLabelDecorator.this.fireChange(arrayList.toArray(new IJavaElement[arrayList.size()]));
        }
    }
}

