/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.Hashtable;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.CleanUpAction;
import org.eclipse.wst.jsdt.internal.ui.dialogs.SortMembersMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.SortMembersCleanUp;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;

public class MultiSortMembersAction
extends CleanUpAction {
    public MultiSortMembersAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.SortMembersAction_label);
        this.setDescription(ActionMessages.SortMembersAction_description);
        this.setToolTipText(ActionMessages.SortMembersAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.sort_members_action");
    }

    public MultiSortMembersAction(JavaEditor javaEditor) {
        super(javaEditor);
        this.setText(ActionMessages.SortMembersAction_label);
        this.setDescription(ActionMessages.SortMembersAction_description);
        this.setToolTipText(ActionMessages.SortMembersAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.sort_members_action");
    }

    protected ICleanUp[] createCleanUps(ICompilationUnit[] iCompilationUnitArray) {
        try {
            if (!this.hasMembersToSort(iCompilationUnitArray)) {
                return null;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return null;
        }
        SortMembersMessageDialog sortMembersMessageDialog = new SortMembersMessageDialog(this.getShell());
        if (sortMembersMessageDialog.open() != 0) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("cleanup.sort_members", "true");
        hashtable.put("cleanup.sort_members_all", !sortMembersMessageDialog.isNotSortingFieldsEnabled() ? "true" : "false");
        return new ICleanUp[]{new SortMembersCleanUp(hashtable)};
    }

    protected String getActionName() {
        return ActionMessages.SortMembersAction_dialog_title;
    }

    private boolean hasMembersToSort(ICompilationUnit[] iCompilationUnitArray) throws JavaModelException {
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            if (this.hasMembersToSort((IJavaElement[])iCompilationUnitArray[n].getTypes())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasMembersToSort(IJavaElement[] iJavaElementArray) throws JavaModelException {
        if (iJavaElementArray.length > 1) {
            return true;
        }
        if (iJavaElementArray.length == 0) {
            return false;
        }
        IJavaElement iJavaElement = iJavaElementArray[0];
        if (!(iJavaElement instanceof IParent)) {
            return false;
        }
        return this.hasMembersToSort(((IParent)iJavaElement).getChildren());
    }
}

