/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;

public class LogicalPackage
extends PlatformObject {
    private Set fPackages;
    private String fName;
    private IJavaProject fJavaProject;

    public LogicalPackage(IPackageFragment iPackageFragment) {
        Assert.isNotNull((Object)iPackageFragment);
        this.fPackages = new HashSet();
        this.fJavaProject = iPackageFragment.getJavaProject();
        Assert.isNotNull((Object)this.fJavaProject);
        this.add(iPackageFragment);
        this.fName = iPackageFragment.getElementName();
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public IPackageFragment[] getFragments() {
        return this.fPackages.toArray(new IPackageFragment[this.fPackages.size()]);
    }

    public void add(IPackageFragment iPackageFragment) {
        Assert.isTrue((iPackageFragment != null && this.fJavaProject.equals(iPackageFragment.getJavaProject()) ? 1 : 0) != 0);
        this.fPackages.add(iPackageFragment);
    }

    public void remove(IPackageFragment iPackageFragment) {
        this.fPackages.remove(iPackageFragment);
    }

    public boolean contains(IPackageFragment iPackageFragment) {
        return this.fPackages.contains(iPackageFragment);
    }

    public String getElementName() {
        return this.fName;
    }

    public int size() {
        return this.fPackages.size();
    }

    public boolean belongs(IPackageFragment iPackageFragment) {
        if (iPackageFragment == null) {
            return false;
        }
        if (this.fJavaProject.equals(iPackageFragment.getJavaProject())) {
            return this.fName.equals(iPackageFragment.getElementName());
        }
        return false;
    }

    public boolean hasSubpackages() throws JavaModelException {
        Iterator iterator = this.fPackages.iterator();
        while (iterator.hasNext()) {
            IPackageFragment iPackageFragment = (IPackageFragment)iterator.next();
            if (!iPackageFragment.hasSubpackages()) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultPackage() {
        return this.fName.length() == 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LogicalPackage)) {
            return false;
        }
        LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
        if (!this.fJavaProject.equals(logicalPackage.getJavaProject())) {
            return false;
        }
        IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
        if (iPackageFragmentArray.length != this.getFragments().length) {
            return false;
        }
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            IPackageFragment iPackageFragment = iPackageFragmentArray[n];
            if (!this.fPackages.contains(iPackageFragment)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        IPackageFragment[] iPackageFragmentArray = this.getFragments();
        return this.fJavaProject.hashCode() + this.getHash(iPackageFragmentArray, iPackageFragmentArray.length - 1);
    }

    private int getHash(IPackageFragment[] iPackageFragmentArray, int n) {
        if (n <= 0) {
            return iPackageFragmentArray[0].hashCode() * 17;
        }
        return iPackageFragmentArray[n].hashCode() * 17 + this.getHash(iPackageFragmentArray, n - 1);
    }
}

