/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;

class FocusOnSelectionAction
extends Action {
    private CallHierarchyViewPart fPart;

    public FocusOnSelectionAction(CallHierarchyViewPart callHierarchyViewPart) {
        super(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_text);
        this.fPart = callHierarchyViewPart;
        this.setDescription(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_description);
        this.setToolTipText(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_focus_on_selection_action_context");
    }

    public boolean canActionBeAdded() {
        Object object = SelectionUtil.getSingleElement(this.getSelection());
        IMethod iMethod = this.getSelectedMethod(object);
        if (iMethod != null) {
            this.setText(Messages.format(CallHierarchyMessages.FocusOnSelectionAction_focusOn_text, iMethod.getElementName()));
            return true;
        }
        return false;
    }

    private IMethod getSelectedMethod(Object object) {
        IMember iMember;
        IMethod iMethod = null;
        if (object instanceof IMethod) {
            iMethod = (IMethod)object;
        } else if (object instanceof MethodWrapper && (iMember = ((MethodWrapper)((Object)object)).getMember()).getElementType() == 9) {
            iMethod = (IMethod)iMember;
        }
        return iMethod;
    }

    public void run() {
        Object object = SelectionUtil.getSingleElement(this.getSelection());
        IMethod iMethod = this.getSelectedMethod(object);
        if (iMethod != null) {
            this.fPart.setMethod(iMethod);
        }
    }

    private ISelection getSelection() {
        ISelectionProvider iSelectionProvider = this.fPart.getSite().getSelectionProvider();
        if (iSelectionProvider != null) {
            return iSelectionProvider.getSelection();
        }
        return null;
    }
}

