/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.HistoryAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.HistoryListAction;

class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private CallHierarchyViewPart fView;
    private Menu fMenu;

    public HistoryDropDownAction(CallHierarchyViewPart callHierarchyViewPart) {
        this.fView = callHierarchyViewPart;
        this.fMenu = null;
        this.setToolTipText(CallHierarchyMessages.HistoryDropDownAction_tooltip);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "history_list.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_history_drop_down_action_context");
        this.setMenuCreator(this);
    }

    public Menu getMenu(Menu menu) {
        return null;
    }

    public Menu getMenu(Control control) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(control);
        IMethod[] iMethodArray = this.fView.getHistoryEntries();
        this.addEntries(this.fMenu, iMethodArray);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new HistoryListAction(this.fView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fView));
        return this.fMenu;
    }

    public void dispose() {
        this.fView = null;
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    protected void addActionToMenu(Menu menu, Action action) {
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)action);
        actionContributionItem.fill(menu, -1);
    }

    private boolean addEntries(Menu menu, IMethod[] iMethodArray) {
        boolean bl = false;
        int n = Math.min(iMethodArray.length, 10);
        int n2 = 0;
        while (n2 < n) {
            HistoryAction historyAction = new HistoryAction(this.fView, iMethodArray[n2]);
            historyAction.setChecked(iMethodArray[n2].equals(this.fView.getMethod()));
            bl = bl || historyAction.isChecked();
            this.addActionToMenu(menu, historyAction);
            ++n2;
        }
        return bl;
    }

    public void run() {
        new HistoryListAction(this.fView).run();
    }

    private static class ClearHistoryAction
    extends Action {
        private CallHierarchyViewPart fView;

        public ClearHistoryAction(CallHierarchyViewPart callHierarchyViewPart) {
            super(CallHierarchyMessages.HistoryDropDownAction_clearhistory_label);
            this.fView = callHierarchyViewPart;
        }

        public void run() {
            this.fView.setHistoryEntries(new IMethod[0]);
            this.fView.setMethod(null);
        }
    }
}

