/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.commands;

import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;

public class JavaElementReferenceConverter
extends AbstractParameterValueConverter {
    private static final char PROJECT_END_CHAR = '/';
    private static final char TYPE_END_CHAR = '#';
    private static final char PARAM_START_CHAR = '(';
    private static final char PARAM_END_CHAR = ')';

    public Object convertToObject(String string) throws ParameterValueConversionException {
        this.assertWellFormed(string != null);
        int n = string.indexOf(47);
        this.assertWellFormed(n != -1);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.assertExists((IJavaElement)iJavaModel);
        IJavaProject iJavaProject = iJavaModel.getJavaProject(string2);
        this.assertExists((IJavaElement)iJavaProject);
        int n2 = string3.indexOf(35);
        String string4 = n2 == -1 ? string3 : string3.substring(0, n2);
        IType iType = null;
        try {
            iType = iJavaProject.findType(string4);
        }
        catch (JavaModelException javaModelException) {}
        this.assertExists((IJavaElement)iType);
        if (n2 == -1) {
            return iType;
        }
        String string5 = string3.substring(n2 + 1);
        int n3 = string5.indexOf(40);
        if (n3 == -1) {
            IField iField = iType.getField(string5);
            this.assertExists((IJavaElement)iField);
            return iField;
        }
        String string6 = string5.substring(0, n3);
        String string7 = string5.substring(n3);
        String[] stringArray = null;
        try {
            stringArray = Signature.getParameterTypes((String)string7);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.assertWellFormed(stringArray != null);
        IMethod iMethod = iType.getMethod(string6, stringArray);
        this.assertExists((IJavaElement)iMethod);
        return iMethod;
    }

    private void assertWellFormed(boolean bl) throws ParameterValueConversionException {
        if (!bl) {
            throw new ParameterValueConversionException("Malformed parameterValue");
        }
    }

    private void assertExists(IJavaElement iJavaElement) throws ParameterValueConversionException {
        if (iJavaElement == null || !iJavaElement.exists()) {
            throw new ParameterValueConversionException("parameterValue must reference an existing IJavaElement");
        }
    }

    public String convertToString(Object object) throws ParameterValueConversionException {
        StringBuffer stringBuffer;
        if (!(object instanceof IJavaElement)) {
            throw new ParameterValueConversionException("parameterValue must be an IJavaElement");
        }
        IJavaElement iJavaElement = (IJavaElement)object;
        IJavaProject iJavaProject = iJavaElement.getJavaProject();
        if (iJavaProject == null) {
            throw new ParameterValueConversionException("Could not get IJavaProject for element");
        }
        if (iJavaElement instanceof IType) {
            IType iType = (IType)iJavaElement;
            stringBuffer = this.composeTypeReference(iType);
        } else if (iJavaElement instanceof IMethod) {
            IMethod iMethod = (IMethod)iJavaElement;
            stringBuffer = this.composeTypeReference(iMethod.getDeclaringType());
            stringBuffer.append('#');
            stringBuffer.append(iMethod.getElementName());
            String[] stringArray = iMethod.getParameterTypes();
            stringBuffer.append('(');
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            stringBuffer.append(')');
        } else if (iJavaElement instanceof IField) {
            IField iField = (IField)iJavaElement;
            stringBuffer = this.composeTypeReference(iField.getDeclaringType());
            stringBuffer.append('#');
            stringBuffer.append(iField.getElementName());
        } else {
            throw new ParameterValueConversionException("Unsupported IJavaElement type");
        }
        return stringBuffer.toString();
    }

    private StringBuffer composeTypeReference(IType iType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iType.getJavaProject().getElementName());
        stringBuffer.append('/');
        stringBuffer.append(iType.getFullyQualifiedName());
        return stringBuffer;
    }
}

