/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.HistoryPageCompareEditorInput;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaElementHistoryPageSource;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaHistoryActionImpl;

class JavaCompareWithEditionActionImpl
extends JavaHistoryActionImpl {
    private static boolean USE_MODAL_COMPARE = false;

    JavaCompareWithEditionActionImpl() {
        super(false);
    }

    public void run(ISelection iSelection) {
        IMember iMember = this.getEditionElement(iSelection);
        if (iMember == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)CompareMessages.CompareWithHistory_title, (String)CompareMessages.CompareWithHistory_invalidSelectionMessage);
            return;
        }
        JavaElementHistoryPageSource javaElementHistoryPageSource = JavaElementHistoryPageSource.getInstance();
        IFile iFile = javaElementHistoryPageSource.getFile(iMember);
        if (iFile == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)CompareMessages.CompareWithHistory_title, (String)CompareMessages.CompareWithHistory_internalErrorMessage);
            return;
        }
        if (USE_MODAL_COMPARE) {
            CompareConfiguration compareConfiguration = new CompareConfiguration();
            compareConfiguration.setLeftEditable(false);
            compareConfiguration.setRightEditable(false);
            HistoryPageCompareEditorInput historyPageCompareEditorInput = new HistoryPageCompareEditorInput(compareConfiguration, (IHistoryPageSource)javaElementHistoryPageSource, (Object)iMember);
            historyPageCompareEditorInput.setTitle(CompareMessages.JavaCompareWithEditionActionImpl_0);
            historyPageCompareEditorInput.setHelpContextId("org.eclipse.wst.jsdt.ui.compare_element_with_history_dialog_context");
            CompareUI.openCompareDialog((CompareEditorInput)historyPageCompareEditorInput);
        } else {
            TeamUI.showHistoryFor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (Object)iMember, (IHistoryPageSource)javaElementHistoryPageSource);
        }
    }
}

