/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;

public abstract class ResizableDialog
extends TrayDialog {
    private static final String DIALOG_BOUNDS_KEY = "ResizableDialogBounds";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    protected ResourceBundle fBundle;
    private Rectangle fNewBounds;
    private IDialogSettings fSettings;

    public ResizableDialog(Shell shell, ResourceBundle resourceBundle) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fBundle = resourceBundle;
        this.fSettings = CompareUI.getPlugin().getDialogSettings();
    }

    protected Point getInitialSize() {
        IDialogSettings iDialogSettings;
        int n = 0;
        int n2 = 0;
        final Shell shell = this.getShell();
        if (shell != null) {
            shell.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent controlEvent) {
                    ResizableDialog.this.fNewBounds = shell.getBounds();
                }

                public void controlResized(ControlEvent controlEvent) {
                    ResizableDialog.this.fNewBounds = shell.getBounds();
                }
            });
        }
        if ((iDialogSettings = this.fSettings.getSection(DIALOG_BOUNDS_KEY)) == null) {
            if (this.fBundle != null) {
                n = JavaCompareUtilities.getInteger(this.fBundle, WIDTH, 0);
                n2 = JavaCompareUtilities.getInteger(this.fBundle, HEIGHT, 0);
                Shell shell2 = this.getParentShell();
                if (shell2 != null) {
                    Point point = shell2.getSize();
                    if (n <= 0) {
                        n = point.x - 300;
                    }
                    if (n2 <= 0) {
                        n2 = point.y - 200;
                    }
                }
            } else {
                Shell shell3 = this.getParentShell();
                if (shell3 != null) {
                    Point point = shell3.getSize();
                    n = point.x - 100;
                    n2 = point.y - 100;
                }
            }
            if (n < 700) {
                n = 700;
            }
            if (n2 < 500) {
                n2 = 500;
            }
        } else {
            try {
                n = iDialogSettings.getInt(WIDTH);
            }
            catch (NumberFormatException numberFormatException) {
                n = 700;
            }
            try {
                n2 = iDialogSettings.getInt(HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 500;
            }
        }
        return new Point(n, n2);
    }

    protected Point getInitialLocation(Point point) {
        Point point2 = super.getInitialLocation(point);
        IDialogSettings iDialogSettings = this.fSettings.getSection(DIALOG_BOUNDS_KEY);
        if (iDialogSettings != null) {
            try {
                point2.x = iDialogSettings.getInt(X);
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                point2.y = iDialogSettings.getInt(Y);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return point2;
    }

    public boolean close() {
        boolean bl = super.close();
        if (bl && this.fNewBounds != null) {
            this.saveBounds(this.fNewBounds);
        }
        return bl;
    }

    private void saveBounds(Rectangle rectangle) {
        IDialogSettings iDialogSettings = this.fSettings.getSection(DIALOG_BOUNDS_KEY);
        if (iDialogSettings == null) {
            iDialogSettings = new DialogSettings(DIALOG_BOUNDS_KEY);
            this.fSettings.addSection(iDialogSettings);
        }
        iDialogSettings.put(X, rectangle.x);
        iDialogSettings.put(Y, rectangle.y);
        iDialogSettings.put(WIDTH, rectangle.width);
        iDialogSettings.put(HEIGHT, rectangle.height);
    }
}

