/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordIterator;

public class TextFieldNavigationHandler {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void install(Text text) {
        if (TextFieldNavigationHandler.isSubWordNavigationEnabled()) {
            new FocusHandler(new TextNavigable(text));
        }
    }

    public static void install(StyledText styledText) {
        if (TextFieldNavigationHandler.isSubWordNavigationEnabled()) {
            new FocusHandler(new StyledTextNavigable(styledText));
        }
    }

    public static void install(Combo combo) {
        if (TextFieldNavigationHandler.isSubWordNavigationEnabled()) {
            new FocusHandler(new ComboNavigable(combo));
        }
    }

    private static boolean isSubWordNavigationEnabled() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        return iPreferenceStore.getBoolean("subWordNavigation");
    }

    private static class ComboNavigable
    extends WorkaroundNavigable {
        private final Combo fCombo;

        public ComboNavigable(Combo combo) {
            this.fCombo = combo;
            this.fLastSelection = this.getSelection();
            this.fCaretPosition = this.fLastSelection.y;
            this.fCombo.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ ComboNavigable this$1;
                {
                    this.this$1 = comboNavigable;
                }

                public void keyReleased(KeyEvent keyEvent) {
                    this.this$1.selectionChanged();
                }
            });
            this.fCombo.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ ComboNavigable this$1;
                {
                    this.this$1 = comboNavigable;
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    this.this$1.selectionChanged();
                }
            });
        }

        public Control getControl() {
            return this.fCombo;
        }

        public String getText() {
            return this.fCombo.getText();
        }

        public void setText(String string) {
            this.fCombo.setText(string);
        }

        public Point getSelection() {
            return this.fCombo.getSelection();
        }

        public int getCaretPosition() {
            this.selectionChanged();
            return this.fCaretPosition;
        }

        public void setSelection(int n, int n2) {
            this.fCombo.setSelection(new Point(n, n2));
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private static final String EMPTY_TEXT = "";
        private final JavaWordIterator fIterator = new JavaWordIterator();
        private final Navigable fNavigable;
        private KeyAdapter fKeyListener;

        private FocusHandler(Navigable navigable) {
            this.fNavigable = navigable;
            Control control = navigable.getControl();
            control.addFocusListener((FocusListener)this);
            if (control.isFocusControl()) {
                this.activate();
            }
            control.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ FocusHandler this$1;
                {
                    this.this$1 = focusHandler;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    FocusHandler.access$0(this.this$1);
                }
            });
        }

        public void focusGained(FocusEvent focusEvent) {
            this.activate();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.deactivate();
        }

        private void activate() {
            this.fNavigable.getControl().addKeyListener((KeyListener)this.getKeyListener());
        }

        private void deactivate() {
            if (this.fKeyListener != null) {
                Control control = this.fNavigable.getControl();
                if (!control.isDisposed()) {
                    control.removeKeyListener((KeyListener)this.fKeyListener);
                }
                this.fKeyListener = null;
            }
        }

        private KeyAdapter getKeyListener() {
            if (this.fKeyListener == null) {
                this.fKeyListener = new KeyAdapter(this){
                    private final boolean IS_WORKAROUND;
                    private List fSubmissions;
                    final /* synthetic */ FocusHandler this$1;
                    {
                        this.this$1 = focusHandler;
                        this.IS_WORKAROUND = FocusHandler.access$1(focusHandler) instanceof ComboNavigable || FocusHandler.access$1(focusHandler) instanceof TextNavigable && TextNavigable.BUG_106024_TEXT_SELECTION;
                    }

                    public void keyPressed(KeyEvent keyEvent) {
                        if (this.IS_WORKAROUND) {
                            if (keyEvent.keyCode == 0x1000003 && keyEvent.stateMask == SWT.MOD2) {
                                int n = FocusHandler.access$1(this.this$1).getCaretPosition();
                                if (n != 0) {
                                    Point point = FocusHandler.access$1(this.this$1).getSelection();
                                    if (n == point.x) {
                                        FocusHandler.access$1(this.this$1).setSelection(point.y, n - 1);
                                    } else {
                                        FocusHandler.access$1(this.this$1).setSelection(point.x, n - 1);
                                    }
                                }
                                keyEvent.doit = false;
                                return;
                            }
                            if (keyEvent.keyCode == 0x1000004 && keyEvent.stateMask == SWT.MOD2) {
                                String string = FocusHandler.access$1(this.this$1).getText();
                                int n = FocusHandler.access$1(this.this$1).getCaretPosition();
                                if (n != string.length()) {
                                    Point point = FocusHandler.access$1(this.this$1).getSelection();
                                    if (n == point.y) {
                                        FocusHandler.access$1(this.this$1).setSelection(point.x, n + 1);
                                    } else {
                                        FocusHandler.access$1(this.this$1).setSelection(point.y, n + 1);
                                    }
                                }
                                keyEvent.doit = false;
                                return;
                            }
                        }
                        int n = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)keyEvent);
                        KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)n));
                        this.getSubmissions();
                        Iterator<E> iterator = this.getSubmissions().iterator();
                        while (iterator.hasNext()) {
                            Submission submission = (Submission)iterator.next();
                            TriggerSequence[] triggerSequenceArray = submission.getTriggerSequences();
                            int n2 = 0;
                            while (n2 < triggerSequenceArray.length) {
                                if (triggerSequenceArray[n2].equals((Object)keySequence)) {
                                    keyEvent.doit = false;
                                    submission.execute();
                                    return;
                                }
                                ++n2;
                            }
                        }
                    }

                    private List getSubmissions() {
                        if (this.fSubmissions != null) {
                            return this.fSubmissions;
                        }
                        this.fSubmissions = new ArrayList<E>();
                        IWorkbench iWorkbench = PlatformUI.getWorkbench();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        ICommandService iCommandService = (ICommandService)iWorkbench.getAdapter((Class)clazz);
                        IWorkbench iWorkbench2 = PlatformUI.getWorkbench();
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("org.eclipse.ui.keys.IBindingService");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        IBindingService iBindingService = (IBindingService)iWorkbench2.getAdapter((Class)clazz2);
                        if (iCommandService == null || iBindingService == null) {
                            return this.fSubmissions;
                        }
                        BindingManager bindingManager = new BindingManager(new ContextManager(), new CommandManager());
                        Scheme[] schemeArray = iBindingService.getDefinedSchemes();
                        if (schemeArray != null) {
                            try {
                                int n = 0;
                                while (n < schemeArray.length) {
                                    Scheme scheme = schemeArray[n];
                                    Scheme scheme2 = bindingManager.getScheme(scheme.getId());
                                    scheme2.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                                    ++n;
                                }
                            }
                            catch (NotDefinedException notDefinedException) {
                                JavaPlugin.log(notDefinedException);
                            }
                        }
                        bindingManager.setLocale(iBindingService.getLocale());
                        bindingManager.setPlatform(iBindingService.getPlatform());
                        bindingManager.setBindings(iBindingService.getBindings());
                        try {
                            Scheme scheme = iBindingService.getActiveScheme();
                            if (scheme != null) {
                                bindingManager.setActiveScheme(scheme);
                            }
                        }
                        catch (NotDefinedException notDefinedException) {
                            JavaPlugin.log(notDefinedException);
                        }
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(bindingManager, iCommandService, "org.eclipse.ui.edit.text.select.wordNext")){
                            final /* synthetic */ 6 this$2;
                            {
                                super(triggerSequenceArray);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                FocusHandler.access$2(6.access$0(this.this$2)).setText(FocusHandler.access$1(6.access$0(this.this$2)).getText());
                                int n = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                int n2 = FocusHandler.access$2(6.access$0(this.this$2)).following(n);
                                if (n2 != -1) {
                                    Point point = FocusHandler.access$1(6.access$0(this.this$2)).getSelection();
                                    if (n == point.y) {
                                        FocusHandler.access$1(6.access$0(this.this$2)).setSelection(point.x, n2);
                                    } else {
                                        FocusHandler.access$1(6.access$0(this.this$2)).setSelection(point.y, n2);
                                    }
                                }
                                FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(bindingManager, iCommandService, "org.eclipse.ui.edit.text.select.wordPrevious")){
                            final /* synthetic */ 6 this$2;
                            {
                                super(triggerSequenceArray);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                FocusHandler.access$2(6.access$0(this.this$2)).setText(FocusHandler.access$1(6.access$0(this.this$2)).getText());
                                int n = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                int n2 = FocusHandler.access$2(6.access$0(this.this$2)).preceding(n);
                                if (n2 != -1) {
                                    Point point = FocusHandler.access$1(6.access$0(this.this$2)).getSelection();
                                    if (n == point.x) {
                                        FocusHandler.access$1(6.access$0(this.this$2)).setSelection(point.y, n2);
                                    } else {
                                        FocusHandler.access$1(6.access$0(this.this$2)).setSelection(point.x, n2);
                                    }
                                }
                                FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(bindingManager, iCommandService, "org.eclipse.ui.edit.text.goto.wordNext")){
                            final /* synthetic */ 6 this$2;
                            {
                                super(triggerSequenceArray);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                FocusHandler.access$2(6.access$0(this.this$2)).setText(FocusHandler.access$1(6.access$0(this.this$2)).getText());
                                int n = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                int n2 = FocusHandler.access$2(6.access$0(this.this$2)).following(n);
                                if (n2 != -1) {
                                    FocusHandler.access$1(6.access$0(this.this$2)).setSelection(n2, n2);
                                }
                                FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(bindingManager, iCommandService, "org.eclipse.ui.edit.text.goto.wordPrevious")){
                            final /* synthetic */ 6 this$2;
                            {
                                super(triggerSequenceArray);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                FocusHandler.access$2(6.access$0(this.this$2)).setText(FocusHandler.access$1(6.access$0(this.this$2)).getText());
                                int n = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                int n2 = FocusHandler.access$2(6.access$0(this.this$2)).preceding(n);
                                if (n2 != -1) {
                                    FocusHandler.access$1(6.access$0(this.this$2)).setSelection(n2, n2);
                                }
                                FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(bindingManager, iCommandService, "org.eclipse.ui.edit.text.deleteNextWord")){
                            final /* synthetic */ 6 this$2;
                            {
                                super(triggerSequenceArray);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                int n;
                                int n2;
                                Point point = FocusHandler.access$1(6.access$0(this.this$2)).getSelection();
                                String string = FocusHandler.access$1(6.access$0(this.this$2)).getText();
                                if (point.x != point.y) {
                                    n2 = point.x;
                                    n = point.y;
                                } else {
                                    FocusHandler.access$2(6.access$0(this.this$2)).setText(string);
                                    n2 = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                    n = FocusHandler.access$2(6.access$0(this.this$2)).following(n2);
                                    FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                                    if (n == -1) {
                                        return;
                                    }
                                }
                                FocusHandler.access$1(6.access$0(this.this$2)).setText(String.valueOf(string.substring(0, n2)) + string.substring(n));
                                FocusHandler.access$1(6.access$0(this.this$2)).setSelection(n2, n2);
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(bindingManager, iCommandService, "org.eclipse.ui.edit.text.deletePreviousWord")){
                            final /* synthetic */ 6 this$2;
                            {
                                super(triggerSequenceArray);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                int n;
                                int n2;
                                Point point = FocusHandler.access$1(6.access$0(this.this$2)).getSelection();
                                String string = FocusHandler.access$1(6.access$0(this.this$2)).getText();
                                if (point.x != point.y) {
                                    n2 = point.x;
                                    n = point.y;
                                } else {
                                    FocusHandler.access$2(6.access$0(this.this$2)).setText(string);
                                    n = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                    n2 = FocusHandler.access$2(6.access$0(this.this$2)).preceding(n);
                                    FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                                    if (n2 == -1) {
                                        return;
                                    }
                                }
                                FocusHandler.access$1(6.access$0(this.this$2)).setText(String.valueOf(string.substring(0, n2)) + string.substring(n));
                                FocusHandler.access$1(6.access$0(this.this$2)).setSelection(n2, n2);
                            }
                        });
                        return this.fSubmissions;
                    }

                    private TriggerSequence[] getKeyBindings(BindingManager bindingManager, ICommandService iCommandService, String string) {
                        Command command = iCommandService.getCommand(string);
                        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
                        return bindingManager.getActiveBindingsDisregardingContextFor(parameterizedCommand);
                    }

                    static /* synthetic */ FocusHandler access$0(6 var0) {
                        return var0.this$1;
                    }
                };
            }
            return this.fKeyListener;
        }

        static /* synthetic */ void access$0(FocusHandler focusHandler) {
            focusHandler.deactivate();
        }

        static /* synthetic */ Navigable access$1(FocusHandler focusHandler) {
            return focusHandler.fNavigable;
        }

        static /* synthetic */ JavaWordIterator access$2(FocusHandler focusHandler) {
            return focusHandler.fIterator;
        }
    }

    private static abstract class Navigable {
        private Navigable() {
        }

        public abstract Control getControl();

        public abstract String getText();

        public abstract void setText(String var1);

        public abstract Point getSelection();

        public abstract void setSelection(int var1, int var2);

        public abstract int getCaretPosition();
    }

    private static class StyledTextNavigable
    extends Navigable {
        private final StyledText fStyledText;

        public StyledTextNavigable(StyledText styledText) {
            this.fStyledText = styledText;
        }

        public Control getControl() {
            return this.fStyledText;
        }

        public String getText() {
            return this.fStyledText.getText();
        }

        public void setText(String string) {
            this.fStyledText.setText(string);
        }

        public Point getSelection() {
            return this.fStyledText.getSelection();
        }

        public int getCaretPosition() {
            return this.fStyledText.getCaretOffset();
        }

        public void setSelection(int n, int n2) {
            this.fStyledText.setSelection(n, n2);
        }
    }

    private static abstract class Submission {
        private TriggerSequence[] fTriggerSequences;

        public Submission(TriggerSequence[] triggerSequenceArray) {
            this.fTriggerSequences = triggerSequenceArray;
        }

        public TriggerSequence[] getTriggerSequences() {
            return this.fTriggerSequences;
        }

        public abstract void execute();
    }

    private static class TextNavigable
    extends WorkaroundNavigable {
        static final boolean BUG_106024_TEXT_SELECTION = "win32".equals(SWT.getPlatform()) || "carbon".equals(SWT.getPlatform());
        private final Text fText;

        public TextNavigable(Text text) {
            this.fText = text;
            if (BUG_106024_TEXT_SELECTION) {
                this.fLastSelection = this.getSelection();
                this.fCaretPosition = this.fLastSelection.y;
                this.fText.addKeyListener((KeyListener)new KeyAdapter(this){
                    final /* synthetic */ TextNavigable this$1;
                    {
                        this.this$1 = textNavigable;
                    }

                    public void keyReleased(KeyEvent keyEvent) {
                        this.this$1.selectionChanged();
                    }
                });
                this.fText.addMouseListener((MouseListener)new MouseAdapter(this){
                    final /* synthetic */ TextNavigable this$1;
                    {
                        this.this$1 = textNavigable;
                    }

                    public void mouseUp(MouseEvent mouseEvent) {
                        this.this$1.selectionChanged();
                    }
                });
            }
        }

        public Control getControl() {
            return this.fText;
        }

        public String getText() {
            return this.fText.getText();
        }

        public void setText(String string) {
            this.fText.setText(string);
        }

        public Point getSelection() {
            return this.fText.getSelection();
        }

        public int getCaretPosition() {
            if (BUG_106024_TEXT_SELECTION) {
                this.selectionChanged();
                return this.fCaretPosition;
            }
            return this.fText.getCaretPosition();
        }

        public void setSelection(int n, int n2) {
            this.fText.setSelection(n, n2);
        }
    }

    private static abstract class WorkaroundNavigable
    extends Navigable {
        Point fLastSelection;
        int fCaretPosition;

        private WorkaroundNavigable() {
        }

        void selectionChanged() {
            Point point = this.getSelection();
            if (!point.equals((Object)this.fLastSelection)) {
                this.fCaretPosition = point.x == point.y ? point.x : (this.fLastSelection.y == point.y ? point.x : point.y);
            }
            this.fLastSelection = point;
        }
    }
}

