/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.fix.SaveParticipantMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CodeFormatingTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CodeStyleTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.UnnecessaryCodeTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;

public class CleanUpSaveParticipantConfigurationModifyDialog
extends StatusDialog
implements ModifyDialogTabPage.IModificationListener {
    private static final String DS_KEY_PREFERRED_WIDTH = "clean_up_save_particpant_modify_dialog.preferred_width";
    private static final String DS_KEY_PREFERRED_HEIGHT = "clean_up_save_particpant_modify_dialog.preferred_height";
    private static final String DS_KEY_PREFERRED_X = "clean_up_save_particpant_modify_dialog.preferred_x";
    private static final String DS_KEY_PREFERRED_Y = "clean_up_save_particpant_modify_dialog.preferred_y";
    private static final String DS_KEY_LAST_FOCUS = "clean_up_save_particpant_modify_dialog.last_focus";
    private static final int APPLY_BUTTON_ID = 1024;
    private final Map fWorkingValues;
    private Map fOrginalValues;
    private final List fTabPages;
    private final IDialogSettings fDialogSettings;
    private TabFolder fTabFolder;
    private Button fApplyButton;
    private CleanUpTabPage[] fPages;
    private Label fCountLabel;

    public CleanUpSaveParticipantConfigurationModifyDialog(Shell shell, Map map, String string) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.setTitle(string);
        this.fWorkingValues = map;
        this.fOrginalValues = new HashMap(map);
        this.setStatusLineAboveButtons(false);
        this.fTabPages = new ArrayList();
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    }

    public void create() {
        super.create();
        int n = 0;
        try {
            n = this.fDialogSettings.getInt(DS_KEY_LAST_FOCUS);
            if (n < 0) {
                n = 0;
            }
            if (n > this.fTabPages.size() - 1) {
                n = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.fTabFolder.setSelection(n);
        ((ModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.fTabFolder = new TabFolder(composite2, 0);
        this.fTabFolder.setFont(composite2.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fPages = this.createTabPages(this.fWorkingValues);
        this.fCountLabel = new Label(composite2, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.updateCountLabel();
        CleanUpSaveParticipantConfigurationModifyDialog.applyDialogFont((Control)composite2);
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TabItem tabItem = (TabItem)selectionEvent.item;
                ModifyDialogTabPage modifyDialogTabPage = (ModifyDialogTabPage)tabItem.getData();
                CleanUpSaveParticipantConfigurationModifyDialog.this.fDialogSettings.put(CleanUpSaveParticipantConfigurationModifyDialog.DS_KEY_LAST_FOCUS, CleanUpSaveParticipantConfigurationModifyDialog.this.fTabPages.indexOf(modifyDialogTabPage));
                modifyDialogTabPage.makeVisible();
            }
        });
        this.updateStatus(StatusInfo.OK_STATUS);
        return composite2;
    }

    protected CleanUpTabPage[] createTabPages(Map map) {
        CleanUpTabPage[] cleanUpTabPageArray = new CleanUpTabPage[]{new CodeStyleTabPage(this, map, true), new UnnecessaryCodeTabPage(this, map, true), new CodeFormatingTabPage(this, map, true)};
        this.addTabPage(SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_CodeStyle_TabPage, cleanUpTabPageArray[0]);
        this.addTabPage(SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_UnnecessaryCode_TabPage, cleanUpTabPageArray[1]);
        this.addTabPage(SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_CodeOrganizing_TabPage, cleanUpTabPageArray[2]);
        return cleanUpTabPageArray;
    }

    public void updateStatus(IStatus iStatus) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fPages.length) {
            n += this.fPages[n2].getSelectedCleanUpCount();
            ++n2;
        }
        if (n == 0) {
            super.updateStatus((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_SelectAnAction_Error));
        } else if (iStatus == null) {
            super.updateStatus(StatusInfo.OK_STATUS);
        } else {
            super.updateStatus(iStatus);
        }
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        try {
            int n;
            int n2 = this.fDialogSettings.getInt(DS_KEY_PREFERRED_WIDTH);
            if (point.x > n2) {
                n2 = point.x;
            }
            if (point.y > (n = this.fDialogSettings.getInt(DS_KEY_PREFERRED_HEIGHT))) {
                n = point.x;
            }
            return new Point(n2, n);
        }
        catch (NumberFormatException numberFormatException) {
            return point;
        }
    }

    protected Point getInitialLocation(Point point) {
        try {
            return new Point(this.fDialogSettings.getInt(DS_KEY_PREFERRED_X), this.fDialogSettings.getInt(DS_KEY_PREFERRED_Y));
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(point);
        }
    }

    public boolean close() {
        Rectangle rectangle = this.getShell().getBounds();
        this.fDialogSettings.put(DS_KEY_PREFERRED_WIDTH, rectangle.width);
        this.fDialogSettings.put(DS_KEY_PREFERRED_HEIGHT, rectangle.height);
        this.fDialogSettings.put(DS_KEY_PREFERRED_X, rectangle.x);
        this.fDialogSettings.put(DS_KEY_PREFERRED_Y, rectangle.y);
        return super.close();
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    protected void buttonPressed(int n) {
        if (n == 1024) {
            this.applyPressed();
        } else {
            super.buttonPressed(n);
        }
    }

    private void applyPressed() {
        this.fOrginalValues = new HashMap(this.fWorkingValues);
        this.updateStatus(StatusInfo.OK_STATUS);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.fApplyButton = this.createButton(composite, 1024, SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_Apply_Button, false);
        this.fApplyButton.setEnabled(false);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        gridLayout.makeColumnsEqualWidth = false;
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.widthHint = gridLayout.horizontalSpacing;
        label.setLayoutData((Object)gridData);
        super.createButtonsForButtonBar(composite);
    }

    protected final void addTabPage(String string, ModifyDialogTabPage modifyDialogTabPage) {
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        CleanUpSaveParticipantConfigurationModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(string);
        tabItem.setData((Object)modifyDialogTabPage);
        tabItem.setControl((Control)modifyDialogTabPage.createContents((Composite)this.fTabFolder));
        this.fTabPages.add(modifyDialogTabPage);
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        super.updateButtonsEnableState(iStatus);
        if (this.fApplyButton != null && !this.fApplyButton.isDisposed()) {
            this.fApplyButton.setEnabled(this.hasChanges() && !iStatus.matches(4));
        }
    }

    private boolean hasChanges() {
        Iterator iterator = this.fWorkingValues.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.fWorkingValues.get(string).equals(this.fOrginalValues.get(string))) continue;
            return true;
        }
        return false;
    }

    public void valuesModified() {
        this.updateCountLabel();
        this.updateStatus(StatusInfo.OK_STATUS);
    }

    private void updateCountLabel() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fPages.length) {
            n += this.fPages[n3].getCleanUpCount();
            n2 += this.fPages[n3].getSelectedCleanUpCount();
            ++n3;
        }
        this.fCountLabel.setText(Messages.format(SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_XofYSelected_Label, new Object[]{new Integer(n2), new Integer(n)}));
    }
}

