/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.ltk.ui.refactoring.history.ISortableRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;

public final class JarRefactoringDialog
extends TrayDialog {
    private static final String SETTING_SORT = "org.eclipse.wst.jsdt.ui.jar.export.sortRefactorings";
    private final JarPackageData fData;
    private Button fExportStructural = null;
    private final RefactoringHistory fHistory;
    private ISortableRefactoringHistoryControl fHistoryControl = null;
    private final IDialogSettings fSettings;

    public JarRefactoringDialog(Shell shell, IDialogSettings iDialogSettings, JarPackageData jarPackageData, RefactoringHistory refactoringHistory) {
        super(shell);
        Assert.isNotNull((Object)jarPackageData);
        Assert.isNotNull((Object)refactoringHistory);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSettings = iDialogSettings;
        this.fData = jarPackageData;
        this.fHistory = refactoringHistory;
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.fData.setRefactoringAware(true);
            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = this.fHistoryControl.getCheckedDescriptors();
            HashSet<IProject> hashSet = new HashSet<IProject>();
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            int n2 = 0;
            while (n2 < refactoringDescriptorProxyArray.length) {
                String string = refactoringDescriptorProxyArray[n2].getProject();
                if (string != null && !"".equals(string)) {
                    hashSet.add(iWorkspaceRoot.getProject(string));
                }
                ++n2;
            }
            this.fData.setRefactoringProjects(hashSet.toArray(new IProject[hashSet.size()]));
            this.fData.setRefactoringDescriptors(refactoringDescriptorProxyArray);
            this.fData.setExportStructuralOnly(this.fExportStructural.getSelection());
            IDialogSettings iDialogSettings = this.fSettings;
            if (iDialogSettings != null) {
                iDialogSettings.put(SETTING_SORT, this.fHistoryControl.isSortByProjects());
            }
        }
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(JarPackagerMessages.JarRefactoringDialog_dialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.jar_packager_refactoring_dialog_context");
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(!this.fHistory.isEmpty());
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite2);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(1808));
        RefactoringHistoryControlConfiguration refactoringHistoryControlConfiguration = new RefactoringHistoryControlConfiguration(null, true, true){

            public final String getWorkspaceCaption() {
                return JarPackagerMessages.JarRefactoringDialog_workspace_caption;
            }
        };
        this.fHistoryControl = (ISortableRefactoringHistoryControl)RefactoringUI.createSortableRefactoringHistoryControl((Composite)composite3, (RefactoringHistoryControlConfiguration)refactoringHistoryControlConfiguration);
        this.fHistoryControl.createControl();
        boolean bl = true;
        IDialogSettings iDialogSettings = this.fSettings;
        if (iDialogSettings != null) {
            bl = iDialogSettings.getBoolean(SETTING_SORT);
        }
        if (bl) {
            this.fHistoryControl.sortByProjects();
        } else {
            this.fHistoryControl.sortByDate();
        }
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(32);
        gridData.widthHint = this.convertWidthInCharsToPixels(72);
        this.fHistoryControl.getControl().setLayoutData((Object)gridData);
        this.fHistoryControl.setInput(this.fHistory);
        this.fHistoryControl.setCheckedDescriptors(this.fData.getRefactoringDescriptors());
        this.createPlainLabel(composite3, JarPackagerMessages.JarPackageWizardPage_options_label);
        this.createOptionsGroup(composite3);
        Dialog.applyDialogFont((Control)composite);
        return composite3;
    }

    protected void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fExportStructural = new Button(composite2, 16416);
        this.fExportStructural.setText(JarPackagerMessages.JarRefactoringDialog_export_structural);
        this.fExportStructural.setSelection(this.fData.isExportStructuralOnly());
    }

    protected Label createPlainLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setFont(composite.getFont());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }
}

