/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class JavadocProjectContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object object) {
        try {
            if (object instanceof IJavaProject) {
                IJavaProject iJavaProject = (IJavaProject)object;
                return this.getPackageFragmentRoots(iJavaProject);
            }
            if (object instanceof IPackageFragmentRoot) {
                return this.getPackageFragments((IPackageFragmentRoot)object);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return new Object[0];
    }

    public Object[] getElements(Object object) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            return JavaCore.create((IWorkspaceRoot)iWorkspaceRoot).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return new Object[0];
        }
    }

    public Object getParent(Object object) {
        IPackageFragmentRoot iPackageFragmentRoot;
        IJavaElement iJavaElement = ((IJavaElement)object).getParent();
        if (iJavaElement instanceof IPackageFragmentRoot && (iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement).getPath().equals((Object)iPackageFragmentRoot.getJavaProject().getProject().getFullPath())) {
            return iPackageFragmentRoot.getJavaProject();
        }
        return iJavaElement;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    private Object[] getPackageFragmentRoots(IJavaProject iJavaProject) throws JavaModelException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
            if (iPackageFragmentRoot.getKind() == 1) {
                if (iPackageFragmentRoot.getPath().equals((Object)iPackageFragmentRoot.getJavaProject().getPath())) {
                    Object[] objectArray = this.getPackageFragments(iPackageFragmentRoot);
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        arrayList.add(objectArray[n2]);
                        ++n2;
                    }
                } else {
                    arrayList.add(iPackageFragmentRoot);
                }
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private Object[] getPackageFragments(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (((IPackageFragment)iJavaElementArray[n]).containsJavaResources()) {
                arrayList.add(iJavaElementArray[n]);
            }
            ++n;
        }
        return arrayList.toArray();
    }
}

