/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class EditorUtility {
    static /* synthetic */ Class class$0;

    public static IEditorPart isOpenInEditor(Object object) {
        IWorkbenchPage iWorkbenchPage;
        IEditorInput iEditorInput = null;
        try {
            iEditorInput = EditorUtility.getEditorInput(object);
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException.getStatus());
        }
        if (iEditorInput != null && (iWorkbenchPage = JavaPlugin.getActivePage()) != null) {
            return iWorkbenchPage.findEditor(iEditorInput);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object object) throws JavaModelException, PartInitException {
        return EditorUtility.openInEditor(object, true);
    }

    public static IEditorPart openInEditor(Object object, boolean bl) throws JavaModelException, PartInitException {
        IJavaElement iJavaElement;
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage;
        Object object2;
        if (object instanceof IFile) {
            return EditorUtility.openInEditor((IFile)object, bl);
        }
        if (object instanceof IJavaElement && ((IJavaElement)object).isVirtual() && (object2 = ((IJavaElement)object).getHostPath()) != null) {
            IFile iFile = ((IJavaElement)object).getJavaProject().getProject().getWorkspace().getRoot().getFileForLocation((IPath)new Path(((URI)object2).getPath()));
            if (iFile == null || !iFile.exists()) {
                iFile = ((IJavaElement)object).getJavaProject().getProject().getWorkspace().getRoot().findMember(((URI)object2).getPath());
            }
            if (iFile != null) {
                return EditorUtility.openInEditor(iFile, bl);
            }
            return EditorUtility.openInEditor((URI)object2, bl);
        }
        if (object instanceof IJavaElement && (object2 = (ICompilationUnit)((IJavaElement)object).getAncestor(5)) != null && !JavaModelUtil.isPrimary((ICompilationUnit)object2) && (iWorkbenchPage = JavaPlugin.getActivePage()) != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null && object2.equals(iJavaElement = EditorUtility.getEditorInputJavaElement(iEditorPart, false))) {
            if (bl && iWorkbenchPage.getActivePart() != iEditorPart) {
                iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
            }
            return iEditorPart;
        }
        object2 = EditorUtility.getEditorInput(object);
        if (object2 == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_editorInput);
        }
        return EditorUtility.openInEditor((IEditorInput)object2, EditorUtility.getEditorID((IEditorInput)object2), bl);
    }

    public static void revealInEditor(IEditorPart iEditorPart, IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return;
        }
        if (iEditorPart instanceof JavaEditor) {
            ((JavaEditor)iEditorPart).setSelection(iJavaElement);
            return;
        }
        try {
            ISourceRange iSourceRange = null;
            if (iJavaElement instanceof ICompilationUnit) {
                iSourceRange = null;
            } else if (iJavaElement instanceof IClassFile) {
                iSourceRange = null;
            } else if (iJavaElement instanceof ILocalVariable) {
                iSourceRange = ((ILocalVariable)iJavaElement).getNameRange();
            } else if (iJavaElement instanceof IMember) {
                iSourceRange = ((IMember)iJavaElement).getNameRange();
            } else if (iJavaElement instanceof ITypeParameter) {
                iSourceRange = ((ITypeParameter)iJavaElement).getNameRange();
            } else if (iJavaElement instanceof ISourceReference) {
                iSourceRange = ((ISourceReference)iJavaElement).getSourceRange();
            }
            if (iSourceRange != null) {
                EditorUtility.revealInEditor(iEditorPart, iSourceRange.getOffset(), iSourceRange.getLength());
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public static void revealInEditor(IEditorPart iEditorPart, IRegion iRegion) {
        if (iEditorPart != null && iRegion != null) {
            EditorUtility.revealInEditor(iEditorPart, iRegion.getOffset(), iRegion.getLength());
        }
    }

    public static void revealInEditor(IEditorPart iEditorPart, final int n, final int n2) {
        if (iEditorPart instanceof ITextEditor) {
            ((ITextEditor)iEditorPart).selectAndReveal(n, n2);
            return;
        }
        if (iEditorPart instanceof IGotoMarker) {
            final IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                final IGotoMarker iGotoMarker = (IGotoMarker)iEditorPart;
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                    /*
                     * Exception decompiling
                     */
                    protected void execute(IProgressMonitor var1_1) throws CoreException {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 85->89)] java.lang.Throwable
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                };
                try {
                    workspaceModifyOperation.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (iEditorPart != null && iEditorPart.getEditorSite().getSelectionProvider() != null) {
            IEditorSite iEditorSite = iEditorPart.getEditorSite();
            if (iEditorSite == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = iEditorPart.getEditorSite().getSelectionProvider();
            if (iSelectionProvider == null) {
                return;
            }
            iSelectionProvider.setSelection((ISelection)new TextSelection(n, n2));
        }
    }

    private static IEditorPart openInEditor(IFile iFile, boolean bl) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        if (iFile == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_file_must_not_be_null);
        }
        if ((iWorkbenchPage = JavaPlugin.getActivePage()) == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)bl);
        EditorUtility.initializeHighlightRange(iEditorPart);
        return iEditorPart;
    }

    private static IEditorPart openInEditor(URI uRI, boolean bl) throws PartInitException {
        IEditorDescriptor iEditorDescriptor;
        IWorkbenchPage iWorkbenchPage;
        if (uRI == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_file_must_not_be_null);
        }
        if ((iWorkbenchPage = JavaPlugin.getActivePage()) == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        if ((iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(uRI.getPath())) == null) {
            EditorUtility.throwPartInitException("Can't find Editor for file: " + uRI.toString());
        }
        IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (URI)uRI, (String)iEditorDescriptor.getId(), (boolean)bl);
        EditorUtility.initializeHighlightRange(iEditorPart);
        return iEditorPart;
    }

    private static IEditorPart openInEditor(IEditorInput iEditorInput, String string, boolean bl) throws PartInitException {
        Assert.isNotNull((Object)iEditorInput);
        Assert.isNotNull((Object)string);
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        IEditorPart iEditorPart = iWorkbenchPage.openEditor(iEditorInput, string, bl);
        EditorUtility.initializeHighlightRange(iEditorPart);
        return iEditorPart;
    }

    private static void throwPartInitException(String string) throws PartInitException {
        Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 0, string, null);
        throw new PartInitException((IStatus)status);
    }

    private static void initializeHighlightRange(IEditorPart iEditorPart) {
        if (iEditorPart instanceof ITextEditor) {
            boolean bl;
            IAction iAction = iEditorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl2 = bl = iAction != null;
            if (bl && iEditorPart instanceof JavaEditor) {
                bl = JavaPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.ui.editor.showSegments");
            } else {
                boolean bl3 = bl = bl && iAction.isEnabled() && iAction.isChecked();
            }
            if (bl) {
                if (iAction instanceof TextEditorAction) {
                    ((TextEditorAction)iAction).setEditor(null);
                    ((TextEditorAction)iAction).setEditor((ITextEditor)iEditorPart);
                } else {
                    iAction.run();
                    iAction.run();
                }
            }
        }
    }

    private static String getEditorID(IEditorInput iEditorInput) throws PartInitException {
        IEditorDescriptor iEditorDescriptor;
        Assert.isNotNull((Object)iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            iEditorDescriptor = IDE.getEditorDescriptor((IFile)((IFileEditorInput)iEditorInput).getFile());
        } else {
            if (iEditorInput instanceof InternalClassFileEditorInput) {
                return "org.eclipse.wst.jsdt.ui.ClassFileEditor";
            }
            String string = iEditorInput.getName();
            if (string == null) {
                EditorUtility.throwPartInitException(JavaEditorMessages.EditorUtility_could_not_find_editorId);
            }
            iEditorDescriptor = IDE.getEditorDescriptor((String)string);
        }
        return iEditorDescriptor.getId();
    }

    public static IJavaElement getEditorInputJavaElement(IEditorPart iEditorPart, boolean bl) {
        Assert.isNotNull((Object)iEditorPart);
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput == null) {
            return null;
        }
        IJavaElement iJavaElement = JavaUI.getEditorInputJavaElement(iEditorInput);
        if (iJavaElement != null || bl) {
            return iJavaElement;
        }
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput, false);
    }

    private static IEditorInput getEditorInput(IJavaElement iJavaElement) throws JavaModelException {
        while (iJavaElement != null) {
            ICompilationUnit iCompilationUnit;
            IResource iResource;
            if (iJavaElement instanceof ICompilationUnit && (iResource = (iCompilationUnit = ((ICompilationUnit)iJavaElement).getPrimary()).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)iResource);
            }
            if (iJavaElement instanceof IClassFile) {
                return new InternalClassFileEditorInput((IClassFile)iJavaElement);
            }
            iJavaElement = iJavaElement.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object object) throws JavaModelException {
        if (object instanceof IJavaElement) {
            return EditorUtility.getEditorInput((IJavaElement)object);
        }
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (JavaModelUtil.isOpenableStorage(object)) {
            return new JarEntryEditorInput((IStorage)object);
        }
        return null;
    }

    public static IJavaElement getActiveEditorJavaInput() {
        IEditorInput iEditorInput;
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null && (iEditorInput = iEditorPart.getEditorInput()) != null) {
            return JavaUI.getEditorInputJavaElement(iEditorInput);
        }
        return null;
    }

    public static int findLocalizedModifier(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int n) {
        String string = "";
        if ((n & 0x40000) == 262144) {
            string = EditorUtility.appendModifierString(string, 262144);
        }
        if ((n & 0x10000) == 65536) {
            string = EditorUtility.appendModifierString(string, 65536);
        }
        if ((n & 0x20000) == 131072) {
            string = EditorUtility.appendModifierString(string, 131072);
        }
        if ((n & 0x400000) == 0x400000) {
            string = EditorUtility.appendModifierString(string, 0x400000);
        }
        return string;
    }

    private static String appendModifierString(String string, int n) {
        if (string == null) {
            string = "";
        }
        String string2 = Action.findModifierString((int)n);
        if (string.length() == 0) {
            return string2;
        }
        return Messages.format(JavaEditorMessages.EditorUtility_concatModifierStrings, new String[]{string, string2});
    }

    public static IJavaProject getJavaProject(IEditorInput iEditorInput) {
        IJavaProject iJavaProject = null;
        if (iEditorInput instanceof IFileEditorInput) {
            IProject iProject = ((IFileEditorInput)iEditorInput).getFile().getProject();
            if (iProject != null && !(iJavaProject = JavaCore.create((IProject)iProject)).exists()) {
                iJavaProject = null;
            }
        } else if (iEditorInput instanceof IClassFileEditorInput) {
            iJavaProject = ((IClassFileEditorInput)iEditorInput).getClassFile().getJavaProject();
        }
        return iJavaProject;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> hashSet = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n2].getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (hashSet.add(iEditorInput)) {
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    public static IEditorPart[] getDirtyEditorsToSave(boolean bl) {
        HashSet<IEditorInput> hashSet = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n2].getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (EditorUtility.mustSaveDirtyEditor(iEditorPart, iEditorInput, bl) && hashSet.add(iEditorInput)) {
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    private static boolean mustSaveDirtyEditor(IEditorPart iEditorPart, IEditorInput iEditorInput, boolean bl) {
        ICompilationUnit iCompilationUnit;
        IResource iResource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iEditorInput.getAdapter((Class)clazz)) == null) {
            return bl;
        }
        IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
        if (iJavaElement instanceof ICompilationUnit && !(iCompilationUnit = (ICompilationUnit)iJavaElement).isWorkingCopy()) {
            return true;
        }
        if (!(iEditorPart instanceof ITextEditor)) {
            return bl;
        }
        iCompilationUnit = (ITextEditor)iEditorPart;
        IDocumentProvider iDocumentProvider = iCompilationUnit.getDocumentProvider();
        if (!(iDocumentProvider instanceof TextFileDocumentProvider)) {
            return bl;
        }
        return false;
    }
}

