/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.StructureSelectHistoryAction;

public class SelectionHistory {
    private List fHistory;
    private JavaEditor fEditor;
    private ISelectionChangedListener fSelectionListener;
    private int fSelectionChangeListenerCounter;
    private StructureSelectHistoryAction fHistoryAction;

    public SelectionHistory(JavaEditor javaEditor) {
        Assert.isNotNull((Object)javaEditor);
        this.fEditor = javaEditor;
        this.fHistory = new ArrayList(3);
        this.fSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (SelectionHistory.this.fSelectionChangeListenerCounter == 0) {
                    SelectionHistory.this.flush();
                }
            }
        };
        this.fEditor.getSelectionProvider().addSelectionChangedListener(this.fSelectionListener);
    }

    public void setHistoryAction(StructureSelectHistoryAction structureSelectHistoryAction) {
        Assert.isNotNull((Object)((Object)structureSelectHistoryAction));
        this.fHistoryAction = structureSelectHistoryAction;
    }

    public boolean isEmpty() {
        return this.fHistory.isEmpty();
    }

    public void remember(ISourceRange iSourceRange) {
        this.fHistory.add(iSourceRange);
        this.fHistoryAction.update();
    }

    public ISourceRange getLast() {
        if (this.isEmpty()) {
            return null;
        }
        int n = this.fHistory.size();
        ISourceRange iSourceRange = (ISourceRange)this.fHistory.remove(n - 1);
        this.fHistoryAction.update();
        return iSourceRange;
    }

    public void flush() {
        if (this.fHistory.isEmpty()) {
            return;
        }
        this.fHistory.clear();
        this.fHistoryAction.update();
    }

    public void ignoreSelectionChanges() {
        ++this.fSelectionChangeListenerCounter;
    }

    public void listenToSelectionChanges() {
        --this.fSelectionChangeListenerCounter;
    }

    public void dispose() {
        this.fEditor.getSelectionProvider().removeSelectionChangedListener(this.fSelectionListener);
    }
}

