/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.model;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.ui.refactoring.model.AbstractSynchronizationCompareAdapter;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.model.JavaModelProvider;
import org.eclipse.wst.jsdt.internal.ui.model.JavaSynchronizationContentProvider;

public final class JavaSynchronizationCompareAdapter
extends AbstractSynchronizationCompareAdapter {
    private static final String MODEL_PROVIDER_ID = "modelProviderId";
    private static final String MODEL_PROVIDERS = "modelProviders";
    private static final String RESOURCE_PATH = "resourcePath";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String RESOURCES = "resources";
    private static final String WORKING_SET_NAME = "workingSetName";
    private static final String WORKING_SETS = "workingSets";
    static /* synthetic */ Class class$0;

    public ICompareInput asCompareInput(ISynchronizationContext iSynchronizationContext, Object object) {
        if (object instanceof RefactoringDescriptorProxy) {
            return super.asCompareInput(iSynchronizationContext, object);
        }
        IResource iResource = JavaModelProvider.getResource(object);
        if (iResource != null) {
            return super.asCompareInput(iSynchronizationContext, (Object)iResource);
        }
        return null;
    }

    public ResourceMapping[] restore(IMemento iMemento) {
        Path path;
        ResourceMapping resourceMapping;
        String string;
        Object object;
        IMemento[] iMementoArray = iMemento.getChildren(RESOURCES);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < iMementoArray.length) {
            object = iMementoArray[n].getInteger(RESOURCE_TYPE);
            if (object != null && (string = iMementoArray[n].getString(RESOURCE_PATH)) != null) {
                ResourceMapping resourceMapping2;
                resourceMapping = null;
                path = new Path(string);
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                switch ((Integer)object) {
                    case 8: {
                        resourceMapping = iWorkspaceRoot;
                        break;
                    }
                    case 4: {
                        resourceMapping = iWorkspaceRoot.getProject(path.lastSegment());
                        break;
                    }
                    case 1: {
                        resourceMapping = iWorkspaceRoot.getFile((IPath)path);
                        break;
                    }
                    case 2: {
                        resourceMapping = iWorkspaceRoot.getFolder((IPath)path);
                    }
                }
                if (resourceMapping != null && (resourceMapping2 = JavaSynchronizationContentProvider.getResourceMapping(resourceMapping)) != null) {
                    arrayList.add(resourceMapping2);
                }
            }
            ++n;
        }
        iMementoArray = iMemento.getChildren(WORKING_SETS);
        n = 0;
        while (n < iMementoArray.length) {
            object = iMementoArray[n].getString(WORKING_SET_NAME);
            if (object != null && (string = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet((String)object)) != null && (resourceMapping = JavaSynchronizationContentProvider.getResourceMapping(string)) != null) {
                arrayList.add(resourceMapping);
            }
            ++n;
        }
        iMementoArray = iMemento.getChildren(MODEL_PROVIDERS);
        n = 0;
        while (n < iMementoArray.length) {
            object = iMementoArray[n].getString(MODEL_PROVIDER_ID);
            if (object != null && (string = ModelProvider.getModelProviderDescriptor((String)object)) != null) {
                try {
                    resourceMapping = string.getModelProvider();
                    if (resourceMapping != null && (path = JavaSynchronizationContentProvider.getResourceMapping(resourceMapping)) != null) {
                        arrayList.add(path);
                    }
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
            }
            ++n;
        }
        return arrayList.toArray(new ResourceMapping[arrayList.size()]);
    }

    public void save(ResourceMapping[] resourceMappingArray, IMemento iMemento) {
        int n = 0;
        while (n < resourceMappingArray.length) {
            IResource iResource;
            IJavaElement iJavaElement;
            Object object = resourceMappingArray[n].getModelObject();
            if (object instanceof IJavaElement) {
                iJavaElement = (IJavaElement)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iJavaElement.getAdapter((Class)clazz)) != null) {
                    IMemento iMemento2 = iMemento.createChild(RESOURCES);
                    iMemento2.putInteger(RESOURCE_TYPE, iResource.getType());
                    iMemento2.putString(RESOURCE_PATH, iResource.getFullPath().toString());
                }
            }
            if (object instanceof IResource) {
                iJavaElement = (IResource)object;
                iResource = iMemento.createChild(RESOURCES);
                iResource.putInteger(RESOURCE_TYPE, iJavaElement.getType());
                iResource.putString(RESOURCE_PATH, iJavaElement.getFullPath().toString());
            } else if (object instanceof IWorkingSet) {
                iMemento.createChild(WORKING_SETS).putString(WORKING_SET_NAME, ((IWorkingSet)object).getName());
            } else if (object instanceof ModelProvider) {
                iMemento.createChild(MODEL_PROVIDERS).putString(MODEL_PROVIDER_ID, ((ModelProvider)object).getId());
            }
            ++n;
        }
    }
}

