/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;

abstract class AbstractConfigurationBlock
implements IPreferenceConfigurationBlock {
    protected static final int INDENT = 20;
    private OverlayPreferenceStore fStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            AbstractConfigurationBlock.this.fStore.setValue((String)AbstractConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            Text text = (Text)modifyEvent.widget;
            AbstractConfigurationBlock.this.fStore.setValue((String)AbstractConfigurationBlock.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            AbstractConfigurationBlock.this.numberFieldChanged((Text)modifyEvent.widget);
        }
    };
    private ArrayList fMasterSlaveListeners = new ArrayList();
    private StatusInfo fStatus;
    private final PreferencePage fMainPage;

    public AbstractConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fStore = overlayPreferenceStore;
        this.fMainPage = null;
    }

    public AbstractConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore, PreferencePage preferencePage) {
        Assert.isNotNull((Object)overlayPreferenceStore);
        Assert.isNotNull((Object)preferencePage);
        this.fStore = overlayPreferenceStore;
        this.fMainPage = preferencePage;
    }

    protected final ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ScrolledPageContent) && composite != null) {
            composite = composite.getParent();
        }
        if (composite instanceof ScrolledPageContent) {
            return (ScrolledPageContent)composite;
        }
        return null;
    }

    private final ExpandableComposite getParentExpandableComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ExpandableComposite) && composite != null) {
            composite = composite.getParent();
        }
        if (composite instanceof ExpandableComposite) {
            return (ExpandableComposite)composite;
        }
        return null;
    }

    protected void updateSectionStyle(ExpandableComposite expandableComposite) {
        expandableComposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent scrolledPageContent = this.getParentScrolledComposite(control);
        if (scrolledPageContent != null) {
            scrolledPageContent.adaptChild(control);
        }
    }

    private boolean isNestedInScrolledComposite(Composite composite) {
        return this.getParentScrolledComposite((Control)composite) != null;
    }

    protected Button addCheckBox(Composite composite, String string, String string2, int n) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.fCheckBoxListener);
        this.makeScrollableCompositeAware((Control)button);
        this.fCheckBoxes.put(button, string2);
        return button;
    }

    protected Control[] addLabelledTextField(Composite composite, String string, String string2, int n, int n2, boolean bl) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n2;
        label.setLayoutData((Object)gridData);
        Text text = new Text(composite, 2052);
        gridData = new GridData(32);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(n + 1);
        text.setLayoutData((Object)gridData);
        text.setTextLimit(n);
        this.fTextFields.put(text, string2);
        if (bl) {
            this.fNumberFields.add(text);
            text.addModifyListener(this.fNumberFieldListener);
        } else {
            text.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{label, text};
    }

    protected void createDependency(Button button, Control control) {
        this.createDependency(button, new Control[]{control});
    }

    protected void createDependency(final Button button, final Control[] controlArray) {
        Assert.isTrue((controlArray.length > 0 ? 1 : 0) != 0);
        AbstractConfigurationBlock.indent(controlArray[0]);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button.getSelection();
                int n = 0;
                while (n < controlArray.length) {
                    controlArray[n].setEnabled(bl);
                    ++n;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        button.addSelectionListener(selectionListener);
        this.fMasterSlaveListeners.add(selectionListener);
    }

    protected static void indent(Control control) {
        ((GridData)control.getLayoutData()).horizontalIndent += 20;
    }

    public void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        String string;
        Button button;
        Iterator<Object> iterator = this.fCheckBoxes.keySet().iterator();
        while (iterator.hasNext()) {
            button = (Button)iterator.next();
            string = (String)this.fCheckBoxes.get(button);
            button.setSelection(this.fStore.getBoolean(string));
        }
        iterator = this.fTextFields.keySet().iterator();
        while (iterator.hasNext()) {
            button = (Text)iterator.next();
            string = (String)this.fTextFields.get(button);
            button.setText(this.fStore.getString(string));
        }
        iterator = this.fMasterSlaveListeners.iterator();
        while (iterator.hasNext()) {
            button = (SelectionListener)iterator.next();
            button.widgetSelected(null);
        }
        this.updateStatus(new StatusInfo());
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.initializeFields();
    }

    IStatus getStatus() {
        if (this.fStatus == null) {
            this.fStatus = new StatusInfo();
        }
        return this.fStatus;
    }

    public void dispose() {
    }

    private void numberFieldChanged(Text text) {
        String string = text.getText();
        IStatus iStatus = this.validatePositiveNumber(string);
        if (!iStatus.matches(4)) {
            this.fStore.setValue((String)this.fTextFields.get(text), string);
        }
        this.updateStatus(iStatus);
    }

    private IStatus validatePositiveNumber(String string) {
        StatusInfo statusInfo = new StatusInfo();
        if (string.length() == 0) {
            statusInfo.setError(PreferencesMessages.JavaEditorPreferencePage_empty_input);
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    statusInfo.setError(Messages.format(PreferencesMessages.JavaEditorPreferencePage_invalid_input, string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(Messages.format(PreferencesMessages.JavaEditorPreferencePage_invalid_input, string));
            }
        }
        return statusInfo;
    }

    protected void updateStatus(IStatus iStatus) {
        if (this.fMainPage == null) {
            return;
        }
        this.fMainPage.setValid(iStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPage, iStatus);
    }

    protected final OverlayPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    protected Composite createSubsection(Composite composite, SectionManager sectionManager, String string) {
        if (sectionManager != null) {
            return sectionManager.createSection(string);
        }
        Group group = new Group(composite, 32);
        group.setText(string);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)gridData);
        return group;
    }

    static /* synthetic */ ExpandableComposite access$4(AbstractConfigurationBlock abstractConfigurationBlock, Control control) {
        return abstractConfigurationBlock.getParentExpandableComposite(control);
    }

    protected final class SectionManager {
        private static final String __NONE = "__none";
        private Set fSections = new HashSet();
        private boolean fIsBeingManaged = false;
        private ExpansionAdapter fListener = new ExpansionAdapter(this){
            final /* synthetic */ SectionManager this$1;
            {
                this.this$1 = sectionManager;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                Object object;
                ExpandableComposite expandableComposite;
                ExpandableComposite expandableComposite2 = (ExpandableComposite)expansionEvent.getSource();
                SectionManager.access$5(this.this$1).updateSectionStyle(expandableComposite2);
                if (SectionManager.access$0(this.this$1)) {
                    return;
                }
                if (expansionEvent.getState()) {
                    try {
                        SectionManager.access$1(this.this$1, true);
                        expandableComposite = SectionManager.access$2(this.this$1).iterator();
                        while (expandableComposite.hasNext()) {
                            object = (ExpandableComposite)expandableComposite.next();
                            if (object == expandableComposite2) continue;
                            object.setExpanded(false);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        SectionManager.access$1(this.this$1, false);
                        throw throwable;
                    }
                    {
                        Object var5_7 = null;
                    }
                    SectionManager.access$1(this.this$1, false);
                    if (SectionManager.access$3(this.this$1) != null && SectionManager.access$4(this.this$1) != null) {
                        SectionManager.access$4(this.this$1).setValue(SectionManager.access$3(this.this$1), expandableComposite2.getText());
                    }
                } else if (!SectionManager.access$0(this.this$1) && SectionManager.access$3(this.this$1) != null && SectionManager.access$4(this.this$1) != null) {
                    SectionManager.access$4(this.this$1).setValue(SectionManager.access$3(this.this$1), "__none");
                }
                if ((expandableComposite = AbstractConfigurationBlock.access$4(SectionManager.access$5(this.this$1), (Control)expandableComposite2)) != null) {
                    expandableComposite.layout(true, true);
                }
                if ((object = SectionManager.access$5(this.this$1).getParentScrolledComposite((Control)expandableComposite2)) != null) {
                    object.reflow(true);
                }
            }
        };
        private Composite fBody;
        private final String fLastOpenKey;
        private final IPreferenceStore fDialogSettingsStore;
        private ExpandableComposite fFirstChild = null;

        public SectionManager() {
            this(null, null);
        }

        public SectionManager(IPreferenceStore iPreferenceStore, String string) {
            this.fDialogSettingsStore = iPreferenceStore;
            this.fLastOpenKey = string;
        }

        private void manage(ExpandableComposite expandableComposite) {
            if (expandableComposite == null) {
                throw new NullPointerException();
            }
            if (this.fSections.add(expandableComposite)) {
                expandableComposite.addExpansionListener((IExpansionListener)this.fListener);
            }
            AbstractConfigurationBlock.this.makeScrollableCompositeAware((Control)expandableComposite);
        }

        public Composite createSectionComposite(Composite composite) {
            ScrolledPageContent scrolledPageContent;
            Assert.isTrue((this.fBody == null ? 1 : 0) != 0);
            boolean bl = AbstractConfigurationBlock.this.isNestedInScrolledComposite(composite);
            if (bl) {
                scrolledPageContent = new Composite(composite, 0);
                this.fBody = scrolledPageContent;
            } else {
                scrolledPageContent = new ScrolledPageContent(composite);
                this.fBody = scrolledPageContent.getBody();
            }
            this.fBody.setLayout((Layout)new GridLayout());
            return scrolledPageContent;
        }

        public Composite createSection(String string) {
            Assert.isNotNull((Object)this.fBody);
            ExpandableComposite expandableComposite = new ExpandableComposite(this.fBody, 0, 50);
            if (this.fFirstChild == null) {
                this.fFirstChild = expandableComposite;
            }
            expandableComposite.setText(string);
            String string2 = null;
            if (this.fLastOpenKey != null && this.fDialogSettingsStore != null) {
                string2 = this.fDialogSettingsStore.getString(this.fLastOpenKey);
            }
            if (this.fFirstChild == expandableComposite && !__NONE.equals(string2) || string.equals(string2)) {
                expandableComposite.setExpanded(true);
                if (this.fFirstChild != expandableComposite) {
                    this.fFirstChild.setExpanded(false);
                }
            } else {
                expandableComposite.setExpanded(false);
            }
            expandableComposite.setLayoutData((Object)new GridData(4, 1, true, false));
            AbstractConfigurationBlock.this.updateSectionStyle(expandableComposite);
            this.manage(expandableComposite);
            Composite composite = new Composite((Composite)expandableComposite, 0);
            expandableComposite.setClient((Control)composite);
            return composite;
        }

        static /* synthetic */ boolean access$0(SectionManager sectionManager) {
            return sectionManager.fIsBeingManaged;
        }

        static /* synthetic */ void access$1(SectionManager sectionManager, boolean bl) {
            sectionManager.fIsBeingManaged = bl;
        }

        static /* synthetic */ Set access$2(SectionManager sectionManager) {
            return sectionManager.fSections;
        }

        static /* synthetic */ String access$3(SectionManager sectionManager) {
            return sectionManager.fLastOpenKey;
        }

        static /* synthetic */ IPreferenceStore access$4(SectionManager sectionManager) {
            return sectionManager.fDialogSettingsStore;
        }

        static /* synthetic */ AbstractConfigurationBlock access$5(SectionManager sectionManager) {
            return sectionManager.AbstractConfigurationBlock.this;
        }
    }
}

