/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.IPreferenceAndPropertyConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.wst.jsdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractConfigurationBlockPreferenceAndPropertyPage
extends PropertyAndPreferencePage {
    private IPreferenceAndPropertyConfigurationBlock fConfigurationBlock;
    private PreferencesAccess fAccess;

    protected abstract IPreferenceAndPropertyConfigurationBlock createConfigurationBlock(IScopeContext var1);

    protected abstract String getHelpId();

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpId());
    }

    protected Control createPreferenceContent(Composite composite) {
        IPreferencePageContainer iPreferencePageContainer = this.getContainer();
        Object object = iPreferencePageContainer instanceof IWorkbenchPreferenceContainer ? ((IWorkbenchPreferenceContainer)iPreferencePageContainer).getWorkingCopyManager() : new WorkingCopyManager();
        this.fAccess = PreferencesAccess.getWorkingCopyPreferences(object);
        IProject iProject = this.getProject();
        IScopeContext iScopeContext = iProject != null ? this.fAccess.getProjectScope(iProject) : this.fAccess.getInstanceScope();
        this.fConfigurationBlock = this.createConfigurationBlock(iScopeContext);
        Control control = this.fConfigurationBlock.createControl(composite);
        this.fConfigurationBlock.initialize();
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    public boolean performOk() {
        this.fConfigurationBlock.performOk();
        try {
            this.fAccess.applyChanges();
        }
        catch (BackingStoreException backingStoreException) {
            JavaPlugin.log(backingStoreException);
        }
        return true;
    }

    public void performDefaults() {
        this.fConfigurationBlock.performDefaults();
        super.performDefaults();
    }

    public void dispose() {
        this.fConfigurationBlock.dispose();
        super.dispose();
    }

    protected void enableProjectSpecificSettings(boolean bl) {
        super.enableProjectSpecificSettings(bl);
        if (bl) {
            this.fConfigurationBlock.enableProjectSettings();
        } else {
            this.fConfigurationBlock.disableProjectSettings();
        }
    }
}

