/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;

final class CodeAssistAdvancedConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_EXCLUDED_CATEGORIES;
    private static final OptionsConfigurationBlock.Key PREF_CATEGORY_ORDER;
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC;
    private final Comparator fCategoryComparator = new Comparator(){

        private int getRank(Object object) {
            return ((ModelElement)object).getRank();
        }

        public int compare(Object object, Object object2) {
            return this.getRank(object) - this.getRank(object2);
        }
    };
    private final PreferenceModel fModel;
    private final Map fImages = new HashMap();
    private CheckboxTableViewer fDefaultViewer;
    private CheckboxTableViewer fSeparateViewer;
    private Button fUpButton;
    private Button fDownButton;
    private static BindingManager fgLocalBindingManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        IBindingService iBindingService;
        Scheme[] schemeArray;
        PREF_EXCLUDED_CATEGORIES = CodeAssistAdvancedConfigurationBlock.getJDTUIKey("content_assist_disabled_computers");
        PREF_CATEGORY_ORDER = CodeAssistAdvancedConfigurationBlock.getJDTUIKey("content_assist_category_order");
        PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC = CodeAssistAdvancedConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.timeoutForParameterNameFromAttachedJavadoc");
        fgLocalBindingManager = new BindingManager(new ContextManager(), new CommandManager());
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((schemeArray = (iBindingService = (IBindingService)iWorkbench.getService((Class)clazz)).getDefinedSchemes()) != null) {
            try {
                int n = 0;
                while (n < schemeArray.length) {
                    Scheme scheme = schemeArray[n];
                    Scheme scheme2 = fgLocalBindingManager.getScheme(scheme.getId());
                    scheme2.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                    ++n;
                }
            }
            catch (NotDefinedException notDefinedException) {
                JavaPlugin.log(notDefinedException);
            }
        }
        fgLocalBindingManager.setLocale(iBindingService.getLocale());
        fgLocalBindingManager.setPlatform(iBindingService.getPlatform());
    }

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_EXCLUDED_CATEGORIES, PREF_CATEGORY_ORDER, PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC};
    }

    CodeAssistAdvancedConfigurationBlock(IStatusChangeListener iStatusChangeListener, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, null, CodeAssistAdvancedConfigurationBlock.getAllKeys(), iWorkbenchPreferenceContainer);
        this.fModel = new PreferenceModel(CompletionProposalComputerRegistry.getDefault());
    }

    protected Control createContents(Composite composite) {
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite, 768);
        scrolledPageContent.setExpandHorizontal(true);
        scrolledPageContent.setExpandVertical(true);
        Composite composite2 = new Composite((Composite)scrolledPageContent, 0);
        int n = 2;
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createDefaultLabel(composite2, n);
        this.createDefaultViewer(composite2, n);
        this.createKeysLink(composite2, n);
        this.createFiller(composite2, n);
        this.createSeparateLabel(composite2, n);
        this.createSeparateSection(composite2);
        this.createFiller(composite2, n);
        this.createParameterTimeoutControl(composite2, n);
        this.updateControls();
        if (this.fModel.elements.size() > 0) {
            this.fDefaultViewer.getTable().select(0);
            this.fSeparateViewer.getTable().select(0);
            this.handleTableSelection();
        }
        scrolledPageContent.setContent((Control)composite2);
        scrolledPageContent.setMinSize(composite2.computeSize(-1, -1));
        return scrolledPageContent;
    }

    private void createDefaultLabel(Composite composite, int n) {
        ICommandService iCommandService;
        Command command;
        ParameterizedCommand parameterizedCommand;
        String string;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((string = CodeAssistAdvancedConfigurationBlock.getKeyboardShortcut(parameterizedCommand = new ParameterizedCommand(command = (iCommandService = (ICommandService)iWorkbench.getAdapter((Class)clazz)).getCommand("org.eclipse.ui.edit.text.contentAssist.proposals"), null))) == null) {
            string = PreferencesMessages.CodeAssistAdvancedConfigurationBlock_no_shortcut;
        }
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        int n2 = pixelConverter.convertWidthInCharsToPixels(40);
        Label label = new Label(composite, 64);
        label.setText(Messages.format(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_page_description, new Object[]{string}));
        GridData gridData = new GridData(4, 4, true, false, n, 1);
        gridData.widthHint = n2;
        label.setLayoutData((Object)gridData);
        this.createFiller(composite, n);
        label = new Label(composite, 64);
        label.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_default_table_description);
        gridData = new GridData(4, 4, true, false, n, 1);
        gridData.widthHint = n2;
        label.setLayoutData((Object)gridData);
    }

    private void createDefaultViewer(Composite composite, int n) {
        this.fDefaultViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2052);
        Table table = this.fDefaultViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 1, false, false, n, 1));
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_default_table_category_column_title);
        tableColumn.setResizable(false);
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_default_table_keybinding_column_title);
        tableColumn2.setResizable(false);
        this.fDefaultViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                boolean bl = checkStateChangedEvent.getChecked();
                ModelElement modelElement = (ModelElement)checkStateChangedEvent.getElement();
                modelElement.setInDefaultCategory(bl);
            }
        });
        this.fDefaultViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        DefaultTableLabelProvider defaultTableLabelProvider = new DefaultTableLabelProvider();
        this.fDefaultViewer.setLabelProvider((IBaseLabelProvider)defaultTableLabelProvider);
        this.fDefaultViewer.setInput((Object)this.fModel.elements);
        this.fDefaultViewer.setComparator(new ViewerComparator());
        int n2 = this.computeWidth((Control)table, tableColumn.getText()) + 20;
        int n3 = this.computeWidth((Control)table, tableColumn2.getText()) + 20;
        int n4 = 0;
        while (n4 < this.fModel.elements.size()) {
            n2 = Math.max(n2, this.computeWidth((Control)table, defaultTableLabelProvider.getColumnText(this.fModel.elements.get(n4), 0)) + 50);
            n3 = Math.max(n3, this.computeWidth((Control)table, defaultTableLabelProvider.getColumnText(this.fModel.elements.get(n4), 1)));
            ++n4;
        }
        tableColumn.setWidth(n2);
        tableColumn2.setWidth(n3);
    }

    private void createKeysLink(Composite composite, int n) {
        Link link = new Link(composite, 64);
        link.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_key_binding_hint);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)CodeAssistAdvancedConfigurationBlock.this.getShell(), (String)selectionEvent.text, null, null);
            }
        });
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        int n2 = pixelConverter.convertWidthInCharsToPixels(40);
        GridData gridData = new GridData(4, 4, false, false, n, 1);
        gridData.widthHint = n2;
        link.setLayoutData((Object)gridData);
    }

    private void createFiller(Composite composite, int n) {
        Label label = new Label(composite, 0);
        label.setVisible(false);
        label.setLayoutData((Object)new GridData(4, 4, false, false, n, 1));
    }

    private void createSeparateLabel(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        int n2 = pixelConverter.convertWidthInCharsToPixels(40);
        Label label = new Label(composite, 64);
        label.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_separate_table_description);
        GridData gridData = new GridData(4, 4, false, false, n, 1);
        gridData.widthHint = n2;
        label.setLayoutData((Object)gridData);
    }

    private void createSeparateSection(Composite composite) {
        this.createSeparateViewer(composite);
        this.createButtonList(composite);
    }

    private void createSeparateViewer(Composite composite) {
        this.fSeparateViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2052);
        Table table = this.fSeparateViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_separate_table_category_column_title);
        tableColumn.setResizable(false);
        this.fSeparateViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        SeparateTableLabelProvider separateTableLabelProvider = new SeparateTableLabelProvider();
        this.fSeparateViewer.setLabelProvider((IBaseLabelProvider)separateTableLabelProvider);
        this.fSeparateViewer.setInput((Object)this.fModel.elements);
        int n = this.computeWidth((Control)table, tableColumn.getText()) + 20;
        int n2 = 0;
        while (n2 < this.fModel.elements.size()) {
            n = Math.max(n, this.computeWidth((Control)table, separateTableLabelProvider.getColumnText(this.fModel.elements.get(n2), 0)) + 50);
            ++n2;
        }
        tableColumn.setWidth(n);
        this.fSeparateViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                boolean bl = checkStateChangedEvent.getChecked();
                ModelElement modelElement = (ModelElement)checkStateChangedEvent.getElement();
                modelElement.setSeparateCommand(bl);
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CodeAssistAdvancedConfigurationBlock.this.handleTableSelection();
            }
        });
    }

    private void createButtonList(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1, 1, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fUpButton = new Button(composite2, 0x1000008);
        this.fUpButton.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_Up);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = CodeAssistAdvancedConfigurationBlock.this.getSelectionIndex();
                if (n != -1) {
                    ((ModelElement)((CodeAssistAdvancedConfigurationBlock)CodeAssistAdvancedConfigurationBlock.this).fModel.elements.get(n)).moveUp();
                    CodeAssistAdvancedConfigurationBlock.this.fSeparateViewer.refresh();
                    CodeAssistAdvancedConfigurationBlock.this.handleTableSelection();
                }
            }
        });
        this.fUpButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fUpButton);
        this.fDownButton = new Button(composite2, 0x1000008);
        this.fDownButton.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_Down);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = CodeAssistAdvancedConfigurationBlock.this.getSelectionIndex();
                if (n != -1) {
                    ((ModelElement)((CodeAssistAdvancedConfigurationBlock)CodeAssistAdvancedConfigurationBlock.this).fModel.elements.get(n)).moveDown();
                    CodeAssistAdvancedConfigurationBlock.this.fSeparateViewer.refresh();
                    CodeAssistAdvancedConfigurationBlock.this.handleTableSelection();
                }
            }
        });
        this.fDownButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fDownButton);
    }

    private void createParameterTimeoutControl(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false, n, 1);
        composite2.setLayoutData((Object)gridData);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        String string = PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout;
        this.addTextField(composite2, string, PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC, 0, pixelConverter.convertWidthInCharsToPixels(7));
        Label label = new Label(composite2, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout_ms);
    }

    private void handleTableSelection() {
        ModelElement modelElement = this.getSelectedItem();
        if (modelElement != null) {
            int n = this.getSelectionIndex();
            this.fUpButton.setEnabled(n > 0);
            this.fDownButton.setEnabled(n < this.fModel.elements.size() - 1);
        } else {
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        }
    }

    private ModelElement getSelectedItem() {
        return (ModelElement)((IStructuredSelection)this.fSeparateViewer.getSelection()).getFirstElement();
    }

    private int getSelectionIndex() {
        return this.fSeparateViewer.getTable().getSelectionIndex();
    }

    protected void updateControls() {
        super.updateControls();
        this.fModel.update();
        this.updateCheckedState();
        this.fDefaultViewer.refresh();
        this.fSeparateViewer.refresh();
        this.handleTableSelection();
    }

    private void updateCheckedState() {
        int n = this.fModel.elements.size();
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>(n);
        ArrayList<ModelElement> arrayList2 = new ArrayList<ModelElement>(n);
        Iterator iterator = this.fModel.elements.iterator();
        while (iterator.hasNext()) {
            ModelElement modelElement = (ModelElement)iterator.next();
            if (modelElement.isInDefaultCategory()) {
                arrayList.add(modelElement);
            }
            if (!modelElement.isSeparateCommand()) continue;
            arrayList2.add(modelElement);
        }
        this.fDefaultViewer.setCheckedElements(arrayList.toArray(new Object[arrayList.size()]));
        this.fSeparateViewer.setCheckedElements(arrayList2.toArray(new Object[arrayList2.size()]));
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        Iterator iterator = this.fModel.elements.iterator();
        while (iterator.hasNext()) {
            ModelElement modelElement = (ModelElement)iterator.next();
            modelElement.update();
        }
        return super.processChanges(iWorkbenchPreferenceContainer);
    }

    protected void validateSettings(OptionsConfigurationBlock.Key key, String string, String string2) {
        if (key == PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC) {
            StatusInfo statusInfo = new StatusInfo();
            if (string2.length() == 0) {
                statusInfo.setError(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout_emptyInput);
            } else {
                try {
                    int n = Integer.parseInt(string2);
                    int n2 = 0;
                    int n3 = 5000;
                    if (n < n2 || n > n3) {
                        String string3 = PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout_invalidRange;
                        String string4 = Messages.format(string3, new Object[]{new Integer(n2), new Integer(n3)});
                        statusInfo.setError(string4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout_invalidInput;
                    String string6 = Messages.format(string5, string2);
                    statusInfo.setError(string6);
                }
            }
            this.fContext.statusChanged(statusInfo);
        }
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        return null;
    }

    public void dispose() {
        Iterator iterator = this.fImages.values().iterator();
        while (iterator.hasNext()) {
            Image image = (Image)iterator.next();
            image.dispose();
        }
        super.dispose();
    }

    private int computeWidth(Control control, String string) {
        int n;
        if (string == null) {
            return 0;
        }
        GC gC = new GC((Drawable)control);
        try {
            gC.setFont(JFaceResources.getDialogFont());
            n = gC.stringExtent((String)string).x + 10;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            gC.dispose();
            throw throwable;
        }
        gC.dispose();
        return n;
    }

    private static String getKeyboardShortcut(ParameterizedCommand parameterizedCommand) {
        TriggerSequence[] triggerSequenceArray;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBindingService iBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz);
        fgLocalBindingManager.setBindings(iBindingService.getBindings());
        try {
            triggerSequenceArray = iBindingService.getActiveScheme();
            if (triggerSequenceArray != null) {
                fgLocalBindingManager.setActiveScheme((Scheme)triggerSequenceArray);
            }
        }
        catch (NotDefinedException notDefinedException) {
            JavaPlugin.log(notDefinedException);
        }
        if ((triggerSequenceArray = fgLocalBindingManager.getActiveBindingsDisregardingContextFor(parameterizedCommand)).length > 0) {
            return triggerSequenceArray[0].format();
        }
        return null;
    }

    private Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = (Image)this.fImages.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage(false);
            this.fImages.put(imageDescriptor, image);
        }
        return image;
    }

    private final class DefaultTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DefaultTableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return ((ModelElement)object).getImage();
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((ModelElement)object).getName();
                }
                case 1: {
                    return ((ModelElement)object).getKeybindingAsString();
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public String getText(Object object) {
            return this.getColumnText(object, 0);
        }
    }

    private final class ModelElement {
        private final CompletionProposalCategory fCategory;
        private final Command fCommand;
        private final IParameter fParam;
        private final PreferenceModel fPreferenceModel;

        ModelElement(CompletionProposalCategory completionProposalCategory, PreferenceModel preferenceModel) {
            IParameter iParameter;
            this.fCategory = completionProposalCategory;
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.commands.ICommandService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ICommandService iCommandService = (ICommandService)iWorkbench.getAdapter((Class)clazz);
            this.fCommand = iCommandService.getCommand("org.eclipse.wst.jsdt.ui.specific_content_assist.command");
            try {
                iParameter = this.fCommand.getParameters()[0];
            }
            catch (NotDefinedException notDefinedException) {
                Assert.isTrue((boolean)false);
                iParameter = null;
            }
            this.fParam = iParameter;
            this.fPreferenceModel = preferenceModel;
        }

        Image getImage() {
            return CodeAssistAdvancedConfigurationBlock.this.getImage(this.fCategory.getImageDescriptor());
        }

        String getName() {
            return this.fCategory.getDisplayName();
        }

        String getKeybindingAsString() {
            Parameterization[] parameterizationArray = new Parameterization[]{new Parameterization(this.fParam, this.fCategory.getId())};
            ParameterizedCommand parameterizedCommand = new ParameterizedCommand(this.fCommand, parameterizationArray);
            String string = CodeAssistAdvancedConfigurationBlock.getKeyboardShortcut(parameterizedCommand);
            return string;
        }

        boolean isInDefaultCategory() {
            return this.fPreferenceModel.readInclusionPreference(this.fCategory);
        }

        void setInDefaultCategory(boolean bl) {
            if (bl != this.isInDefaultCategory()) {
                this.fPreferenceModel.writeInclusionPreference(this, bl);
            }
        }

        String getId() {
            return this.fCategory.getId();
        }

        int getRank() {
            int n = this.getInternalRank();
            if (n > 65535) {
                return n - 65535;
            }
            return n;
        }

        void moveUp() {
            this.fPreferenceModel.moveUp(this);
        }

        void moveDown() {
            this.fPreferenceModel.moveDown(this);
        }

        private int getInternalRank() {
            return this.fPreferenceModel.readOrderPreference(this.fCategory);
        }

        boolean isSeparateCommand() {
            return this.getInternalRank() < 65535;
        }

        void setSeparateCommand(boolean bl) {
            if (bl != this.isSeparateCommand()) {
                this.fPreferenceModel.writeOrderPreference(this, bl);
            }
        }

        void update() {
            this.fCategory.setIncluded(this.isInDefaultCategory());
            int n = this.getInternalRank();
            this.fCategory.setSortOrder(n);
            this.fCategory.setSeparateCommand(n < 65535);
        }
    }

    private final class PreferenceModel {
        private static final int LIMIT = 65535;
        private static final String COLON = ":";
        private static final String SEPARATOR = "\u0000";
        private final List fElements;
        final List elements;

        public PreferenceModel(CompletionProposalComputerRegistry completionProposalComputerRegistry) {
            List list = completionProposalComputerRegistry.getProposalCategories();
            this.fElements = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CompletionProposalCategory completionProposalCategory = (CompletionProposalCategory)iterator.next();
                if (!completionProposalCategory.hasComputers()) continue;
                this.fElements.add(new ModelElement(completionProposalCategory, this));
            }
            Collections.sort(this.fElements, CodeAssistAdvancedConfigurationBlock.this.fCategoryComparator);
            this.elements = Collections.unmodifiableList(this.fElements);
        }

        public void moveUp(ModelElement modelElement) {
            int n = this.fElements.indexOf(modelElement);
            if (n > 0) {
                Object e = this.fElements.remove(n);
                this.fElements.add(n - 1, e);
                this.writeOrderPreference(null, false);
            }
        }

        public void moveDown(ModelElement modelElement) {
            int n = this.fElements.indexOf(modelElement);
            if (n < this.fElements.size() - 1) {
                Object e = this.fElements.remove(n);
                this.fElements.add(n + 1, e);
                this.writeOrderPreference(null, false);
            }
        }

        private void writeInclusionPreference(ModelElement modelElement, boolean bl) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            Object object2 = this.fElements.iterator();
            while (object2.hasNext()) {
                boolean bl2;
                object = (ModelElement)object2.next();
                boolean bl3 = bl2 = modelElement == object ? bl : ((ModelElement)object).isInDefaultCategory();
                if (bl2) continue;
                stringBuffer.append(String.valueOf(((ModelElement)object).getId()) + SEPARATOR);
            }
            object2 = stringBuffer.toString();
            object = CodeAssistAdvancedConfigurationBlock.this.setValue(PREF_EXCLUDED_CATEGORIES, (String)object2);
            CodeAssistAdvancedConfigurationBlock.this.validateSettings(PREF_EXCLUDED_CATEGORIES, (String)object, (String)object2);
        }

        private void writeOrderPreference(ModelElement modelElement, boolean bl) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            Object object2 = this.fElements.iterator();
            while (object2.hasNext()) {
                object = (ModelElement)object2.next();
                boolean bl2 = modelElement == object ? bl : ((ModelElement)object).isSeparateCommand();
                int n2 = bl2 ? n : n + 65535;
                stringBuffer.append(String.valueOf(((ModelElement)object).getId()) + COLON + n2 + SEPARATOR);
                ++n;
            }
            object2 = stringBuffer.toString();
            object = CodeAssistAdvancedConfigurationBlock.this.setValue(PREF_CATEGORY_ORDER, (String)object2);
            CodeAssistAdvancedConfigurationBlock.this.validateSettings(PREF_CATEGORY_ORDER, (String)object, (String)object2);
        }

        private boolean readInclusionPreference(CompletionProposalCategory completionProposalCategory) {
            String[] stringArray = CodeAssistAdvancedConfigurationBlock.this.getTokens(CodeAssistAdvancedConfigurationBlock.this.getValue(PREF_EXCLUDED_CATEGORIES), SEPARATOR);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(completionProposalCategory.getId())) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private int readOrderPreference(CompletionProposalCategory completionProposalCategory) {
            String[] stringArray = CodeAssistAdvancedConfigurationBlock.this.getTokens(CodeAssistAdvancedConfigurationBlock.this.getValue(PREF_CATEGORY_ORDER), SEPARATOR);
            int n = 0;
            while (n < stringArray.length) {
                String[] stringArray2 = CodeAssistAdvancedConfigurationBlock.this.getTokens(stringArray[n], COLON);
                if (stringArray2[0].equals(completionProposalCategory.getId())) {
                    return Integer.parseInt(stringArray2[1]);
                }
                ++n;
            }
            return 65536;
        }

        public void update() {
            Collections.sort(this.fElements, CodeAssistAdvancedConfigurationBlock.this.fCategoryComparator);
        }
    }

    private final class SeparateTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SeparateTableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return ((ModelElement)object).getImage();
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((ModelElement)object).getName();
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }
    }
}

