/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.Iterator;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;
import org.eclipse.wst.jsdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.wst.jsdt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import org.eclipse.wst.jsdt.ui.text.IColorManager;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

public class CodeTemplateSourceViewerConfiguration
extends SimpleJavaSourceViewerConfiguration {
    private final TemplateVariableProcessor fProcessor;

    public CodeTemplateSourceViewerConfiguration(IColorManager iColorManager, IPreferenceStore iPreferenceStore, ITextEditor iTextEditor, TemplateVariableProcessor templateVariableProcessor) {
        super(iColorManager, iPreferenceStore, iTextEditor, "___java_partitioning", false);
        this.fProcessor = templateVariableProcessor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager iColorManager = javaTextTools.getColorManager();
        ContentAssistant contentAssistant = new ContentAssistant();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__dftl_partition_content_type");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_string");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_character");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_singleline_comment");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_multiline_comment");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__java_javadoc");
        contentAssistant.enableAutoInsert(iPreferenceStore.getBoolean("content_assist_autoinsert"));
        contentAssistant.enableAutoActivation(iPreferenceStore.getBoolean("content_assist_autoactivation"));
        contentAssistant.setAutoActivationDelay(iPreferenceStore.getInt("content_assist_autoactivation_delay"));
        contentAssistant.setProposalPopupOrientation(10);
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        });
        Color color = this.getColor(iPreferenceStore, "content_assist_proposals_background", iColorManager);
        contentAssistant.setContextInformationPopupBackground(color);
        contentAssistant.setContextSelectorBackground(color);
        contentAssistant.setProposalSelectorBackground(color);
        Color color2 = this.getColor(iPreferenceStore, "content_assist_proposals_foreground", iColorManager);
        contentAssistant.setContextInformationPopupForeground(color2);
        contentAssistant.setContextSelectorForeground(color2);
        contentAssistant.setProposalSelectorForeground(color2);
        return contentAssistant;
    }

    private Color getColor(IPreferenceStore iPreferenceStore, String string, IColorManager iColorManager) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        return iColorManager.getColor(rGB);
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string, int n) {
        return new TemplateVariableTextHover(this.fProcessor);
    }

    private static class TemplateVariableTextHover
    implements ITextHover {
        private TemplateVariableProcessor fProcessor;

        public TemplateVariableTextHover(TemplateVariableProcessor templateVariableProcessor) {
            this.fProcessor = templateVariableProcessor;
        }

        public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
            try {
                IDocument iDocument = iTextViewer.getDocument();
                int n = iRegion.getOffset();
                if (n >= 2 && "${".equals(iDocument.get(n - 2, 2))) {
                    String string = iDocument.get(n, iRegion.getLength());
                    TemplateContextType templateContextType = this.fProcessor.getContextType();
                    if (templateContextType != null) {
                        Iterator iterator = templateContextType.resolvers();
                        while (iterator.hasNext()) {
                            TemplateVariableResolver templateVariableResolver = (TemplateVariableResolver)iterator.next();
                            if (!string.equals(templateVariableResolver.getType())) continue;
                            return templateVariableResolver.getDescription();
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
            return null;
        }

        public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
            if (iTextViewer != null) {
                return JavaWordFinder.findWord(iTextViewer.getDocument(), n);
            }
            return null;
        }
    }
}

