/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.BuildPathsPropertyPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstall2;
import org.eclipse.wst.jsdt.launching.JavaRuntime;

public class ComplianceConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_LOCAL_VARIABLE_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.debug.localVariable");
    private static final OptionsConfigurationBlock.Key PREF_LINE_NUMBER_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.debug.lineNumber");
    private static final OptionsConfigurationBlock.Key PREF_SOURCE_FILE_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_UNUSED_LOCAL = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.codegen.unusedLocal");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_TARGET_PLATFORM = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_INLINE_JSR_BYTECODE = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.codegen.inlineJsrBytecode");
    private static final OptionsConfigurationBlock.Key PREF_SOURCE_COMPATIBILITY = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.source");
    private static final OptionsConfigurationBlock.Key PREF_COMPLIANCE = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.compliance");
    private static final OptionsConfigurationBlock.Key PREF_PB_ASSERT_AS_IDENTIFIER = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier");
    private static final OptionsConfigurationBlock.Key PREF_PB_ENUM_AS_IDENTIFIER = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.problem.enumIdentifier");
    private static final OptionsConfigurationBlock.Key INTR_DEFAULT_COMPLIANCE = ComplianceConfigurationBlock.getJDTUIKey("internal.default.compliance");
    private static final String GENERATE = "generate";
    private static final String DO_NOT_GENERATE = "do not generate";
    private static final String PRESERVE = "preserve";
    private static final String OPTIMIZE_OUT = "optimize out";
    private static final String VERSION_1_1 = "1.1";
    private static final String VERSION_1_2 = "1.2";
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String VERSION_1_5 = "1.5";
    private static final String VERSION_1_6 = "1.6";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String DEFAULT_CONF = "default";
    private static final String USER_CONF = "user";
    private ArrayList fComplianceControls = new ArrayList();
    private PixelConverter fPixelConverter;
    private String[] fRememberedUserCompliance;
    private static final int IDX_ASSERT_AS_IDENTIFIER = 0;
    private static final int IDX_ENUM_AS_IDENTIFIER = 1;
    private static final int IDX_SOURCE_COMPATIBILITY = 2;
    private static final int IDX_CODEGEN_TARGET_PLATFORM = 3;
    private static final int IDX_COMPLIANCE = 4;
    private static final int IDX_INLINE_JSR_BYTECODE = 5;
    private IStatus fComplianceStatus = new StatusInfo();
    private Link fJRE50InfoText;
    private Composite fControlsComposite;
    private ControlEnableState fBlockEnableState = null;

    public ComplianceConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, iProject, ComplianceConfigurationBlock.getKeys(), iWorkbenchPreferenceContainer);
        this.fRememberedUserCompliance = new String[]{this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER), this.getValue(PREF_PB_ENUM_AS_IDENTIFIER), this.getValue(PREF_SOURCE_COMPATIBILITY), this.getValue(PREF_CODEGEN_TARGET_PLATFORM), this.getValue(PREF_COMPLIANCE), this.getValue(PREF_CODEGEN_INLINE_JSR_BYTECODE)};
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_LOCAL_VARIABLE_ATTR, PREF_LINE_NUMBER_ATTR, PREF_SOURCE_FILE_ATTR, PREF_CODEGEN_UNUSED_LOCAL, PREF_CODEGEN_INLINE_JSR_BYTECODE, PREF_COMPLIANCE, PREF_SOURCE_COMPATIBILITY, PREF_CODEGEN_TARGET_PLATFORM, PREF_PB_ASSERT_AS_IDENTIFIER, PREF_PB_ENUM_AS_IDENTIFIER};
    }

    protected void settingsUpdated() {
        this.setValue(INTR_DEFAULT_COMPLIANCE, this.getCurrentCompliance());
        super.settingsUpdated();
    }

    protected Control createContents(Composite composite) {
        this.fPixelConverter = new PixelConverter((Control)composite);
        this.setShell(composite.getShell());
        Composite composite2 = this.createComplianceTabContent(composite);
        this.validateSettings(null, null, null);
        return composite2;
    }

    public void enablePreferenceContent(boolean bl) {
        if (this.fControlsComposite != null && !this.fControlsComposite.isDisposed()) {
            if (bl) {
                if (this.fBlockEnableState != null) {
                    this.fBlockEnableState.restore();
                    this.fBlockEnableState = null;
                }
            } else if (this.fBlockEnableState == null) {
                this.fBlockEnableState = ControlEnableState.disable((Control)this.fControlsComposite);
            }
        }
    }

    private Composite createComplianceTabContent(Composite composite) {
        String[] stringArray = new String[]{VERSION_1_4, VERSION_1_5};
        String[] stringArray2 = new String[]{PreferencesMessages.ComplianceConfigurationBlock_version14, PreferencesMessages.ComplianceConfigurationBlock_version15};
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite);
        Composite composite2 = scrolledPageContent.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fControlsComposite = new Composite(composite2, 0);
        this.fControlsComposite.setFont(composite2.getFont());
        this.fControlsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        this.fControlsComposite.setLayout((Layout)gridLayout);
        int n = 3;
        gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        Group group = new Group(this.fControlsComposite, 0);
        group.setFont(this.fControlsComposite.getFont());
        group.setText(PreferencesMessages.ComplianceConfigurationBlock_compliance_group_label);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)gridLayout);
        String string = PreferencesMessages.ComplianceConfigurationBlock_compiler_compliance_label;
        Combo combo = this.addComboBox((Composite)group, string, PREF_COMPLIANCE, stringArray, stringArray2, 0);
        combo.setEnabled(false);
        return scrolledPageContent;
    }

    protected final void openBuildPathPropertyPage() {
        if (this.getPreferenceContainer() != null) {
            HashMap<Object, IClasspathEntry> hashMap = new HashMap<Object, IClasspathEntry>();
            hashMap.put(BuildPathsPropertyPage.DATA_REVEAL_ENTRY, JavaRuntime.getDefaultJREContainerEntry());
            this.getPreferenceContainer().openPage("org.eclipse.wst.jsdt.ui.propertyPages.BuildPathsPropertyPage", hashMap);
        }
        this.validateJRE50Status();
    }

    protected final void openJREInstallPreferencePage() {
        String string = "org.eclipse.wst.jsdt.debug.ui.preferences.VMPreferencePage";
        if (this.fProject == null && this.getPreferenceContainer() != null) {
            this.getPreferenceContainer().openPage(string, null);
        } else {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)string, (String[])new String[]{string}, null).open();
        }
        this.validateJRE50Status();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key key, String string, String string2) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (key != null) {
            if (INTR_DEFAULT_COMPLIANCE.equals(key)) {
                this.updateComplianceEnableState();
                this.updateComplianceDefaultSettings(true, null);
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_COMPLIANCE.equals(key)) {
                this.setValue(INTR_DEFAULT_COMPLIANCE, DEFAULT_CONF);
                this.updateComplianceEnableState();
                this.fComplianceStatus = this.validateCompliance();
                this.validateJRE50Status();
            } else if (PREF_SOURCE_COMPATIBILITY.equals(key)) {
                this.updateAssertEnumAsIdentifierEnableState();
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_CODEGEN_TARGET_PLATFORM.equals(key)) {
                this.updateInlineJSREnableState();
                this.fComplianceStatus = this.validateCompliance();
            } else {
                if (!PREF_PB_ENUM_AS_IDENTIFIER.equals(key) && !PREF_PB_ASSERT_AS_IDENTIFIER.equals(key)) return;
                this.fComplianceStatus = this.validateCompliance();
            }
        } else {
            this.fComplianceStatus = this.validateCompliance();
        }
        this.fContext.statusChanged(this.fComplianceStatus);
    }

    private void validateJRE50Status() {
        if (this.fJRE50InfoText != null && !this.fJRE50InfoText.isDisposed()) {
            String string;
            boolean bl = false;
            String string2 = this.getStoredValue(PREF_COMPLIANCE);
            IVMInstall iVMInstall = null;
            if (this.fProject != null) {
                try {
                    iVMInstall = JavaRuntime.getVMInstall(JavaCore.create((IProject)this.fProject));
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
            } else {
                iVMInstall = JavaRuntime.getDefaultVMInstall();
            }
            if (iVMInstall instanceof IVMInstall2 && JavaModelUtil.isVersionLessThan(string = JavaModelUtil.getCompilerCompliance((IVMInstall2)((Object)iVMInstall), string2), string2)) {
                Object[] objectArray = new String[]{this.getVersionLabel(string2), this.getVersionLabel(string)};
                if (this.fProject == null) {
                    this.fJRE50InfoText.setText(Messages.format(PreferencesMessages.ComplianceConfigurationBlock_jrecompliance_info, objectArray));
                } else {
                    this.fJRE50InfoText.setText(Messages.format(PreferencesMessages.ComplianceConfigurationBlock_jrecompliance_info_project, objectArray));
                }
                bl = true;
            }
            this.fJRE50InfoText.setVisible(bl);
        }
    }

    private String getVersionLabel(String string) {
        if (JavaModelUtil.isVersionLessThan(string, VERSION_1_5)) {
            return string;
        }
        if (VERSION_1_5.equals(string)) {
            return PreferencesMessages.ComplianceConfigurationBlock_version15;
        }
        return PreferencesMessages.ComplianceConfigurationBlock_version16;
    }

    private IStatus validateCompliance() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.getValue(PREF_COMPLIANCE);
        String string2 = this.getValue(PREF_SOURCE_COMPATIBILITY);
        String string3 = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
        if (JavaModelUtil.isVersionLessThan(string, string2)) {
            statusInfo.setError(PreferencesMessages.ComplianceConfigurationBlock_src_greater_compliance);
            return statusInfo;
        }
        if (JavaModelUtil.isVersionLessThan(string, string3)) {
            statusInfo.setError(PreferencesMessages.ComplianceConfigurationBlock_classfile_greater_compliance);
            return statusInfo;
        }
        if (!VERSION_1_3.equals(string2) && JavaModelUtil.isVersionLessThan(string3, string2)) {
            statusInfo.setError(PreferencesMessages.ComplianceConfigurationBlock_classfile_greater_source);
            return statusInfo;
        }
        return statusInfo;
    }

    public void useProjectSpecificSettings(boolean bl) {
        super.useProjectSpecificSettings(bl);
        this.validateJRE50Status();
    }

    private void updateComplianceEnableState() {
        boolean bl = this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF);
        int n = this.fComplianceControls.size() - 1;
        while (n >= 0) {
            Control control = (Control)this.fComplianceControls.get(n);
            control.setEnabled(bl);
            --n;
        }
    }

    private void updateAssertEnumAsIdentifierEnableState() {
        if (this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF)) {
            String string = this.getValue(PREF_SOURCE_COMPATIBILITY);
            boolean bl = VERSION_1_3.equals(string);
            this.updateRememberedComplianceOption(PREF_PB_ASSERT_AS_IDENTIFIER, 0, bl);
            boolean bl2 = bl || VERSION_1_4.equals(string);
            this.updateRememberedComplianceOption(PREF_PB_ENUM_AS_IDENTIFIER, 1, bl2);
        }
    }

    private void updateRememberedComplianceOption(OptionsConfigurationBlock.Key key, int n, boolean bl) {
        Combo combo = this.getComboBox(key);
        combo.setEnabled(bl);
        if (!bl) {
            String string = this.getValue(key);
            if (!ERROR.equals(string)) {
                this.setValue(key, ERROR);
                this.updateCombo(combo);
                this.fRememberedUserCompliance[n] = string;
            }
        } else {
            String string = this.fRememberedUserCompliance[n];
            if (!ERROR.equals(string)) {
                this.setValue(key, string);
                this.updateCombo(combo);
            }
        }
    }

    private void updateInlineJSREnableState() {
        String string = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
        boolean bl = JavaModelUtil.isVersionLessThan(string, VERSION_1_5);
        Button button = this.getCheckBox(PREF_CODEGEN_INLINE_JSR_BYTECODE);
        button.setEnabled(bl);
        if (!bl) {
            String string2;
            this.fRememberedUserCompliance[5] = string2 = this.getValue(PREF_CODEGEN_INLINE_JSR_BYTECODE);
            if (!ENABLED.equals(string2)) {
                this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, ENABLED);
                this.updateCheckBox(button);
            }
        } else {
            String string3 = this.fRememberedUserCompliance[5];
            if (!ENABLED.equals(string3)) {
                this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, string3);
                this.updateCheckBox(button);
            }
        }
    }

    private void updateComplianceDefaultSettings(boolean bl, String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        boolean bl2 = this.checkValue(INTR_DEFAULT_COMPLIANCE, DEFAULT_CONF);
        String string6 = this.getValue(PREF_COMPLIANCE);
        if (bl2) {
            if (bl) {
                if (string == null) {
                    string = string6;
                }
                this.fRememberedUserCompliance[0] = this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER);
                this.fRememberedUserCompliance[1] = this.getValue(PREF_PB_ENUM_AS_IDENTIFIER);
                this.fRememberedUserCompliance[2] = this.getValue(PREF_SOURCE_COMPATIBILITY);
                this.fRememberedUserCompliance[3] = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
                this.fRememberedUserCompliance[4] = string;
            }
            if (VERSION_1_4.equals(string6)) {
                string5 = WARNING;
                string4 = WARNING;
                string3 = VERSION_1_3;
                string2 = VERSION_1_2;
            } else if (VERSION_1_5.equals(string6)) {
                string5 = ERROR;
                string4 = ERROR;
                string3 = VERSION_1_5;
                string2 = VERSION_1_5;
            } else if (VERSION_1_6.equals(string6)) {
                string5 = ERROR;
                string4 = ERROR;
                string3 = VERSION_1_6;
                string2 = VERSION_1_6;
            } else {
                string5 = IGNORE;
                string4 = IGNORE;
                string3 = VERSION_1_3;
                string2 = VERSION_1_1;
            }
        } else if (bl && string6.equals(this.fRememberedUserCompliance[4])) {
            string5 = this.fRememberedUserCompliance[0];
            string4 = this.fRememberedUserCompliance[1];
            string3 = this.fRememberedUserCompliance[2];
            string2 = this.fRememberedUserCompliance[3];
        } else {
            this.updateInlineJSREnableState();
            this.updateAssertEnumAsIdentifierEnableState();
            return;
        }
        this.setValue(PREF_PB_ASSERT_AS_IDENTIFIER, string5);
        this.setValue(PREF_PB_ENUM_AS_IDENTIFIER, string4);
        this.setValue(PREF_SOURCE_COMPATIBILITY, string3);
        this.setValue(PREF_CODEGEN_TARGET_PLATFORM, string2);
        this.updateControls();
        this.updateInlineJSREnableState();
        this.updateAssertEnumAsIdentifierEnableState();
    }

    private String getCurrentCompliance() {
        String string = this.getValue(PREF_COMPLIANCE);
        if (VERSION_1_3.equals(string) && IGNORE.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && IGNORE.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_3.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_1.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_4.equals(string) && WARNING.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && WARNING.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_3.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_2.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_5.equals(string) && ERROR.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && ERROR.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_5.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_5.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_6.equals(string) && ERROR.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && ERROR.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_6.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_6.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM))) {
            return DEFAULT_CONF;
        }
        return USER_CONF;
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        String string = PreferencesMessages.ComplianceConfigurationBlock_needsbuild_title;
        String string2 = bl ? PreferencesMessages.ComplianceConfigurationBlock_needsfullbuild_message : PreferencesMessages.ComplianceConfigurationBlock_needsprojectbuild_message;
        return new String[]{string, string2};
    }

    public boolean performOk() {
        this.setValue(INTR_DEFAULT_COMPLIANCE, null);
        return super.performOk();
    }

    public boolean performApply() {
        this.setValue(INTR_DEFAULT_COMPLIANCE, null);
        boolean bl = super.performApply();
        this.setValue(INTR_DEFAULT_COMPLIANCE, this.getCurrentCompliance());
        return bl;
    }
}

