/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;

class JavaSourcePreviewerUpdater {
    JavaSourcePreviewerUpdater(final SourceViewer sourceViewer, final JavaSourceViewerConfiguration javaSourceViewerConfiguration, final IPreferenceStore iPreferenceStore) {
        Assert.isNotNull((Object)sourceViewer);
        Assert.isNotNull((Object)((Object)javaSourceViewerConfiguration));
        Assert.isNotNull((Object)iPreferenceStore);
        final IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("org.eclipse.wst.jsdt.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont");
                    sourceViewer.getTextWidget().setFont(font);
                }
            }
        };
        final IPropertyChangeListener iPropertyChangeListener2 = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (javaSourceViewerConfiguration.affectsTextPresentation(propertyChangeEvent)) {
                    javaSourceViewerConfiguration.handlePropertyChangeEvent(propertyChangeEvent);
                    sourceViewer.invalidateTextPresentation();
                }
            }
        };
        sourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                iPreferenceStore.removePropertyChangeListener(iPropertyChangeListener2);
                JFaceResources.getFontRegistry().removeListener(iPropertyChangeListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(iPropertyChangeListener);
        iPreferenceStore.addPropertyChangeListener(iPropertyChangeListener2);
    }
}

