/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.cleanup;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.preferences.BulletListBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;

public class CleanUpConfigurationBlock
extends ProfileConfigurationBlock {
    private static final String CLEANUP_PAGE_SETTINGS_KEY = "cleanup_page";
    private static final String DIALOGSTORE_LASTSAVELOADPATH = "org.eclipse.wst.jsdt.ui.cleanup";
    private final IScopeContext fCurrContext;
    private SelectionButtonDialogField fShowCleanUpWizardDialogField;
    private CleanUpProfileManager fProfileManager;
    private ProfileStore fProfileStore;
    private BulletListBlock fBrowserBlock;

    public CleanUpConfigurationBlock(IProject iProject, PreferencesAccess preferencesAccess) {
        super(iProject, preferencesAccess, DIALOGSTORE_LASTSAVELOADPATH);
        this.fCurrContext = iProject != null ? null : preferencesAccess.getInstanceScope();
    }

    protected IProfileVersioner createProfileVersioner() {
        return new CleanUpProfileVersioner();
    }

    protected ProfileStore createProfileStore(IProfileVersioner iProfileVersioner) {
        this.fProfileStore = new ProfileStore("org.eclipse.wst.jsdt.ui.cleanupprofiles", iProfileVersioner);
        return this.fProfileStore;
    }

    protected ProfileManager createProfileManager(List list, IScopeContext iScopeContext, PreferencesAccess preferencesAccess, IProfileVersioner iProfileVersioner) {
        list.addAll(CleanUpPreferenceUtil.getBuiltInProfiles());
        this.fProfileManager = new CleanUpProfileManager(list, iScopeContext, preferencesAccess, iProfileVersioner);
        return this.fProfileManager;
    }

    protected void configurePreview(Composite composite, int n, final ProfileManager profileManager) {
        Map map = profileManager.getSelected().getSettings();
        final Hashtable hashtable = new Hashtable();
        this.fill(map, hashtable);
        final ICleanUp[] iCleanUpArray = CleanUpRefactoring.createCleanUps(hashtable);
        CleanUpConfigurationBlock.createLabel(composite, CleanUpMessages.CleanUpConfigurationBlock_SelectedCleanUps_label, n);
        this.fBrowserBlock = new BulletListBlock();
        Control control = this.fBrowserBlock.createControl(composite);
        ((GridData)control.getLayoutData()).horizontalSpan = n;
        this.fBrowserBlock.setText(this.getSelectedCleanUpsInfo(iCleanUpArray));
        profileManager.addObserver(new Observer(){

            public void update(Observable observable, Object object) {
                int n = (Integer)object;
                switch (n) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        CleanUpConfigurationBlock.this.fill(profileManager.getSelected().getSettings(), hashtable);
                        CleanUpConfigurationBlock.this.fBrowserBlock.setText(CleanUpConfigurationBlock.this.getSelectedCleanUpsInfo(iCleanUpArray));
                    }
                }
            }
        });
    }

    private String getSelectedCleanUpsInfo(ICleanUp[] iCleanUpArray) {
        if (iCleanUpArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        while (n < iCleanUpArray.length) {
            String[] stringArray = iCleanUpArray[n].getDescriptions();
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append(stringArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void fill(Map map, Map map2) {
        map2.clear();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            map2.put(string, map.get(string));
        }
    }

    protected ModifyDialog createModifyDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean bl) {
        return new CleanUpModifyDialog(shell, profile, profileManager, profileStore, bl, CLEANUP_PAGE_SETTINGS_KEY, DIALOGSTORE_LASTSAVELOADPATH);
    }

    public Composite createContents(Composite composite) {
        Composite composite2 = super.createContents(composite);
        if (this.fCurrContext == null) {
            return composite2;
        }
        this.fShowCleanUpWizardDialogField = new SelectionButtonDialogField(32);
        this.fShowCleanUpWizardDialogField.setLabelText(CleanUpMessages.CleanUpConfigurationBlock_ShowCleanUpWizard_checkBoxLabel);
        this.fShowCleanUpWizardDialogField.doFillIntoGrid(composite2, 5);
        IEclipsePreferences iEclipsePreferences = this.fCurrContext.getNode("org.eclipse.wst.jsdt.ui");
        boolean bl = iEclipsePreferences.get("cleanup.showwizard", null) != null ? iEclipsePreferences.getBoolean("cleanup.showwizard", true) : new DefaultScope().getNode("org.eclipse.wst.jsdt.ui").getBoolean("cleanup.showwizard", true);
        if (bl) {
            this.fShowCleanUpWizardDialogField.setSelection(true);
        }
        this.fShowCleanUpWizardDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                CleanUpConfigurationBlock.this.doShowCleanUpWizard(CleanUpConfigurationBlock.this.fShowCleanUpWizardDialogField.isSelected());
            }
        });
        return composite2;
    }

    private void doShowCleanUpWizard(boolean bl) {
        IEclipsePreferences iEclipsePreferences = this.fCurrContext.getNode("org.eclipse.wst.jsdt.ui");
        if (iEclipsePreferences.get("cleanup.showwizard", null) != null && iEclipsePreferences.getBoolean("cleanup.showwizard", true) == bl) {
            return;
        }
        iEclipsePreferences.putBoolean("cleanup.showwizard", bl);
    }

    public void performDefaults() {
        super.performDefaults();
        if (this.fCurrContext == null) {
            return;
        }
        this.fCurrContext.getNode("org.eclipse.wst.jsdt.ui").remove("cleanup.showwizard");
        boolean bl = new DefaultScope().getNode("org.eclipse.wst.jsdt.ui").getBoolean("cleanup.showwizard", true);
        this.fShowCleanUpWizardDialogField.setDialogFieldListener(null);
        this.fShowCleanUpWizardDialogField.setSelection(bl);
        this.fShowCleanUpWizardDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                CleanUpConfigurationBlock.this.doShowCleanUpWizard(CleanUpConfigurationBlock.this.fShowCleanUpWizardDialogField.isSelected());
            }
        });
    }

    protected void preferenceChanged(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
        block13: {
            if ("org.eclipse.wst.jsdt.ui.cleanupprofiles".equals(preferenceChangeEvent.getKey())) {
                try {
                    String string = this.fCurrContext.getNode("org.eclipse.wst.jsdt.ui").get("cleanup_profile", null);
                    if (string == null) {
                        this.fProfileManager.getDefaultProfile().getID();
                    }
                    List list = this.fProfileManager.getSortedProfiles();
                    ProfileManager.Profile[] profileArray = list.toArray(new ProfileManager.Profile[list.size()]);
                    int n = 0;
                    while (n < profileArray.length) {
                        if (profileArray[n] instanceof ProfileManager.CustomProfile) {
                            this.fProfileManager.deleteProfile((ProfileManager.CustomProfile)profileArray[n]);
                        }
                        ++n;
                    }
                    List list2 = this.fProfileStore.readProfilesFromString((String)preferenceChangeEvent.getNewValue());
                    Object object = list2.iterator();
                    while (object.hasNext()) {
                        ProfileManager.CustomProfile customProfile = (ProfileManager.CustomProfile)object.next();
                        this.fProfileManager.addProfile(customProfile);
                    }
                    object = this.fProfileManager.getProfile(string);
                    if (object != null) {
                        this.fProfileManager.setSelected((ProfileManager.Profile)object);
                        break block13;
                    }
                    this.fProfileManager.setSelected(this.fProfileManager.getDefaultProfile());
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
            } else if ("cleanup_profile".equals(preferenceChangeEvent.getKey())) {
                if (preferenceChangeEvent.getNewValue() == null) {
                    this.fProfileManager.setSelected(this.fProfileManager.getDefaultProfile());
                } else {
                    ProfileManager.Profile profile = this.fProfileManager.getProfile((String)preferenceChangeEvent.getNewValue());
                    if (profile != null) {
                        this.fProfileManager.setSelected(profile);
                    }
                }
            }
        }
    }

    public void enableProjectSpecificSettings(boolean bl) {
        this.fBrowserBlock.setEnabled(bl);
    }
}

