/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class ChangeExceptionHandler {
    private Shell fParent;
    private String fName;

    public ChangeExceptionHandler(Shell shell, Refactoring refactoring) {
        this.fParent = shell;
        this.fName = refactoring.getName();
    }

    public void handle(Change change, RuntimeException runtimeException) {
        JavaPlugin.log(runtimeException);
        Status status = null;
        status = runtimeException.getMessage() == null ? new Status(4, JavaPlugin.getPluginId(), 4, RefactoringMessages.ChangeExceptionHandler_status_without_detail, (Throwable)runtimeException) : new Status(4, JavaPlugin.getPluginId(), 4, runtimeException.getMessage(), (Throwable)runtimeException);
        this.handle(change, (IStatus)status);
    }

    public void handle(Change change, CoreException coreException) {
        JavaPlugin.log(coreException);
        this.handle(change, coreException.getStatus());
    }

    private void handle(Change change, IStatus iStatus) {
        Change change2;
        if (change instanceof CompositeChange && (change2 = ((CompositeChange)change).getUndoUntilException()) != null) {
            JavaPlugin.log(iStatus);
            RefactorErrorDialog refactorErrorDialog = new RefactorErrorDialog(this.fParent, RefactoringMessages.ChangeExceptionHandler_dialog_title, Messages.format(RefactoringMessages.ChangeExceptionHandler_dialog_message, this.fName), iStatus, 7);
            int n = refactorErrorDialog.open();
            if (n == 0) {
                this.performUndo(change2);
            }
            return;
        }
        change2 = new ErrorDialog(this.fParent, RefactoringMessages.ChangeExceptionHandler_dialog_title, Messages.format(RefactoringMessages.ChangeExceptionHandler_dialog_message, this.fName), iStatus, 7);
        change2.open();
    }

    private void performUndo(final Change change) {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                block5: {
                    block4: {
                        iProgressMonitor.beginTask("", 11);
                        try {
                            change.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                            if (change.isValid((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)).hasFatalError()) {
                                iProgressMonitor.done();
                                Object var2_2 = null;
                                break block4;
                            }
                            change.perform((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 9));
                            break block5;
                        }
                        catch (Throwable throwable) {
                            Object var2_3 = null;
                            change.dispose();
                            throw throwable;
                        }
                    }
                    change.dispose();
                    return;
                }
                Object var2_4 = null;
                change.dispose();
            }
        };
        WorkbenchRunnableAdapter workbenchRunnableAdapter = new WorkbenchRunnableAdapter(iWorkspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.fParent);
        try {
            progressMonitorDialog.run(false, false, (IRunnableWithProgress)workbenchRunnableAdapter);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.fParent, RefactoringMessages.ChangeExceptionHandler_undo_dialog_title, String.valueOf(RefactoringMessages.ChangeExceptionHandler_undo_dialog_message) + this.fName);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static class NotCancelableProgressMonitor
    extends ProgressMonitorWrapper {
        public NotCancelableProgressMonitor(IProgressMonitor iProgressMonitor) {
            super(iProgressMonitor);
        }

        public void setCanceled(boolean bl) {
        }

        public boolean isCanceled() {
            return false;
        }
    }

    private static class RefactorErrorDialog
    extends ErrorDialog {
        public RefactorErrorDialog(Shell shell, String string, String string2, IStatus iStatus, int n) {
            super(shell, string, string2, iStatus, n);
        }

        protected void createButtonsForButtonBar(Composite composite) {
            super.createButtonsForButtonBar(composite);
            Button button = this.getButton(0);
            button.setText(RefactoringMessages.ChangeExceptionHandler_undo_button);
            Button button2 = this.createButton(composite, 1, RefactoringMessages.ChangeExceptionHandler_abort_button, true);
            button2.moveBelow((Control)button);
            button2.setFocus();
        }

        protected Control createMessageArea(Composite composite) {
            Control control = super.createMessageArea(composite);
            new Label(composite, 0);
            Label label = new Label(composite, 0);
            label.setText(RefactoringMessages.ChangeExceptionHandler_message);
            label.setLayoutData((Object)new GridData(768));
            RefactorErrorDialog.applyDialogFont((Control)control);
            return control;
        }
    }
}

