/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ExceptionInfo;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IExceptionListChangeListener;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;

public class ChangeExceptionsControl
extends Composite {
    private final IExceptionListChangeListener fListener;
    private final IJavaProject fProject;
    private TableViewer fTableViewer;
    private Button fRemoveButton;
    private List fExceptionInfos;

    public ChangeExceptionsControl(Composite composite, int n, IExceptionListChangeListener iExceptionListChangeListener, IJavaProject iJavaProject) {
        super(composite, n);
        Assert.isNotNull((Object)iExceptionListChangeListener);
        this.fListener = iExceptionListChangeListener;
        Assert.isNotNull((Object)iJavaProject);
        this.fProject = iJavaProject;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.createExceptionList(this);
        this.createButtonComposite(this);
    }

    public void setInput(List list) {
        Assert.isNotNull((Object)list);
        this.fExceptionInfos = list;
        this.fTableViewer.setInput((Object)this.fExceptionInfos);
        if (this.fExceptionInfos.size() > 0) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fExceptionInfos.get(0)));
        }
    }

    private void createExceptionList(Composite composite) {
        Table table = new Table(composite, 2818);
        table.setLayoutData((Object)new GridData(1808));
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ExceptionInfoContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ExceptionInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ChangeExceptionsControl.this.updateButtonsEnabledState();
            }
        });
    }

    private ExceptionInfo[] getSelectedItems() {
        ISelection iSelection = this.fTableViewer.getSelection();
        if (iSelection == null) {
            return new ExceptionInfo[0];
        }
        if (!(iSelection instanceof IStructuredSelection)) {
            return new ExceptionInfo[0];
        }
        List list = ((IStructuredSelection)iSelection).toList();
        return list.toArray(new ExceptionInfo[list.size()]);
    }

    private void createButtonComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createAddButton(composite2);
        this.fRemoveButton = this.createRemoveButton(composite2);
        this.updateButtonsEnabledState();
    }

    private void updateButtonsEnabledState() {
        if (this.fRemoveButton != null) {
            this.fRemoveButton.setEnabled(this.getTableSelectionCount() != 0);
        }
    }

    private int getTableSelectionCount() {
        return this.getTable().getSelectionCount();
    }

    private int getTableItemCount() {
        return this.getTable().getItemCount();
    }

    private Table getTable() {
        return this.fTableViewer.getTable();
    }

    private Button createAddButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(RefactoringMessages.ChangeExceptionsControl_buttons_add);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeExceptionsControl.this.doAddException();
            }
        });
        return button;
    }

    private void doAddException() {
        IType iType = this.chooseException();
        if (iType == null) {
            return;
        }
        ExceptionInfo exceptionInfo = this.findExceptionInfo(iType);
        if (exceptionInfo != null) {
            if (exceptionInfo.isDeleted()) {
                exceptionInfo.markAsOld();
                this.fTableViewer.refresh();
            }
            this.fListener.exceptionListChanged();
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)exceptionInfo), true);
            return;
        }
        exceptionInfo = ExceptionInfo.createInfoForAddedException(iType);
        this.fExceptionInfos.add(exceptionInfo);
        this.fListener.exceptionListChanged();
        this.fTableViewer.refresh();
        this.fTableViewer.getControl().setFocus();
        int n = this.getTableItemCount() - 1;
        this.getTable().setSelection(n);
        this.updateButtonsEnabledState();
    }

    private IType chooseException() {
        IJavaElement[] iJavaElementArray = new IJavaElement[]{this.fProject.getJavaProject()};
        IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])iJavaElementArray);
        FilteredTypesSelectionDialog filteredTypesSelectionDialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), iJavaSearchScope, 5);
        filteredTypesSelectionDialog.setTitle(RefactoringMessages.ChangeExceptionsControl_choose_title);
        filteredTypesSelectionDialog.setMessage(RefactoringMessages.ChangeExceptionsControl_choose_message);
        filteredTypesSelectionDialog.setInitialPattern("*Exception*");
        filteredTypesSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new StatusInfo(4, "");
                }
                try {
                    return ChangeExceptionsControl.this.checkException((IType)objectArray[0]);
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                    return StatusInfo.OK_STATUS;
                }
            }
        });
        if (filteredTypesSelectionDialog.open() == 0) {
            return (IType)filteredTypesSelectionDialog.getFirstResult();
        }
        return null;
    }

    private IStatus checkException(IType iType) throws JavaModelException {
        ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType iType2 = iType;
        while (iType2 != null) {
            String string = iType2.getFullyQualifiedName();
            if ("java.lang.Throwable".equals(string)) {
                return StatusInfo.OK_STATUS;
            }
            iType2 = iTypeHierarchy.getSuperclass(iType2);
        }
        return JavaUIStatus.createError(4, RefactoringMessages.ChangeExceptionsControl_not_exception, null);
    }

    private ExceptionInfo findExceptionInfo(IType iType) {
        Iterator iterator = this.fExceptionInfos.iterator();
        while (iterator.hasNext()) {
            ExceptionInfo exceptionInfo = (ExceptionInfo)iterator.next();
            if (!exceptionInfo.getType().equals(iType)) continue;
            return exceptionInfo;
        }
        return null;
    }

    private Button createRemoveButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(RefactoringMessages.ChangeExceptionsControl_buttons_remove);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ChangeExceptionsControl.this.getTable().getSelectionIndices()[0];
                ExceptionInfo[] exceptionInfoArray = ChangeExceptionsControl.this.getSelectedItems();
                int n2 = 0;
                while (n2 < exceptionInfoArray.length) {
                    if (exceptionInfoArray[n2].isAdded()) {
                        ChangeExceptionsControl.this.fExceptionInfos.remove(exceptionInfoArray[n2]);
                    } else {
                        exceptionInfoArray[n2].markAsDeleted();
                    }
                    ++n2;
                }
                this.restoreSelection(n);
            }

            private void restoreSelection(int n) {
                ChangeExceptionsControl.this.fTableViewer.refresh();
                ChangeExceptionsControl.this.fTableViewer.getControl().setFocus();
                int n2 = ChangeExceptionsControl.this.getTableItemCount();
                if (n2 != 0) {
                    if (n >= n2) {
                        n = n2 - 1;
                    }
                    ChangeExceptionsControl.this.getTable().setSelection(n);
                }
                ChangeExceptionsControl.this.fListener.exceptionListChanged();
                ChangeExceptionsControl.this.updateButtonsEnabledState();
            }
        });
        return button;
    }

    private static class ExceptionInfoContentProvider
    implements IStructuredContentProvider {
        private ExceptionInfoContentProvider() {
        }

        public Object[] getElements(Object object) {
            return this.removeMarkedAsDeleted((List)object);
        }

        private ExceptionInfo[] removeMarkedAsDeleted(List list) {
            ArrayList<ExceptionInfo> arrayList = new ArrayList<ExceptionInfo>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExceptionInfo exceptionInfo = (ExceptionInfo)iterator.next();
                if (exceptionInfo.isDeleted()) continue;
                arrayList.add(exceptionInfo);
            }
            return arrayList.toArray(new ExceptionInfo[arrayList.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class ExceptionInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image fInterfaceImage = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.class_obj.gif");

        public Image getColumnImage(Object object, int n) {
            return this.fInterfaceImage;
        }

        public String getColumnText(Object object, int n) {
            ExceptionInfo exceptionInfo = (ExceptionInfo)object;
            return exceptionInfo.getType().getFullyQualifiedName();
        }
    }
}

