/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.VariableNamesProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.RowLayouter;

public class ExtractTempWizard
extends RefactoringWizard {
    static final String DIALOG_SETTING_SECTION = "ExtractTempWizard";

    public ExtractTempWizard(ExtractTempRefactoring extractTempRefactoring) {
        super((Refactoring)extractTempRefactoring, 36);
        this.setDefaultPageTitle(RefactoringMessages.ExtractTempWizard_defaultPageTitle);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ExtractTempInputPage(this.getExtractTempRefactoring().guessTempNames()));
    }

    private ExtractTempRefactoring getExtractTempRefactoring() {
        return (ExtractTempRefactoring)this.getRefactoring();
    }

    private static class ExtractTempInputPage
    extends TextInputWizardPage {
        private static final String DECLARE_FINAL = "declareFinal";
        private static final String REPLACE_ALL = "replaceOccurrences";
        private final boolean fInitialValid;
        private static final String DESCRIPTION = RefactoringMessages.ExtractTempInputPage_enter_name;
        private String[] fTempNameProposals;
        private IDialogSettings fSettings;

        public ExtractTempInputPage(String[] stringArray) {
            super(DESCRIPTION, true, stringArray.length == 0 ? "" : stringArray[0]);
            Assert.isNotNull((Object)stringArray);
            this.fTempNameProposals = stringArray;
            this.fInitialValid = stringArray.length > 0;
        }

        public void createControl(Composite composite) {
            this.loadSettings();
            Composite composite2 = new Composite(composite, 0);
            this.setControl((Control)composite2);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.verticalSpacing = 8;
            composite2.setLayout((Layout)gridLayout);
            RowLayouter rowLayouter = new RowLayouter(2);
            Label label = new Label(composite2, 0);
            label.setText(RefactoringMessages.ExtractTempInputPage_variable_name);
            Text text = this.createTextInputField(composite2);
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            ControlContentAssistHelper.createTextContentAssistant(text, new VariableNamesProcessor(this.fTempNameProposals));
            rowLayouter.perform((Control)label, (Control)text, 1);
            this.addReplaceAllCheckbox(composite2, rowLayouter);
            this.addDeclareFinalCheckbox(composite2, rowLayouter);
            this.validateTextField(text.getText());
            Dialog.applyDialogFont((Control)composite2);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.extract_temp_page_context");
        }

        private void loadSettings() {
            this.fSettings = this.getDialogSettings().getSection(ExtractTempWizard.DIALOG_SETTING_SECTION);
            if (this.fSettings == null) {
                this.fSettings = this.getDialogSettings().addNewSection(ExtractTempWizard.DIALOG_SETTING_SECTION);
                this.fSettings.put(DECLARE_FINAL, false);
                this.fSettings.put(REPLACE_ALL, true);
            }
            this.getExtractTempRefactoring().setDeclareFinal(this.fSettings.getBoolean(DECLARE_FINAL));
            this.getExtractTempRefactoring().setReplaceAllOccurrences(this.fSettings.getBoolean(REPLACE_ALL));
        }

        private void addReplaceAllCheckbox(Composite composite, RowLayouter rowLayouter) {
            String string = RefactoringMessages.ExtractTempInputPage_replace_all;
            boolean bl = this.getExtractTempRefactoring().replaceAllOccurrences();
            Button button = ExtractTempInputPage.createCheckbox(composite, string, bl, rowLayouter);
            this.getExtractTempRefactoring().setReplaceAllOccurrences(button.getSelection());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this, button){
                final /* synthetic */ ExtractTempInputPage this$1;
                private final /* synthetic */ Button val$checkBox;
                {
                    this.this$1 = extractTempInputPage;
                    this.val$checkBox = button;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ExtractTempInputPage.access$0(this.this$1).put("replaceOccurrences", this.val$checkBox.getSelection());
                    ExtractTempInputPage.access$1(this.this$1).setReplaceAllOccurrences(this.val$checkBox.getSelection());
                }
            });
        }

        private void addDeclareFinalCheckbox(Composite composite, RowLayouter rowLayouter) {
            String string = RefactoringMessages.ExtractTempInputPage_declare_final;
            boolean bl = this.getExtractTempRefactoring().declareFinal();
            Button button = ExtractTempInputPage.createCheckbox(composite, string, bl, rowLayouter);
            this.getExtractTempRefactoring().setDeclareFinal(button.getSelection());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this, button){
                final /* synthetic */ ExtractTempInputPage this$1;
                private final /* synthetic */ Button val$checkBox;
                {
                    this.this$1 = extractTempInputPage;
                    this.val$checkBox = button;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ExtractTempInputPage.access$0(this.this$1).put("declareFinal", this.val$checkBox.getSelection());
                    ExtractTempInputPage.access$1(this.this$1).setDeclareFinal(this.val$checkBox.getSelection());
                }
            });
        }

        protected void textModified(String string) {
            this.getExtractTempRefactoring().setTempName(string);
            super.textModified(string);
        }

        protected RefactoringStatus validateTextField(String string) {
            return this.getExtractTempRefactoring().checkTempName(string);
        }

        private ExtractTempRefactoring getExtractTempRefactoring() {
            return (ExtractTempRefactoring)this.getRefactoring();
        }

        private static Button createCheckbox(Composite composite, String string, boolean bl, RowLayouter rowLayouter) {
            Button button = new Button(composite, 32);
            button.setText(string);
            button.setSelection(bl);
            rowLayouter.perform((Control)button);
            return button;
        }

        protected boolean isInitialInputValid() {
            return this.fInitialValid;
        }

        static /* synthetic */ IDialogSettings access$0(ExtractTempInputPage extractTempInputPage) {
            return extractTempInputPage.fSettings;
        }

        static /* synthetic */ ExtractTempRefactoring access$1(ExtractTempInputPage extractTempInputPage) {
            return extractTempInputPage.getExtractTempRefactoring();
        }
    }
}

