/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MultiStateCellEditor
extends CellEditor {
    private int fValue;
    private final int fStateCount;

    public MultiStateCellEditor(Composite composite, int n, int n2) {
        super(composite);
        Assert.isTrue((n > 1 ? 1 : 0) != 0, (String)"incorrect state count");
        this.fStateCount = n;
        Assert.isTrue((n2 >= 0 && n2 < n ? 1 : 0) != 0, (String)"incorrect initial value");
        this.fValue = n2;
        this.setValueValid(true);
    }

    public void activate() {
        this.fValue = MultiStateCellEditor.getNextValue(this.fStateCount, this.fValue);
        this.fireApplyEditorValue();
    }

    public static int getNextValue(int n, int n2) {
        Assert.isTrue((n > 1 ? 1 : 0) != 0, (String)"incorrect state count");
        Assert.isTrue((n2 >= 0 && n2 < n ? 1 : 0) != 0, (String)"incorrect initial value");
        return (n2 + 1) % n;
    }

    protected Control createControl(Composite composite) {
        return null;
    }

    protected Object doGetValue() {
        return new Integer(this.fValue);
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object object) {
        Assert.isTrue((boolean)(object instanceof Integer), (String)"value must be Integer");
        this.fValue = (Integer)object;
        Assert.isTrue((this.fValue >= 0 && this.fValue < this.fStateCount ? 1 : 0) != 0, (String)"invalid value");
    }
}

