/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameInformationPopup;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedNamesAssistProposal;
import org.eclipse.wst.jsdt.ui.refactoring.RenameSupport;

public class RenameLinkedMode {
    private static RenameLinkedMode fgActiveLinkedMode;
    private final CompilationUnitEditor fEditor;
    private final IJavaElement fJavaElement;
    private RenameInformationPopup fInfoPopup;
    private boolean fOriginalSaved;
    private Point fOriginalSelection;
    private String fOriginalName;
    private LinkedPosition fNamePosition;
    private LinkedModeModel fLinkedModeModel;
    private LinkedPositionGroup fLinkedPositionGroup;
    private final FocusEditingSupport fFocusEditingSupport;
    private boolean fShowPreview;

    public RenameLinkedMode(IJavaElement iJavaElement, CompilationUnitEditor compilationUnitEditor) {
        Assert.isNotNull((Object)iJavaElement);
        Assert.isNotNull((Object)compilationUnitEditor);
        this.fEditor = compilationUnitEditor;
        this.fJavaElement = iJavaElement;
        this.fFocusEditingSupport = new FocusEditingSupport();
    }

    public static RenameLinkedMode getActiveLinkedMode() {
        if (fgActiveLinkedMode != null) {
            StyledText styledText;
            ISourceViewer iSourceViewer = RenameLinkedMode.fgActiveLinkedMode.fEditor.getViewer();
            if (iSourceViewer != null && (styledText = iSourceViewer.getTextWidget()) != null && !styledText.isDisposed()) {
                return fgActiveLinkedMode;
            }
            fgActiveLinkedMode = null;
        }
        return null;
    }

    public void start() {
        if (RenameLinkedMode.getActiveLinkedMode() != null) {
            fgActiveLinkedMode.startFullDialog();
            return;
        }
        this.fOriginalSaved = !this.fEditor.isDirty();
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        this.fOriginalSelection = iSourceViewer.getSelectedRange();
        int n = this.fOriginalSelection.x;
        try {
            SimpleName simpleName;
            CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.getCompilationUnit(), ASTProvider.WAIT_YES, null);
            this.fLinkedPositionGroup = new LinkedPositionGroup();
            ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, this.fOriginalSelection.x, this.fOriginalSelection.y);
            if (!(aSTNode instanceof SimpleName)) {
                return;
            }
            SimpleName simpleName2 = (SimpleName)aSTNode;
            this.fOriginalName = simpleName2.getIdentifier();
            final int n2 = simpleName2.getStartPosition();
            SimpleName[] simpleNameArray = LinkedNodeFinder.findByNode((ASTNode)compilationUnit, simpleName2);
            Arrays.sort(simpleNameArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return this.rank((ASTNode)object) - this.rank((ASTNode)object2);
                }

                private int rank(ASTNode aSTNode) {
                    int n = aSTNode.getStartPosition() + aSTNode.getLength() - n2;
                    if (n < 0) {
                        return Integer.MAX_VALUE + n;
                    }
                    return n;
                }
            });
            int n3 = 0;
            while (n3 < simpleNameArray.length) {
                simpleName = simpleNameArray[n3];
                LinkedPosition linkedPosition = new LinkedPosition(iDocument, simpleName.getStartPosition(), simpleName.getLength(), n3);
                if (n3 == 0) {
                    this.fNamePosition = linkedPosition;
                }
                this.fLinkedPositionGroup.addPosition(linkedPosition);
                ++n3;
            }
            this.fLinkedModeModel = new LinkedModeModel();
            this.fLinkedModeModel.addGroup(this.fLinkedPositionGroup);
            this.fLinkedModeModel.forceInstall();
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(this.fEditor));
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorSynchronizer());
            EditorLinkedModeUI editorLinkedModeUI = new EditorLinkedModeUI(this.fLinkedModeModel, (ITextViewer)iSourceViewer);
            editorLinkedModeUI.setExitPosition((ITextViewer)iSourceViewer, n, 0, Integer.MAX_VALUE);
            editorLinkedModeUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(iDocument));
            editorLinkedModeUI.enter();
            iSourceViewer.setSelectedRange(this.fOriginalSelection.x, this.fOriginalSelection.y);
            if (iSourceViewer instanceof IEditingSupportRegistry) {
                simpleName = (IEditingSupportRegistry)iSourceViewer;
                simpleName.register((IEditingSupport)this.fFocusEditingSupport);
            }
            this.openSecondaryPopup();
            fgActiveLinkedMode = this;
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doRename(boolean bl) {
        Image image;
        block23: {
            this.cancel();
            image = null;
            Label label = null;
            this.fShowPreview |= bl;
            try {
                try {
                    boolean bl2;
                    Composite composite;
                    Object object;
                    block26: {
                        block25: {
                            Object object2;
                            block24: {
                                ISourceViewer iSourceViewer = this.fEditor.getViewer();
                                if (iSourceViewer instanceof SourceViewer && (object = (object2 = (SourceViewer)iSourceViewer).getControl()) instanceof Composite) {
                                    Point point;
                                    composite = (Composite)object;
                                    Display display = composite.getDisplay();
                                    while (!display.isDisposed() && display.readAndDispatch()) {
                                    }
                                    GC gC = new GC((Drawable)composite);
                                    try {
                                        point = composite.getSize();
                                        image = new Image(gC.getDevice(), point.x, point.y);
                                        gC.copyArea(image, 0, 0);
                                        Object var11_17 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_16 = null;
                                        gC.dispose();
                                        gC = null;
                                        throw throwable;
                                    }
                                    gC.dispose();
                                    gC = null;
                                    label = new Label(composite, 0);
                                    label.setImage(image);
                                    label.setBounds(0, 0, point.x, point.y);
                                    label.moveAbove(null);
                                }
                                if (!this.fOriginalName.equals(object2 = this.fNamePosition.getContent())) break block24;
                                break block25;
                            }
                            object = this.undoAndCreateRenameSupport((String)object2);
                            if (object != null) break block26;
                        }
                        Object var13_18 = null;
                        if (label != null) {
                            label.dispose();
                        }
                        if (image == null) return;
                        image.dispose();
                        return;
                    }
                    composite = this.fEditor.getSite().getShell();
                    if (this.fShowPreview) {
                        bl2 = ((RenameSupport)object).openDialog((Shell)composite, true);
                    } else {
                        ((RenameSupport)object).perform((Shell)composite, (IRunnableContext)this.fEditor.getSite().getWorkbenchWindow());
                        bl2 = true;
                    }
                    if (bl2) {
                        this.restoreFullSelection();
                    }
                    JavaModelUtil.reconcile(this.getCompilationUnit());
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    JavaPlugin.log(invocationTargetException);
                }
                catch (BadLocationException badLocationException) {
                    JavaPlugin.log(badLocationException);
                }
                Object var13_20 = null;
                if (label == null) break block23;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                if (label != null) {
                    label.dispose();
                }
                if (image == null) throw throwable;
                image.dispose();
                throw throwable;
            }
            label.dispose();
        }
        if (image == null) return;
        image.dispose();
    }

    public void cancel() {
        if (this.fLinkedModeModel != null) {
            this.fLinkedModeModel.exit(0);
        }
        this.linkedModeLeft();
    }

    private void restoreFullSelection() {
        if (this.fOriginalSelection.y != 0) {
            int n = this.fOriginalSelection.x;
            LinkedPosition[] linkedPositionArray = this.fLinkedPositionGroup.getPositions();
            int n2 = 0;
            while (n2 < linkedPositionArray.length) {
                LinkedPosition linkedPosition = linkedPositionArray[n2];
                if (!linkedPosition.isDeleted() && linkedPosition.includes(n)) {
                    this.fEditor.getViewer().setSelectedRange(linkedPosition.offset, linkedPosition.length);
                    return;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RenameSupport undoAndCreateRenameSupport(String string) throws CoreException {
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        final IDocument iDocument = iSourceViewer.getDocument();
        try {
            try {
                if (!this.fOriginalName.equals(string)) {
                    this.fEditor.getSite().getWorkbenchWindow().run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            LinkedPosition[] linkedPositionArray = RenameLinkedMode.this.fLinkedPositionGroup.getPositions();
                            Arrays.sort(linkedPositionArray, new Comparator(this){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public int compare(Object object, Object object2) {
                                    return ((LinkedPosition)object).offset - ((LinkedPosition)object2).offset;
                                }
                            });
                            int n = 0;
                            int n2 = RenameLinkedMode.this.fOriginalName.length();
                            int n3 = 0;
                            while (n3 < linkedPositionArray.length) {
                                LinkedPosition linkedPosition = linkedPositionArray[n3];
                                try {
                                    int n4 = linkedPosition.getLength();
                                    iDocument.replace(linkedPosition.getOffset() + n, n4, RenameLinkedMode.this.fOriginalName);
                                    n = n - n4 + n2;
                                }
                                catch (BadLocationException badLocationException) {
                                    throw new InvocationTargetException(badLocationException);
                                }
                                ++n3;
                            }
                            if (RenameLinkedMode.this.fOriginalSaved) {
                                RenameLinkedMode.this.fEditor.doSave(iProgressMonitor);
                            }
                        }
                    });
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), ReorgMessages.RenameLinkedMode_error_saving_editor, (Throwable)invocationTargetException));
            }
            catch (InterruptedException interruptedException) {
                Object var5_6 = null;
                JavaModelUtil.reconcile(this.getCompilationUnit());
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            JavaModelUtil.reconcile(this.getCompilationUnit());
            throw throwable;
        }
        {
            RenameSupport renameSupport = null;
        }
        JavaModelUtil.reconcile(this.getCompilationUnit());
        iSourceViewer.setSelectedRange(this.fOriginalSelection.x, this.fOriginalSelection.y);
        RenameJavaElementDescriptor renameJavaElementDescriptor = this.createRenameDescriptor(this.fJavaElement, string);
        return RenameSupport.create(renameJavaElementDescriptor);
    }

    private ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
    }

    public void startFullDialog() {
        this.cancel();
        try {
            String string = this.fNamePosition.getContent();
            RenameSupport renameSupport = this.undoAndCreateRenameSupport(string);
            if (renameSupport != null) {
                renameSupport.openDialog(this.fEditor.getSite().getShell());
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private RenameJavaElementDescriptor createRenameDescriptor(IJavaElement iJavaElement, String string) throws JavaModelException {
        IDialogSettings iDialogSettings;
        IField iField;
        IMethod iMethod;
        String string2;
        int n = iJavaElement.getElementType();
        switch (n) {
            case 2: {
                string2 = "org.eclipse.wst.jsdt.ui.rename.java.project";
                break;
            }
            case 3: {
                string2 = "org.eclipse.wst.jsdt.ui.rename.source.folder";
                break;
            }
            case 4: {
                string2 = "org.eclipse.wst.jsdt.ui.rename.package";
                break;
            }
            case 5: {
                string2 = "org.eclipse.wst.jsdt.ui.rename.compilationunit";
                break;
            }
            case 7: {
                string2 = "org.eclipse.wst.jsdt.ui.rename.type";
                break;
            }
            case 9: {
                iMethod = (IMethod)iJavaElement;
                if (iMethod.isConstructor()) {
                    return this.createRenameDescriptor((IJavaElement)iMethod.getDeclaringType(), string);
                }
                string2 = "org.eclipse.wst.jsdt.ui.rename.method";
                break;
            }
            case 8: {
                iField = (IField)iJavaElement;
                if (iField.isEnumConstant()) {
                    string2 = "org.eclipse.wst.jsdt.ui.rename.enum.constant";
                    break;
                }
                string2 = "org.eclipse.wst.jsdt.ui.rename.field";
                break;
            }
            case 15: {
                string2 = "org.eclipse.wst.jsdt.ui.rename.type.parameter";
                break;
            }
            case 14: {
                string2 = "org.eclipse.wst.jsdt.ui.rename.local.variable";
                break;
            }
            default: {
                return null;
            }
        }
        iMethod = (RenameJavaElementDescriptor)RefactoringCore.getRefactoringContribution((String)string2).createDescriptor();
        iMethod.setJavaElement(iJavaElement);
        iMethod.setNewName(string);
        if (n != 3) {
            iMethod.setUpdateReferences(true);
        }
        if ((iDialogSettings = (iField = JavaPlugin.getDefault().getDialogSettings()).getSection("org.eclipse.ltk.ui.refactoring.settings")) == null) {
            iDialogSettings = iField.addNewSection("org.eclipse.ltk.ui.refactoring.settings");
        }
        switch (n) {
            case 8: 
            case 9: {
                iMethod.setDeprecateDelegate(iDialogSettings.getBoolean("delegateDeprecation"));
                iMethod.setKeepOriginal(iDialogSettings.getBoolean("delegateUpdating"));
            }
        }
        switch (n) {
            case 7: {
                int n2;
                iMethod.setUpdateSimilarDeclarations(iDialogSettings.getBoolean("updateSimilarElements"));
                try {
                    n2 = iDialogSettings.getInt("updateSimilarElementsMatchStrategy");
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 1;
                }
                iMethod.setMatchStrategy(n2);
            }
        }
        switch (n) {
            case 4: {
                iMethod.setUpdateHierarchy(iDialogSettings.getBoolean("renameSubpackages"));
            }
        }
        switch (n) {
            case 4: 
            case 7: {
                String string3 = iDialogSettings.get("patterns");
                if (string3 == null || string3.length() == 0) break;
                iMethod.setFileNamePatterns(string3);
                boolean bl = iDialogSettings.getBoolean("updateQualifiedNames");
                iMethod.setUpdateQualifiedNames(bl);
                this.fShowPreview |= bl;
            }
        }
        switch (n) {
            case 4: 
            case 7: 
            case 8: {
                boolean bl = iDialogSettings.getBoolean("updateTextualMatches");
                iMethod.setUpdateTextualOccurrences(bl);
                this.fShowPreview |= bl;
            }
        }
        switch (n) {
            case 8: {
                iMethod.setRenameGetters(iDialogSettings.getBoolean("renameGetter"));
                iMethod.setRenameSetters(iDialogSettings.getBoolean("renameSetter"));
            }
        }
        return iMethod;
    }

    private void linkedModeLeft() {
        ISourceViewer iSourceViewer;
        fgActiveLinkedMode = null;
        if (this.fInfoPopup != null) {
            this.fInfoPopup.close();
        }
        if ((iSourceViewer = this.fEditor.getViewer()) instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry iEditingSupportRegistry = (IEditingSupportRegistry)iSourceViewer;
            iEditingSupportRegistry.unregister((IEditingSupport)this.fFocusEditingSupport);
        }
    }

    private void openSecondaryPopup() {
        this.fInfoPopup = new RenameInformationPopup(this.fEditor, this);
        this.fInfoPopup.open();
    }

    public boolean isCaretInLinkedPosition() {
        return this.getCurrentLinkedPosition() != null;
    }

    public LinkedPosition getCurrentLinkedPosition() {
        Point point = this.fEditor.getViewer().getSelectedRange();
        int n = point.x;
        int n2 = n + point.y;
        LinkedPosition[] linkedPositionArray = this.fLinkedPositionGroup.getPositions();
        int n3 = 0;
        while (n3 < linkedPositionArray.length) {
            LinkedPosition linkedPosition = linkedPositionArray[n3];
            if (linkedPosition.includes(n) && linkedPosition.includes(n2)) {
                return linkedPosition;
            }
            ++n3;
        }
        return null;
    }

    public boolean isEnabled() {
        String string;
        block3: {
            try {
                string = this.fNamePosition.getContent();
                if (!this.fOriginalName.equals(string)) break block3;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        IJavaProject iJavaProject = this.fJavaElement.getJavaProject();
        String string2 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String string3 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        return JavaConventions.validateIdentifier((String)string, (String)string2, (String)string3).isOK();
    }

    public boolean isOriginalName() {
        try {
            String string = this.fNamePosition.getContent();
            return this.fOriginalName.equals(string);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private class EditorSynchronizer
    implements ILinkedModeListener {
        private EditorSynchronizer() {
        }

        public void left(LinkedModeModel linkedModeModel, int n) {
            RenameLinkedMode.this.linkedModeLeft();
            if ((n & 2) != 0) {
                RenameLinkedMode.this.doRename(RenameLinkedMode.this.fShowPreview);
            }
        }

        public void resume(LinkedModeModel linkedModeModel, int n) {
        }

        public void suspend(LinkedModeModel linkedModeModel) {
        }
    }

    private class ExitPolicy
    extends LinkedNamesAssistProposal.DeleteBlockingExitPolicy {
        public ExitPolicy(IDocument iDocument) {
            super(iDocument);
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel linkedModeModel, VerifyEvent verifyEvent, int n, int n2) {
            RenameLinkedMode renameLinkedMode = RenameLinkedMode.this;
            renameLinkedMode.fShowPreview = renameLinkedMode.fShowPreview | (verifyEvent.stateMask & 0x40000) != 0;
            return super.doExit(linkedModeModel, verifyEvent, n, n2);
        }
    }

    private class FocusEditingSupport
    implements IEditingSupport {
        private FocusEditingSupport() {
        }

        public boolean ownsFocusShell() {
            Shell shell;
            if (RenameLinkedMode.this.fInfoPopup == null) {
                return false;
            }
            if (RenameLinkedMode.this.fInfoPopup.ownsFocusShell()) {
                return true;
            }
            Shell shell2 = RenameLinkedMode.this.fEditor.getSite().getShell();
            return shell2 == (shell = shell2.getDisplay().getActiveShell());
        }

        public boolean isOriginator(DocumentEvent documentEvent, IRegion iRegion) {
            return false;
        }
    }
}

