/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

class RenameTypeWizardSimilarElementsPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "SimilarElementSelectionPage";
    private final long LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private Label fSimilarElementsLabel;
    private SourceViewer fSourceViewer;
    private ContainerCheckedTreeViewer fTreeViewer;
    private SimilarLabelProvider fTreeViewerLabelProvider;
    private Map fSimilarElementsToNewName;
    private Button fEditElementButton;
    private boolean fWasInitialized;
    private CLabel fCurrentElementLabel;

    public RenameTypeWizardSimilarElementsPage() {
        super(PAGE_NAME);
    }

    public void createControl(Composite composite) {
        ViewForm viewForm = new ViewForm(composite, 0x800800);
        Composite composite2 = new Composite((Composite)viewForm, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.createTreeAndSourceViewer(composite2);
        this.createButtonComposite(composite2);
        viewForm.setContent((Control)composite2);
        this.setControl((Control)viewForm);
        Dialog.applyDialogFont((Control)viewForm);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.rename_type_wizard_page_context");
    }

    private void createTreeAndSourceViewer(Composite composite) {
        SashForm sashForm = new SashForm(composite, 256);
        this.initializeDialogUnits((Control)composite);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        sashForm.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        sashForm.setLayout((Layout)gridLayout);
        this.createSimilarElementTreeComposite((Composite)sashForm);
        this.createSourceViewerComposite((Composite)sashForm);
        sashForm.setWeights(new int[]{50, 50});
    }

    private void createSimilarElementTreeComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createTypeHierarchyLabel(composite2);
        this.createTreeViewer(composite2);
    }

    private void createTypeHierarchyLabel(Composite composite) {
        this.fSimilarElementsLabel = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.heightHint = JavaElementImageProvider.SMALL_SIZE.x;
        this.fSimilarElementsLabel.setLayoutData((Object)gridData);
        this.fSimilarElementsLabel.setText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_review_similar_elements);
    }

    private void createTreeViewer(Composite composite) {
        Tree tree = new Tree(composite, 2852);
        tree.setLayoutData((Object)new GridData(1808));
        this.fTreeViewer = new ContainerCheckedTreeViewer(tree);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setComparator((ViewerComparator)new SimilarElementComparator());
        this.fTreeViewer.setContentProvider((IContentProvider)new SimilarElementTreeContentProvider());
        this.fTreeViewerLabelProvider = new SimilarLabelProvider();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeViewerLabelProvider);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                RenameTypeWizardSimilarElementsPage.this.treeViewerSelectionChanged(selectionChangedEvent);
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                RenameTypeWizardSimilarElementsPage.this.editCurrentElement();
            }
        });
    }

    private void createSourceViewerComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createSourceViewerLabel(composite2);
        this.createSourceViewer(composite2);
    }

    private void createSourceViewerLabel(Composite composite) {
        this.fCurrentElementLabel = new CLabel(composite, 0);
        GridData gridData = new GridData(768);
        gridData.heightHint = JavaElementImageProvider.SMALL_SIZE.x;
        this.fCurrentElementLabel.setText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_select_element_to_view_source);
        this.fCurrentElementLabel.setLayoutData((Object)gridData);
    }

    private void createSourceViewer(Composite composite) {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.fSourceViewer = new JavaSourceViewer(composite, null, null, false, 68354, iPreferenceStore);
        this.fSourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(RenameTypeWizardSimilarElementsPage.getJavaTextTools().getColorManager(), iPreferenceStore, null, null));
        this.fSourceViewer.setEditable(false);
        this.fSourceViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fSourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
        Document document = new Document();
        RenameTypeWizardSimilarElementsPage.getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document);
        this.fSourceViewer.setDocument((IDocument)document);
    }

    private static JavaTextTools getJavaTextTools() {
        return JavaPlugin.getDefault().getJavaTextTools();
    }

    private void createButtonComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Button button = new Button(composite2, 8);
        button.setText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_restore_defaults);
        button.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RenameTypeWizardSimilarElementsPage.this.resetDataInRefAndUI();
            }
        });
        this.fEditElementButton = new Button(composite2, 8);
        this.fEditElementButton.setText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_change_name);
        this.fEditElementButton.setLayoutData((Object)new GridData());
        this.fEditElementButton.setEnabled(false);
        SWTUtil.setButtonDimensionHint(this.fEditElementButton);
        this.fEditElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RenameTypeWizardSimilarElementsPage.this.editCurrentElement();
            }
        });
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.initializeUIFromRef();
        }
        super.setVisible(bl);
        this.selectFirstElement();
    }

    private void selectFirstElement() {
        TreeItem treeItem;
        if (this.fTreeViewer.getTree().getItemCount() > 0 && (treeItem = this.fTreeViewer.getTree().getItem(0)).getData() != null) {
            this.fTreeViewer.reveal(treeItem.getData());
            Object object = this.getFirstSimilarElement(treeItem);
            if (object != null) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
            }
        }
        this.fTreeViewer.getTree().setFocus();
    }

    private Object getFirstSimilarElement(TreeItem treeItem) {
        Object object = treeItem.getData();
        if (this.isSimilarElement(object)) {
            return object;
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            Object object2 = this.getFirstSimilarElement(treeItemArray[n]);
            if (object2 != null) {
                return object2;
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeUIFromRef() {
        Map map = this.getRenameTypeProcessor().getSimilarElementsToNewNames();
        try {
            this.getShell().setRedraw(false);
            if (this.fSimilarElementsToNewName == null || map != this.fSimilarElementsToNewName) {
                this.fSimilarElementsToNewName = map;
                this.fTreeViewerLabelProvider.initialize(this.fSimilarElementsToNewName);
                this.fTreeViewer.setInput((Object)this.fSimilarElementsToNewName);
            }
            this.fTreeViewer.expandAll();
            this.restoreSelectionAndNames(this.getRenameTypeProcessor().getSimilarElementsToSelection());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getShell().setRedraw(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.getShell().setRedraw(true);
        this.fWasInitialized = true;
    }

    private void initializeRefFromUI() {
        IJavaElement[] iJavaElementArray = this.getCheckedSimilarElements();
        Map map = this.getRenameTypeProcessor().getSimilarElementsToSelection();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement iJavaElement = (IJavaElement)iterator.next();
            map.put(iJavaElement, Boolean.FALSE);
        }
        int n = 0;
        while (n < iJavaElementArray.length) {
            map.put(iJavaElementArray[n], Boolean.TRUE);
            ++n;
        }
    }

    private void resetDataInRefAndUI() {
        this.getRenameTypeProcessor().resetSelectedSimilarElements();
        this.restoreSelectionAndNames(this.getRenameTypeProcessor().getSimilarElementsToSelection());
    }

    protected void editCurrentElement() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (iStructuredSelection != null && this.isSimilarElement(iStructuredSelection.getFirstElement())) {
            String string;
            IJavaElement iJavaElement = (IJavaElement)iStructuredSelection.getFirstElement();
            String string2 = (String)this.fSimilarElementsToNewName.get(iJavaElement);
            if (string2 == null) {
                return;
            }
            EditElementDialog editElementDialog = new EditElementDialog(this.getShell(), iJavaElement, string2);
            if (editElementDialog.open() == 0 && !(string = editElementDialog.getNewName()).equals(string2)) {
                this.fSimilarElementsToNewName.put(iJavaElement, string);
                this.fTreeViewer.update((Object)iJavaElement, null);
            }
        }
    }

    private void restoreSelectionAndNames(Map map) {
        Map map2 = map;
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement iJavaElement = (IJavaElement)iterator.next();
            boolean bl = (Boolean)map2.get(iJavaElement);
            this.fTreeViewer.setChecked((Object)iJavaElement, bl);
            this.fTreeViewer.update((Object)iJavaElement, null);
        }
    }

    public IWizardPage getNextPage() {
        IWizardPage iWizardPage;
        if (this.fWasInitialized) {
            this.initializeRefFromUI();
        }
        if ((iWizardPage = super.getNextPage()) != this) {
            iWizardPage.setPreviousPage((IWizardPage)this);
        }
        return iWizardPage;
    }

    public IWizardPage getPreviousPage() {
        if (this.fWasInitialized) {
            this.initializeRefFromUI();
        }
        return super.getPreviousPage();
    }

    protected boolean performFinish() {
        this.initializeRefFromUI();
        return super.performFinish();
    }

    private boolean isSimilarElement(Object object) {
        if (!this.fWasInitialized) {
            return false;
        }
        return this.fSimilarElementsToNewName.containsKey(object);
    }

    private void treeViewerSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        try {
            IJavaElement iJavaElement = this.getFirstSelectedSourceReference(selectionChangedEvent);
            this.setSourceViewerContents(iJavaElement);
            this.fEditElementButton.setEnabled(iJavaElement != null && this.isSimilarElement(iJavaElement));
            this.fCurrentElementLabel.setText(iJavaElement != null ? JavaElementLabels.getElementLabel(iJavaElement, this.LABEL_FLAGS) : RefactoringMessages.RenameTypeWizardSimilarElementsPage_select_element_to_view_source);
            this.fCurrentElementLabel.setImage(iJavaElement != null ? this.fTreeViewerLabelProvider.getJavaImage(iJavaElement) : null);
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.RenameTypeWizard_defaultPageTitle, RefactoringMessages.RenameTypeWizard_unexpected_exception);
        }
    }

    private IJavaElement getFirstSelectedSourceReference(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IJavaElement)) {
            return null;
        }
        return (IJavaElement)object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setSourceViewerContents(IJavaElement iJavaElement) throws JavaModelException {
        String string = "";
        if (iJavaElement == null) {
            this.fSourceViewer.getDocument().set(string);
            return;
        }
        ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
        if (iCompilationUnit == null) {
            this.fSourceViewer.getDocument().set(string);
            return;
        }
        String string2 = iCompilationUnit.getSource();
        try {
            this.fSourceViewer.setRedraw(false);
            this.fSourceViewer.getDocument().set(string2 == null ? string : string2);
            ISourceRange iSourceRange = this.getNameRange(iJavaElement);
            if (iSourceRange != null) {
                this.fSourceViewer.setSelectedRange(iSourceRange.getOffset(), iSourceRange.getLength());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fSourceViewer.setRedraw(true);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.fSourceViewer.setRedraw(true);
    }

    private ISourceRange getNameRange(IJavaElement iJavaElement) throws JavaModelException {
        if (iJavaElement instanceof IMember) {
            return ((IMember)iJavaElement).getNameRange();
        }
        if (iJavaElement instanceof ILocalVariable) {
            return ((ILocalVariable)iJavaElement).getNameRange();
        }
        return null;
    }

    private IJavaElement[] getCheckedSimilarElements() {
        Object[] objectArray = this.fTreeViewer.getCheckedElements();
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (this.isSimilarElement(objectArray[n])) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    public RenameTypeProcessor getRenameTypeProcessor() {
        RefactoringProcessor refactoringProcessor = ((RenameRefactoring)this.getRefactoring()).getProcessor();
        if (refactoringProcessor instanceof RenameTypeProcessor) {
            return (RenameTypeProcessor)refactoringProcessor;
        }
        if (refactoringProcessor instanceof RenameCompilationUnitProcessor) {
            RenameCompilationUnitProcessor renameCompilationUnitProcessor = (RenameCompilationUnitProcessor)refactoringProcessor;
            return renameCompilationUnitProcessor.getRenameTypeProcessor();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static class EditElementDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fNameField;
        private IJavaElement fElementToEdit;

        public EditElementDialog(Shell shell, IJavaElement iJavaElement, String string) {
            super(shell);
            this.setTitle(RefactoringMessages.RenameTypeWizardSimilarElementsPage_change_element_name);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.fElementToEdit = iJavaElement;
            this.fNameField = new StringDialogField();
            this.fNameField.setDialogFieldListener(this);
            this.fNameField.setLabelText(RefactoringMessages.RenameTypeWizardSimilarElementsPage_enter_new_name);
            this.fNameField.setText(string);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fNameField}, true, -1, -1);
            this.fNameField.postSetFocusOnDialogField(composite.getDisplay());
            LayoutUtil.setWidthHint((Control)this.fNameField.getLabelControl(null), this.convertHorizontalDLUsToPixels(300));
            Text text = this.fNameField.getTextControl(null);
            LayoutUtil.setHorizontalGrabbing((Control)text);
            TextFieldNavigationHandler.install(text);
            Dialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (dialogField == this.fNameField) {
                this.updateStatus(this.validateSettings());
            }
        }

        private IStatus validateSettings() {
            String string = this.fNameField.getText();
            if (string.length() == 0) {
                return new StatusInfo(4, RefactoringMessages.RenameTypeWizardSimilarElementsPage_name_empty);
            }
            IStatus iStatus = JavaConventions.validateIdentifier((String)string);
            if (iStatus.matches(4)) {
                return iStatus;
            }
            if (!Checks.startsWithLowerCase(string)) {
                return new StatusInfo(2, RefactoringMessages.RenameTypeWizardSimilarElementsPage_name_should_start_lowercase);
            }
            if (this.fElementToEdit instanceof IMember && ((IMember)this.fElementToEdit).getDeclaringType() != null) {
                IField iField;
                IType iType = ((IMember)this.fElementToEdit).getDeclaringType();
                if (this.fElementToEdit instanceof IField && (iField = iType.getField(string)).exists()) {
                    return new StatusInfo(4, RefactoringMessages.RenameTypeWizardSimilarElementsPage_field_exists);
                }
                if (this.fElementToEdit instanceof IMethod && (iField = iType.getMethod(string, ((IMethod)this.fElementToEdit).getParameterTypes())).exists()) {
                    return new StatusInfo(4, RefactoringMessages.RenameTypeWizardSimilarElementsPage_method_exists);
                }
            }
            return StatusInfo.OK_STATUS;
        }

        public String getNewName() {
            return this.fNameField.getText();
        }
    }

    private static class SimilarElementComparator
    extends JavaElementComparator {
        private SimilarElementComparator() {
        }

        public int category(Object object) {
            IMember iMember;
            ISourceRange iSourceRange = null;
            if (object instanceof IMember) {
                iMember = (IMember)object;
                try {
                    iSourceRange = iMember.getNameRange();
                }
                catch (JavaModelException javaModelException) {}
            }
            if (object instanceof ILocalVariable) {
                iMember = (ILocalVariable)object;
                iSourceRange = iMember.getNameRange();
            }
            if (iSourceRange != null) {
                return 100 + iSourceRange.getOffset();
            }
            return super.category(object);
        }
    }

    private static class SimilarElementTreeContentProvider
    implements ITreeContentProvider {
        private Map fTreeElementMap;
        private Set fTopLevelElements;

        private SimilarElementTreeContentProvider() {
        }

        public Object[] getChildren(Object object) {
            Set set = (Set)this.fTreeElementMap.get(object);
            if (set != null) {
                return set.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof IMember || object instanceof ILocalVariable) {
                return ((IJavaElement)object).getParent();
            }
            if (object instanceof ICompilationUnit) {
                return null;
            }
            Assert.isTrue((boolean)false, (String)"Should not get here");
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.fTreeElementMap.containsKey(object);
        }

        public Object[] getElements(Object object) {
            Assert.isTrue((object == null || object instanceof Map ? 1 : 0) != 0);
            return this.fTopLevelElements.toArray();
        }

        public void dispose() {
            this.fTreeElementMap.clear();
            this.fTreeElementMap = null;
            this.fTopLevelElements = null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            Assert.isTrue((object2 == null || object2 instanceof Map ? 1 : 0) != 0);
            if (object2 == null) {
                return;
            }
            Map map = (Map)object2;
            IJavaElement[] iJavaElementArray = map.keySet().toArray(new IJavaElement[0]);
            this.fTreeElementMap = new HashMap();
            this.fTopLevelElements = new HashSet();
            int n = 0;
            while (n < iJavaElementArray.length) {
                IType iType = (IType)iJavaElementArray[n].getAncestor(7);
                if (iJavaElementArray[n] instanceof IMember) {
                    this.addToMap((IJavaElement)iType, iJavaElementArray[n]);
                } else {
                    IJavaElement iJavaElement = iJavaElementArray[n].getParent();
                    if (iJavaElement instanceof IMember) {
                        this.addToMap(iJavaElement, iJavaElementArray[n]);
                        this.addToMap((IJavaElement)iType, iJavaElement);
                    }
                }
                this.handleDeclaring((IJavaElement)iType);
                ++n;
            }
        }

        private void handleDeclaring(IJavaElement iJavaElement) {
            IJavaElement iJavaElement2 = iJavaElement.getParent();
            if (iJavaElement2 instanceof ICompilationUnit) {
                this.fTopLevelElements.add(iJavaElement.getParent());
                this.addToMap(iJavaElement.getParent(), iJavaElement);
            } else {
                this.addToMap(iJavaElement2, iJavaElement);
                this.handleDeclaring(iJavaElement2);
            }
        }

        private void addToMap(IJavaElement iJavaElement, IJavaElement iJavaElement2) {
            HashSet<IJavaElement> hashSet = (HashSet<IJavaElement>)this.fTreeElementMap.get(iJavaElement);
            if (hashSet == null) {
                hashSet = new HashSet<IJavaElement>();
                this.fTreeElementMap.put(iJavaElement, hashSet);
            }
            hashSet.add(iJavaElement2);
        }
    }

    private static class SimilarLabelProvider
    extends JavaElementLabelProvider {
        private Map fDescriptorImageMap = new HashMap();
        private Map fElementToNewName;

        public SimilarLabelProvider() {
            super(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);
        }

        public void initialize(Map map) {
            this.fElementToNewName = map;
        }

        public void dispose() {
            Iterator iterator = this.fDescriptorImageMap.values().iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.dispose();
            }
            super.dispose();
        }

        private Image manageImageDescriptor(ImageDescriptor imageDescriptor) {
            Image image = (Image)this.fDescriptorImageMap.get(imageDescriptor);
            if (image == null) {
                image = imageDescriptor.createImage();
                this.fDescriptorImageMap.put(imageDescriptor, image);
            }
            return image;
        }

        public Image getImage(Object object) {
            if (this.isSimilarElement(object)) {
                return this.manageImageDescriptor(JavaPluginImages.DESC_OBJS_DEFAULT_CHANGE);
            }
            return super.getImage(object);
        }

        public Image getJavaImage(Object object) {
            return super.getImage(object);
        }

        public String getText(Object object) {
            if (this.isSimilarElement(object)) {
                return Messages.format(RefactoringMessages.RenameTypeWizardSimilarElementsPage_rename_to, new String[]{super.getText(object), (String)this.fElementToNewName.get(object)});
            }
            return super.getText(object);
        }

        private boolean isSimilarElement(Object object) {
            return this.fElementToNewName.containsKey(object);
        }
    }
}

