/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResult;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.NewSearchResultCollector;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchParticipantRecord;
import org.eclipse.wst.jsdt.internal.ui.search.SearchParticipantsExtensionPoint;
import org.eclipse.wst.jsdt.internal.ui.search.SearchResultUpdater;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.IMatchPresentation;
import org.eclipse.wst.jsdt.ui.search.IQueryParticipant;
import org.eclipse.wst.jsdt.ui.search.ISearchRequestor;
import org.eclipse.wst.jsdt.ui.search.PatternQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class JavaSearchQuery
implements ISearchQuery {
    private static final String PERF_SEARCH_PARTICIPANT = "org.eclipse.wst.jsdt.ui/perf/search/participants";
    private ISearchResult fResult;
    private final QuerySpecification fPatternData;

    public JavaSearchQuery(QuerySpecification querySpecification) {
        if (querySpecification == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.fPatternData = querySpecification;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) {
        JavaSearchResult javaSearchResult = (JavaSearchResult)this.getSearchResult();
        javaSearchResult.removeAll();
        SearchEngine searchEngine = new SearchEngine();
        try {
            SearchPattern searchPattern;
            String string;
            Object object;
            int n = 1000;
            IProject[] iProjectArray = JavaSearchScopeFactory.getInstance().getProjects(this.fPatternData.getScope());
            final SearchParticipantRecord[] searchParticipantRecordArray = SearchParticipantsExtensionPoint.getInstance().getSearchParticipants(iProjectArray);
            final int[] nArray = new int[searchParticipantRecordArray.length];
            int n2 = 0;
            while (n2 < searchParticipantRecordArray.length) {
                final int n3 = n2;
                object = new ISafeRunnable(){

                    public void handleException(Throwable throwable) {
                        nArray[n3] = 0;
                        String string = SearchMessages.JavaSearchQuery_error_participant_estimate;
                        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, string, throwable));
                    }

                    public void run() throws Exception {
                        nArray[n3] = searchParticipantRecordArray[n3].getParticipant().estimateTicks(JavaSearchQuery.this.fPatternData);
                    }
                };
                SafeRunner.run((ISafeRunnable)object);
                n += nArray[n2];
                ++n2;
            }
            if (this.fPatternData instanceof ElementQuerySpecification) {
                object = ((ElementQuerySpecification)this.fPatternData).getElement();
                string = JavaElementLabels.getElementLabel((IJavaElement)object, JavaElementLabels.ALL_DEFAULT);
                if (!object.exists()) {
                    return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(SearchMessages.JavaSearchQuery_error_element_does_not_exist, string), null);
                }
                searchPattern = SearchPattern.createPattern((IJavaElement)object, (int)this.fPatternData.getLimitTo(), (int)24);
            } else {
                int n3;
                object = (PatternQuerySpecification)this.fPatternData;
                string = ((PatternQuerySpecification)object).getPattern();
                int bl = this.getMatchMode(string) | 0x10;
                if (((PatternQuerySpecification)object).isCaseSensitive()) {
                    n3 = bl | 8;
                }
                searchPattern = SearchPattern.createPattern((String)((PatternQuerySpecification)object).getPattern(), (int)((PatternQuerySpecification)object).getSearchFor(), (int)((QuerySpecification)object).getLimitTo(), (int)n3);
            }
            if (searchPattern == null) {
                return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(SearchMessages.JavaSearchQuery_error_unsupported_pattern, string), null);
            }
            iProgressMonitor.beginTask(Messages.format(SearchMessages.JavaSearchQuery_task_label, string), n);
            object = new SubProgressMonitor(iProgressMonitor, 1000);
            boolean bl = NewSearchUI.arePotentialMatchesIgnored();
            NewSearchResultCollector newSearchResultCollector = new NewSearchResultCollector(javaSearchResult, bl);
            searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.fPatternData.getScope(), (org.eclipse.wst.jsdt.core.search.SearchRequestor)newSearchResultCollector, (IProgressMonitor)object);
            int n4 = 0;
            while (n4 < searchParticipantRecordArray.length) {
                final SearchRequestor searchRequestor = new SearchRequestor(searchParticipantRecordArray[n4].getParticipant(), javaSearchResult);
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, nArray[n4]);
                final int n5 = n4++;
                ISafeRunnable iSafeRunnable = new ISafeRunnable((IProgressMonitor)subProgressMonitor){
                    private final /* synthetic */ IProgressMonitor val$participantPM;
                    {
                        this.val$participantPM = iProgressMonitor;
                    }

                    public void handleException(Throwable throwable) {
                        searchParticipantRecordArray[n5].getDescriptor().disable();
                        String string = SearchMessages.JavaSearchQuery_error_participant_search;
                        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, string, throwable));
                    }

                    public void run() throws Exception {
                        IQueryParticipant iQueryParticipant = searchParticipantRecordArray[n5].getParticipant();
                        PerformanceStats performanceStats = PerformanceStats.getStats((String)JavaSearchQuery.PERF_SEARCH_PARTICIPANT, (Object)iQueryParticipant);
                        performanceStats.startRun();
                        iQueryParticipant.search(searchRequestor, JavaSearchQuery.this.fPatternData, this.val$participantPM);
                        performanceStats.endRun();
                    }
                };
                SafeRunner.run((ISafeRunnable)iSafeRunnable);
            }
        }
        catch (CoreException coreException) {
            return coreException.getStatus();
        }
        String string = Messages.format(SearchMessages.JavaSearchQuery_status_ok_message, String.valueOf(javaSearchResult.getMatchCount()));
        return new Status(0, JavaPlugin.getPluginId(), 0, string, null);
    }

    private int getMatchMode(String string) {
        if (string.indexOf(42) != -1 || string.indexOf(63) != -1) {
            return 2;
        }
        if (SearchUtils.isCamelCasePattern(string)) {
            return 128;
        }
        return 0;
    }

    public String getLabel() {
        return SearchMessages.JavaSearchQuery_label;
    }

    public String getResultLabel(int n) {
        if (n == 1) {
            Object[] objectArray = new String[]{this.getSearchPatternDescription(), this.fPatternData.getScopeDescription()};
            switch (this.fPatternData.getLimitTo()) {
                case 1: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularImplementorsPostfix, objectArray);
                }
                case 0: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularDeclarationsPostfix, objectArray);
                }
                case 2: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularReferencesPostfix, objectArray);
                }
                case 3: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularOccurrencesPostfix, objectArray);
                }
                case 4: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularReadReferencesPostfix, objectArray);
                }
                case 5: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularWriteReferencesPostfix, objectArray);
                }
            }
            return Messages.format(SearchMessages.JavaSearchOperation_singularOccurrencesPostfix, objectArray);
        }
        Object[] objectArray = new Object[]{this.getSearchPatternDescription(), new Integer(n), this.fPatternData.getScopeDescription()};
        switch (this.fPatternData.getLimitTo()) {
            case 1: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralImplementorsPostfix, objectArray);
            }
            case 0: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralDeclarationsPostfix, objectArray);
            }
            case 2: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralReferencesPostfix, objectArray);
            }
            case 3: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralOccurrencesPostfix, objectArray);
            }
            case 4: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralReadReferencesPostfix, objectArray);
            }
            case 5: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralWriteReferencesPostfix, objectArray);
            }
        }
        return Messages.format(SearchMessages.JavaSearchOperation_pluralOccurrencesPostfix, objectArray);
    }

    private String getSearchPatternDescription() {
        if (this.fPatternData instanceof ElementQuerySpecification) {
            IJavaElement iJavaElement = ((ElementQuerySpecification)this.fPatternData).getElement();
            return JavaElementLabels.getElementLabel(iJavaElement, JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_FULLY_QUALIFIED | 0x1000000000000L);
        }
        return ((PatternQuerySpecification)this.fPatternData).getPattern();
    }

    ImageDescriptor getImageDescriptor() {
        if (this.fPatternData.getLimitTo() == 1 || this.fPatternData.getLimitTo() == 0) {
            return JavaPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            JavaSearchResult javaSearchResult = new JavaSearchResult(this);
            new SearchResultUpdater(javaSearchResult);
            this.fResult = javaSearchResult;
        }
        return this.fResult;
    }

    QuerySpecification getSpecification() {
        return this.fPatternData;
    }

    private static class SearchRequestor
    implements ISearchRequestor {
        private IQueryParticipant fParticipant;
        private JavaSearchResult fSearchResult;

        public void reportMatch(Match match) {
            IMatchPresentation iMatchPresentation = this.fParticipant.getUIParticipant();
            if (iMatchPresentation == null || match.getElement() instanceof IJavaElement || match.getElement() instanceof IResource) {
                this.fSearchResult.addMatch(match);
            } else {
                this.fSearchResult.addMatch(match, iMatchPresentation);
            }
        }

        protected SearchRequestor(IQueryParticipant iQueryParticipant, JavaSearchResult javaSearchResult) {
            this.fParticipant = iQueryParticipant;
            this.fSearchResult = javaSearchResult;
        }
    }
}

