/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.WorkingSetComparator;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class JavaSearchScopeFactory {
    public static final int JRE = 4;
    public static final int LIBS = 2;
    public static final int PROJECTS = 8;
    public static final int SOURCES = 1;
    public static final int ALL = 15;
    public static final int NO_PROJ = 7;
    public static final int NO_JRE = 11;
    public static final int NO_JRE_NO_PROJ = 11;
    private static JavaSearchScopeFactory fgInstance;
    private final IJavaSearchScope EMPTY_SCOPE = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private JavaSearchScopeFactory() {
    }

    public static JavaSearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new JavaSearchScopeFactory();
        }
        return fgInstance;
    }

    public IWorkingSet[] queryWorkingSets() throws JavaModelException, InterruptedException {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog iWorkingSetSelectionDialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (iWorkingSetSelectionDialog.open() != 0) {
            throw new InterruptedException();
        }
        IWorkingSet[] iWorkingSetArray = iWorkingSetSelectionDialog.getSelection();
        if (iWorkingSetArray.length > 0) {
            return iWorkingSetArray;
        }
        return null;
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet[] iWorkingSetArray, boolean bl) {
        return this.createJavaSearchScope(iWorkingSetArray, bl ? 15 : 11);
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet[] iWorkingSetArray, int n) {
        if (iWorkingSetArray == null || iWorkingSetArray.length < 1) {
            return this.EMPTY_SCOPE;
        }
        HashSet hashSet = new HashSet(iWorkingSetArray.length * 10);
        int n2 = 0;
        while (n2 < iWorkingSetArray.length) {
            IWorkingSet iWorkingSet = iWorkingSetArray[n2];
            if (iWorkingSet.isEmpty() && iWorkingSet.isAggregateWorkingSet()) {
                return this.createWorkspaceScope(n);
            }
            this.addJavaElements(hashSet, iWorkingSet);
            ++n2;
        }
        return this.createJavaSearchScope(hashSet, n);
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet iWorkingSet, boolean bl) {
        return this.createJavaSearchScope(iWorkingSet, bl ? 7 : 11);
    }

    public IJavaSearchScope createJavaSearchScope(IWorkingSet iWorkingSet, int n) {
        HashSet hashSet = new HashSet(10);
        if (iWorkingSet.isEmpty() && iWorkingSet.isAggregateWorkingSet()) {
            return this.createWorkspaceScope(n);
        }
        this.addJavaElements(hashSet, iWorkingSet);
        return this.createJavaSearchScope(hashSet, n);
    }

    public IJavaSearchScope createJavaSearchScope(IResource[] iResourceArray, boolean bl) {
        return this.createJavaSearchScope(iResourceArray, bl ? 7 : 11);
    }

    public IJavaSearchScope createJavaSearchScope(IResource[] iResourceArray, int n) {
        if (iResourceArray == null) {
            return this.EMPTY_SCOPE;
        }
        HashSet hashSet = new HashSet(iResourceArray.length);
        this.addJavaElements(hashSet, iResourceArray);
        return this.createJavaSearchScope(hashSet, n);
    }

    public IJavaSearchScope createJavaSearchScope(ISelection iSelection, boolean bl) {
        return this.createJavaSearchScope(iSelection, bl ? 7 : 11);
    }

    public IJavaSearchScope createJavaSearchScope(ISelection iSelection, int n) {
        return this.createJavaSearchScope(this.getJavaElements(iSelection), n);
    }

    public IJavaSearchScope createJavaProjectSearchScope(String[] stringArray, boolean bl) {
        return this.createJavaProjectSearchScope(stringArray, bl ? 7 : 11);
    }

    public IJavaSearchScope createJavaProjectSearchScope(String[] stringArray, int n) {
        ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n2 = 0;
        while (n2 < stringArray.length) {
            IJavaProject iJavaProject = JavaCore.create((IProject)iWorkspaceRoot.getProject(stringArray[n2]));
            if (iJavaProject.exists()) {
                arrayList.add(iJavaProject);
            }
            ++n2;
        }
        return this.createJavaSearchScope(arrayList, n);
    }

    public IJavaSearchScope createJavaProjectSearchScope(IJavaProject iJavaProject, boolean bl) {
        return this.createJavaProjectSearchScope(iJavaProject, bl ? 7 : 11);
    }

    public IJavaSearchScope createJavaProjectSearchScope(IJavaProject iJavaProject, int n) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iJavaProject}, (int)JavaSearchScopeFactory.getSearchFlags(n));
    }

    public IJavaSearchScope createJavaProjectSearchScope(IEditorInput iEditorInput, boolean bl) {
        return this.createJavaProjectSearchScope(iEditorInput, bl ? 15 : 11);
    }

    public IJavaSearchScope createJavaProjectSearchScope(IEditorInput iEditorInput, int n) {
        IJavaProject iJavaProject;
        IJavaElement iJavaElement = JavaUI.getEditorInputJavaElement(iEditorInput);
        if (iJavaElement != null && (iJavaProject = iJavaElement.getJavaProject()) != null) {
            return this.createJavaProjectSearchScope(iJavaProject, n);
        }
        return this.EMPTY_SCOPE;
    }

    public String getWorkspaceScopeDescription(boolean bl) {
        return bl ? SearchMessages.WorkspaceScope : SearchMessages.WorkspaceScopeNoJRE;
    }

    public String getWorkspaceScopeDescription(int n) {
        return this.getWorkspaceScopeDescription((n & 4) != 0);
    }

    public String getProjectScopeDescription(String[] stringArray, int n) {
        String string;
        boolean bl;
        if (stringArray.length == 0) {
            return SearchMessages.JavaSearchScopeFactory_undefined_projects;
        }
        boolean bl2 = bl = (n & 4) != 0;
        if (stringArray.length == 1) {
            String string2 = bl ? SearchMessages.EnclosingProjectScope : SearchMessages.EnclosingProjectScopeNoJRE;
            string = Messages.format(string2, stringArray[0]);
        } else if (stringArray.length == 2) {
            String string3 = bl ? SearchMessages.EnclosingProjectsScope2 : SearchMessages.EnclosingProjectsScope2NoJRE;
            string = Messages.format(string3, new String[]{stringArray[0], stringArray[1]});
        } else {
            String string4 = bl ? SearchMessages.EnclosingProjectsScope : SearchMessages.EnclosingProjectsScopeNoJRE;
            string = Messages.format(string4, new String[]{stringArray[0], stringArray[1]});
        }
        return string;
    }

    public String getProjectScopeDescription(IJavaProject iJavaProject, boolean bl) {
        if (bl) {
            return Messages.format(SearchMessages.ProjectScope, iJavaProject.getElementName());
        }
        return Messages.format(SearchMessages.ProjectScopeNoJRE, iJavaProject.getElementName());
    }

    public String getProjectScopeDescription(IEditorInput iEditorInput, boolean bl) {
        IJavaProject iJavaProject;
        IJavaElement iJavaElement = JavaUI.getEditorInputJavaElement(iEditorInput);
        if (iJavaElement != null && (iJavaProject = iJavaElement.getJavaProject()) != null) {
            return this.getProjectScopeDescription(iJavaProject, bl);
        }
        return Messages.format(SearchMessages.ProjectScope, "");
    }

    public String getHierarchyScopeDescription(IType iType) {
        return Messages.format(SearchMessages.HierarchyScope, new String[]{iType.getElementName()});
    }

    public String getSelectionScopeDescription(IJavaElement[] iJavaElementArray, int n) {
        return this.getSelectionScopeDescription(iJavaElementArray, (n & 4) != 0);
    }

    public String getSelectionScopeDescription(IJavaElement[] iJavaElementArray, boolean bl) {
        String string;
        if (iJavaElementArray.length == 0) {
            return SearchMessages.JavaSearchScopeFactory_undefined_selection;
        }
        if (iJavaElementArray.length == 1) {
            String string2 = bl ? SearchMessages.SingleSelectionScope : SearchMessages.SingleSelectionScopeNoJRE;
            string = Messages.format(string2, iJavaElementArray[0].getElementName());
        } else if (iJavaElementArray.length == 1) {
            String string3 = bl ? SearchMessages.DoubleSelectionScope : SearchMessages.DoubleSelectionScopeNoJRE;
            string = Messages.format(string3, new String[]{iJavaElementArray[0].getElementName(), iJavaElementArray[1].getElementName()});
        } else {
            String string4 = bl ? SearchMessages.SelectionScope : SearchMessages.SelectionScopeNoJRE;
            string = Messages.format(string4, new String[]{iJavaElementArray[0].getElementName(), iJavaElementArray[1].getElementName()});
        }
        return string;
    }

    public String getWorkingSetScopeDescription(IWorkingSet[] iWorkingSetArray, int n) {
        return this.getWorkingSetScopeDescription(iWorkingSetArray, (n & 4) != 0);
    }

    public String getWorkingSetScopeDescription(IWorkingSet[] iWorkingSetArray, boolean bl) {
        if (iWorkingSetArray.length == 0) {
            return SearchMessages.JavaSearchScopeFactory_undefined_workingsets;
        }
        if (iWorkingSetArray.length == 1) {
            String string = bl ? SearchMessages.SingleWorkingSetScope : SearchMessages.SingleWorkingSetScopeNoJRE;
            return Messages.format(string, iWorkingSetArray[0].getLabel());
        }
        Arrays.sort(iWorkingSetArray, new WorkingSetComparator());
        if (iWorkingSetArray.length == 2) {
            String string = bl ? SearchMessages.DoubleWorkingSetScope : SearchMessages.DoubleWorkingSetScopeNoJRE;
            return Messages.format(string, new String[]{iWorkingSetArray[0].getLabel(), iWorkingSetArray[1].getLabel()});
        }
        String string = bl ? SearchMessages.WorkingSetsScope : SearchMessages.WorkingSetsScopeNoJRE;
        return Messages.format(string, new String[]{iWorkingSetArray[0].getLabel(), iWorkingSetArray[1].getLabel()});
    }

    public IProject[] getProjects(IJavaSearchScope iJavaSearchScope) {
        IPath[] iPathArray = iJavaSearchScope.enclosingProjectsAndJars();
        HashSet<IResource> hashSet = new HashSet<IResource>();
        int n = 0;
        while (n < iPathArray.length) {
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPathArray[n]);
            if (iResource != null && iResource.getType() == 4) {
                hashSet.add(iResource);
            }
            ++n;
        }
        return hashSet.toArray(new IProject[hashSet.size()]);
    }

    public IJavaElement[] getJavaElements(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            return this.getJavaElements(((IStructuredSelection)iSelection).toArray());
        }
        return new IJavaElement[0];
    }

    private IJavaElement[] getJavaElements(Object[] objectArray) {
        if (objectArray.length == 0) {
            return new IJavaElement[0];
        }
        HashSet hashSet = new HashSet(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            IWorkingSet iWorkingSet;
            Object object = objectArray[n];
            if (object instanceof IJavaElement) {
                this.addJavaElements(hashSet, (IJavaElement)object);
            } else if (object instanceof IResource) {
                this.addJavaElements(hashSet, (IResource)object);
            } else if (object instanceof LogicalPackage) {
                this.addJavaElements(hashSet, (LogicalPackage)((Object)object));
            } else if (object instanceof IWorkingSet) {
                iWorkingSet = (IWorkingSet)object;
                this.addJavaElements(hashSet, iWorkingSet);
            } else if (object instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iWorkingSet = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.addJavaElements(hashSet, (IResource)iWorkingSet);
                }
            }
            ++n;
        }
        return hashSet.toArray(new IJavaElement[hashSet.size()]);
    }

    public IJavaSearchScope createJavaSearchScope(IJavaElement[] iJavaElementArray, boolean bl) {
        return this.createJavaSearchScope(iJavaElementArray, bl ? 7 : 11);
    }

    public IJavaSearchScope createJavaSearchScope(IJavaElement[] iJavaElementArray, int n) {
        if (iJavaElementArray.length == 0) {
            return this.EMPTY_SCOPE;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])iJavaElementArray, (int)JavaSearchScopeFactory.getSearchFlags(n));
    }

    private IJavaSearchScope createJavaSearchScope(Collection collection, int n) {
        if (collection.isEmpty()) {
            return this.EMPTY_SCOPE;
        }
        IJavaElement[] iJavaElementArray = collection.toArray(new IJavaElement[collection.size()]);
        return SearchEngine.createJavaSearchScope((IJavaElement[])iJavaElementArray, (int)JavaSearchScopeFactory.getSearchFlags(n));
    }

    private static int getSearchFlags(int n) {
        return n;
    }

    private void addJavaElements(Set set, IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            this.addJavaElements(set, iResourceArray[n]);
            ++n;
        }
    }

    private void addJavaElements(Set set, IResource iResource) {
        IJavaElement iJavaElement;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iJavaElement = (IJavaElement)iResource.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (iJavaElement.getElementType() == 4) {
            try {
                this.addJavaElements(set, ((IFolder)iResource).members());
            }
            catch (CoreException coreException) {}
        }
        set.add(iJavaElement);
    }

    private void addJavaElements(Set set, IJavaElement iJavaElement) {
        set.add(iJavaElement);
    }

    private void addJavaElements(Set set, IWorkingSet iWorkingSet) {
        if (iWorkingSet == null) {
            return;
        }
        if (iWorkingSet.isAggregateWorkingSet() && iWorkingSet.isEmpty()) {
            try {
                IJavaProject[] iJavaProjectArray = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                set.addAll(Arrays.asList(iJavaProjectArray));
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            return;
        }
        IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
        int n = 0;
        while (n < iAdaptableArray.length) {
            IJavaElement iJavaElement;
            IAdaptable iAdaptable = iAdaptableArray[n];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.addJavaElements(set, iJavaElement);
            } else {
                IResource iResource;
                IAdaptable iAdaptable2 = iAdaptableArray[n];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable2.getAdapter((Class)clazz2)) != null) {
                    this.addJavaElements(set, iResource);
                }
            }
            ++n;
        }
    }

    private void addJavaElements(Set set, LogicalPackage logicalPackage) {
        IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            this.addJavaElements(set, (IJavaElement)iPackageFragmentArray[n]);
            ++n;
        }
    }

    public IJavaSearchScope createWorkspaceScope(boolean bl) {
        return this.createWorkspaceScope(bl ? 15 : 11);
    }

    public IJavaSearchScope createWorkspaceScope(int n) {
        if ((n & 7) != 7) {
            try {
                IJavaProject[] iJavaProjectArray = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                return SearchEngine.createJavaSearchScope((IJavaElement[])iJavaProjectArray, (int)JavaSearchScopeFactory.getSearchFlags(n));
            }
            catch (JavaModelException javaModelException) {}
        }
        return SearchEngine.createWorkspaceScope();
    }

    public boolean isInsideJRE(IJavaElement iJavaElement) {
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
        if (iPackageFragmentRoot != null) {
            try {
                IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
                if (iClasspathEntry.getEntryKind() == 5) {
                    IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iClasspathEntry.getPath(), (IJavaProject)iPackageFragmentRoot.getJavaProject());
                    return iClasspathContainer != null && iClasspathContainer.getKind() == 3;
                }
                return false;
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        return true;
    }
}

