/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.FieldReferenceMatch;
import org.eclipse.wst.jsdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.wst.jsdt.core.search.MethodReferenceMatch;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementMatch;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResult;

public class NewSearchResultCollector
extends SearchRequestor {
    private JavaSearchResult fSearch;
    private boolean fIgnorePotentials;

    public NewSearchResultCollector(JavaSearchResult javaSearchResult, boolean bl) {
        this.fSearch = javaSearchResult;
        this.fIgnorePotentials = bl;
    }

    public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
        IJavaElement iJavaElement = (IJavaElement)searchMatch.getElement();
        if (iJavaElement != null) {
            FieldReferenceMatch fieldReferenceMatch;
            if (this.fIgnorePotentials && searchMatch.getAccuracy() == 1) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (searchMatch instanceof FieldReferenceMatch) {
                fieldReferenceMatch = (FieldReferenceMatch)searchMatch;
                bl = fieldReferenceMatch.isWriteAccess();
                bl2 = fieldReferenceMatch.isReadAccess();
            } else if (searchMatch instanceof LocalVariableReferenceMatch) {
                fieldReferenceMatch = (LocalVariableReferenceMatch)searchMatch;
                bl = fieldReferenceMatch.isWriteAccess();
                bl2 = fieldReferenceMatch.isReadAccess();
            }
            boolean bl3 = false;
            if (searchMatch instanceof MethodReferenceMatch) {
                MethodReferenceMatch methodReferenceMatch = (MethodReferenceMatch)searchMatch;
                bl3 = methodReferenceMatch.isSuperInvocation();
            }
            this.fSearch.addMatch(new JavaElementMatch(iJavaElement, searchMatch.getRule(), searchMatch.getOffset(), searchMatch.getLength(), searchMatch.getAccuracy(), bl2, bl, searchMatch.isInsideDocComment(), bl3));
        }
    }

    public void beginReporting() {
    }

    public void endReporting() {
    }

    public void enterParticipant(SearchParticipant searchParticipant) {
    }

    public void exitParticipant(SearchParticipant searchParticipant) {
    }
}

