/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.search.IQueryParticipant;

public class SearchParticipantDescriptor {
    private static final String CLASS = "class";
    private static final String NATURE = "nature";
    private static final String ID = "id";
    private IConfigurationElement fConfigurationElement;
    private boolean fEnabled;

    protected SearchParticipantDescriptor(IConfigurationElement iConfigurationElement) {
        this.fConfigurationElement = iConfigurationElement;
        this.fEnabled = true;
    }

    protected IStatus checkSyntax() {
        if (this.fConfigurationElement.getAttribute(ID) == null) {
            String string = SearchMessages.SearchParticipant_error_noID;
            String string2 = Messages.format(string, new String[]{this.fConfigurationElement.getDeclaringExtension().getUniqueIdentifier()});
            return new Status(4, JavaPlugin.getPluginId(), 0, string2, null);
        }
        if (this.fConfigurationElement.getAttribute(NATURE) == null) {
            String string = SearchMessages.SearchParticipant_error_noNature;
            String string3 = Messages.format(string, new String[]{this.fConfigurationElement.getAttribute(ID)});
            return new Status(4, JavaPlugin.getPluginId(), 0, string3, null);
        }
        if (this.fConfigurationElement.getAttribute(CLASS) == null) {
            String string = SearchMessages.SearchParticipant_error_noClass;
            String string4 = Messages.format(string, new String[]{this.fConfigurationElement.getAttribute(ID)});
            return new Status(4, JavaPlugin.getPluginId(), 0, string4, null);
        }
        return Status.OK_STATUS;
    }

    public String getID() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public void disable() {
        this.fEnabled = false;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    protected IQueryParticipant create() throws CoreException {
        try {
            return (IQueryParticipant)this.fConfigurationElement.createExecutableExtension(CLASS);
        }
        catch (ClassCastException classCastException) {
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, SearchMessages.SearchParticipant_error_classCast, (Throwable)classCastException));
        }
    }

    protected String getNature() {
        return this.fConfigurationElement.getAttribute(NATURE);
    }
}

