/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.wst.jsdt.internal.ui.text.BufferedDocumentScanner;
import org.eclipse.wst.jsdt.ui.text.IJavaPartitions;

public class FastJavaPartitionScanner
implements IPartitionTokenScanner,
IJavaPartitions {
    private static final int JAVA = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int MULTI_LINE_COMMENT = 2;
    private static final int JAVADOC = 3;
    private static final int CHARACTER = 4;
    private static final int STRING = 5;
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int SLASH = 2;
    private static final int SLASH_STAR = 3;
    private static final int SLASH_STAR_STAR = 4;
    private static final int STAR = 5;
    private static final int CARRIAGE_RETURN = 6;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fState;
    private int fLast;
    private int fPrefixLength;
    private boolean fEmulate = false;
    private int fJavaOffset;
    private int fJavaLength;
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"__java_singleline_comment"), new Token((Object)"__java_multiline_comment"), new Token((Object)"__java_javadoc"), new Token((Object)"__java_character"), new Token((Object)"__java_string")};

    public FastJavaPartitionScanner(boolean bl) {
        this.fEmulate = bl;
    }

    public FastJavaPartitionScanner() {
        this(false);
    }

    public IToken nextToken() {
        if (this.fEmulate) {
            if (this.fJavaOffset != -1 && this.fTokenOffset + this.fTokenLength != this.fJavaOffset + this.fJavaLength) {
                this.fTokenOffset += this.fTokenLength;
                return this.fTokens[0];
            }
            this.fJavaOffset = -1;
            this.fJavaLength = 0;
        }
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        block56: while (true) {
            int n = this.fScanner.read();
            switch (n) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        this.fLast = 0;
                        return this.preFix(this.fState, 0, 0, 0);
                    }
                    this.fLast = 0;
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
                case 13: {
                    if (!this.fEmulate && this.fLast != 6) {
                        this.fLast = 6;
                        ++this.fTokenLength;
                        continue block56;
                    }
                    switch (this.fState) {
                        case 1: 
                        case 4: 
                        case 5: {
                            if (this.fTokenLength > 0) {
                                IToken iToken = this.fTokens[this.fState];
                                if (this.fEmulate) {
                                    ++this.fTokenLength;
                                    this.fLast = 0;
                                    this.fPrefixLength = 0;
                                } else {
                                    this.fLast = 6;
                                    this.fPrefixLength = 1;
                                }
                                this.fState = 0;
                                return iToken;
                            }
                            this.consume();
                            continue block56;
                        }
                    }
                    this.consume();
                    continue block56;
                }
                case 10: {
                    switch (this.fState) {
                        case 1: 
                        case 4: 
                        case 5: {
                            return this.postFix(this.fState);
                        }
                    }
                    this.consume();
                    continue block56;
                }
            }
            if (!this.fEmulate && this.fLast == 6) {
                switch (this.fState) {
                    case 1: 
                    case 4: 
                    case 5: {
                        int n2;
                        int n3;
                        switch (n) {
                            case 47: {
                                n3 = 2;
                                n2 = 0;
                                break;
                            }
                            case 42: {
                                n3 = 5;
                                n2 = 0;
                                break;
                            }
                            case 39: {
                                n3 = 0;
                                n2 = 4;
                                break;
                            }
                            case 34: {
                                n3 = 0;
                                n2 = 5;
                                break;
                            }
                            case 13: {
                                n3 = 6;
                                n2 = 0;
                                break;
                            }
                            case 92: {
                                n3 = 1;
                                n2 = 0;
                                break;
                            }
                            default: {
                                n3 = 0;
                                n2 = 0;
                            }
                        }
                        this.fLast = 0;
                        return this.preFix(this.fState, n2, n3, 1);
                    }
                }
            }
            block22 : switch (this.fState) {
                case 0: {
                    switch (n) {
                        case 47: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastJavaPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 1, 0, 2);
                                }
                                this.preFix(0, 1, 0, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                            ++this.fTokenLength;
                            this.fLast = 2;
                            break;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastJavaPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 2, 3, 2);
                                }
                                this.preFix(0, 2, 3, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                            this.consume();
                            break;
                        }
                        case 39: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 4, 0, 1);
                            }
                            this.preFix(0, 4, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        case 34: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 5, 0, 1);
                            }
                            this.preFix(0, 5, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    this.consume();
                    break;
                }
                case 3: {
                    switch (n) {
                        case 47: {
                            switch (this.fLast) {
                                case 4: {
                                    return this.postFix(2);
                                }
                                case 5: {
                                    return this.postFix(3);
                                }
                            }
                            this.consume();
                            break;
                        }
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 5;
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n) {
                        case 42: {
                            if (this.fLast == 3) {
                                this.fLast = 4;
                                ++this.fTokenLength;
                                this.fState = 3;
                                break;
                            }
                            ++this.fTokenLength;
                            this.fLast = 5;
                            break;
                        }
                        case 47: {
                            if (this.fLast == 5) {
                                return this.postFix(2);
                            }
                            this.consume();
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (n) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break;
                        }
                        case 34: {
                            if (this.fLast != 1) {
                                return this.postFix(5);
                            }
                            this.consume();
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (n) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block22;
                        }
                        case 39: {
                            if (this.fLast != 1) {
                                return this.postFix(4);
                            }
                            this.consume();
                            break block22;
                        }
                        default: {
                            this.consume();
                        }
                    }
                }
            }
        }
    }

    private static final int getLastLength(int n) {
        switch (n) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: 
        }
        return 3;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int n) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = 0;
        this.fPrefixLength = 0;
        return this.fTokens[n];
    }

    private final IToken preFix(int n, int n2, int n3, int n4) {
        if (this.fEmulate && n == 0 && this.fTokenLength - FastJavaPartitionScanner.getLastLength(this.fLast) > 0) {
            this.fTokenLength -= FastJavaPartitionScanner.getLastLength(this.fLast);
            this.fJavaOffset = this.fTokenOffset;
            this.fJavaLength = this.fTokenLength;
            this.fTokenLength = 1;
            this.fState = n2;
            this.fPrefixLength = n4;
            this.fLast = n3;
            return this.fTokens[n];
        }
        this.fTokenLength -= FastJavaPartitionScanner.getLastLength(this.fLast);
        this.fLast = n3;
        this.fPrefixLength = n4;
        IToken iToken = this.fTokens[n];
        this.fState = n2;
        return iToken;
    }

    private static int getState(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equals("__java_singleline_comment")) {
            return 1;
        }
        if (string.equals("__java_multiline_comment")) {
            return 2;
        }
        if (string.equals("__java_javadoc")) {
            return 3;
        }
        if (string.equals("__java_string")) {
            return 5;
        }
        if (string.equals("__java_character")) {
            return 4;
        }
        return 0;
    }

    public void setPartialRange(IDocument iDocument, int n, int n2, String string, int n3) {
        this.fScanner.setRange(iDocument, n, n2);
        this.fTokenOffset = n3;
        this.fTokenLength = 0;
        this.fPrefixLength = n - n3;
        this.fLast = 0;
        this.fState = n == n3 ? 0 : FastJavaPartitionScanner.getState(string);
        if (this.fEmulate) {
            this.fJavaOffset = -1;
            this.fJavaLength = 0;
        }
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        this.fScanner.setRange(iDocument, n, n2);
        this.fTokenOffset = n;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fLast = 0;
        this.fState = 0;
        if (this.fEmulate) {
            this.fJavaOffset = -1;
            this.fJavaLength = 0;
        }
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

