/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class ASTResolving {
    private static final PrimitiveType.Code[] CODE_ORDER = new PrimitiveType.Code[]{PrimitiveType.CHAR, PrimitiveType.SHORT, PrimitiveType.INT, PrimitiveType.LONG, PrimitiveType.FLOAT, PrimitiveType.DOUBLE};

    public static ITypeBinding guessBindingForReference(ASTNode aSTNode) {
        return Bindings.normalizeTypeBinding(ASTResolving.getPossibleReferenceBinding(aSTNode));
    }

    private static ITypeBinding getPossibleReferenceBinding(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getParent();
        switch (aSTNode2.getNodeType()) {
            case 7: {
                Assignment assignment = (Assignment)aSTNode2;
                if (aSTNode.equals((Object)assignment.getLeftHandSide())) {
                    return assignment.getRightHandSide().resolveTypeBinding();
                }
                return assignment.getLeftHandSide().resolveTypeBinding();
            }
            case 27: {
                InfixExpression infixExpression = (InfixExpression)aSTNode2;
                InfixExpression.Operator operator = infixExpression.getOperator();
                if (operator == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.CONDITIONAL_OR) {
                    return infixExpression.getAST().resolveWellKnownType("boolean");
                }
                if (operator == InfixExpression.Operator.LEFT_SHIFT || operator == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED || operator == InfixExpression.Operator.RIGHT_SHIFT_SIGNED) {
                    return infixExpression.getAST().resolveWellKnownType("int");
                }
                if (aSTNode.equals((Object)infixExpression.getLeftOperand())) {
                    ITypeBinding iTypeBinding = infixExpression.getRightOperand().resolveTypeBinding();
                    if (iTypeBinding != null) {
                        return iTypeBinding;
                    }
                } else {
                    ITypeBinding iTypeBinding = infixExpression.getLeftOperand().resolveTypeBinding();
                    if (iTypeBinding != null) {
                        return iTypeBinding;
                    }
                }
                if (operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS) break;
                return infixExpression.getAST().resolveWellKnownType("int");
            }
            case 62: {
                InstanceofExpression instanceofExpression = (InstanceofExpression)aSTNode2;
                return instanceofExpression.getRightOperand().resolveBinding();
            }
            case 59: {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTNode2;
                if (!variableDeclarationFragment.getInitializer().equals((Object)aSTNode)) break;
                return variableDeclarationFragment.getName().resolveTypeBinding();
            }
            case 48: {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)aSTNode2;
                IMethodBinding iMethodBinding = ASTNodes.getMethodBinding((Name)superMethodInvocation.getName());
                if (iMethodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(aSTNode, superMethodInvocation.arguments(), iMethodBinding);
            }
            case 32: {
                MethodInvocation methodInvocation = (MethodInvocation)aSTNode2;
                IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
                if (iMethodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(aSTNode, methodInvocation.arguments(), iMethodBinding);
            }
            case 46: {
                SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)aSTNode2;
                IMethodBinding iMethodBinding = superConstructorInvocation.resolveConstructorBinding();
                if (iMethodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(aSTNode, superConstructorInvocation.arguments(), iMethodBinding);
            }
            case 17: {
                ConstructorInvocation constructorInvocation = (ConstructorInvocation)aSTNode2;
                IMethodBinding iMethodBinding = constructorInvocation.resolveConstructorBinding();
                if (iMethodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(aSTNode, constructorInvocation.arguments(), iMethodBinding);
            }
            case 14: {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)aSTNode2;
                IMethodBinding iMethodBinding = classInstanceCreation.resolveConstructorBinding();
                if (iMethodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(aSTNode, classInstanceCreation.arguments(), iMethodBinding);
            }
            case 36: {
                return ASTResolving.guessBindingForReference(aSTNode2);
            }
            case 2: {
                if (((ArrayAccess)aSTNode2).getIndex().equals((Object)aSTNode)) {
                    return aSTNode2.getAST().resolveWellKnownType("int");
                }
                return ASTResolving.getPossibleReferenceBinding(aSTNode2);
            }
            case 3: {
                if (!((ArrayCreation)aSTNode2).dimensions().contains(aSTNode)) break;
                return aSTNode2.getAST().resolveWellKnownType("int");
            }
            case 4: {
                Object object;
                ASTNode aSTNode3 = aSTNode2.getParent();
                int n = 1;
                while (aSTNode3 instanceof ArrayInitializer) {
                    aSTNode3 = aSTNode3.getParent();
                    ++n;
                }
                ArrayType arrayType = null;
                if (aSTNode3 instanceof ArrayCreation) {
                    arrayType = ((ArrayCreation)aSTNode3).getType();
                } else if (aSTNode3 instanceof VariableDeclaration) {
                    object = (VariableDeclaration)aSTNode3;
                    arrayType = ASTNodes.getType(object);
                    n -= object.getExtraDimensions();
                } else if (aSTNode3 instanceof MemberValuePair) {
                    object = ((MemberValuePair)aSTNode3).getName().getIdentifier();
                    IMethodBinding iMethodBinding = ASTResolving.findAnnotationMember((Annotation)aSTNode3.getParent(), (String)object);
                    if (iMethodBinding != null) {
                        return ASTResolving.getReducedDimensionBinding(iMethodBinding.getReturnType(), n);
                    }
                }
                if (arrayType == null) break;
                while (arrayType instanceof ArrayType && n > 0) {
                    arrayType = arrayType.getComponentType();
                    --n;
                }
                return arrayType.resolveBinding();
            }
            case 16: {
                ConditionalExpression conditionalExpression = (ConditionalExpression)aSTNode2;
                if (aSTNode.equals((Object)conditionalExpression.getExpression())) {
                    return aSTNode2.getAST().resolveWellKnownType("boolean");
                }
                if (aSTNode.equals((Object)conditionalExpression.getElseExpression())) {
                    return conditionalExpression.getThenExpression().resolveTypeBinding();
                }
                return conditionalExpression.getElseExpression().resolveTypeBinding();
            }
            case 37: {
                return aSTNode2.getAST().resolveWellKnownType("int");
            }
            case 38: {
                if (((PrefixExpression)aSTNode2).getOperator() == PrefixExpression.Operator.NOT) {
                    return aSTNode2.getAST().resolveWellKnownType("boolean");
                }
                return aSTNode2.getAST().resolveWellKnownType("int");
            }
            case 19: 
            case 25: 
            case 61: {
                if (!(aSTNode instanceof Expression)) break;
                return aSTNode2.getAST().resolveWellKnownType("boolean");
            }
            case 50: {
                if (!((SwitchStatement)aSTNode2).getExpression().equals((Object)aSTNode)) break;
                return aSTNode2.getAST().resolveWellKnownType("int");
            }
            case 41: {
                MethodDeclaration methodDeclaration = ASTResolving.findParentMethodDeclaration(aSTNode2);
                if (methodDeclaration == null || methodDeclaration.isConstructor()) break;
                return methodDeclaration.getReturnType2().resolveBinding();
            }
            case 11: {
                return ((CastExpression)aSTNode2).getType().resolveBinding();
            }
            case 12: 
            case 53: {
                return aSTNode2.getAST().resolveWellKnownType("java.lang.Exception");
            }
            case 22: {
                if (!aSTNode.equals((Object)((FieldAccess)aSTNode2).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(aSTNode2);
            }
            case 47: {
                return ASTResolving.getPossibleReferenceBinding(aSTNode2);
            }
            case 40: {
                if (!aSTNode.equals((Object)((QualifiedName)aSTNode2).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(aSTNode2);
            }
            case 49: {
                if (!aSTNode.equals((Object)((SwitchCase)aSTNode2).getExpression()) || !(aSTNode2.getParent() instanceof SwitchStatement)) break;
                return ((SwitchStatement)aSTNode2.getParent()).getExpression().resolveTypeBinding();
            }
            case 6: {
                if (aSTNode.getLocationInParent() == AssertStatement.EXPRESSION_PROPERTY) {
                    return aSTNode2.getAST().resolveWellKnownType("boolean");
                }
                return aSTNode2.getAST().resolveWellKnownType("java.lang.String");
            }
            case 79: {
                IMethodBinding iMethodBinding = ASTResolving.findAnnotationMember((Annotation)aSTNode2, "value");
                if (iMethodBinding == null) break;
                return iMethodBinding.getReturnType();
            }
            case 80: {
                String string = ((MemberValuePair)aSTNode2).getName().getIdentifier();
                IMethodBinding iMethodBinding = ASTResolving.findAnnotationMember((Annotation)aSTNode2.getParent(), string);
                if (iMethodBinding == null) break;
                return iMethodBinding.getReturnType();
            }
        }
        return null;
    }

    private static IMethodBinding findAnnotationMember(Annotation annotation, String string) {
        ITypeBinding iTypeBinding = annotation.resolveTypeBinding();
        if (iTypeBinding != null) {
            return Bindings.findMethodInType(iTypeBinding, string, null);
        }
        return null;
    }

    public static Type guessTypeForReference(AST aST, ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getParent();
        while (aSTNode2 != null) {
            switch (aSTNode2.getNodeType()) {
                case 59: {
                    if (((VariableDeclarationFragment)aSTNode2).getInitializer() == aSTNode) {
                        return ASTNodeFactory.newType(aST, (VariableDeclaration)aSTNode2);
                    }
                    return null;
                }
                case 44: {
                    if (((VariableDeclarationFragment)aSTNode2).getInitializer() == aSTNode) {
                        return ASTNodeFactory.newType(aST, (VariableDeclaration)aSTNode2);
                    }
                    return null;
                }
                case 2: {
                    Type type;
                    if (!((ArrayAccess)aSTNode2).getIndex().equals((Object)aSTNode) && (type = ASTResolving.guessTypeForReference(aST, aSTNode2)) != null) {
                        return aST.newArrayType(type);
                    }
                    return null;
                }
                case 22: {
                    if (aSTNode.equals((Object)((FieldAccess)aSTNode2).getName())) {
                        aSTNode = aSTNode2;
                        aSTNode2 = aSTNode2.getParent();
                        break;
                    }
                    return null;
                }
                case 36: 
                case 47: {
                    aSTNode = aSTNode2;
                    aSTNode2 = aSTNode2.getParent();
                    break;
                }
                case 40: {
                    if (aSTNode.equals((Object)((QualifiedName)aSTNode2).getName())) {
                        aSTNode = aSTNode2;
                        aSTNode2 = aSTNode2.getParent();
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static ITypeBinding getReducedDimensionBinding(ITypeBinding iTypeBinding, int n) {
        while (n > 0) {
            iTypeBinding = iTypeBinding.getComponentType();
            --n;
        }
        return iTypeBinding;
    }

    private static ITypeBinding getParameterTypeBinding(ASTNode aSTNode, List list, IMethodBinding iMethodBinding) {
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        int n = list.indexOf(aSTNode);
        if (iMethodBinding.isVarargs() && n >= iTypeBindingArray.length - 1) {
            return iTypeBindingArray[iTypeBindingArray.length - 1].getComponentType();
        }
        if (n >= 0 && n < iTypeBindingArray.length) {
            return iTypeBindingArray[n];
        }
        return null;
    }

    public static ITypeBinding guessBindingForTypeReference(ASTNode aSTNode) {
        ITypeBinding iTypeBinding;
        StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
        if (structuralPropertyDescriptor == QualifiedName.QUALIFIER_PROPERTY) {
            return null;
        }
        if (structuralPropertyDescriptor == SimpleType.NAME_PROPERTY) {
            aSTNode = aSTNode.getParent();
        }
        if ((iTypeBinding = Bindings.normalizeTypeBinding(ASTResolving.getPossibleTypeBinding(aSTNode))) != null && iTypeBinding.isWildcardType()) {
            return ASTResolving.normalizeWildcardType(iTypeBinding, true, aSTNode.getAST());
        }
        return iTypeBinding;
    }

    private static ITypeBinding getPossibleTypeBinding(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getParent();
        switch (aSTNode2.getNodeType()) {
            case 5: {
                int n = 1;
                while (aSTNode2.getParent() instanceof ArrayType) {
                    aSTNode2 = aSTNode2.getParent();
                    ++n;
                }
                ITypeBinding iTypeBinding = ASTResolving.getPossibleTypeBinding(aSTNode2);
                if (iTypeBinding != null && iTypeBinding.getDimensions() == n) {
                    return iTypeBinding.getElementType();
                }
                return null;
            }
            case 74: {
                ITypeBinding iTypeBinding = ASTResolving.getPossibleTypeBinding(aSTNode2);
                if (iTypeBinding == null || !iTypeBinding.isParameterizedType()) {
                    return null;
                }
                if (aSTNode.getLocationInParent() == ParameterizedType.TYPE_PROPERTY) {
                    return iTypeBinding;
                }
                ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
                List list = ((ParameterizedType)aSTNode2).typeArguments();
                int n = list.indexOf(aSTNode);
                if (n != -1 && iTypeBindingArray.length == list.size()) {
                    return iTypeBindingArray[n];
                }
                return null;
            }
            case 76: {
                ITypeBinding iTypeBinding = ASTResolving.getPossibleTypeBinding(aSTNode2);
                if (iTypeBinding == null || !iTypeBinding.isWildcardType()) {
                    return null;
                }
                WildcardType wildcardType = (WildcardType)aSTNode2;
                if (iTypeBinding.isUpperbound() == wildcardType.isUpperBound()) {
                    return iTypeBinding.getBound();
                }
                return null;
            }
            case 75: {
                ITypeBinding iTypeBinding = ASTResolving.getPossibleTypeBinding(aSTNode2);
                if (iTypeBinding == null || !iTypeBinding.isMember()) {
                    return null;
                }
                if (aSTNode.getLocationInParent() == QualifiedType.QUALIFIER_PROPERTY) {
                    return iTypeBinding.getDeclaringClass();
                }
                return iTypeBinding;
            }
            case 60: {
                return ASTResolving.guessVariableType(((VariableDeclarationStatement)aSTNode2).fragments());
            }
            case 23: {
                return ASTResolving.guessVariableType(((FieldDeclaration)aSTNode2).fragments());
            }
            case 58: {
                return ASTResolving.guessVariableType(((VariableDeclarationExpression)aSTNode2).fragments());
            }
            case 44: {
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)aSTNode2;
                if (singleVariableDeclaration.getInitializer() == null) break;
                return Bindings.normalizeTypeBinding(singleVariableDeclaration.getInitializer().resolveTypeBinding());
            }
            case 3: {
                ArrayCreation arrayCreation = (ArrayCreation)aSTNode2;
                if (arrayCreation.getInitializer() != null) {
                    return arrayCreation.getInitializer().resolveTypeBinding();
                }
                return ASTResolving.getPossibleReferenceBinding(aSTNode2);
            }
            case 57: {
                return ((TypeLiteral)aSTNode2).getType().resolveBinding();
            }
            case 14: {
                return ASTResolving.getPossibleReferenceBinding(aSTNode2);
            }
            case 11: {
                return ASTResolving.getPossibleReferenceBinding(aSTNode2);
            }
            case 65: {
                List list;
                ASTNode aSTNode3;
                TagElement tagElement = (TagElement)aSTNode2;
                if (!"@throws".equals(tagElement.getTagName()) && !"@exception".equals(tagElement.getTagName()) || !((aSTNode3 = tagElement.getParent().getParent()) instanceof MethodDeclaration) || (list = ((MethodDeclaration)aSTNode3).thrownExceptions()).size() != 1) break;
                return ((Name)list.get(0)).resolveTypeBinding();
            }
        }
        return null;
    }

    private static ITypeBinding guessVariableType(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            if (variableDeclarationFragment.getInitializer() == null) continue;
            return Bindings.normalizeTypeBinding(variableDeclarationFragment.getInitializer().resolveTypeBinding());
        }
        return null;
    }

    public static ITypeBinding[] getQualifierGuess(ASTNode aSTNode, final String string, List list, final IBinding iBinding) {
        final int n = list.size();
        final ArrayList arrayList = new ArrayList();
        ITypeBinding iTypeBinding = aSTNode.getAST().resolveWellKnownType("java.lang.Object");
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n2 = 0;
        while (n2 < iMethodBindingArray.length) {
            IMethodBinding iMethodBinding = iMethodBindingArray[n2];
            if (iMethodBinding.getName().equals(string) && iMethodBinding.getParameterTypes().length == n) {
                return new ITypeBinding[]{iTypeBinding};
            }
            ++n2;
        }
        ASTResolving.visitAllBindings(aSTNode, new TypeBindingVisitor(){
            private HashSet fVisitedBindings = new HashSet(100);

            public boolean visit(ITypeBinding iTypeBinding) {
                if ((iTypeBinding = Bindings.normalizeTypeBinding(iTypeBinding)) == null) {
                    return true;
                }
                if (!this.fVisitedBindings.add(iTypeBinding.getKey())) {
                    return true;
                }
                if (iTypeBinding.isGenericType()) {
                    return true;
                }
                if (iBinding != null && !ASTResolving.isUseableTypeInContext(iTypeBinding, iBinding, false)) {
                    return true;
                }
                IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
                int n2 = 0;
                while (n2 < iMethodBindingArray.length) {
                    IMethodBinding iMethodBinding = iMethodBindingArray[n2];
                    if (iMethodBinding.getName().equals(string) && iMethodBinding.getParameterTypes().length == n) {
                        arrayList.add(iTypeBinding);
                    }
                    ++n2;
                }
                return true;
            }
        });
        return arrayList.toArray(new ITypeBinding[arrayList.size()]);
    }

    public static void visitAllBindings(ASTNode aSTNode, TypeBindingVisitor typeBindingVisitor) {
        try {
            aSTNode.accept((ASTVisitor)new AllBindingsVisitor(typeBindingVisitor));
        }
        catch (AllBindingsVisitor.VisitCancelledException visitCancelledException) {}
    }

    public static IBinding getParentMethodOrTypeBinding(ASTNode aSTNode) {
        do {
            if (aSTNode instanceof MethodDeclaration) {
                return ((MethodDeclaration)aSTNode).resolveBinding();
            }
            if (aSTNode instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)aSTNode).resolveBinding();
            }
            if (!(aSTNode instanceof AnonymousClassDeclaration)) continue;
            return ((AnonymousClassDeclaration)aSTNode).resolveBinding();
        } while ((aSTNode = aSTNode.getParent()) != null);
        return null;
    }

    public static BodyDeclaration findParentBodyDeclaration(ASTNode aSTNode) {
        while (aSTNode != null && !(aSTNode instanceof BodyDeclaration)) {
            aSTNode = aSTNode.getParent();
        }
        return (BodyDeclaration)aSTNode;
    }

    public static BodyDeclaration findParentBodyDeclaration(ASTNode aSTNode, boolean bl) {
        StructuralPropertyDescriptor structuralPropertyDescriptor = null;
        while (aSTNode != null) {
            if (aSTNode instanceof BodyDeclaration) {
                BodyDeclaration bodyDeclaration = (BodyDeclaration)aSTNode;
                if (!bl || structuralPropertyDescriptor != bodyDeclaration.getModifiersProperty()) {
                    return bodyDeclaration;
                }
                bl = false;
            }
            structuralPropertyDescriptor = aSTNode.getLocationInParent();
            aSTNode = aSTNode.getParent();
        }
        return (BodyDeclaration)aSTNode;
    }

    public static CompilationUnit findParentCompilationUnit(ASTNode aSTNode) {
        return (CompilationUnit)ASTResolving.findAncestor(aSTNode, 15);
    }

    public static ASTNode findParentType(ASTNode aSTNode, boolean bl) {
        StructuralPropertyDescriptor structuralPropertyDescriptor = null;
        while (aSTNode != null) {
            if (aSTNode instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)aSTNode;
                if (!bl || structuralPropertyDescriptor != abstractTypeDeclaration.getModifiersProperty()) {
                    return abstractTypeDeclaration;
                }
            } else if (aSTNode instanceof AnonymousClassDeclaration) {
                return aSTNode;
            }
            structuralPropertyDescriptor = aSTNode.getLocationInParent();
            aSTNode = aSTNode.getParent();
        }
        return null;
    }

    public static ASTNode findParentType(ASTNode aSTNode) {
        return ASTResolving.findParentType(aSTNode, false);
    }

    public static ASTNode findParent(ASTNode aSTNode) {
        while (aSTNode != null) {
            if (aSTNode instanceof CompilationUnit) {
                return aSTNode;
            }
            if (aSTNode instanceof AbstractTypeDeclaration) {
                return aSTNode;
            }
            if (aSTNode instanceof AnonymousClassDeclaration) {
                return aSTNode;
            }
            aSTNode = aSTNode.getParent();
        }
        return null;
    }

    public static MethodDeclaration findParentMethodDeclaration(ASTNode aSTNode) {
        while (aSTNode != null) {
            if (aSTNode.getNodeType() == 31) {
                return (MethodDeclaration)aSTNode;
            }
            if (aSTNode instanceof AbstractTypeDeclaration || aSTNode instanceof AnonymousClassDeclaration) {
                return null;
            }
            aSTNode = aSTNode.getParent();
        }
        return null;
    }

    public static ASTNode findAncestor(ASTNode aSTNode, int n) {
        while (aSTNode != null && aSTNode.getNodeType() != n) {
            aSTNode = aSTNode.getParent();
        }
        return aSTNode;
    }

    public static Statement findParentStatement(ASTNode aSTNode) {
        while (aSTNode != null && !(aSTNode instanceof Statement)) {
            if (!((aSTNode = aSTNode.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (Statement)aSTNode;
    }

    public static TryStatement findParentTryStatement(ASTNode aSTNode) {
        while (aSTNode != null && !(aSTNode instanceof TryStatement)) {
            if (!((aSTNode = aSTNode.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (TryStatement)aSTNode;
    }

    public static boolean isInsideConstructorInvocation(MethodDeclaration methodDeclaration, ASTNode aSTNode) {
        Statement statement;
        return methodDeclaration.isConstructor() && ((statement = ASTResolving.findParentStatement(aSTNode)) instanceof ConstructorInvocation || statement instanceof SuperConstructorInvocation);
    }

    public static boolean isInsideModifiers(ASTNode aSTNode) {
        while (aSTNode != null && !(aSTNode instanceof BodyDeclaration)) {
            if (aSTNode instanceof Annotation) {
                return true;
            }
            aSTNode = aSTNode.getParent();
        }
        return false;
    }

    public static boolean isInStaticContext(ASTNode aSTNode) {
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(aSTNode);
        if (bodyDeclaration instanceof MethodDeclaration) {
            if (ASTResolving.isInsideConstructorInvocation((MethodDeclaration)bodyDeclaration, aSTNode)) {
                return true;
            }
            return Modifier.isStatic((int)bodyDeclaration.getModifiers());
        }
        if (bodyDeclaration instanceof Initializer) {
            return Modifier.isStatic((int)((Initializer)bodyDeclaration).getModifiers());
        }
        if (bodyDeclaration instanceof FieldDeclaration) {
            return Modifier.isStatic((int)((FieldDeclaration)bodyDeclaration).getModifiers());
        }
        return false;
    }

    public static boolean isWriteAccess(Name name) {
        Name name2 = name;
        ASTNode aSTNode = name2.getParent();
        while (aSTNode != null) {
            switch (aSTNode.getNodeType()) {
                case 40: {
                    if (((QualifiedName)aSTNode).getQualifier() != name2) break;
                    return false;
                }
                case 22: {
                    if (((FieldAccess)aSTNode).getExpression() != name2) break;
                    return false;
                }
                case 47: {
                    break;
                }
                case 7: {
                    return ((Assignment)aSTNode).getLeftHandSide() == name2;
                }
                case 44: 
                case 59: {
                    return ((VariableDeclaration)aSTNode).getName() == name2;
                }
                case 37: 
                case 38: {
                    return true;
                }
                default: {
                    return false;
                }
            }
            name2 = aSTNode;
            aSTNode = name2.getParent();
        }
        return false;
    }

    public static int getPossibleTypeKinds(ASTNode aSTNode, boolean bl) {
        int n = ASTResolving.internalGetPossibleTypeKinds(aSTNode);
        if (!bl) {
            n &= 6;
        }
        return n;
    }

    private static int internalGetPossibleTypeKinds(ASTNode aSTNode) {
        int n = 126;
        int n2 = 254;
        ASTNode aSTNode2 = aSTNode.getParent();
        while (aSTNode2 instanceof QualifiedName) {
            if (aSTNode.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
                return 30;
            }
            aSTNode = aSTNode2;
            aSTNode2 = aSTNode2.getParent();
            n2 = 30;
        }
        while (aSTNode2 instanceof Type) {
            if (aSTNode2 instanceof QualifiedType) {
                if (aSTNode.getLocationInParent() == QualifiedType.QUALIFIER_PROPERTY) {
                    return n2 & 0x1E;
                }
                n2 &= 0x1E;
            } else if (aSTNode2 instanceof ParameterizedType) {
                if (aSTNode.getLocationInParent() == ParameterizedType.TYPE_ARGUMENTS_PROPERTY) {
                    return n2 & 0x3E;
                }
                n2 &= 6;
            } else if (aSTNode2 instanceof WildcardType && aSTNode.getLocationInParent() == WildcardType.BOUND_PROPERTY) {
                return n2 & 0x3E;
            }
            aSTNode = aSTNode2;
            aSTNode2 = aSTNode2.getParent();
        }
        switch (aSTNode2.getNodeType()) {
            case 55: {
                if (aSTNode.getLocationInParent() == TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY) {
                    n = 4;
                    break;
                }
                if (aSTNode.getLocationInParent() != TypeDeclaration.SUPERCLASS_TYPE_PROPERTY) break;
                n = 2;
                break;
            }
            case 71: {
                n = 4;
                break;
            }
            case 31: {
                if (aSTNode.getLocationInParent() == MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY) {
                    n = 2;
                    break;
                }
                if (aSTNode.getLocationInParent() != MethodDeclaration.RETURN_TYPE2_PROPERTY) break;
                n = 254;
                break;
            }
            case 82: {
                n = 88;
                break;
            }
            case 62: {
                n = 30;
                break;
            }
            case 53: {
                n = 2;
                break;
            }
            case 14: {
                if (((ClassInstanceCreation)aSTNode2).getAnonymousClassDeclaration() == null) {
                    n = 2;
                    break;
                }
                n = 6;
                break;
            }
            case 44: {
                int n3 = aSTNode2.getParent().getNodeType();
                if (n3 != 12) break;
                n = 2;
                break;
            }
            case 65: {
                n = 30;
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                n = 8;
                break;
            }
            case 73: {
                if (((TypeParameter)aSTNode2).typeBounds().indexOf(aSTNode) > 0) {
                    n = 4;
                    break;
                }
                n = 62;
                break;
            }
            case 57: {
                n = 30;
            }
        }
        return n & n2;
    }

    public static String getFullName(Name name) {
        return name.getFullyQualifiedName();
    }

    public static ICompilationUnit findCompilationUnitForBinding(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, ITypeBinding iTypeBinding) throws JavaModelException {
        if (iTypeBinding == null || !iTypeBinding.isFromSource() || iTypeBinding.isTypeVariable() || iTypeBinding.isWildcardType()) {
            return null;
        }
        ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)iTypeBinding.getTypeDeclaration());
        if (aSTNode == null) {
            ICompilationUnit iCompilationUnit2 = Bindings.findCompilationUnit(iTypeBinding, iCompilationUnit.getJavaProject());
            if (iCompilationUnit2 != null) {
                return iCompilationUnit2;
            }
            return null;
        }
        if (aSTNode instanceof CompilationUnit || aSTNode instanceof AbstractTypeDeclaration || aSTNode instanceof AnonymousClassDeclaration) {
            return iCompilationUnit;
        }
        return null;
    }

    public static ITypeBinding[] getNarrowingTypes(AST aST, ITypeBinding iTypeBinding) {
        ArrayList<ITypeBinding> arrayList = new ArrayList<ITypeBinding>();
        arrayList.add(iTypeBinding);
        if (iTypeBinding.isPrimitive()) {
            PrimitiveType.Code code = PrimitiveType.toCode((String)iTypeBinding.getName());
            int n = 0;
            while (n < CODE_ORDER.length && code != CODE_ORDER[n]) {
                String string = CODE_ORDER[n].toString();
                arrayList.add(aST.resolveWellKnownType(string));
                ++n;
            }
        }
        return arrayList.toArray(new ITypeBinding[arrayList.size()]);
    }

    public static ITypeBinding[] getRelaxingTypes(AST aST, ITypeBinding iTypeBinding) {
        ArrayList<ITypeBinding> arrayList = new ArrayList<ITypeBinding>();
        arrayList.add(iTypeBinding);
        if (iTypeBinding.isArray()) {
            arrayList.add(aST.resolveWellKnownType("java.lang.Object"));
            arrayList.add(aST.resolveWellKnownType("java.io.Serializable"));
            arrayList.add(aST.resolveWellKnownType("java.lang.Cloneable"));
        } else if (iTypeBinding.isPrimitive()) {
            PrimitiveType.Code code = PrimitiveType.toCode((String)iTypeBinding.getName());
            boolean bl = false;
            int n = 0;
            while (n < CODE_ORDER.length) {
                if (bl) {
                    String string = CODE_ORDER[n].toString();
                    arrayList.add(aST.resolveWellKnownType(string));
                }
                if (code == CODE_ORDER[n]) {
                    bl = true;
                }
                ++n;
            }
        } else {
            ASTResolving.collectRelaxingTypes(arrayList, iTypeBinding);
        }
        return arrayList.toArray(new ITypeBinding[arrayList.size()]);
    }

    private static void collectRelaxingTypes(Collection collection, ITypeBinding iTypeBinding) {
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding2 = iTypeBindingArray[n];
            if (!collection.contains(iTypeBinding2)) {
                collection.add(iTypeBinding2);
            }
            ASTResolving.collectRelaxingTypes(collection, iTypeBinding2);
            ++n;
        }
        ITypeBinding iTypeBinding3 = iTypeBinding.getSuperclass();
        if (iTypeBinding3 != null) {
            if (!collection.contains(iTypeBinding3)) {
                collection.add(iTypeBinding3);
            }
            ASTResolving.collectRelaxingTypes(collection, iTypeBinding3);
        }
    }

    public static String[] getUsedVariableNames(ASTNode aSTNode) {
        CompilationUnit compilationUnit = (CompilationUnit)aSTNode.getRoot();
        Collection collection = new ScopeAnalyzer(compilationUnit).getUsedVariableNames(aSTNode.getStartPosition(), aSTNode.getLength());
        return collection.toArray(new String[collection.size()]);
    }

    private static boolean isVariableDefinedInContext(IBinding iBinding, ITypeBinding iTypeBinding) {
        IVariableBinding iVariableBinding;
        if (iBinding.getKind() == 3 && (iBinding = (iVariableBinding = (IVariableBinding)iBinding).getDeclaringMethod()) == null) {
            iBinding = iVariableBinding.getDeclaringClass();
        }
        if (iBinding instanceof IMethodBinding) {
            if (iBinding == iTypeBinding.getDeclaringMethod()) {
                return true;
            }
            iBinding = ((IMethodBinding)iBinding).getDeclaringClass();
        }
        while (iBinding instanceof ITypeBinding) {
            if (iBinding == iTypeBinding.getDeclaringClass()) {
                return true;
            }
            if (Modifier.isStatic((int)iBinding.getModifiers())) break;
            iBinding = ((ITypeBinding)iBinding).getDeclaringClass();
        }
        return false;
    }

    public static boolean isUseableTypeInContext(ITypeBinding[] iTypeBindingArray, IBinding iBinding, boolean bl) {
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (!ASTResolving.isUseableTypeInContext(iTypeBindingArray[n], iBinding, bl)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isUseableTypeInContext(ITypeBinding iTypeBinding, IBinding iBinding, boolean bl) {
        if (iTypeBinding.isArray()) {
            iTypeBinding = iTypeBinding.getElementType();
        }
        if (iTypeBinding.isAnonymous()) {
            return false;
        }
        if (iTypeBinding.isRawType() || iTypeBinding.isPrimitive()) {
            return true;
        }
        if (iTypeBinding.isTypeVariable()) {
            return ASTResolving.isVariableDefinedInContext(iBinding, iTypeBinding);
        }
        if (iTypeBinding.isGenericType()) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeParameters();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                if (!ASTResolving.isUseableTypeInContext(iTypeBindingArray[n], iBinding, bl)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (iTypeBinding.isParameterizedType()) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                if (!ASTResolving.isUseableTypeInContext(iTypeBindingArray[n], iBinding, bl)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (iTypeBinding.isCapture()) {
            iTypeBinding = iTypeBinding.getWildcard();
        }
        if (iTypeBinding.isWildcardType()) {
            if (bl) {
                return false;
            }
            if (iTypeBinding.getBound() != null) {
                return ASTResolving.isUseableTypeInContext(iTypeBinding.getBound(), iBinding, bl);
            }
        }
        return true;
    }

    public static ITypeBinding normalizeWildcardType(ITypeBinding iTypeBinding, boolean bl, AST aST) {
        ITypeBinding iTypeBinding2 = iTypeBinding.getBound();
        if (bl) {
            if (iTypeBinding2 == null || !iTypeBinding.isUpperbound()) {
                return aST.resolveWellKnownType("java.lang.Object");
            }
        } else if (iTypeBinding2 == null || iTypeBinding.isUpperbound()) {
            return null;
        }
        return iTypeBinding2;
    }

    public static String getTypeSignature(ITypeBinding iTypeBinding) {
        return BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, BindingLabelProvider.DEFAULT_TEXTFLAGS);
    }

    public static String getMethodSignature(IMethodBinding iMethodBinding, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && !iMethodBinding.isConstructor()) {
            stringBuffer.append(iMethodBinding.getDeclaringClass().getTypeDeclaration().getName()).append('.');
        }
        return BindingLabelProvider.getBindingLabel((IBinding)iMethodBinding, BindingLabelProvider.DEFAULT_TEXTFLAGS);
    }

    public static String getMethodSignature(String string, ITypeBinding[] iTypeBindingArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append('(');
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (n > 0) {
                stringBuffer.append(JavaElementLabels.COMMA_STRING);
            }
            if (bl && n == iTypeBindingArray.length - 1) {
                stringBuffer.append(ASTResolving.getTypeSignature(iTypeBindingArray[n].getElementType()));
                stringBuffer.append("...");
            } else {
                stringBuffer.append(ASTResolving.getTypeSignature(iTypeBindingArray[n]));
            }
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static CompilationUnit createQuickFixAST(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) {
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setSource(iCompilationUnit);
        aSTParser.setResolveBindings(true);
        aSTParser.setStatementsRecovery(true);
        aSTParser.setBindingsRecovery(true);
        return (CompilationUnit)aSTParser.createAST(iProgressMonitor);
    }

    private static class AllBindingsVisitor
    extends GenericVisitor {
        private final TypeBindingVisitor fVisitor;

        public AllBindingsVisitor(TypeBindingVisitor typeBindingVisitor) {
            super(true);
            this.fVisitor = typeBindingVisitor;
        }

        public boolean visit(SimpleName simpleName) {
            ITypeBinding iTypeBinding = simpleName.resolveTypeBinding();
            if (iTypeBinding != null) {
                boolean bl = this.fVisitor.visit(iTypeBinding);
                if (bl) {
                    bl = Bindings.visitHierarchy(iTypeBinding, this.fVisitor);
                }
                if (!bl) {
                    throw new VisitCancelledException();
                }
            }
            return false;
        }

        private static class VisitCancelledException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            private VisitCancelledException() {
            }
        }
    }
}

