/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Iterator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaTokenComparator;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class CUCorrectionProposal
extends ChangeCorrectionProposal {
    private ICompilationUnit fCompilationUnit;
    private LinkedProposalModel fLinkedProposalModel;
    private final int surroundLines = 1;

    public CUCorrectionProposal(String string, ICompilationUnit iCompilationUnit, TextChange textChange, int n, Image image) {
        super(string, (Change)textChange, n, image);
        if (iCompilationUnit == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        this.fCompilationUnit = iCompilationUnit;
        this.fLinkedProposalModel = null;
    }

    protected CUCorrectionProposal(String string, ICompilationUnit iCompilationUnit, int n, Image image) {
        this(string, iCompilationUnit, null, n, image);
    }

    protected void addEdits(IDocument iDocument, TextEdit textEdit) throws CoreException {
    }

    protected LinkedProposalModel getLinkedProposalModel() {
        if (this.fLinkedProposalModel == null) {
            this.fLinkedProposalModel = new LinkedProposalModel();
        }
        return this.fLinkedProposalModel;
    }

    protected void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    public String getAdditionalProposalInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            TextChange textChange = this.getTextChange();
            IDocument iDocument = textChange.getPreviewDocument((IProgressMonitor)new NullProgressMonitor());
            String string = textChange.getCurrentContent((IProgressMonitor)new NullProgressMonitor());
            JavaTokenComparator javaTokenComparator = new JavaTokenComparator(iDocument.get());
            JavaTokenComparator javaTokenComparator2 = new JavaTokenComparator(string);
            RangeDifference[] rangeDifferenceArray = RangeDifferencer.findRanges((IRangeComparator)((IRangeComparator)javaTokenComparator), (IRangeComparator)((IRangeComparator)javaTokenComparator2));
            int n = 0;
            while (n < rangeDifferenceArray.length) {
                RangeDifference rangeDifference = rangeDifferenceArray[n];
                int n2 = javaTokenComparator.getTokenStart(rangeDifference.leftStart());
                int n3 = javaTokenComparator.getTokenStart(rangeDifference.leftEnd());
                if (rangeDifference.kind() == 2 && rangeDifference.leftLength() > 0) {
                    stringBuffer.append("<b>");
                    this.appendContent(iDocument, n2, n3, stringBuffer, false);
                    stringBuffer.append("</b>");
                } else if (rangeDifference.kind() == 0) {
                    this.appendContent(iDocument, n2, n3, stringBuffer, true);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        return stringBuffer.toString();
    }

    private void appendContent(IDocument iDocument, int n, int n2, StringBuffer stringBuffer, boolean bl) throws BadLocationException {
        int n3 = iDocument.getLineOfOffset(n);
        int n4 = iDocument.getLineOfOffset(n2);
        boolean bl2 = false;
        if (bl && n == 0) {
            n3 = Math.max(n4 - 1, 0);
            stringBuffer.append("...<br>");
            bl2 = true;
        }
        int n5 = n3;
        while (n5 <= n4) {
            if (bl && n5 - n3 > 1 && n4 - n5 > 1) {
                if (!bl2) {
                    stringBuffer.append("...<br>");
                    bl2 = true;
                } else if (n2 == iDocument.getLength()) {
                    return;
                }
            } else {
                IRegion iRegion = iDocument.getLineInformation(n5);
                int n6 = iRegion.getOffset();
                int n7 = n6 + iRegion.getLength();
                int n8 = Math.max(n6, n);
                int n9 = Math.min(n7, n2);
                String string = iDocument.get(n8, n9 - n8);
                if (!bl || n8 != n6 || !Strings.containsOnlyWhitespaces(string)) {
                    int n10 = 0;
                    while (n10 < string.length()) {
                        char c = string.charAt(n10);
                        if (c == '<') {
                            stringBuffer.append("&lt;");
                        } else if (c == '>') {
                            stringBuffer.append("&gt;");
                        } else {
                            stringBuffer.append(c);
                        }
                        ++n10;
                    }
                    if (n9 == n7 && n9 != n2) {
                        stringBuffer.append("<br>");
                    }
                }
            }
            ++n5;
        }
    }

    public void apply(IDocument iDocument) {
        try {
            ICompilationUnit iCompilationUnit = this.getCompilationUnit();
            IEditorPart iEditorPart = null;
            if (iCompilationUnit.getResource().exists()) {
                IWorkbenchPage iWorkbenchPage;
                boolean bl = this.performValidateEdit(iCompilationUnit);
                if (!bl) {
                    return;
                }
                iEditorPart = EditorUtility.isOpenInEditor(iCompilationUnit);
                if (iEditorPart == null && (iEditorPart = JavaUI.openInEditor((IJavaElement)iCompilationUnit)) != null) {
                    iDocument = JavaUI.getDocumentProvider().getDocument((Object)iEditorPart.getEditorInput());
                }
                if ((iWorkbenchPage = JavaPlugin.getActivePage()) != null && iEditorPart != null) {
                    iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
                }
                if (iEditorPart != null) {
                    iEditorPart.setFocus();
                }
            }
            this.performChange(iEditorPart, iDocument);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, CorrectionMessages.CUCorrectionProposal_error_title, CorrectionMessages.CUCorrectionProposal_error_message);
        }
    }

    private boolean performValidateEdit(ICompilationUnit iCompilationUnit) {
        IStatus iStatus = Resources.makeCommittable(iCompilationUnit.getResource(), (Object)JavaPlugin.getActiveWorkbenchShell());
        if (!iStatus.isOK()) {
            String string = CorrectionMessages.CUCorrectionProposal_error_title;
            String string2 = CorrectionMessages.CUCorrectionProposal_error_message;
            ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)string, (String)string2, (IStatus)iStatus);
            return false;
        }
        return true;
    }

    protected void performChange(IEditorPart iEditorPart, IDocument iDocument) throws CoreException {
        try {
            super.performChange(iEditorPart, iDocument);
            if (iEditorPart == null) {
                return;
            }
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroup.PositionInformation positionInformation;
                if (this.fLinkedProposalModel.hasLinkedPositions() && iEditorPart instanceof JavaEditor) {
                    ISourceViewer iSourceViewer = ((JavaEditor)iEditorPart).getViewer();
                    this.enterLinkedMode((ITextViewer)iSourceViewer, iEditorPart);
                } else if (iEditorPart instanceof ITextEditor && (positionInformation = this.fLinkedProposalModel.getEndPosition()) != null) {
                    int n = positionInformation.getOffset() + positionInformation.getLength();
                    ((ITextEditor)iEditorPart).selectAndReveal(n, 0);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(JavaUIStatus.createError(4, badLocationException));
        }
    }

    private void enterLinkedMode(ITextViewer iTextViewer, IEditorPart iEditorPart) throws BadLocationException {
        IRegion iRegion;
        Object object;
        LinkedProposalPositionGroup linkedProposalPositionGroup;
        IDocument iDocument = iTextViewer.getDocument();
        LinkedModeModel linkedModeModel = new LinkedModeModel();
        boolean bl = false;
        Iterator iterator = this.fLinkedProposalModel.getPositionGroupIterator();
        while (iterator.hasNext()) {
            linkedProposalPositionGroup = (LinkedProposalPositionGroup)iterator.next();
            object = new LinkedPositionGroup();
            iRegion = linkedProposalPositionGroup.getPositions();
            if (((LinkedProposalPositionGroup.PositionInformation[])iRegion).length <= 0) continue;
            LinkedProposalPositionGroup.Proposal[] proposalArray = linkedProposalPositionGroup.getProposals();
            if (proposalArray.length <= 1) {
                int n = 0;
                while (n < ((LinkedProposalPositionGroup.PositionInformation[])iRegion).length) {
                    LinkedProposalPositionGroup.PositionInformation positionInformation = iRegion[n];
                    if (positionInformation.getOffset() != -1) {
                        object.addPosition(new LinkedPosition(iDocument, positionInformation.getOffset(), positionInformation.getLength(), positionInformation.getSequenceRank()));
                    }
                    ++n;
                }
            } else {
                ICompletionProposal[] iCompletionProposalArray = new LinkedPositionProposalImpl[proposalArray.length];
                int n = 0;
                while (n < proposalArray.length) {
                    iCompletionProposalArray[n] = new LinkedPositionProposalImpl(proposalArray[n], linkedModeModel);
                    ++n;
                }
                n = 0;
                while (n < ((IRegion)iRegion).length) {
                    IRegion iRegion2 = iRegion[n];
                    if (iRegion2.getOffset() != -1) {
                        object.addPosition((LinkedPosition)new ProposalPosition(iDocument, iRegion2.getOffset(), iRegion2.getLength(), iRegion2.getSequenceRank(), iCompletionProposalArray));
                    }
                    ++n;
                }
            }
            linkedModeModel.addGroup((LinkedPositionGroup)object);
            bl = true;
        }
        linkedModeModel.forceInstall();
        if (iEditorPart instanceof JavaEditor) {
            linkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer((JavaEditor)iEditorPart));
        }
        if (bl) {
            linkedProposalPositionGroup = new EditorLinkedModeUI(linkedModeModel, iTextViewer);
            object = this.fLinkedProposalModel.getEndPosition();
            if (object != null && ((LinkedProposalPositionGroup.PositionInformation)object).getOffset() != -1) {
                linkedProposalPositionGroup.setExitPosition(iTextViewer, ((LinkedProposalPositionGroup.PositionInformation)object).getOffset() + ((LinkedProposalPositionGroup.PositionInformation)object).getLength(), 0, Integer.MAX_VALUE);
            } else {
                int n = iTextViewer.getSelectedRange().x;
                if (n != 0) {
                    linkedProposalPositionGroup.setExitPosition(iTextViewer, n, 0, Integer.MAX_VALUE);
                }
            }
            linkedProposalPositionGroup.setExitPolicy(new LinkedModeExitPolicy());
            linkedProposalPositionGroup.enter();
            iRegion = linkedProposalPositionGroup.getSelectedRegion();
            iTextViewer.setSelectedRange(iRegion.getOffset(), iRegion.getLength());
            iTextViewer.revealRange(iRegion.getOffset(), iRegion.getLength());
        }
    }

    protected TextChange createTextChange() throws CoreException {
        Object object;
        Document document;
        Object object2;
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        String string = this.getName();
        if (!iCompilationUnit.getResource().exists()) {
            try {
                object2 = iCompilationUnit.getSource();
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                object2 = new String();
            }
            document = new Document(object2);
            document.setInitialLineDelimiter(StubUtility.getLineDelimiterUsed((IJavaElement)iCompilationUnit));
            object = new DocumentChange(string, (IDocument)document);
        } else {
            object2 = new CompilationUnitChange(string, iCompilationUnit);
            object2.setSaveMode(4);
            object = object2;
        }
        object2 = new MultiTextEdit();
        object.setEdit((TextEdit)object2);
        document = object.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
        this.addEdits((IDocument)document, (TextEdit)object2);
        return object;
    }

    protected final Change createChange() throws CoreException {
        return this.createTextChange();
    }

    public final TextChange getTextChange() throws CoreException {
        return (TextChange)this.getChange();
    }

    public final ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getPreviewContent() throws CoreException {
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }

    private static class LinkedModeExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private LinkedModeExitPolicy() {
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel linkedModeModel, VerifyEvent verifyEvent, int n, int n2) {
            if (verifyEvent.character == '=') {
                return new LinkedModeUI.ExitFlags(1, true);
            }
            return null;
        }
    }

    private static class LinkedPositionProposalImpl
    implements ICompletionProposalExtension2,
    IJavaCompletionProposal {
        private final LinkedProposalPositionGroup.Proposal fProposal;
        private final LinkedModeModel fLinkedPositionModel;

        public LinkedPositionProposalImpl(LinkedProposalPositionGroup.Proposal proposal, LinkedModeModel linkedModeModel) {
            this.fProposal = proposal;
            this.fLinkedPositionModel = linkedModeModel;
        }

        public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
            IDocument iDocument = iTextViewer.getDocument();
            LinkedPosition linkedPosition = this.fLinkedPositionModel.findPosition(new LinkedPosition(iDocument, n2, 0));
            if (linkedPosition != null) {
                try {
                    try {
                        TextEdit textEdit = this.fProposal.computeEdits(n2, linkedPosition, c, n, this.fLinkedPositionModel);
                        if (textEdit != null) {
                            textEdit.apply(linkedPosition.getDocument(), 0);
                        }
                    }
                    catch (MalformedTreeException malformedTreeException) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, "Unexpected exception applying edit", (Throwable)malformedTreeException));
                    }
                    catch (BadLocationException badLocationException) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, "Unexpected exception applying edit", (Throwable)badLocationException));
                    }
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
            }
        }

        public String getDisplayString() {
            return this.fProposal.getDisplayString();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }

        public int getRelevance() {
            return this.fProposal.getRelevance();
        }

        public void apply(IDocument iDocument) {
        }

        public String getAdditionalProposalInfo() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public Point getSelection(IDocument iDocument) {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void selected(ITextViewer iTextViewer, boolean bl) {
        }

        public void unselected(ITextViewer iTextViewer) {
        }

        public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
            String string = this.getDisplayString();
            LinkedPosition linkedPosition = this.fLinkedPositionModel.findPosition(new LinkedPosition(iDocument, n, 0));
            int n2 = linkedPosition != null ? linkedPosition.getOffset() : Math.max(0, n - string.length());
            int n3 = n - n2;
            if (n <= iDocument.getLength()) {
                try {
                    String string2 = iDocument.get(n2, n3);
                    if (string.startsWith(string2)) {
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    JavaPlugin.log(badLocationException);
                }
            }
            return false;
        }
    }
}

