/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class CastCompletionProposal
extends LinkedCorrectionProposal {
    public static final String ADD_CAST_ID = "org.eclipse.wst.jsdt.ui.correction.addCast";
    private Expression fNodeToCast;
    private final Object fCastType;

    public CastCompletionProposal(String string, ICompilationUnit iCompilationUnit, Expression expression, String string2, int n) {
        super(string, iCompilationUnit, (ASTRewrite)null, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_cast.gif"));
        this.fNodeToCast = expression;
        this.fCastType = string2;
        this.setCommandId(ADD_CAST_ID);
    }

    public CastCompletionProposal(String string, ICompilationUnit iCompilationUnit, Expression expression, ITypeBinding iTypeBinding, int n) {
        super(string, iCompilationUnit, (ASTRewrite)null, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_cast.gif"));
        this.fNodeToCast = expression;
        this.fCastType = iTypeBinding;
        this.setCommandId(ADD_CAST_ID);
    }

    private Type getNewCastTypeNode(ASTRewrite aSTRewrite, ImportRewrite importRewrite) throws CoreException {
        MethodInvocation methodInvocation;
        AST aST = aSTRewrite.getAST();
        if (this.fCastType != null) {
            if (this.fCastType instanceof ITypeBinding) {
                return importRewrite.addImport((ITypeBinding)this.fCastType, aST);
            }
            String string = importRewrite.addImport((String)this.fCastType);
            return ASTNodeFactory.newType(aST, string);
        }
        Expression expression = this.fNodeToCast;
        ASTNode aSTNode = expression.getParent();
        if (aSTNode instanceof CastExpression) {
            expression = aSTNode;
            aSTNode = aSTNode.getParent();
        }
        while (aSTNode instanceof ParenthesizedExpression) {
            expression = aSTNode;
            aSTNode = aSTNode.getParent();
        }
        if (aSTNode instanceof MethodInvocation && (methodInvocation = (MethodInvocation)expression.getParent()).getExpression() == expression) {
            IBinding iBinding = ASTResolving.getParentMethodOrTypeBinding((ASTNode)expression);
            ITypeBinding[] iTypeBindingArray = ASTResolving.getQualifierGuess(expression.getRoot(), methodInvocation.getName().getIdentifier(), methodInvocation.arguments(), iBinding);
            if (iTypeBindingArray.length > 0) {
                ITypeBinding iTypeBinding = this.getCastFavorite(iTypeBindingArray, this.fNodeToCast.resolveTypeBinding());
                Type type = importRewrite.addImport(iTypeBinding, aST);
                this.addLinkedPosition(aSTRewrite.track((ASTNode)type), true, "casttype");
                int n = 0;
                while (n < iTypeBindingArray.length) {
                    this.addLinkedPositionProposal("casttype", iTypeBindingArray[n]);
                    ++n;
                }
                return type;
            }
        }
        methodInvocation = aST.newSimpleType((Name)aST.newSimpleName("Object"));
        this.addLinkedPosition(aSTRewrite.track((ASTNode)methodInvocation), true, "casttype");
        return methodInvocation;
    }

    private ITypeBinding getCastFavorite(ITypeBinding[] iTypeBindingArray, ITypeBinding iTypeBinding) {
        if (iTypeBinding == null) {
            return iTypeBindingArray[0];
        }
        ITypeBinding iTypeBinding2 = iTypeBindingArray[0];
        int n = 0;
        while (n < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding3 = iTypeBindingArray[n];
            if (iTypeBinding.isCastCompatible(iTypeBinding3)) {
                return iTypeBinding3;
            }
            if (iTypeBinding3.isInterface()) {
                iTypeBinding2 = iTypeBinding3;
            }
            ++n;
        }
        return iTypeBinding2;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        AST aST = this.fNodeToCast.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)this.fNodeToCast.getRoot());
        Type type = this.getNewCastTypeNode(aSTRewrite, importRewrite);
        if (this.fNodeToCast.getNodeType() == 11) {
            CastExpression castExpression = (CastExpression)this.fNodeToCast;
            aSTRewrite.replace((ASTNode)castExpression.getType(), (ASTNode)type, null);
        } else {
            ParenthesizedExpression parenthesizedExpression;
            Expression expression = (Expression)aSTRewrite.createCopyTarget((ASTNode)this.fNodeToCast);
            if (CastCompletionProposal.needsInnerParantheses((ASTNode)this.fNodeToCast)) {
                parenthesizedExpression = aST.newParenthesizedExpression();
                parenthesizedExpression.setExpression(expression);
                expression = parenthesizedExpression;
            }
            parenthesizedExpression = aST.newCastExpression();
            parenthesizedExpression.setExpression(expression);
            parenthesizedExpression.setType(type);
            ParenthesizedExpression parenthesizedExpression2 = parenthesizedExpression;
            if (CastCompletionProposal.needsOuterParantheses((ASTNode)this.fNodeToCast)) {
                ParenthesizedExpression parenthesizedExpression3 = aST.newParenthesizedExpression();
                parenthesizedExpression3.setExpression((Expression)parenthesizedExpression);
                parenthesizedExpression2 = parenthesizedExpression3;
            }
            aSTRewrite.replace((ASTNode)this.fNodeToCast, (ASTNode)parenthesizedExpression2, null);
        }
        return aSTRewrite;
    }

    private static boolean needsInnerParantheses(ASTNode aSTNode) {
        int n = aSTNode.getNodeType();
        return n == 27 || n == 16 || n == 7 || n == 62;
    }

    private static boolean needsOuterParantheses(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getParent();
        return aSTNode2 instanceof MethodInvocation ? ((MethodInvocation)aSTNode2).getExpression() == aSTNode : (aSTNode2 instanceof QualifiedName ? ((QualifiedName)aSTNode2).getQualifier() == aSTNode : aSTNode2 instanceof FieldAccess && ((FieldAccess)aSTNode2).getExpression() == aSTNode);
    }
}

