/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.wst.jsdt.core.CorrectionEngine;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MultiStateCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.FixCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CorrectionMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker iMarker) {
        return CorrectionMarkerResolutionGenerator.internalHasResolutions(iMarker);
    }

    public IMarkerResolution[] getResolutions(IMarker iMarker) {
        return CorrectionMarkerResolutionGenerator.internalGetResolutions(iMarker);
    }

    private static boolean internalHasResolutions(IMarker iMarker) {
        int n = iMarker.getAttribute("id", -1);
        ICompilationUnit iCompilationUnit = CorrectionMarkerResolutionGenerator.getCompilationUnit(iMarker);
        return iCompilationUnit != null && JavaCorrectionProcessor.hasCorrections(iCompilationUnit, n, MarkerUtilities.getMarkerType((IMarker)iMarker));
    }

    private static IMarkerResolution[] internalGetResolutions(IMarker iMarker) {
        if (!CorrectionMarkerResolutionGenerator.internalHasResolutions(iMarker)) {
            return NO_RESOLUTIONS;
        }
        try {
            IProblemLocation iProblemLocation;
            IEditorInput iEditorInput;
            ICompilationUnit iCompilationUnit = CorrectionMarkerResolutionGenerator.getCompilationUnit(iMarker);
            if (iCompilationUnit != null && (iEditorInput = EditorUtility.getEditorInput(iCompilationUnit)) != null && (iProblemLocation = CorrectionMarkerResolutionGenerator.findProblemLocation(iEditorInput, iMarker)) != null) {
                AssistContext assistContext = new AssistContext(iCompilationUnit, iProblemLocation.getOffset(), iProblemLocation.getLength());
                if (!CorrectionMarkerResolutionGenerator.hasProblem(assistContext.getASTRoot().getProblems(), iProblemLocation)) {
                    return NO_RESOLUTIONS;
                }
                ArrayList arrayList = new ArrayList();
                JavaCorrectionProcessor.collectCorrections(assistContext, new IProblemLocation[]{iProblemLocation}, arrayList);
                Collections.sort(arrayList, new CompletionProposalComparator());
                int n = arrayList.size();
                IMarkerResolution[] iMarkerResolutionArray = new IMarkerResolution[n];
                int n2 = 0;
                while (n2 < n) {
                    iMarkerResolutionArray[n2] = new CorrectionMarkerResolution(assistContext.getCompilationUnit(), iProblemLocation.getOffset(), iProblemLocation.getLength(), (IJavaCompletionProposal)arrayList.get(n2), iMarker);
                    ++n2;
                }
                return iMarkerResolutionArray;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return NO_RESOLUTIONS;
    }

    private static boolean hasProblem(IProblem[] iProblemArray, IProblemLocation iProblemLocation) {
        int n = 0;
        while (n < iProblemArray.length) {
            IProblem iProblem = iProblemArray[n];
            if (iProblem.getID() == iProblemLocation.getProblemId() && iProblem.getSourceStart() == iProblemLocation.getOffset()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static ICompilationUnit getCompilationUnit(IMarker iMarker) {
        IJavaElement iJavaElement;
        IResource iResource = iMarker.getResource();
        if (iResource instanceof IFile && iResource.isAccessible() && (iJavaElement = JavaCore.create((IFile)((IFile)iResource))) instanceof ICompilationUnit) {
            return (ICompilationUnit)iJavaElement;
        }
        return null;
    }

    private static IProblemLocation findProblemLocation(IEditorInput iEditorInput, IMarker iMarker) {
        IAnnotationModel iAnnotationModel = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getAnnotationModel(iEditorInput);
        if (iAnnotationModel != null) {
            Iterator iterator = iAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Position position;
                JavaMarkerAnnotation javaMarkerAnnotation;
                Object e = iterator.next();
                if (!(e instanceof JavaMarkerAnnotation) || !iMarker.equals((Object)(javaMarkerAnnotation = (JavaMarkerAnnotation)e).getMarker()) || (position = iAnnotationModel.getPosition((Annotation)javaMarkerAnnotation)) == null) continue;
                return new ProblemLocation(position.getOffset(), position.getLength(), javaMarkerAnnotation);
            }
        } else {
            ICompilationUnit iCompilationUnit = CorrectionMarkerResolutionGenerator.getCompilationUnit(iMarker);
            return CorrectionMarkerResolutionGenerator.createFromMarker(iMarker, iCompilationUnit);
        }
        return null;
    }

    private static IProblemLocation createFromMarker(IMarker iMarker, ICompilationUnit iCompilationUnit) {
        try {
            int n = iMarker.getAttribute("id", -1);
            int n2 = iMarker.getAttribute("charStart", -1);
            int n3 = iMarker.getAttribute("charEnd", -1);
            int n4 = iMarker.getAttribute("severity", 0);
            String[] stringArray = CorrectionEngine.getProblemArguments((IMarker)iMarker);
            String string = iMarker.getType();
            if (iCompilationUnit != null && n != -1 && n2 != -1 && n3 != -1 && stringArray != null) {
                boolean bl = n4 == 2;
                return new ProblemLocation(n2, n3 - n2, n, stringArray, bl, string);
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        return null;
    }

    public static class CorrectionMarkerResolution
    extends WorkbenchMarkerResolution {
        private static final IMarker[] NO_MARKERS = new IMarker[0];
        private static final int BATCH_SIZE = 40;
        private ICompilationUnit fCompilationUnit;
        private int fOffset;
        private int fLength;
        private IJavaCompletionProposal fProposal;
        private final IMarker fMarker;

        public CorrectionMarkerResolution(ICompilationUnit iCompilationUnit, int n, int n2, IJavaCompletionProposal iJavaCompletionProposal, IMarker iMarker) {
            this.fCompilationUnit = iCompilationUnit;
            this.fOffset = n;
            this.fLength = n2;
            this.fProposal = iJavaCompletionProposal;
            this.fMarker = iMarker;
        }

        public String getLabel() {
            return this.fProposal.getDisplayString();
        }

        public void run(IMarker iMarker) {
            try {
                IEditorPart iEditorPart = EditorUtility.isOpenInEditor(this.fCompilationUnit);
                if (iEditorPart == null && (iEditorPart = JavaUI.openInEditor((IJavaElement)this.fCompilationUnit, true, false)) instanceof ITextEditor) {
                    ((ITextEditor)iEditorPart).selectAndReveal(this.fOffset, this.fLength);
                }
                if (iEditorPart != null) {
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    IDocument iDocument = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(iEditorInput);
                    this.fProposal.apply(iDocument);
                }
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IMarker[] iMarkerArray, IProgressMonitor iProgressMonitor) {
            if (iMarkerArray.length == 1) {
                this.run(iMarkerArray[0]);
                return;
            }
            IProgressMonitor iProgressMonitor2 = iProgressMonitor;
            if (iProgressMonitor2 == null) {
                iProgressMonitor2 = new NullProgressMonitor();
            }
            try {
                block31: {
                    List list;
                    IJavaProject iJavaProject;
                    Object object;
                    IProblemLocation iProblemLocation;
                    block34: {
                        block33: {
                            block32: {
                                ICompilationUnit iCompilationUnit;
                                Object object2;
                                Object object3;
                                ICleanUp iCleanUp;
                                if (!(this.fProposal instanceof FixCorrectionProposal) || (iCleanUp = ((FixCorrectionProposal)this.fProposal).getCleanUp()) == null) break block31;
                                Hashtable hashtable = new Hashtable();
                                int n = 0;
                                while (n < iMarkerArray.length) {
                                    object3 = iMarkerArray[n];
                                    object2 = CorrectionMarkerResolutionGenerator.getCompilationUnit((IMarker)object3);
                                    if (object2 != null) {
                                        try {
                                            iCompilationUnit = EditorUtility.getEditorInput(object2);
                                            iProblemLocation = CorrectionMarkerResolutionGenerator.findProblemLocation((IEditorInput)iCompilationUnit, (IMarker)object3);
                                            if (iProblemLocation != null) {
                                                if (!hashtable.containsKey(object2.getPrimary())) {
                                                    hashtable.put(object2.getPrimary(), new ArrayList());
                                                }
                                                object = (List)hashtable.get(object2.getPrimary());
                                                object.add(iProblemLocation);
                                            }
                                        }
                                        catch (JavaModelException javaModelException) {
                                            JavaPlugin.log(javaModelException);
                                        }
                                    }
                                    ++n;
                                }
                                if (hashtable.size() <= 0) break block31;
                                Set set = hashtable.keySet();
                                object3 = new Hashtable();
                                object2 = set.iterator();
                                while (object2.hasNext()) {
                                    iCompilationUnit = (ICompilationUnit)object2.next();
                                    iProblemLocation = iCompilationUnit.getJavaProject();
                                    if (!((Hashtable)object3).containsKey(iProblemLocation)) {
                                        ((Hashtable)object3).put(iProblemLocation, new ArrayList());
                                    }
                                    ((List)((Hashtable)object3).get(iProblemLocation)).add(iCompilationUnit);
                                }
                                iProgressMonitor2.beginTask("", hashtable.size() * 2 + 2 + ((Hashtable)object3).keySet().size());
                                object2 = "";
                                iCompilationUnit = iCleanUp.getDescriptions();
                                if (iCompilationUnit != null && ((String[])iCompilationUnit).length == 1) {
                                    object2 = iCompilationUnit[0];
                                }
                                iProblemLocation = new CompositeChange((String)object2);
                                object = ((Hashtable)object3).keySet().iterator();
                                while (object.hasNext()) {
                                    Object var16_20;
                                    iJavaProject = (IJavaProject)object.next();
                                    list = (List)((Hashtable)object3).get(iJavaProject);
                                    ICompilationUnit[] iCompilationUnitArray = list.toArray(new ICompilationUnit[list.size()]);
                                    try {
                                        try {
                                            this.cleanUpProject(iJavaProject, iCompilationUnitArray, iCleanUp, hashtable, (CompositeChange)iProblemLocation, iProgressMonitor2);
                                        }
                                        catch (CoreException coreException) {
                                            JavaPlugin.log(coreException);
                                        }
                                        var16_20 = null;
                                    }
                                    catch (Throwable throwable) {
                                        var16_20 = null;
                                        iProgressMonitor2.worked(1);
                                        throw throwable;
                                    }
                                    iProgressMonitor2.worked(1);
                                }
                                if (!iProgressMonitor2.isCanceled()) break block32;
                                break block33;
                            }
                            iProblemLocation.initializeValidationData((IProgressMonitor)new SubProgressMonitor(iProgressMonitor2, 1));
                            if (this.validChanges((CompositeChange)iProblemLocation)) break block34;
                        }
                        Object var18_22 = null;
                        iProgressMonitor2.done();
                        return;
                    }
                    object = new PerformChangeOperation((Change)iProblemLocation);
                    object.setUndoManager(RefactoringCore.getUndoManager(), iProblemLocation.getName());
                    try {
                        try {
                            object.run((IProgressMonitor)new SubProgressMonitor(iProgressMonitor2, 1));
                        }
                        catch (CoreException coreException) {
                            JavaPlugin.log(coreException);
                        }
                        list = null;
                    }
                    catch (Throwable throwable) {
                        list = null;
                        iProgressMonitor2.worked(1);
                        throw throwable;
                    }
                    iProgressMonitor2.worked(1);
                    iJavaProject = EditorUtility.isOpenInEditor(this.fCompilationUnit);
                    if (iJavaProject instanceof ITextEditor) {
                        ((ITextEditor)iJavaProject).selectAndReveal(this.fOffset, this.fLength);
                        iJavaProject.setFocus();
                    }
                }
                Object var18_24 = null;
            }
            catch (Throwable throwable) {
                Object var18_23 = null;
                iProgressMonitor2.done();
                throw throwable;
            }
            iProgressMonitor2.done();
        }

        private boolean validChanges(CompositeChange compositeChange) {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            ArrayList arrayList = new ArrayList();
            try {
                this.findFilesToBeModified(compositeChange, arrayList);
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                return false;
            }
            refactoringStatus.merge(Checks.validateModifiesFiles(arrayList.toArray(new IFile[arrayList.size()]), JavaPlugin.getActiveWorkbenchShell().getShell()));
            if (refactoringStatus.hasFatalError()) {
                MultiStatus multiStatus;
                RefactoringStatusEntry[] refactoringStatusEntryArray = refactoringStatus.getEntries();
                if (refactoringStatusEntryArray.length > 1) {
                    multiStatus = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, refactoringStatus.getMessageMatchingSeverity(3), null);
                    int n = 0;
                    while (n < refactoringStatusEntryArray.length) {
                        multiStatus.add((IStatus)new Status(refactoringStatusEntryArray[n].getSeverity(), "org.eclipse.wst.jsdt.ui", 0, refactoringStatusEntryArray[n].getMessage(), null));
                        ++n;
                    }
                } else {
                    RefactoringStatusEntry refactoringStatusEntry = refactoringStatusEntryArray[0];
                    multiStatus = new Status(refactoringStatusEntry.getSeverity(), "org.eclipse.wst.jsdt.ui", 0, refactoringStatusEntry.getMessage(), null);
                }
                ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell().getShell(), (String)CorrectionMessages.CorrectionMarkerResolutionGenerator__multiFixErrorDialog_Titel, (String)CorrectionMessages.CorrectionMarkerResolutionGenerator_multiFixErrorDialog_description, (IStatus)multiStatus);
                return false;
            }
            return true;
        }

        private void findFilesToBeModified(CompositeChange compositeChange, List list) throws JavaModelException {
            Change[] changeArray = compositeChange.getChildren();
            int n = 0;
            while (n < changeArray.length) {
                Change change = changeArray[n];
                if (change instanceof CompositeChange) {
                    this.findFilesToBeModified((CompositeChange)change, list);
                } else if (change instanceof MultiStateCompilationUnitChange) {
                    list.add(((MultiStateCompilationUnitChange)change).getCompilationUnit().getCorrespondingResource());
                } else if (change instanceof CompilationUnitChange) {
                    list.add(((CompilationUnitChange)change).getCompilationUnit().getCorrespondingResource());
                }
                ++n;
            }
        }

        private void cleanUpProject(IJavaProject iJavaProject, ICompilationUnit[] iCompilationUnitArray, ICleanUp iCleanUp, Hashtable hashtable, CompositeChange compositeChange, IProgressMonitor iProgressMonitor) throws CoreException {
            iCleanUp.checkPreConditions(iJavaProject, iCompilationUnitArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
                CompilationUnit compilationUnit = CorrectionMarkerResolution.getASTRoot(iCompilationUnit, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                List list = (List)hashtable.get(iCompilationUnit);
                IProblemLocation[] iProblemLocationArray = list.toArray(new IProblemLocation[list.size()]);
                IFix iFix = iCleanUp.createFix(compilationUnit, iProblemLocationArray);
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                if (iFix != null) {
                    TextChange textChange = iFix.createChange();
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    compositeChange.add((Change)textChange);
                    iProgressMonitor.worked(1);
                }
                ++n;
            }
            iCleanUp.checkPostConditions(null);
        }

        public String getDescription() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }

        public IMarker[] findOtherMarkers(IMarker[] iMarkerArray) {
            if (!(this.fProposal instanceof FixCorrectionProposal)) {
                return NO_MARKERS;
            }
            FixCorrectionProposal fixCorrectionProposal = (FixCorrectionProposal)this.fProposal;
            ICleanUp iCleanUp = fixCorrectionProposal.getCleanUp();
            if (iCleanUp == null) {
                return NO_MARKERS;
            }
            Hashtable hashtable = this.getMarkersForFiles(iMarkerArray);
            if (hashtable.isEmpty()) {
                return NO_MARKERS;
            }
            Hashtable hashtable2 = this.getCompilationUnitsForProjects(hashtable);
            if (hashtable2.size() == 0) {
                return NO_MARKERS;
            }
            ArrayList arrayList = new ArrayList();
            Iterator iterator = hashtable2.keySet().iterator();
            while (iterator.hasNext()) {
                IJavaProject iJavaProject = (IJavaProject)iterator.next();
                List list = (List)hashtable2.get(iJavaProject);
                ASTParser aSTParser = CorrectionMarkerResolution.getParser(iJavaProject);
                int n = 0;
                int n2 = 0;
                while (n2 < list.size()) {
                    n2 = Math.min(n + 40, list.size());
                    List list2 = list.subList(n, n2);
                    ICompilationUnit[] iCompilationUnitArray = list2.toArray(new ICompilationUnit[list2.size()]);
                    aSTParser.createASTs(iCompilationUnitArray, new String[0], new ASTRequestor(this, hashtable, iCleanUp, arrayList){
                        final /* synthetic */ CorrectionMarkerResolution this$1;
                        private final /* synthetic */ Hashtable val$fileMarkerTable;
                        private final /* synthetic */ ICleanUp val$cleanUp;
                        private final /* synthetic */ List val$result;
                        {
                            this.this$1 = correctionMarkerResolution;
                            this.val$fileMarkerTable = hashtable;
                            this.val$cleanUp = iCleanUp;
                            this.val$result = list;
                        }

                        public void acceptAST(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit) {
                            try {
                                IEditorInput iEditorInput = EditorUtility.getEditorInput(iCompilationUnit);
                                List list = (List)this.val$fileMarkerTable.get(iCompilationUnit.getResource());
                                Iterator<E> iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    IMarker iMarker = (IMarker)iterator.next();
                                    IProblemLocation iProblemLocation = CorrectionMarkerResolutionGenerator.access$1(iEditorInput, iMarker);
                                    if (iProblemLocation == null || !this.val$cleanUp.canFix(compilationUnit, iProblemLocation)) continue;
                                    this.val$result.add(iMarker);
                                }
                            }
                            catch (CoreException coreException) {
                                JavaPlugin.log(coreException);
                            }
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                    n = n2;
                }
            }
            if (arrayList.size() == 0) {
                return NO_MARKERS;
            }
            return arrayList.toArray(new IMarker[arrayList.size()]);
        }

        private Hashtable getMarkersForFiles(IMarker[] iMarkerArray) {
            String string;
            Hashtable<IResource, ArrayList<IMarker>> hashtable = new Hashtable<IResource, ArrayList<IMarker>>();
            try {
                string = this.fMarker.getType();
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
                return hashtable;
            }
            int n = 0;
            while (n < iMarkerArray.length) {
                IMarker iMarker = iMarkerArray[n];
                if (!iMarker.equals((Object)this.fMarker)) {
                    IResource iResource;
                    String string2 = null;
                    try {
                        string2 = iMarker.getType();
                    }
                    catch (CoreException coreException) {
                        JavaPlugin.log(coreException);
                    }
                    if (string2 != null && string2.equals(string) && (iResource = iMarker.getResource()) instanceof IFile && iResource.isAccessible()) {
                        ArrayList<IMarker> arrayList = (ArrayList<IMarker>)hashtable.get(iResource);
                        if (arrayList == null) {
                            arrayList = new ArrayList<IMarker>();
                            hashtable.put(iResource, arrayList);
                        }
                        arrayList.add(iMarker);
                    }
                }
                ++n;
            }
            return hashtable;
        }

        private Hashtable getCompilationUnitsForProjects(Hashtable hashtable) {
            Hashtable<IJavaProject, ArrayList<ICompilationUnit>> hashtable2 = new Hashtable<IJavaProject, ArrayList<ICompilationUnit>>();
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                IFile iFile = (IFile)iterator.next();
                IJavaElement iJavaElement = JavaCore.create((IFile)iFile);
                if (!(iJavaElement instanceof ICompilationUnit)) continue;
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement;
                ArrayList<ICompilationUnit> arrayList = (ArrayList<ICompilationUnit>)hashtable2.get(iCompilationUnit.getJavaProject());
                if (arrayList == null) {
                    arrayList = new ArrayList<ICompilationUnit>();
                    hashtable2.put(iCompilationUnit.getJavaProject(), arrayList);
                }
                arrayList.add(iCompilationUnit);
            }
            return hashtable2;
        }

        private static ASTParser getParser(IJavaProject iJavaProject) {
            ASTParser aSTParser = ASTParser.newParser((int)3);
            aSTParser.setResolveBindings(true);
            aSTParser.setProject(iJavaProject);
            return aSTParser;
        }

        private static CompilationUnit getASTRoot(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) {
            CompilationUnit compilationUnit = ASTProvider.getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_YES, iProgressMonitor);
            if (compilationUnit == null) {
                compilationUnit = ASTResolving.createQuickFixAST(iCompilationUnit, iProgressMonitor);
            }
            return compilationUnit;
        }
    }
}

