/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class MissingReturnTypeCorrectionProposal
extends LinkedCorrectionProposal {
    private static final String RETURN_EXPRESSION_KEY = "value";
    private MethodDeclaration fMethodDecl;
    private ReturnStatement fExistingReturn;

    public MissingReturnTypeCorrectionProposal(ICompilationUnit iCompilationUnit, MethodDeclaration methodDeclaration, ReturnStatement returnStatement, int n) {
        super("", iCompilationUnit, (ASTRewrite)null, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        this.fMethodDecl = methodDeclaration;
        this.fExistingReturn = returnStatement;
    }

    public String getDisplayString() {
        if (this.fExistingReturn != null) {
            return CorrectionMessages.MissingReturnTypeCorrectionProposal_changereturnstatement_description;
        }
        return CorrectionMessages.MissingReturnTypeCorrectionProposal_addreturnstatement_description;
    }

    protected ASTRewrite getRewrite() {
        Expression expression;
        ReturnStatement returnStatement;
        AST aST = this.fMethodDecl.getAST();
        ITypeBinding iTypeBinding = this.getReturnTypeBinding();
        if (this.fExistingReturn != null) {
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            Expression expression2 = this.evaluateReturnExpressions(aST, iTypeBinding, this.fExistingReturn.getStartPosition());
            if (expression2 != null) {
                aSTRewrite.set((ASTNode)this.fExistingReturn, (StructuralPropertyDescriptor)ReturnStatement.EXPRESSION_PROPERTY, (Object)expression2, null);
                this.addLinkedPosition(aSTRewrite.track((ASTNode)expression2), true, RETURN_EXPRESSION_KEY);
            }
            return aSTRewrite;
        }
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        Block block = this.fMethodDecl.getBody();
        List list = block.statements();
        int n = list.size();
        ASTNode aSTNode = null;
        if (n > 0) {
            aSTNode = (ASTNode)list.get(n - 1);
        }
        if (iTypeBinding != null && aSTNode instanceof ExpressionStatement && aSTNode.getNodeType() != 7 && (returnStatement = (expression = ((ExpressionStatement)aSTNode).getExpression()).resolveTypeBinding()) != null && returnStatement.isAssignmentCompatible(iTypeBinding)) {
            Expression expression3 = (Expression)aSTRewrite.createMoveTarget((ASTNode)expression);
            ReturnStatement returnStatement2 = aST.newReturnStatement();
            returnStatement2.setExpression(expression3);
            aSTRewrite.replace(aSTNode, (ASTNode)returnStatement2, null);
            return aSTRewrite;
        }
        int n2 = aSTNode == null ? block.getStartPosition() + 1 : aSTNode.getStartPosition() + aSTNode.getLength();
        returnStatement = aST.newReturnStatement();
        Expression expression4 = this.evaluateReturnExpressions(aST, iTypeBinding, n2);
        returnStatement.setExpression(expression4);
        aSTRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertLast((ASTNode)returnStatement, null);
        this.addLinkedPosition(aSTRewrite.track((ASTNode)returnStatement.getExpression()), true, RETURN_EXPRESSION_KEY);
        return aSTRewrite;
    }

    private ITypeBinding getReturnTypeBinding() {
        IMethodBinding iMethodBinding = this.fMethodDecl.resolveBinding();
        if (iMethodBinding != null && iMethodBinding.getReturnType() != null) {
            return iMethodBinding.getReturnType();
        }
        return null;
    }

    private Expression evaluateReturnExpressions(AST aST, ITypeBinding iTypeBinding, int n) {
        ScopeAnalyzer scopeAnalyzer;
        CompilationUnit compilationUnit = (CompilationUnit)this.fMethodDecl.getRoot();
        SimpleName simpleName = null;
        if (iTypeBinding != null) {
            scopeAnalyzer = new ScopeAnalyzer(compilationUnit);
            IBinding[] iBindingArray = scopeAnalyzer.getDeclarationsInScope(n, 18);
            int n2 = 0;
            while (n2 < iBindingArray.length) {
                IVariableBinding iVariableBinding = (IVariableBinding)iBindingArray[n2];
                ITypeBinding iTypeBinding2 = iVariableBinding.getType();
                if (iTypeBinding2 != null && iTypeBinding2.isAssignmentCompatible(iTypeBinding) && this.testModifier(iVariableBinding)) {
                    if (simpleName == null) {
                        simpleName = aST.newSimpleName(iVariableBinding.getName());
                    }
                    this.addLinkedPositionProposal(RETURN_EXPRESSION_KEY, iVariableBinding.getName(), null);
                }
                ++n2;
            }
        }
        scopeAnalyzer = ASTNodeFactory.newDefaultExpression(aST, this.fMethodDecl.getReturnType2(), this.fMethodDecl.getExtraDimensions());
        this.addLinkedPositionProposal(RETURN_EXPRESSION_KEY, ASTNodes.asString((ASTNode)scopeAnalyzer), null);
        if (simpleName == null) {
            return scopeAnalyzer;
        }
        return simpleName;
    }

    private boolean testModifier(IVariableBinding iVariableBinding) {
        int n;
        int n2 = iVariableBinding.getModifiers();
        if ((n2 & (n = 24)) == n) {
            return false;
        }
        return !Modifier.isStatic((int)n2) || Modifier.isStatic((int)this.fMethodDecl.getModifiers());
    }
}

