/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.text.folding.FoldingMessages;
import org.eclipse.wst.jsdt.ui.text.folding.IJavaFoldingPreferenceBlock;

public class DefaultJavaFoldingPreferenceBlock
implements IJavaFoldingPreferenceBlock {
    private IPreferenceStore fStore;
    private OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            DefaultJavaFoldingPreferenceBlock.this.fOverlayStore.setValue((String)DefaultJavaFoldingPreferenceBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    public DefaultJavaFoldingPreferenceBlock() {
        this.fStore = JavaPlugin.getDefault().getPreferenceStore();
        this.fKeys = this.createKeys();
        this.fOverlayStore = new OverlayPreferenceStore(this.fStore, this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_javadoc"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_methods"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_headers"));
        return arrayList.toArray(new OverlayPreferenceStore.OverlayKey[arrayList.size()]);
    }

    public Control createControl(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 3;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(FoldingMessages.DefaultJavaFoldingPreferenceBlock_title);
        this.addCheckBox(composite2, FoldingMessages.DefaultJavaFoldingPreferenceBlock_comments, "editor_folding_default_javadoc", 0);
        this.addCheckBox(composite2, FoldingMessages.DefaultJavaFoldingPreferenceBlock_headers, "editor_folding_default_headers", 0);
        this.addCheckBox(composite2, FoldingMessages.DefaultJavaFoldingPreferenceBlock_methods, "editor_folding_default_methods", 0);
        return composite2;
    }

    private Button addCheckBox(Composite composite, String string, String string2, int n) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 1;
        gridData.grabExcessVerticalSpace = false;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(button, string2);
        return button;
    }

    private void initializeFields() {
        Iterator iterator = this.fCheckBoxes.keySet().iterator();
        while (iterator.hasNext()) {
            Button button = (Button)iterator.next();
            String string = (String)this.fCheckBoxes.get(button);
            button.setSelection(this.fOverlayStore.getBoolean(string));
        }
    }

    public void performOk() {
        this.fOverlayStore.propagate();
    }

    public void initialize() {
        this.initializeFields();
    }

    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
    }

    public void dispose() {
        this.fOverlayStore.stop();
    }
}

