/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class JavaStringAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String fPartitioning;

    private String displayString(String string, String string2, String string3) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("\r")) {
                stringBuffer.append("\\r");
                if (!stringTokenizer.hasMoreTokens()) continue;
                string4 = stringTokenizer.nextToken();
                if (string4.equals("\n")) {
                    stringBuffer.append("\\n");
                    stringBuffer.append("\" + " + string3);
                    stringBuffer.append(string2);
                    stringBuffer.append("\"");
                    continue;
                }
                stringBuffer.append("\" + " + string3);
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            } else if (string4.equals("\n")) {
                stringBuffer.append("\\n");
                stringBuffer.append("\" + " + string3);
                stringBuffer.append(string2);
                stringBuffer.append("\"");
                continue;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = 0;
            while (n2 < string4.length()) {
                char c = string4.charAt(n2);
                switch (c) {
                    case '\r': {
                        stringBuffer2.append("\\r");
                        break;
                    }
                    case '\n': {
                        stringBuffer2.append("\\n");
                        break;
                    }
                    case '\b': {
                        stringBuffer2.append("\\b");
                        break;
                    }
                    case '\t': {
                        stringBuffer2.append("\t");
                        break;
                    }
                    case '\f': {
                        stringBuffer2.append("\\f");
                        break;
                    }
                    case '\"': {
                        stringBuffer2.append("\\\"");
                        break;
                    }
                    case '\'': {
                        stringBuffer2.append("\\'");
                        break;
                    }
                    case '\\': {
                        stringBuffer2.append("\\\\");
                        break;
                    }
                    default: {
                        stringBuffer2.append(c);
                    }
                }
                ++n2;
            }
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    public JavaStringAutoIndentStrategy(String string) {
        this.fPartitioning = string;
    }

    private boolean isLineDelimiter(IDocument iDocument, String string) {
        String[] stringArray = iDocument.getLegalLineDelimiters();
        if (stringArray != null) {
            return TextUtilities.equals((String[])stringArray, (String)string) > -1;
        }
        return false;
    }

    private String getLineIndentation(IDocument iDocument, int n) throws BadLocationException {
        int n2 = n == iDocument.getLength() ? n - 1 : n;
        IRegion iRegion = iDocument.getLineInformationOfOffset(n2);
        int n3 = iRegion.getOffset();
        int n4 = this.findEndOfWhiteSpace(iDocument, n3, n);
        return iDocument.get(n3, n4 - n3);
    }

    private String getModifiedText(String string, String string2, String string3) {
        return this.displayString(string, string2, string3);
    }

    private void javaStringIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) throws BadLocationException {
        int n;
        ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)documentCommand.offset, (boolean)true);
        int n2 = iTypedRegion.getOffset();
        if (documentCommand.offset == n2 + (n = iTypedRegion.getLength()) && iDocument.getChar(n2 + n - 1) == '\"') {
            return;
        }
        String string = this.getLineIndentation(iDocument, documentCommand.offset);
        String string2 = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
        IRegion iRegion = iDocument.getLineInformationOfOffset(n2);
        String string3 = iDocument.get(iRegion.getOffset(), n2 - iRegion.getOffset());
        if (string3.trim().length() != 0) {
            string = String.valueOf(string) + String.valueOf("\t\t");
        }
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (this.isLineDelimiter(iDocument, documentCommand.text)) {
            documentCommand.text = "\" +" + documentCommand.text + string + "\"";
        } else if (documentCommand.text.length() > 1 && iPreferenceStore.getBoolean("escapeStrings")) {
            documentCommand.text = this.getModifiedText(documentCommand.text, string, string2);
        }
    }

    private boolean isSmartMode() {
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 iTextEditorExtension3 = (ITextEditorExtension3)iEditorPart;
            return iTextEditorExtension3.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        try {
            if (documentCommand.text == null) {
                return;
            }
            IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            if (iPreferenceStore.getBoolean("wrapStrings") && this.isSmartMode()) {
                this.javaStringIndentAfterNewLine(iDocument, documentCommand);
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

